/*
 * Decompiled with CFR 0.152.
 */
package nz.org.geonet.quakeml.v1_0_1.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import nz.org.geonet.quakeml.v1_0_1.domain.Quakeml;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;

public class QuakemlFactory {
    public Quakeml getQuakeml(InputStream inputStream) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"nz.org.geonet.quakeml.v1_0_1.domain");
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Quakeml quakeml = (Quakeml)unmarshaller.unmarshal(inputStream);
        return quakeml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Quakeml getQuakeml(String httpGetRequest, String username, String password) {
        HttpClient client = new HttpClient();
        if (username != null && password != null) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
            client.getState().setCredentials(AuthScope.ANY, (Credentials)creds);
        }
        Quakeml quakeml = null;
        InputStream inputStream = null;
        GetMethod method = new GetMethod(httpGetRequest);
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode == 200) {
                inputStream = method.getResponseBodyAsStream();
                quakeml = this.getQuakeml(inputStream);
            } else {
                Logger.getLogger(QuakemlFactory.class.getName()).log(Level.WARNING, "Method failed: " + method.getStatusLine());
            }
        }
        catch (JAXBException jaxbe) {
            Logger.getLogger(QuakemlFactory.class.getName()).log(Level.SEVERE, "Input parameter that choked jaxb were url: " + httpGetRequest + " with mapping to package nz.org.geonet.quakeml.v1_0_1.domain", jaxbe);
        }
        catch (HttpException httpe) {
            Logger.getLogger(QuakemlFactory.class.getName()).log(Level.SEVERE, "Input parameter that choked jaxb were url: " + httpGetRequest, httpe);
        }
        catch (IOException ioe) {
            Logger.getLogger(QuakemlFactory.class.getName()).log(Level.SEVERE, "Input parameter that choked jaxb were url: " + httpGetRequest, ioe);
        }
        finally {
            method.releaseConnection();
            try {
                inputStream.close();
            }
            catch (IOException ex) {
                Logger.getLogger(QuakemlFactory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return quakeml;
    }
}

