/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.calc;

import java.util.ArrayList;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFuncList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractileCurveCalculator {
    private DiscretizedFuncList funcList;
    private ArrayList<Double> relativeWeights;
    private int num;
    private ArrayList<ArbDiscrEmpiricalDistFunc> empiricalDists;
    private static final String ERROR_WEIGHTS = "Error! Number of weights should be equal to number of curves";
    private static final String ERROR_LIST = "No curves exist in the list";
    private static final String ERROR_POINTS = "Number of points in each curve should be same";

    public FractileCurveCalculator(DiscretizedFuncList functionList, ArrayList<Double> relativeWts) {
        this.set(functionList, relativeWts);
    }

    public void set(DiscretizedFuncList functionList, ArrayList<Double> relativeWts) {
        int i;
        if (functionList.size() != relativeWts.size()) {
            throw new RuntimeException(ERROR_WEIGHTS);
        }
        int numFunctions = functionList.size();
        if (numFunctions == 0) {
            throw new RuntimeException(ERROR_LIST);
        }
        int numPoints = functionList.get(0).getNum();
        for (i = 1; i < numFunctions; ++i) {
            if (functionList.get(i).getNum() == numPoints) continue;
            throw new RuntimeException(ERROR_POINTS);
        }
        this.funcList = functionList;
        this.relativeWeights = relativeWts;
        this.num = numPoints;
        this.empiricalDists = new ArrayList();
        for (i = 0; i < this.num; ++i) {
            ArbDiscrEmpiricalDistFunc empirical = new ArbDiscrEmpiricalDistFunc();
            for (int j = 0; j < numFunctions; ++j) {
                empirical.set(this.funcList.get(j).getY(i), (double)this.relativeWeights.get(j));
            }
            this.empiricalDists.add(empirical);
        }
    }

    public ArbitrarilyDiscretizedFunc getMeanCurve() {
        int i;
        ArbitrarilyDiscretizedFunc result = (ArbitrarilyDiscretizedFunc)this.funcList.get(0).deepClone();
        double totWt = 0.0;
        int numPoints = this.funcList.get(0).getNum();
        int numFuncs = this.funcList.size();
        for (i = 0; i < numPoints; ++i) {
            result.set(i, 0.0);
        }
        for (int f = 0; f < numFuncs; ++f) {
            double wt = this.relativeWeights.get(f);
            totWt += wt;
            for (i = 0; i < numPoints; ++i) {
                result.set(i, result.getY(i) + wt * this.funcList.get(f).getY(i));
            }
        }
        for (i = 0; i < numPoints; ++i) {
            result.set(i, result.getY(i) / totWt);
        }
        return result;
    }

    public ArbitrarilyDiscretizedFunc getFractile(double fraction) {
        ArbitrarilyDiscretizedFunc result = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < this.num; ++i) {
            result.set(this.funcList.get(0).getX(i), this.empiricalDists.get(i).getDiscreteFractile(fraction));
        }
        return result;
    }
}

