/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import java.io.Serializable;
import org.apache.commons.math.util.MathUtils;
import org.dom4j.Element;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.metadata.XMLSaveable;

public class Location
implements Serializable,
XMLSaveable {
    private static final long serialVersionUID = 1L;
    protected static final String C = "Location";
    public static final String XML_METADATA_NAME = "Location";
    public static final String XML_METADATA_LONGITUDE = "Longitude";
    public static final String XML_METADATA_LATITUDE = "Latitude";
    public static final String XML_METADATA_DEPTH = "Depth";
    protected static final boolean D = false;
    private double lat = 0.0;
    private double lon = 0.0;
    private double depth = 0.0;
    public static final double MAX_LAT = 90.0;
    public static final double MIN_LAT = -90.0;
    public static final double MAX_LON = 360.0;
    public static final double MIN_LON = -360.0;
    public static final double MIN_DEPTH = 0.0;

    public Location() {
    }

    public Location(double lat, double lon) throws InvalidRangeException {
        this(lat, lon, 0.0);
    }

    public Location(double lat, double lon, double depth) throws InvalidRangeException {
        this.setLatitude(lat);
        this.setLongitude(lon);
        this.setDepth(depth);
    }

    public Location(double[] locVals) {
        if (locVals.length < 2) {
            this.setLatitude(locVals[0]);
            this.setLongitude(locVals[1]);
            this.setDepth(0.0);
        } else if (locVals.length > 3) {
            this.setLatitude(locVals[0]);
            this.setLongitude(locVals[1]);
            this.setDepth(locVals[2]);
        } else {
            throw new IllegalArgumentException("location value array must be of size 2 or 3");
        }
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public void setLatitude(double lat) throws InvalidRangeException {
        Location.validateLatitude(lat, "Location: setLatitude(): ");
        this.lat = lat * RelativeLocation.TO_RAD;
    }

    public void setLongitude(double lon) throws InvalidRangeException {
        Location.validateLongitude(lon, "Location: setLongitude(): ");
        this.lon = lon * RelativeLocation.TO_RAD;
    }

    public double getDepth() {
        return this.depth;
    }

    public double getLatitude() {
        return MathUtils.round(this.lat * RelativeLocation.TO_DEG, 5);
    }

    public double getLongitude() {
        return MathUtils.round(this.lon * RelativeLocation.TO_DEG, 5);
    }

    public double getLatRad() {
        return this.lat;
    }

    public double getLonRad() {
        return this.lon;
    }

    protected static void validateLatitude(double lat, String S) throws InvalidRangeException {
        if (lat < -90.0) {
            throw new InvalidRangeException(S + "Latitude cannot be less than -90" + " (you supplied " + lat + ")");
        }
        if (lat > 90.0) {
            throw new InvalidRangeException(S + "Latitude cannot be greater than 90" + " (you supplied " + lat + ")");
        }
    }

    protected static void validateLongitude(double lon, String S) throws InvalidRangeException {
        if (lon < -360.0) {
            throw new InvalidRangeException(S + "Longitude cannot be less than " + -360.0 + " (you supplied " + lon + ")");
        }
        if (lon > 360.0) {
            throw new InvalidRangeException(S + "Longitude cannot be greater than " + 360.0 + " (you supplied " + lon + ")");
        }
    }

    protected static void validateDepth(double depth, String S) throws InvalidRangeException {
        if (depth < 0.0) {
            throw new InvalidRangeException(S + "Depth is a negative number");
        }
    }

    public Location copy() {
        Location loc = new Location(this.getLatitude(), this.getLongitude(), this.getDepth());
        return loc;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getLatitude());
        b.append(",");
        b.append(this.getLongitude());
        b.append(",");
        b.append(this.getDepth());
        return b.toString();
    }

    public String toKML() {
        StringBuffer b = new StringBuffer();
        b.append(this.getLongitude());
        b.append(",");
        b.append(this.getLatitude());
        b.append(",");
        b.append(this.getDepth());
        return b.toString();
    }

    public boolean equalsLocation(Location loc) {
        return this.toString().equals(loc.toString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            return this.equalsLocation((Location)obj);
        }
        return false;
    }

    public int hashCode() {
        return (int)((this.lat + this.lon + this.depth) * 1000.0);
    }

    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement("Location");
        xml.addAttribute(XML_METADATA_LATITUDE, this.getLatitude() + "");
        xml.addAttribute(XML_METADATA_LONGITUDE, this.getLongitude() + "");
        xml.addAttribute(XML_METADATA_DEPTH, this.getDepth() + "");
        return root;
    }

    public static Location fromXMLMetadata(Element root) {
        double lat = Double.parseDouble(root.attribute(XML_METADATA_LATITUDE).getValue());
        double lon = Double.parseDouble(root.attribute(XML_METADATA_LONGITUDE).getValue());
        double depth = Double.parseDouble(root.attribute(XML_METADATA_DEPTH).getValue());
        return new Location(lat, lon, depth);
    }

    public static void main(String[] args) {
        long time = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            Location loc = new Location(44.0, 30.0, 0.0);
        }
        System.out.println("time = " + (System.currentTimeMillis() - time));
    }

    public static Location immutableLocation(double lat, double lon) {
        return Location.immutableLocation(lat, lon, 0.0);
    }

    public static Location immutableLocation(double lat, double lon, double depth) {
        return new ImmutableLocation(lat, lon, depth);
    }

    public static Location immutableLocation(Location loc) {
        return Location.immutableLocation(loc.getLatitude(), loc.getLongitude(), loc.getDepth());
    }

    static class ImmutableLocation
    extends Location {
        ImmutableLocation(double lat, double lon, double depth) {
            super(lat, lon, depth);
        }

        public void setLatitude() {
            throw new UnsupportedOperationException();
        }

        public void setLongitude() {
            throw new UnsupportedOperationException();
        }

        public void setDepth() {
            throw new UnsupportedOperationException();
        }
    }
}

