/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.dom4j.Element;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationComparator;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.metadata.XMLSaveable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationList
implements Serializable,
XMLSaveable,
Iterable<Location> {
    private static final long serialVersionUID = 178211150L;
    protected static final String C = "LocationList";
    public static final String XML_METADATA_NAME = "LocationList";
    protected static final boolean D = false;
    protected ArrayList<Location> locations = new ArrayList();
    private static final String TAB = "  ";

    public Location getLocationAt(int index) throws InvalidRangeException {
        this.checkIndex(index);
        return this.locations.get(index);
    }

    private void checkIndex(int index) throws InvalidRangeException {
        if (this.size() < index + 1) {
            throw new InvalidRangeException("LocationList: getLocationAt(): Specified index larger than array size.");
        }
    }

    public void replaceLocationAt(Location location, int index) throws InvalidRangeException {
        this.checkIndex(index);
        this.locations.set(index, location);
    }

    public void sort() {
        Collections.sort(this.locations, new LocationComparator());
    }

    public void addLocation(Location location) {
        this.locations.add(location);
    }

    public void addLocation(double lat, double lon, double depth) {
        this.addLocation(new Location(lat, lon, depth));
    }

    public void addAllLocations(LocationList locList) {
        for (int i = 0; i < locList.size(); ++i) {
            this.addLocation(locList.getLocationAt(i));
        }
    }

    public void addLocationAt(Location location, int index) {
        this.locations.add(index, location);
    }

    public void clear() {
        this.locations.clear();
    }

    public void remove(int index) {
        this.locations.remove(index);
    }

    public void reverse() {
        int size = this.locations.size();
        int reverseIndex = size - 1;
        ArrayList<Location> newList = new ArrayList<Location>();
        for (int i = reverseIndex; i >= 0; --i) {
            newList.add(this.locations.get(i));
        }
        this.locations = newList;
    }

    public int size() {
        return this.locations.size();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append('\n');
        b.append("  Size = " + this.size());
        for (Location location : this) {
            b.append(TAB + location.toString());
        }
        return b.toString();
    }

    public double getHorzDistToClosestLocation(Location loc) {
        double min = Double.MAX_VALUE;
        Iterator<Location> it = this.iterator();
        while (it.hasNext()) {
            double temp = RelativeLocation.getHorzDistance(loc, it.next());
            if (!(temp < min)) continue;
            min = temp;
        }
        return min;
    }

    public int compareTo(Object obj) {
        boolean compareFlag = true;
        if (!(obj instanceof LocationList)) {
            throw new ClassCastException("LocationListObject not a LocationList, unable to compare");
        }
        LocationList locList = (LocationList)obj;
        Iterator<Location> it = locList.iterator();
        Iterator<Location> it1 = this.iterator();
        if (this.size() != locList.size()) {
            return -1;
        }
        Location loc = null;
        Location loc1 = null;
        while (it.hasNext() && (compareFlag = (loc = it.next()).equals(loc1 = it1.next()))) {
        }
        if (!compareFlag) {
            return -1;
        }
        return 0;
    }

    public int getLocationIndex(Location loc) {
        return this.locations.indexOf(loc);
    }

    public double getMinHorzDistToLine(Location loc) {
        double min = Double.MAX_VALUE;
        for (int i = 1; i < this.size(); ++i) {
            double temp = RelativeLocation.getApproxHorzDistToLine(this.getLocationAt(i - 1), this.getLocationAt(i), loc);
            if (!(temp < min)) continue;
            min = temp;
        }
        return min;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element locs = root.addElement("LocationList");
        for (int i = 0; i < this.size(); ++i) {
            Location loc = this.getLocationAt(i);
            locs = loc.toXMLMetadata(locs);
        }
        return root;
    }

    public static LocationList fromXMLMetadata(Element locationElement) {
        LocationList locs = new LocationList();
        Iterator it = locationElement.elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (!el.getName().equals("Location")) continue;
            locs.addLocation(Location.fromXMLMetadata(el));
        }
        return locs;
    }

    @Override
    public Iterator<Location> iterator() {
        return this.locations.iterator();
    }

    public ArrayList<LocationList> split(int pieceSize) {
        ArrayList<LocationList> lists = new ArrayList<LocationList>();
        if (pieceSize <= 0 || this.size() <= pieceSize) {
            lists.add(this);
            return lists;
        }
        LocationList cur = new LocationList();
        for (int i = 0; i < this.size(); ++i) {
            if (i % pieceSize == 0 && i > 0) {
                lists.add(cur);
                cur = new LocationList();
            }
            cur.addLocation(this.getLocationAt(i));
        }
        if (cur.size() > 0) {
            lists.add(cur);
        }
        return lists;
    }

    public LocationList copy() {
        LocationList locList = new LocationList();
        for (Location loc : this.locations) {
            locList.addLocation(loc.copy());
        }
        return locList;
    }

    public LocationList copyImmutable() {
        LocationList locList = new LocationList();
        for (Location loc : this.locations) {
            locList.addLocation(Location.immutableLocation(loc));
        }
        return locList;
    }
}

