/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.estimate;

import org.opensha.commons.calc.GaussianDistCalc;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.data.estimate.InvalidParamValException;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;

public class NormalEstimate
extends Estimate {
    public static final String NAME = "Normal (Gaussian)";
    private double mean = Double.NaN;
    private double stdDev = Double.NaN;
    private static final String MSG_TRUNCATION_ERR = "Error: Lower and Upper Truncation must be below and above the mean respectively";

    public NormalEstimate(double mean, double stdDev) {
        this.setMean(mean);
        this.setStdDev(stdDev);
        this.min = Double.NEGATIVE_INFINITY;
        this.max = Double.POSITIVE_INFINITY;
    }

    public String toString() {
        String text = "Estimate Type=" + this.getName() + "\n" + super.toString() + "\n" + "Values from toString() method of specific estimate:\n " + "Mean=" + this.getMean() + "\n" + "Standard Deviation=" + this.getStdDev() + "\n";
        if (!Double.isInfinite(this.getMin())) {
            text = text + "Lower Truncation(absolute):" + this.getMin() + "\n" + "Lower Truncation(# of sigmas):" + this.getMinSigma() + "\n";
        }
        if (!Double.isInfinite(this.getMax())) {
            text = text + "Upper Truncation(absolute):" + this.getMax() + "\n" + "Upper Truncation(# of sigmas):" + this.getMaxSigma() + "\n";
        }
        if (Double.isInfinite(this.getMin()) && Double.isInfinite(this.getMax())) {
            text = text + "No Truncation";
        }
        return text;
    }

    public NormalEstimate(double mean, double stdDev, double min, double max) {
        this.setMean(mean);
        this.setStdDev(stdDev);
        this.setMinMax(min, max);
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double getMean() {
        return this.mean;
    }

    public void setStdDev(double stdDev) {
        if (stdDev < 0.0) {
            throw new InvalidParamValException("Error: Standard deviation must be positive.");
        }
        this.stdDev = stdDev;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public double getMedian() {
        return this.getMean();
    }

    public double getMode() {
        return this.getMean();
    }

    public double getFractile(double prob) {
        try {
            double stdRndVar = GaussianDistCalc.getStandRandVar(1.0 - prob, this.getStandRandVar(this.min), this.getStandRandVar(this.max), 1.0E-6);
            return this.getMean() + stdRndVar * this.getStdDev();
        }
        catch (RuntimeException e) {
            throw new RuntimeException(MSG_TRUNCATION_ERR);
        }
    }

    private double getStandRandVar(double val) {
        if (Double.isInfinite(val)) {
            return val;
        }
        return (val - this.mean) / this.stdDev;
    }

    public void setMinMax(double min, double max) {
        if (max < min) {
            throw new InvalidParamValException("Error: Minimum must be less than Maximum");
        }
        this.max = max;
        this.min = min;
    }

    public void setMinMaxSigmas(double minSigma, double maxSigma) {
        if (maxSigma < minSigma) {
            throw new InvalidParamValException("Error: Minimum must be less than Maximum");
        }
        this.min = this.mean + minSigma * this.stdDev;
        this.max = this.mean + maxSigma * this.stdDev;
    }

    public double getMinSigma() {
        return (this.min - this.mean) / this.stdDev;
    }

    public double getMaxSigma() {
        return (this.max - this.mean) / this.stdDev;
    }

    public String getName() {
        return NAME;
    }

    public DiscretizedFunc getPDF_Test() {
        EvenlyDiscretizedFunc func = this.getEvenlyDiscretizedFunc();
        double deltaX = func.getDelta();
        int numPoints = func.getNum();
        for (int i = 0; i < numPoints; ++i) {
            double x = func.getX(i);
            func.set(i, this.getProbLessThanEqual(x + deltaX / 2.0) - this.getProbLessThanEqual(x - deltaX / 2.0));
        }
        func.setInfo("PDF from Normal Distribution");
        return func;
    }

    public double getProbLessThanEqual(double x) {
        return 1.0 - GaussianDistCalc.getExceedProb(this.getStandRandVar(x), this.getStandRandVar(this.min), this.getStandRandVar(this.max));
    }

    public DiscretizedFunc getCDF_Test() {
        EvenlyDiscretizedFunc func = this.getEvenlyDiscretizedFunc();
        int numPoints = func.getNum();
        for (int i = 0; i < numPoints; ++i) {
            func.set(i, this.getProbLessThanEqual(func.getX(i)));
        }
        func.setInfo("CDF from Normal Distribution using getProbLessThanEqual() method");
        return func;
    }

    private EvenlyDiscretizedFunc getEvenlyDiscretizedFunc() {
        double min = this.mean - 4.0 * this.stdDev;
        double max = this.mean + 4.0 * this.stdDev;
        int numPoints = 81;
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(min, max, numPoints);
        return func;
    }
}

