/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.commons.data.DataPoint2D;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFuncAPI;
import org.opensha.commons.exceptions.DataPoint2DException;
import org.opensha.commons.exceptions.DiscretizedFuncException;
import org.opensha.commons.exceptions.InvalidRangeException;

public class EvenlyDiscretizedFunc
extends DiscretizedFunc {
    private static final long serialVersionUID = 206441789L;
    protected static final String C = "EvenlyDiscretizedFunc";
    protected static final boolean D = false;
    protected double[] points;
    protected double minX = Double.NaN;
    protected double maxX = Double.NaN;
    protected double delta = Double.NaN;
    protected int num;
    protected boolean first = true;

    public EvenlyDiscretizedFunc(double min, int num, double delta) {
        this.set(min, num, delta);
    }

    public void set(double min, int num, double delta) {
        this.set(min, min + (double)(num - 1) * delta, num);
    }

    public EvenlyDiscretizedFunc(double min, double max, int num) {
        this.set(min, max, num);
    }

    public void set(double min, double max, int num) {
        if (num <= 0) {
            throw new DiscretizedFuncException("num points must be >= 0");
        }
        if (num == 1 && min != max) {
            throw new DiscretizedFuncException("min must equal max if num points = 1");
        }
        if (min > max) {
            throw new DiscretizedFuncException("min must be less than max");
        }
        if (min < max) {
            this.delta = (max - min) / (double)(num - 1);
        } else if (num == 1) {
            this.delta = 0.0;
        } else {
            throw new DiscretizedFuncException("num must = 1 if min = max");
        }
        this.minX = min;
        this.maxX = max;
        this.num = num;
        this.points = new double[num];
    }

    public void clear() {
        for (int i = 0; i < this.num; ++i) {
            this.points[i] = Double.NaN;
        }
    }

    protected boolean withinTolerance(double x, double xx) {
        return Math.abs(x - xx) <= this.tolerance;
    }

    public double getDelta() {
        return this.delta;
    }

    public int getNum() {
        return this.num;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        double minY = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.num; ++i) {
            if (!(this.points[i] < minY)) continue;
            minY = this.points[i];
        }
        return minY;
    }

    public double getMaxY() {
        double maxY = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.num; ++i) {
            if (!(this.points[i] > maxY)) continue;
            maxY = this.points[i];
        }
        return maxY;
    }

    public DataPoint2D get(int index) {
        return new DataPoint2D(this.getX(index), this.getY(index));
    }

    public double getX(int index) {
        if (index < 0 || index > this.num - 1) {
            return Double.NaN;
        }
        return this.minX + this.delta * (double)index;
    }

    public double getY(int index) {
        if (index < 0 || index > this.num - 1) {
            return Double.NaN;
        }
        return this.points[index];
    }

    public double getY(double x) {
        return this.getY(this.getXIndex(x));
    }

    public int getXIndex(double x) throws DataPoint2DException {
        int i = Math.round((float)((x - this.minX) / this.delta));
        if (this.withinTolerance(x, this.getX(i))) {
            return i;
        }
        throw new DataPoint2DException("EvenlyDiscretizedFunc: set(): This point doesn't match a permitted x value.");
    }

    public void set(DataPoint2D point) throws DataPoint2DException {
        this.set(point.getX(), point.getY());
    }

    public void set(double x, double y) throws DataPoint2DException {
        int index = this.getXIndex(x);
        this.points[index] = y;
    }

    public void add(double x, double y) throws DataPoint2DException {
        int index = this.getXIndex(x);
        this.points[index] = y + this.points[index];
    }

    public void set(int index, double y) throws DataPoint2DException {
        if (index < 0 || index > this.num - 1) {
            throw new DataPoint2DException("EvenlyDiscretizedFunc: set(): The specified index doesn't match this function domain.");
        }
        this.points[index] = y;
    }

    public void add(int index, double y) throws DataPoint2DException {
        if (index < 0 || index > this.num - 1) {
            throw new DataPoint2DException("EvenlyDiscretizedFunc: set(): The specified index doesn't match this function domain.");
        }
        this.points[index] = y + this.points[index];
    }

    public Iterator getPointsIterator() {
        ArrayList<DataPoint2D> list = new ArrayList<DataPoint2D>();
        for (int i = 0; i < this.num; ++i) {
            list.add(new DataPoint2D(this.getX(i), this.getY(i)));
        }
        return list.listIterator();
    }

    public ListIterator getXValuesIterator() {
        ArrayList<Double> list = new ArrayList<Double>();
        for (int i = 0; i < this.num; ++i) {
            list.add(new Double(this.getX(i)));
        }
        return list.listIterator();
    }

    public ListIterator getYValuesIterator() {
        ArrayList<Double> list = new ArrayList<Double>();
        for (int i = 0; i < this.num; ++i) {
            list.add(new Double(this.getY(i)));
        }
        return list.listIterator();
    }

    public double getFirstInterpolatedX(double y) {
        int i;
        double y1 = Double.NaN;
        double y2 = Double.NaN;
        if (this.num == 1 && y == this.getY(0)) {
            return this.getX(0);
        }
        boolean found = false;
        for (i = 0; i < this.num - 1; ++i) {
            y1 = this.getY(i);
            y2 = this.getY(i + 1);
            if (!(y <= y1 && y >= y2 && y2 <= y1) && (!(y >= y1) || !(y <= y2) || !(y2 >= y1))) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new InvalidRangeException("Y Value (" + y + ") must be within the range: " + this.getY(0) + " and " + this.getY(this.num - 1));
        }
        double x1 = this.getX(i);
        double x2 = this.getX(i + 1);
        double x = (y - y1) * (x2 - x1) / (y2 - y1) + x1;
        return x;
    }

    public double getFirstInterpolatedX_inLogXLogYDomain(double y) {
        int i;
        double y1 = Double.NaN;
        double y2 = Double.NaN;
        if (this.num == 1 && y == this.getY(0)) {
            return this.getX(0);
        }
        boolean found = false;
        for (i = 0; i < this.num - 1; ++i) {
            y1 = this.getY(i);
            y2 = this.getY(i + 1);
            if (!(y <= y1 && y >= y2 && y2 <= y1) && (!(y >= y1) || !(y <= y2) || !(y2 >= y1))) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new InvalidRangeException("Y Value (" + y + ") must be within the range: " + this.getY(0) + " and " + this.getY(this.num - 1));
        }
        double x1 = Math.log(this.getX(i));
        double x2 = Math.log(this.getX(i + 1));
        y1 = Math.log(y1);
        y2 = Math.log(y2);
        y = Math.log(y);
        double x = (y - y1) * (x2 - x1) / (y2 - y1) + x1;
        return Math.exp(x);
    }

    public double getInterpolatedY(double x) {
        double x1 = Double.NaN;
        double x2 = Double.NaN;
        if (x > this.getX(this.num - 1) || x < this.getX(0)) {
            throw new InvalidRangeException("x Value (" + x + ") must be within the range: " + this.getX(0) + " and " + this.getX(this.num - 1));
        }
        for (int i = 0; i < this.num - 1; ++i) {
            x1 = this.getX(i);
            x2 = this.getX(i + 1);
            if (x >= x1 && x <= x2) break;
        }
        double y1 = this.getY(x1);
        double y2 = this.getY(x2);
        double y = (y2 - y1) * (x - x1) / (x2 - x1) + y1;
        return y;
    }

    public double getInterpolatedY_inLogXLogYDomain(double x) {
        double x1 = Double.NaN;
        double x2 = Double.NaN;
        if (x > this.getX(this.num - 1) || x < this.getX(0)) {
            throw new InvalidRangeException("x Value must be within the range: " + this.getX(0) + " and " + this.getX(this.num - 1));
        }
        for (int i = 0; i < this.num - 1; ++i) {
            x1 = this.getX(i);
            x2 = this.getX(i + 1);
            if (x >= x1 && x <= x2) break;
        }
        double y1 = Math.log(this.getY(x1));
        double y2 = Math.log(this.getY(x2));
        x1 = Math.log(x1);
        x2 = Math.log(x2);
        x = Math.log(x);
        double y = (y2 - y1) * (x - x1) / (x2 - x1) + y1;
        return Math.exp(y);
    }

    public double getInterpolatedY_inLogYDomain(double x) {
        double x1 = Double.NaN;
        double x2 = Double.NaN;
        if (x > this.getX(this.num - 1) || x < this.getX(0)) {
            throw new InvalidRangeException("x Value must be within the range: " + this.getX(0) + " and " + this.getX(this.num - 1));
        }
        for (int i = 0; i < this.num - 1; ++i) {
            x1 = this.getX(i);
            x2 = this.getX(i + 1);
            if (x >= x1 && x <= x2) break;
        }
        double y1 = Math.log(this.getY(x1));
        double y2 = Math.log(this.getY(x2));
        double y = (y2 - y1) * (x - x1) / (x2 - x1) + y1;
        return Math.exp(y);
    }

    public DiscretizedFuncAPI deepClone() {
        EvenlyDiscretizedFunc f = new EvenlyDiscretizedFunc(this.minX, this.num, this.delta);
        f.info = this.info;
        f.minX = this.minX;
        f.maxX = this.maxX;
        f.name = this.name;
        f.tolerance = this.tolerance;
        f.setInfo(this.getInfo());
        f.setName(this.getName());
        for (int i = 0; i < this.num; ++i) {
            f.set(i, this.points[i]);
        }
        return f;
    }

    public boolean equalXValues(DiscretizedFuncAPI function) {
        if (!(function instanceof EvenlyDiscretizedFunc)) {
            return false;
        }
        if (this.num != function.getNum()) {
            return false;
        }
        double min = this.minX;
        double min1 = ((EvenlyDiscretizedFunc)function).getMinX();
        if (!this.withinTolerance(min, min1)) {
            return false;
        }
        double d = this.delta;
        double d1 = ((EvenlyDiscretizedFunc)function).getDelta();
        return d == d1;
    }

    public boolean areAllXValuesInteger(double tolerance) {
        double diff = Math.abs(this.minX - Math.rint(this.minX));
        if (diff > tolerance) {
            return false;
        }
        diff = Math.abs(this.delta - Math.rint(this.delta));
        return !(diff > tolerance);
    }

    public boolean equalXAndYValues(DiscretizedFuncAPI function) {
        if (!this.equalXValues(function)) {
            return false;
        }
        for (int i = 0; i < this.num; ++i) {
            double y1 = this.getY(i);
            double y2 = function.getY(i);
            if (y1 == Double.NaN && y2 != Double.NaN) {
                return false;
            }
            if (y2 == Double.NaN && y1 != Double.NaN) {
                return false;
            }
            if (y1 == y2) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Name: " + this.getName() + '\n');
        b.append("Num Points: " + this.getNum() + '\n');
        b.append("Info: " + this.getInfo() + "\n\n");
        b.append("X, Y Data:\n");
        b.append(this.getMetadataString() + '\n');
        return b.toString();
    }

    public String getMetadataString() {
        StringBuffer b = new StringBuffer();
        Iterator it2 = this.getPointsIterator();
        while (it2.hasNext()) {
            DataPoint2D point = (DataPoint2D)it2.next();
            double x = point.getX();
            double y = point.getY();
            b.append((float)x + "\t  " + (float)y + '\n');
        }
        return b.toString();
    }

    public boolean hasPoint(DataPoint2D point) {
        return this.hasPoint(point.getX(), point.getY());
    }

    public boolean hasPoint(double x, double y) {
        try {
            int index = this.getXIndex(x);
            double yVal = this.getY(index);
            return yVal != Double.NaN && yVal == y;
        }
        catch (DataPoint2DException e) {
            return false;
        }
    }

    public int getIndex(DataPoint2D point) {
        try {
            int index = this.getXIndex(point.getX());
            if (index < 0) {
                return -1;
            }
            double y = this.getY(index);
            if (y != point.getY()) {
                return -1;
            }
            return index;
        }
        catch (DataPoint2DException e) {
            return -1;
        }
    }

    public static void main(String[] args) {
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(5.0, 9.0, 41);
        func.setTolerance(func.getDelta() / 2.0);
        System.out.println(func.getXIndex(8.899999999999999));
    }
}

