/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.region;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.data.siteData.OrderedSiteDataProviderList;
import org.opensha.commons.data.siteData.SiteDataAPI;
import org.opensha.commons.data.siteData.SiteDataValueList;
import org.opensha.commons.data.siteData.impl.CVM4BasinDepth;
import org.opensha.commons.data.siteData.impl.WillsMap2006;
import org.opensha.commons.exceptions.RegionConstraintException;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.sha.util.SiteTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SitesInGriddedRegion
implements Serializable {
    public static final boolean D = false;
    Site site = new Site();
    ArrayList<SiteDataValueList<?>> siteDataValueLists = null;
    private boolean setSameSiteParams = true;
    private ArrayList defaultSiteParams;
    SiteTranslator siteTranslator = new SiteTranslator();
    private GriddedRegion region;

    public SitesInGriddedRegion(GriddedRegion region) {
        this.region = region;
    }

    public GriddedRegion getRegion() {
        return this.region;
    }

    @Deprecated
    public void setSiteParamsForRegion(String[] willsSiteClass, double[] bd) {
        if (willsSiteClass != null && bd != null && willsSiteClass.length != bd.length) {
            throw new RuntimeException("Invalid Range Site Type Values, both Wills Site Class and Basindepth should have same number of values");
        }
        this.siteDataValueLists = new ArrayList();
        if (willsSiteClass != null || bd != null) {
            this.setSameSiteParams = false;
            if (willsSiteClass != null) {
                ArrayList<String> willsData = new ArrayList<String>();
                for (String wills : willsSiteClass) {
                    willsData.add(wills);
                }
                this.siteDataValueLists.add(new SiteDataValueList("Wills Class", "Measured", willsData, null));
            }
            if (bd != null) {
                ArrayList<Double> basinData = new ArrayList<Double>();
                for (double basin : bd) {
                    basinData.add(basin);
                }
                this.siteDataValueLists.add(new SiteDataValueList("Depth to Vs = 2.5 km/sec", "Measured", basinData, null));
            }
        }
    }

    public void setSiteParamsForRegion(OrderedSiteDataProviderList providers) throws IOException {
        this.setSameSiteParams = false;
        LocationList locList = this.region.getNodeList();
        this.siteDataValueLists = new ArrayList();
        for (int i = 0; i < providers.size(); ++i) {
            if (!providers.isEnabled(i)) continue;
            SiteDataAPI<?> provider = providers.getProvider(i);
            ArrayList<?> vals = provider.getValues(locList);
            this.siteDataValueLists.add(new SiteDataValueList(vals, provider));
        }
    }

    public void setSiteDataValueLists(ArrayList<SiteDataValueList<?>> siteDataValueLists) {
        this.setSameSiteParams = false;
        this.siteDataValueLists = siteDataValueLists;
    }

    public ArrayList<SiteDataValueList<?>> getSiteDataValueLists() {
        return this.siteDataValueLists;
    }

    @Deprecated
    public void setSiteParamsForRegionFromServlet(boolean connectForBasinDepth) {
        ArrayList providers = new ArrayList();
        try {
            providers.add(new WillsMap2006());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (connectForBasinDepth) {
            try {
                providers.add(new CVM4BasinDepth("Depth to Vs = 2.5 km/sec"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        OrderedSiteDataProviderList providerList = new OrderedSiteDataProviderList(providers);
        try {
            this.setSiteParamsForRegion(providerList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Site getSite(int index) throws RegionConstraintException {
        this.site.setLocation(this.region.locationForIndex(index));
        Object siteInfo = null;
        if (!this.setSameSiteParams) {
            ListIterator<ParameterAPI> it = this.site.getParametersIterator();
            while (it.hasNext()) {
                ParameterAPI tempParam = (ParameterAPI)it.next();
                ArrayList datas = new ArrayList();
                for (SiteDataValueList<?> dataList : this.siteDataValueLists) {
                    datas.add(dataList.getValue(index));
                }
                boolean flag = this.siteTranslator.setParameterValue(tempParam, datas);
                if (flag) continue;
                for (ParameterAPI param : this.defaultSiteParams) {
                    if (!tempParam.getName().equals(param.getName())) continue;
                    tempParam.setValue(param.getValue());
                }
            }
        }
        return this.site;
    }

    public void addSiteParams(Iterator it) {
        while (it.hasNext()) {
            ParameterAPI tempParam = (ParameterAPI)it.next();
            if (this.site.containsParameter(tempParam)) continue;
            this.site.addParameter(tempParam);
        }
    }

    public void removeSiteParams() {
        ListIterator<ParameterAPI> it1 = this.site.getParametersIterator();
        while (it1.hasNext()) {
            this.site.removeParameter(it1.next());
        }
    }

    public void setSameSiteParams() {
        this.setSameSiteParams = true;
        this.siteDataValueLists = null;
    }

    public void setDefaultSiteParams(ArrayList defaultSiteParams) {
        if (this.defaultSiteParams != null) {
            this.defaultSiteParams.clear();
        } else {
            this.defaultSiteParams = new ArrayList();
        }
        for (ParameterAPI param : defaultSiteParams) {
            this.defaultSiteParams.add((ParameterAPI)param.clone());
        }
    }
}

