/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.IOException;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.SiteDataAPI;
import org.opensha.commons.data.siteData.impl.SRTM30PlusTopoSlope;
import org.opensha.commons.data.siteData.util.MeanTopoSlopeCalculator;
import org.opensha.commons.param.DoubleParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeanTopoSlope
extends AbstractSiteData<Double> {
    SiteDataAPI<Double> topoSlopeProvider = null;
    MeanTopoSlopeCalculator calc = null;
    public static final String PARAM_RADIUS_NAME = "Single Location Radius (KM)";
    public static final Double PARAM_RADIUS_MIN = 10.0;
    public static final Double PARAM_RADIUS_MAX = 10000.0;
    public static final Double PARAM_RADIUS_DEFAULT = 300.0;
    public static final String PARAM_RADIUS_INFO = "The radius in KM around single Location requests that should be used to determine mean slope";
    private DoubleParameter radiusParam = new DoubleParameter("Single Location Radius (KM)", PARAM_RADIUS_MIN, PARAM_RADIUS_MAX, PARAM_RADIUS_DEFAULT);
    public static final String PARAM_SPACING_NAME = "Single Location Grid Spacing (degrees)";
    public static final Double PARAM_SPACING_MIN = 0.001;
    public static final Double PARAM_SPACING_MAX = 1.0;
    public static final Double PARAM_SPACING_DEFAULT = 0.1;
    public static final String PARAM_SPACING_INFO = "The degree spacing that should be used for the circular region around single site requests";
    private DoubleParameter spacingParam = new DoubleParameter("Single Location Grid Spacing (degrees)", PARAM_SPACING_MIN, PARAM_SPACING_MAX, PARAM_SPACING_DEFAULT);

    public MeanTopoSlope() throws IOException {
        this(new SRTM30PlusTopoSlope());
    }

    public MeanTopoSlope(SiteDataAPI<Double> topoSlopeProvider) {
        this.topoSlopeProvider = topoSlopeProvider;
        this.calc = new MeanTopoSlopeCalculator(topoSlopeProvider);
        this.radiusParam.setInfo(PARAM_RADIUS_INFO);
        this.spacingParam.setInfo(PARAM_SPACING_INFO);
        this.paramList.addParameter(this.radiusParam);
        this.paramList.addParameter(this.spacingParam);
    }

    @Override
    public Region getApplicableRegion() {
        return this.topoSlopeProvider.getApplicableRegion();
    }

    @Override
    public Location getClosestDataLocation(Location loc) throws IOException {
        return this.topoSlopeProvider.getClosestDataLocation(loc);
    }

    @Override
    public String getDataMeasurementType() {
        return this.topoSlopeProvider.getDataMeasurementType();
    }

    @Override
    public String getDataType() {
        return this.topoSlopeProvider.getDataType();
    }

    @Override
    public String getMetadata() {
        String meta = "Topographic slope averaged over a region from the following dataset:\n\n";
        meta = meta + this.topoSlopeProvider.getMetadata();
        return meta;
    }

    @Override
    public String getName() {
        return "Regional Mean of " + this.topoSlopeProvider.getName();
    }

    @Override
    public double getResolution() {
        return this.topoSlopeProvider.getResolution();
    }

    @Override
    public String getShortName() {
        return "Mean" + this.topoSlopeProvider.getShortName();
    }

    @Override
    public Double getValue(Location loc) throws IOException {
        double radius = (Double)this.radiusParam.getValue();
        double gridSpacing = (Double)this.spacingParam.getValue();
        return this.calc.getMeanSlope(loc, radius, gridSpacing);
    }

    public Double getValue(GriddedRegion region) throws IOException {
        return this.calc.getMeanSlope(region);
    }

    @Override
    public boolean isValueValid(Double el) {
        return !el.isNaN();
    }
}

