/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.dom4j.Element;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.SiteDataToXYZ;
import org.opensha.commons.data.siteData.servlet.SiteDataServletAccessor;
import org.opensha.commons.exceptions.RegionConstraintException;
import org.opensha.commons.util.binFile.GeolocatedRectangularBinaryMesh2DCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class USGSBayAreaBasinDepth
extends AbstractSiteData<Double> {
    public static final String NAME = "USGS Bay Area Velocity Model Release 8.3.0";
    public static final String SHORT_NAME = "USGSBayAreaBasin";
    public static final double minLat = 35.0;
    public static final double minLon = -127.0;
    private static final int nx = 851;
    private static final int ny = 651;
    private static final long MAX_FILE_POS = 2210000L;
    public static final double gridSpacing = 0.01;
    public static final String DEPTH_2_5_FILE = "data/siteData/SF06/depth_2.5.bin";
    public static final String DEPTH_1_0_FILE = "data/siteData/SF06/depth_1.0.bin";
    public static final String SERVLET_2_5_URL = "http://opensha.usc.edu:8080/OpenSHA_dev/SiteData/SF06_2_5";
    public static final String SERVLET_1_0_URL = "http://opensha.usc.edu:8080/OpenSHA_dev/SiteData/SF06_1_0";
    private RandomAccessFile file = null;
    private String fileName = null;
    private GeolocatedRectangularBinaryMesh2DCalculator calc = null;
    private byte[] recordBuffer = null;
    private FloatBuffer floatBuff = null;
    private boolean useServlet;
    private String type;
    private SiteDataServletAccessor<Double> servlet = null;

    public USGSBayAreaBasinDepth(String type) throws IOException {
        this(type, null, true);
    }

    public USGSBayAreaBasinDepth(String type, String dataFile) throws IOException {
        this(type, dataFile, false);
    }

    public USGSBayAreaBasinDepth(String type, boolean useServlet) throws IOException {
        this(type, null, useServlet);
    }

    public USGSBayAreaBasinDepth(String type, String dataFile, boolean useServlet) throws IOException {
        this.useServlet = useServlet;
        this.fileName = dataFile;
        this.type = type;
        this.calc = new GeolocatedRectangularBinaryMesh2DCalculator(3, 851, 651, 35.0, -127.0, 0.01);
        if (useServlet) {
            this.servlet = type.equals("Depth to Vs = 1.0 km/sec") ? new SiteDataServletAccessor(SERVLET_1_0_URL) : new SiteDataServletAccessor(SERVLET_2_5_URL);
        } else {
            if (dataFile == null) {
                dataFile = type.equals("Depth to Vs = 1.0 km/sec") ? DEPTH_1_0_FILE : DEPTH_2_5_FILE;
            }
            this.file = new RandomAccessFile(new File(dataFile), "r");
            this.calc.setStartBottom(true);
            this.calc.setStartLeft(true);
            this.recordBuffer = new byte[4];
            ByteBuffer record = ByteBuffer.wrap(this.recordBuffer);
            record.order(ByteOrder.LITTLE_ENDIAN);
            this.floatBuff = record.asFloatBuffer();
        }
        this.initDefaultBasinParams();
        this.paramList.addParameter(this.minBasinDoubleParam);
        this.paramList.addParameter(this.maxBasinDoubleParam);
    }

    @Override
    public Region getApplicableRegion() {
        return this.calc.getApplicableRegion();
    }

    @Override
    public Location getClosestDataLocation(Location loc) {
        return this.calc.calcClosestLocation(loc);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getMetadata() {
        return this.type + ", extracted from version 8.3.0 of the USGS Bay Area Velocity Model (used in the SF06" + " simulation project). Extracted March 4, 2009 by Kevin Milner.\n\n" + "It has a grid spacing of " + 0.01 + " degrees";
    }

    @Override
    public double getResolution() {
        return 0.01;
    }

    @Override
    public String getDataType() {
        return this.type;
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    @Override
    public Double getValue(Location loc) throws IOException {
        if (this.useServlet) {
            return this.certifyMinMaxBasinDepth(this.servlet.getValue(loc));
        }
        long pos = this.calc.calcClosestLocationFileIndex(loc);
        if (pos > 2210000L || pos < 0L) {
            return Double.NaN;
        }
        this.file.seek(pos);
        this.file.read(this.recordBuffer);
        double val = this.floatBuff.get(0);
        if (val >= 1.0E8) {
            return Double.NaN;
        }
        Double dobVal = val / 1000.0;
        return this.certifyMinMaxBasinDepth(dobVal);
    }

    @Override
    public ArrayList<Double> getValues(LocationList locs) throws IOException {
        if (this.useServlet) {
            ArrayList<Double> vals = this.servlet.getValues(locs);
            for (int i = 0; i < vals.size(); ++i) {
                vals.set(i, this.certifyMinMaxBasinDepth(vals.get(i)));
            }
            return vals;
        }
        return super.getValues(locs);
    }

    @Override
    public boolean isValueValid(Double val) {
        return val != null && !Double.isNaN(val);
    }

    @Override
    protected Element addXMLParameters(Element paramsEl) {
        paramsEl.addAttribute("useServlet", this.useServlet + "");
        paramsEl.addAttribute("fileName", this.fileName);
        paramsEl.addAttribute("type", this.type);
        return super.addXMLParameters(paramsEl);
    }

    public static USGSBayAreaBasinDepth fromXMLParams(Element paramsElem) throws IOException {
        boolean useServlet = Boolean.parseBoolean(paramsElem.attributeValue("useServlet"));
        String fileName = paramsElem.attributeValue("fileName");
        String type = paramsElem.attributeValue("type");
        return new USGSBayAreaBasinDepth(type, fileName, useServlet);
    }

    public static void main(String[] args) throws RegionConstraintException {
        try {
            USGSBayAreaBasinDepth cvm = new USGSBayAreaBasinDepth("Depth to Vs = 1.0 km/sec", DEPTH_2_5_FILE, true);
            SiteDataToXYZ.writeXYZ(cvm, 0.05, "/tmp/sfbasin.txt");
            System.out.println(cvm.getValue(new Location(35.1, -125.0)));
            System.out.println(cvm.getValue(new Location(36.1, -125.0)));
            System.out.println(cvm.getValue(new Location(40.0, -124.0)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

