/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.servlet;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.siteData.servlet.AbstractSiteDataServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteDataServletAccessor<Element> {
    private String url;
    private int maxLocsPerRequest = 10000;

    public SiteDataServletAccessor(String servletURL) {
        this.url = servletURL;
    }

    public int getMaxLocsPerRequest() {
        return this.maxLocsPerRequest;
    }

    public void setMaxLocsPerRequest(int maxLocsPerRequest) {
        this.maxLocsPerRequest = maxLocsPerRequest;
    }

    public Element getValue(Location loc) throws IOException {
        return (Element)this.getResult(loc);
    }

    public Location getClosestLocation(Location loc) throws IOException {
        return (Location)this.getResult(loc, AbstractSiteDataServlet.OP_GET_CLOSEST);
    }

    public ArrayList<Element> getValues(LocationList locs) throws IOException {
        ArrayList result = null;
        if (this.maxLocsPerRequest > 0 && locs.size() > this.maxLocsPerRequest) {
            result = new ArrayList();
            int done = 0;
            int tot = locs.size();
            for (LocationList partialLocs : locs.split(this.maxLocsPerRequest)) {
                float frac = (float)done / (float)tot * 100.0f;
                result.addAll((ArrayList)this.getResult(partialLocs));
                done += partialLocs.size();
            }
        } else {
            result = (ArrayList)this.getResult(locs);
        }
        return result;
    }

    private Object getResult(Object request) throws IOException {
        return this.getResult(request, null);
    }

    private Object getResult(Object request, String operation) throws IOException {
        URLConnection servletConnection = this.openServletConnection();
        ObjectOutputStream outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
        if (operation != null && operation.length() > 0) {
            outputToServlet.writeObject(operation);
        }
        outputToServlet.writeObject(request);
        ObjectInputStream inputFromServlet = new ObjectInputStream(servletConnection.getInputStream());
        try {
            Object result = inputFromServlet.readObject();
            this.checkForError(result, inputFromServlet);
            inputFromServlet.close();
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkForError(Object obj, ObjectInputStream inputFromServlet) throws IOException, ClassNotFoundException {
        if (obj instanceof Boolean) {
            String message = (String)inputFromServlet.readObject();
            throw new RuntimeException("Status Request Failed: " + message);
        }
    }

    protected URLConnection openServletConnection() throws IOException {
        URL servlet = new URL(this.url);
        URLConnection servletConnection = servlet.openConnection();
        servletConnection.setDoInput(true);
        servletConnection.setDoOutput(true);
        servletConnection.setUseCaches(false);
        servletConnection.setDefaultUseCaches(false);
        servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
        return servletConnection;
    }
}

