/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gridComputing;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.opensha.commons.gridComputing.ResourceProvider;
import org.opensha.commons.gridComputing.StorageHost;
import org.opensha.commons.gridComputing.SubmitHost;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.util.XMLUtils;

public abstract class GridResource
implements XMLSaveable,
Serializable {
    public abstract String getName();

    public void writeToFile(String fileName) throws IOException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(XMLUtils.DEFAULT_ROOT_NAME);
        root = this.toXMLMetadata(root);
        XMLUtils.writeDocumentToFile(fileName, document);
    }

    public static void main(String[] args) {
        String mainDir = "";
        if (args.length > 0) {
            mainDir = args[0];
            if (!mainDir.endsWith(File.separator)) {
                mainDir = mainDir + File.separator;
            }
        } else {
            mainDir = "org/opensha/commons/gridComputing/defaults/";
        }
        try {
            String outDir = mainDir + "rp" + "/";
            ResourceProvider rp = ResourceProvider.HPC();
            rp.writeToFile(outDir + "1hpc.xml");
            rp = ResourceProvider.HPC_SCEC_QUEUE();
            rp.writeToFile(outDir + "1hpc_scec.xml");
            rp = ResourceProvider.DYNAMIC();
            rp.writeToFile(outDir + "3dynamic.xml");
            rp = ResourceProvider.ABE_NO_GLIDE_INS();
            rp.setName("Abe (NCSA/TeraGrid)");
            rp.writeToFile(outDir + "2abe.xml");
            rp = ResourceProvider.ABE_GLIDE_INS();
            rp.setName("Abe WITH GLIDE INS (NCSA/TeraGrid)");
            rp.writeToFile(outDir + "4abe_glide.xml");
            outDir = mainDir + "submit" + "/";
            SubmitHost submit = SubmitHost.AFTERSHOCK;
            submit.writeToFile(outDir + "aftershock.xml");
            outDir = mainDir + "storage" + "/";
            StorageHost storage = StorageHost.HPC;
            storage.writeToFile(outDir + "hpc.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

