/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.opensha.commons.calc.ArcsecondConverter;
import org.opensha.commons.data.ArbDiscretizedXYZ_DataSet;
import org.opensha.commons.data.DataPoint2D;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.XYZ_DataSetAPI;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.exceptions.RegionConstraintException;
import org.opensha.commons.mapping.gmt.GMT_KML_Generator;
import org.opensha.commons.mapping.gmt.GMT_Map;
import org.opensha.commons.mapping.gmt.elements.CoastAttributes;
import org.opensha.commons.mapping.gmt.elements.PSXYPolygon;
import org.opensha.commons.mapping.gmt.elements.PSXYSymbol;
import org.opensha.commons.mapping.gmt.elements.PSXYSymbolSet;
import org.opensha.commons.mapping.gmt.elements.TopographicSlopeFile;
import org.opensha.commons.param.BooleanParameter;
import org.opensha.commons.param.DoubleParameter;
import org.opensha.commons.param.IntegerParameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.StringConstraint;
import org.opensha.commons.param.StringParameter;
import org.opensha.commons.util.RunScript;
import org.opensha.commons.util.cpt.CPT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMT_MapGenerator
implements Serializable {
    protected static final String C = "GMT_MapGenerator";
    protected static final boolean D = false;
    protected static final String DEFAULT_GMT_SCRIPT_NAME = "map_GMT_Script.txt";
    protected String GMT_SCRIPT_NAME = "map_GMT_Script.txt";
    protected static final String DEFAULT_XYZ_FILE_NAME = "map_data.txt";
    protected String XYZ_FILE_NAME = "map_data.txt";
    protected static final String DEFAULT_METADATA_FILE_NAME = "map_info.html";
    protected String METADATA_FILE_NAME = "map_info.html";
    protected static final String DEFAULT_PS_FILE_NAME = "map.ps";
    protected String PS_FILE_NAME = "map.ps";
    public static final String DEFAULT_JPG_FILE_NAME = "map.jpg";
    protected String JPG_FILE_NAME = "map.jpg";
    public static final String DEFAULT_PNG_FILE_NAME = "map.png";
    protected String PNG_FILE_NAME = "map.png";
    protected static final String DEFAULT_PDF_FILE_NAME = "map.pdf";
    protected String PDF_FILE_NAME = "map.pdf";
    protected String SCALE_LABEL;
    public static final String OPENSHA_GMT_PATH = "/usr/local/GMT4.2.1/bin/";
    public static final String OPENSHA_GS_PATH = "/usr/bin/gs";
    public static final String OPENSHA_PS2PDF_PATH = "/usr/bin/ps2pdf";
    public static final String OPENSHA_CONVERT_PATH = "/usr/bin/convert";
    public static final String OPENSHA_GMT_DATA_PATH = "/export/opensha/data/gmt/";
    public static final String OPENSHA_SERVLET_URL = "http://opensha.usc.edu:8080/OpenSHA_dev/GMT_MapGeneratorServlet";
    public static final String OPENSHA_JAVA_PATH = "/usr/java/1.5.0_10/bin/java";
    public static final String OPENSHA_CLASSPATH = "/usr/local/tomcat/default/webapps/OpenSHA/WEB-INF/classes";
    public static final String OPENSHA_NETCDF_LIB_PATH = "/usr/local/netCDF/lib/";
    public static final String GRAVITY_GMT_PATH = "/opt/install/gmt/bin/";
    public static final String GRAVITY_GS_PATH = "/usr/local/bin/gs";
    public static final String GRAVITY_PS2PDF_PATH = "/usr/local/bin/ps2pdf";
    public static final String GRAVITY_CONVERT_PATH = "/usr/bin/convert";
    public static final String GRAVITY_GMT_DATA_PATH = "/usr/scec/data/gmt/";
    public static final String GRAVITY_SERVLET_URL = "http://gravity.usc.edu/OpenSHA/servlet/GMT_MapGeneratorServlet";
    public static final String GRAVITY_JAVA_PATH = "";
    public static final String GRAVITY_CLASSPATH = "";
    protected static String SCEC_GMT_DATA_PATH = "/export/opensha/data/gmt/";
    private static String SERVLET_URL = "http://opensha.usc.edu:8080/OpenSHA_dev/GMT_MapGeneratorServlet";
    private static String JAVA_PATH = "/usr/java/1.5.0_10/bin/java";
    private static String JAVA_CLASSPATH = "/usr/local/tomcat/default/webapps/OpenSHA/WEB-INF/classes";
    protected static String GMT_PATH = "/usr/local/GMT4.2.1/bin/";
    protected static String GS_PATH = "/usr/bin/gs";
    protected static String CONVERT_PATH = "/usr/bin/convert";
    protected static String PS2PDF_PATH = "/usr/bin/ps2pdf";
    protected static String NETCDF_LIB_PATH = "/usr/local/netCDF/lib/";
    protected static String COMMAND_PATH = "/bin/";
    protected XYZ_DataSetAPI xyzDataSet;
    protected String xOff;
    protected String yOff;
    protected String region;
    protected String projWdth;
    public static final String MIN_LAT_PARAM_NAME = "Min Latitude";
    public static final String MAX_LAT_PARAM_NAME = "Max Latitude";
    public static final String MIN_LON_PARAM_NAME = "Min Longitude";
    public static final String MAX_LON_PARAM_NAME = "Max Longitude";
    public static final String GRID_SPACING_PARAM_NAME = "Grid Spacing";
    private static final String LAT_LON_PARAM_UNITS = "Degrees";
    private static final String LAT_LON_PARAM_INFO = "Corner point of mapped region";
    private static final String GRID_SPACING_PARAM_INFO = "Grid interval in the Region";
    private static final Double MIN_LAT_PARAM_DEFAULT = new Double(32.5);
    private static final Double MAX_LAT_PARAM_DEFAULT = new Double(36.6);
    private static final Double MIN_LON_PARAM_DEFAULT = new Double(-121.5);
    private static final Double MAX_LON_PARAM_DEFAULT = new Double(-115.0);
    private static final Double GRID_SPACING_PARAM_DEFAULT = new Double(0.1);
    DoubleParameter minLatParam = new DoubleParameter("Min Latitude", -90.0, 90.0, "Degrees", MIN_LAT_PARAM_DEFAULT);
    DoubleParameter maxLatParam;
    DoubleParameter minLonParam;
    DoubleParameter maxLonParam;
    DoubleParameter gridSpacingParam;
    public static final String IMAGE_WIDTH_NAME = "Image Width";
    private static final String IMAGE_WIDTH_UNITS = "inches";
    private static final String IMAGE_WIDTH_INFO = "Width of the final jpg image (ps file width is always 8.5 inches)";
    private static final double IMAGE_WIDTH_MIN = 1.0;
    private static final double IMAGE_WIDTH_MAX = 20.0;
    protected static final Double IMAGE_WIDTH_DEFAULT = new Double(6.5);
    DoubleParameter imageWidthParam;
    public static final String CPT_FILE_PARAM_NAME = "Color Scheme";
    protected static final String CPT_FILE_PARAM_DEFAULT = "MaxSpectrum.cpt";
    private static final String CPT_FILE_PARAM_INFO = "Color scheme for the scale";
    public static final String CPT_FILE_MAX_SPECTRUM = "MaxSpectrum.cpt";
    public static final String CPT_FILE_STEP = "STEP.cpt";
    public static final String CPT_FILE_SHAKEMAP = "Shakemap.cpt";
    public static final String CPT_FILE_RELM = "relm_color_map.cpt";
    public static final String CPT_FILE_GMT_POLAR = "GMT_polar.cpt";
    StringParameter cptFileParam;
    public static final String COAST_PARAM_NAME = "Coast";
    public static final String COAST_DRAW = "Draw Boundary";
    public static final String COAST_FILL = "Draw & Fill";
    public static final String COAST_NONE = "Draw Nothing";
    protected static final String COAST_DEFAULT = "Draw & Fill";
    private static final String COAST_PARAM_INFO = "Specifies how bodies of water are drawn";
    StringParameter coastParam;
    public static final String COLOR_SCALE_MODE_NAME = "Color Scale Limits";
    public static final String COLOR_SCALE_MODE_INFO = "Set manually or from max/min of the data";
    public static final String COLOR_SCALE_MODE_MANUALLY = "Manually";
    public static final String COLOR_SCALE_MODE_FROMDATA = "From Data";
    public static final String COLOR_SCALE_MODE_DEFAULT = "From Data";
    StringParameter colorScaleModeParam;
    public static final String COLOR_SCALE_MIN_PARAM_NAME = "Color-Scale Min";
    private static final Double COLOR_SCALE_MIN_PARAM_DEFAULT = new Double(-2.0);
    private static final String COLOR_SCALE_MIN_PARAM_INFO = "Lower limit on color scale (values below are the same color)";
    public static final String COLOR_SCALE_MAX_PARAM_NAME = "Color-Scale Max";
    private static final Double COLOR_SCALE_MAX_PARAM_DEFAULT = new Double(-0.5);
    private static final String COLOR_SCALE_MAX_PARAM_INFO = "Upper limit on color scale (values above are the same color)";
    DoubleParameter colorScaleMaxParam;
    DoubleParameter colorScaleMinParam;
    public static final String DPI_PARAM_NAME = "DPI";
    private static final String DPI_PARAM_INFO = "Dots per inch for PS file";
    protected static final Integer DPI_DEFAULT = new Integer(72);
    private static final Integer DPI_MIN = new Integer(0);
    private static final Integer DPI_MAX = new Integer(Integer.MAX_VALUE);
    private IntegerParameter dpiParam;
    public static final String GMT_SMOOTHING_PARAM_NAME = "Apply GMT Smoothing?";
    private static final String GMT_SMOOTHING_PARAM_INFO = "Apply GMT Smoothing?";
    protected static final boolean GMT_SMOOTHING_DEFAULT = true;
    private BooleanParameter gmtSmoothingParam;
    public static final String TOPO_RESOLUTION_PARAM_NAME = "Topo Resolution";
    private static final String TOPO_RESOLUTION_PARAM_UNITS = "arc-sec";
    private static final String TOPO_RESOLUTION_PARAM_INFO = "Resolution of the shaded relief";
    private static final String TOPO_RESOLUTION_03_CA = "03 sec California";
    private static final String TOPO_RESOLUTION_06_CA = "06 sec California";
    private static final String TOPO_RESOLUTION_18_CA = "18 sec California";
    private static final String TOPO_RESOLUTION_30_CA = "30 sec California";
    private static final String TOPO_RESOLUTION_30_GLOBAL = "30 sec Global";
    protected static final String TOPO_RESOLUTION_PARAM_DEFAULT = "30 sec Global";
    public static final String TOPO_RESOLUTION_NONE = "No Topo";
    StringParameter topoResolutionParam;
    public static final String SHOW_HIWYS_PARAM_NAME = "Highways in plot";
    public static final String SHOW_HIWYS_PARAM_DEFAULT = "None";
    public static final String SHOW_HIWYS_PARAM_INFO = "Select the highways you'd like to be shown";
    public static final String SHOW_HIWYS_ALL = "ca_hiwys.all.xy";
    public static final String SHOW_HIWYS_MAIN = "ca_hiwys.main.xy";
    public static final String SHOW_HIWYS_OTHER = "ca_hiwys.other.xy";
    public static final String SHOW_HIWYS_NONE = "None";
    StringParameter showHiwysParam;
    public static final String GMT_WEBSERVICE_NAME = "Use GMT WebService";
    private static final String GMT_WEBSERVICE_INFO = "Use server-mode GMT (rather than on this computer)";
    BooleanParameter gmtFromServer;
    public static final String LOG_PLOT_NAME = "Plot Log";
    private static final String LOG_PLOT_INFO = "Plot Log or Linear Map";
    protected static final boolean LOG_PLOT_PARAM_DEFAULT = true;
    protected BooleanParameter logPlotParam;
    public static final String CUSTOM_SCALE_LABEL_PARAM_CHECK_NAME = "Custom Scale Label";
    private static final String CUSTOM_SCALE_LABEL_PARAM_CHECK_INFO = "Allows to give a custom scale label to the map";
    protected BooleanParameter customScaleLabelCheckParam;
    public static final String SCALE_LABEL_PARAM_NAME = "Scale Label";
    private static final String SCALE_LABEL_PARAM_INFO = "Map Scale Label(Don't give any brackets in label)";
    protected StringParameter scaleLabelParam;
    protected ParameterList adjustableParams;
    protected String imgWebAddr = null;

    public GMT_MapGenerator() {
        this.minLatParam.setInfo(LAT_LON_PARAM_INFO);
        this.maxLatParam = new DoubleParameter(MAX_LAT_PARAM_NAME, -90.0, 90.0, LAT_LON_PARAM_UNITS, MAX_LAT_PARAM_DEFAULT);
        this.minLatParam.setInfo(LAT_LON_PARAM_INFO);
        this.minLonParam = new DoubleParameter(MIN_LON_PARAM_NAME, -360.0, 360.0, LAT_LON_PARAM_UNITS, MIN_LON_PARAM_DEFAULT);
        this.minLatParam.setInfo(LAT_LON_PARAM_INFO);
        this.maxLonParam = new DoubleParameter(MAX_LON_PARAM_NAME, -360.0, 360.0, LAT_LON_PARAM_UNITS, MAX_LON_PARAM_DEFAULT);
        this.minLatParam.setInfo(LAT_LON_PARAM_INFO);
        this.gridSpacingParam = new DoubleParameter(GRID_SPACING_PARAM_NAME, 0.001, 100.0, LAT_LON_PARAM_UNITS, GRID_SPACING_PARAM_DEFAULT);
        this.minLatParam.setInfo(GRID_SPACING_PARAM_INFO);
        this.imageWidthParam = new DoubleParameter(IMAGE_WIDTH_NAME, 1.0, 20.0, IMAGE_WIDTH_UNITS, IMAGE_WIDTH_DEFAULT);
        this.imageWidthParam.setInfo(IMAGE_WIDTH_INFO);
        StringConstraint cptFileConstraint = new StringConstraint();
        cptFileConstraint.addString("MaxSpectrum.cpt");
        cptFileConstraint.addString(CPT_FILE_STEP);
        cptFileConstraint.addString(CPT_FILE_SHAKEMAP);
        cptFileConstraint.addString(CPT_FILE_RELM);
        cptFileConstraint.addString(CPT_FILE_GMT_POLAR);
        this.cptFileParam = new StringParameter(CPT_FILE_PARAM_NAME, cptFileConstraint, "MaxSpectrum.cpt");
        this.cptFileParam.setInfo(CPT_FILE_PARAM_INFO);
        StringConstraint coastConstraint = new StringConstraint();
        coastConstraint.addString("Draw & Fill");
        coastConstraint.addString(COAST_DRAW);
        coastConstraint.addString(COAST_NONE);
        this.coastParam = new StringParameter(COAST_PARAM_NAME, coastConstraint, "Draw & Fill");
        this.coastParam.setInfo(COAST_PARAM_INFO);
        StringConstraint colorScaleModeConstraint = new StringConstraint();
        colorScaleModeConstraint.addString("From Data");
        colorScaleModeConstraint.addString(COLOR_SCALE_MODE_MANUALLY);
        this.colorScaleModeParam = new StringParameter(COLOR_SCALE_MODE_NAME, colorScaleModeConstraint, "From Data");
        this.colorScaleModeParam.setInfo(COLOR_SCALE_MODE_INFO);
        this.colorScaleMinParam = new DoubleParameter(COLOR_SCALE_MIN_PARAM_NAME, COLOR_SCALE_MIN_PARAM_DEFAULT);
        this.colorScaleMinParam.setInfo(COLOR_SCALE_MIN_PARAM_INFO);
        this.colorScaleMaxParam = new DoubleParameter(COLOR_SCALE_MAX_PARAM_NAME, COLOR_SCALE_MAX_PARAM_DEFAULT);
        this.colorScaleMaxParam.setInfo(COLOR_SCALE_MAX_PARAM_INFO);
        StringConstraint topoResolutionConstraint = new StringConstraint();
        topoResolutionConstraint.addString("30 sec Global");
        topoResolutionConstraint.addString(TOPO_RESOLUTION_30_CA);
        topoResolutionConstraint.addString(TOPO_RESOLUTION_18_CA);
        topoResolutionConstraint.addString(TOPO_RESOLUTION_06_CA);
        topoResolutionConstraint.addString(TOPO_RESOLUTION_03_CA);
        topoResolutionConstraint.addString(TOPO_RESOLUTION_NONE);
        this.topoResolutionParam = new StringParameter(TOPO_RESOLUTION_PARAM_NAME, topoResolutionConstraint, TOPO_RESOLUTION_PARAM_UNITS, "30 sec Global");
        this.topoResolutionParam.setInfo(TOPO_RESOLUTION_PARAM_INFO);
        StringConstraint showHiwysConstraint = new StringConstraint();
        showHiwysConstraint.addString("None");
        showHiwysConstraint.addString(SHOW_HIWYS_ALL);
        showHiwysConstraint.addString(SHOW_HIWYS_MAIN);
        showHiwysConstraint.addString(SHOW_HIWYS_OTHER);
        this.showHiwysParam = new StringParameter(SHOW_HIWYS_PARAM_NAME, showHiwysConstraint, "None");
        this.showHiwysParam.setInfo(SHOW_HIWYS_PARAM_INFO);
        this.gmtFromServer = new BooleanParameter(GMT_WEBSERVICE_NAME, new Boolean("true"));
        this.gmtFromServer.setInfo(GMT_WEBSERVICE_INFO);
        this.logPlotParam = new BooleanParameter(LOG_PLOT_NAME, true);
        this.logPlotParam.setInfo(LOG_PLOT_INFO);
        this.customScaleLabelCheckParam = new BooleanParameter(CUSTOM_SCALE_LABEL_PARAM_CHECK_NAME, new Boolean(false));
        this.customScaleLabelCheckParam.setInfo(CUSTOM_SCALE_LABEL_PARAM_CHECK_INFO);
        this.scaleLabelParam = new StringParameter(SCALE_LABEL_PARAM_NAME, "");
        this.scaleLabelParam.setInfo(SCALE_LABEL_PARAM_INFO);
        this.dpiParam = new IntegerParameter(DPI_PARAM_NAME, DPI_MIN, DPI_MAX, DPI_DEFAULT);
        this.dpiParam.setInfo(DPI_PARAM_INFO);
        this.gmtSmoothingParam = new BooleanParameter("Apply GMT Smoothing?", true);
        this.gmtSmoothingParam.setInfo("Apply GMT Smoothing?");
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.minLatParam);
        this.adjustableParams.addParameter(this.maxLatParam);
        this.adjustableParams.addParameter(this.minLonParam);
        this.adjustableParams.addParameter(this.maxLonParam);
        this.adjustableParams.addParameter(this.gridSpacingParam);
        this.adjustableParams.addParameter(this.cptFileParam);
        this.adjustableParams.addParameter(this.colorScaleModeParam);
        this.adjustableParams.addParameter(this.colorScaleMinParam);
        this.adjustableParams.addParameter(this.colorScaleMaxParam);
        this.adjustableParams.addParameter(this.topoResolutionParam);
        this.adjustableParams.addParameter(this.showHiwysParam);
        this.adjustableParams.addParameter(this.coastParam);
        this.adjustableParams.addParameter(this.imageWidthParam);
        this.adjustableParams.addParameter(this.customScaleLabelCheckParam);
        this.adjustableParams.addParameter(this.scaleLabelParam);
        this.adjustableParams.addParameter(this.gmtSmoothingParam);
        this.adjustableParams.addParameter(this.dpiParam);
        this.adjustableParams.addParameter(this.gmtFromServer);
        this.adjustableParams.addParameter(this.logPlotParam);
    }

    public String makeMapLocally(XYZ_DataSetAPI xyzDataSet, String scaleLabel, String metadata, String dirName) throws GMT_MapException {
        this.createMapInfoFile(metadata);
        GMT_PATH = "/sw/bin/";
        GS_PATH = "/sw/bin/gs";
        PS2PDF_PATH = "/sw/bin/ps2pdf";
        CONVERT_PATH = "/sw/bin/convert";
        this.SCALE_LABEL = scaleLabel;
        this.xyzDataSet = xyzDataSet;
        this.checkForLogPlot();
        this.makeXYZ_File(this.XYZ_FILE_NAME);
        ArrayList gmtLines = this.getGMT_ScriptLines();
        this.makeFileFromLines(gmtLines, this.GMT_SCRIPT_NAME);
        String[] command = new String[]{"sh", "-c", "sh " + this.GMT_SCRIPT_NAME};
        RunScript.runScript(command);
        return this.JPG_FILE_NAME;
    }

    public GMT_Map getGMTMapSpecification(XYZ_DataSetAPI xyzData) {
        Region region = new Region(new Location((Double)this.minLatParam.getValue(), (Double)this.minLonParam.getValue()), new Location((Double)this.maxLatParam.getValue(), (Double)this.maxLonParam.getValue()));
        GMT_Map map = new GMT_Map(region, xyzData, (double)((Double)this.gridSpacingParam.getValue()), (String)this.cptFileParam.getValue());
        map.setXyzFileName(this.XYZ_FILE_NAME);
        map.setPSFileName(this.PS_FILE_NAME);
        map.setPDFFileName(this.PDF_FILE_NAME);
        map.setPNGFileName(this.PNG_FILE_NAME);
        map.setJPGFileName(this.JPG_FILE_NAME);
        CoastAttributes coast = null;
        if (((String)this.coastParam.getValue()).equals(COAST_DRAW)) {
            coast = new CoastAttributes(4.0);
        } else if (((String)this.coastParam.getValue()).equals("Draw & Fill")) {
            coast = new CoastAttributes();
        }
        map.setCoast(coast);
        if (((Boolean)this.customScaleLabelCheckParam.getValue()).booleanValue()) {
            map.setCustomLabel((String)this.scaleLabelParam.getValue());
        } else {
            map.setCustomLabel(null);
        }
        if (((String)this.colorScaleModeParam.getValue()).equals(COLOR_SCALE_MODE_MANUALLY)) {
            map.setCustomScaleMin((Double)this.colorScaleMinParam.getValue());
            map.setCustomScaleMax((Double)this.colorScaleMaxParam.getValue());
        } else {
            map.setCustomScaleMin(null);
            map.setCustomScaleMax(null);
        }
        map.setDpi((Integer)this.dpiParam.getValue());
        if (((String)this.showHiwysParam.getValue()).equals(SHOW_HIWYS_ALL)) {
            map.setHighwayFile(GMT_Map.HighwayFile.ALL);
        } else if (((String)this.showHiwysParam.getValue()).equals(SHOW_HIWYS_MAIN)) {
            map.setHighwayFile(GMT_Map.HighwayFile.MAIN);
        } else if (((String)this.showHiwysParam.getValue()).equals(SHOW_HIWYS_OTHER)) {
            map.setHighwayFile(GMT_Map.HighwayFile.OTHER);
        } else {
            map.setHighwayFile(null);
        }
        map.setImageWidth((Double)this.imageWidthParam.getValue());
        map.setLogPlot((Boolean)this.logPlotParam.getValue());
        map.setRescaleCPT(true);
        if (((String)this.topoResolutionParam.getValue()).equals(TOPO_RESOLUTION_03_CA)) {
            map.setTopoResolution(TopographicSlopeFile.CA_THREE);
        } else if (((String)this.topoResolutionParam.getValue()).equals(TOPO_RESOLUTION_06_CA)) {
            map.setTopoResolution(TopographicSlopeFile.CA_SIX);
        } else if (((String)this.topoResolutionParam.getValue()).equals(TOPO_RESOLUTION_18_CA)) {
            map.setTopoResolution(TopographicSlopeFile.CA_EIGHTEEN);
        } else if (((String)this.topoResolutionParam.getValue()).equals(TOPO_RESOLUTION_30_CA)) {
            map.setTopoResolution(TopographicSlopeFile.CA_THIRTY);
        } else if (((String)this.topoResolutionParam.getValue()).equals("30 sec Global")) {
            map.setTopoResolution(TopographicSlopeFile.SRTM_30_PLUS);
        } else {
            map.setTopoResolution(null);
        }
        map.setUseGMTSmoothing((Boolean)this.gmtSmoothingParam.getValue());
        return map;
    }

    public String makeMapUsingServlet(XYZ_DataSetAPI xyzDataSet, String scaleLabel, String metadata, String dirName) throws GMT_MapException, RuntimeException {
        GMT_Map map = this.getGMTMapSpecification(xyzDataSet);
        map.setCustomLabel(scaleLabel);
        return this.makeMapUsingServlet(map, metadata, dirName);
    }

    public String makeMapUsingServlet(GMT_Map map, String metadata, String dirName) throws GMT_MapException, RuntimeException {
        GMT_PATH = OPENSHA_GMT_PATH;
        GS_PATH = OPENSHA_GS_PATH;
        PS2PDF_PATH = OPENSHA_PS2PDF_PATH;
        CONVERT_PATH = "/usr/bin/convert";
        this.xyzDataSet = map.getGriddedData();
        this.checkForLogPlot();
        if (!this.xyzDataSet.checkXYZ_NumVals()) {
            throw new RuntimeException("X, Y and Z dataset does not have equal size");
        }
        this.imgWebAddr = this.openServletConnection(map, metadata, dirName);
        if (!this.imgWebAddr.endsWith(File.separator)) {
            this.imgWebAddr = this.imgWebAddr + File.separator;
        }
        return this.imgWebAddr + this.JPG_FILE_NAME;
    }

    public String makeMapUsingWebServer(XYZ_DataSetAPI xyzDataSet, String scaleLabel, String metadata) throws GMT_MapException {
        this.createMapInfoFile(metadata);
        GMT_PATH = OPENSHA_GMT_PATH;
        GS_PATH = OPENSHA_GS_PATH;
        PS2PDF_PATH = OPENSHA_PS2PDF_PATH;
        CONVERT_PATH = "/usr/bin/convert";
        this.SCALE_LABEL = scaleLabel;
        this.xyzDataSet = xyzDataSet;
        this.checkForLogPlot();
        this.makeXYZ_File(this.XYZ_FILE_NAME);
        ArrayList gmtLines = this.getGMT_ScriptLines();
        this.makeFileFromLines(gmtLines, this.GMT_SCRIPT_NAME);
        String[] fileNames = new String[]{this.GMT_SCRIPT_NAME, this.XYZ_FILE_NAME, this.METADATA_FILE_NAME};
        return this.imgWebAddr + this.JPG_FILE_NAME;
    }

    public ListIterator getAdjustableParamsIterator() {
        return this.adjustableParams.getParametersIterator();
    }

    public ParameterList getAdjustableParamsList() {
        return this.adjustableParams;
    }

    public String getImageFileName() {
        return this.JPG_FILE_NAME;
    }

    protected ArrayList getMapInfoLines() {
        ArrayList<String> metadataFilesLines = new ArrayList<String>();
        try {
            FileReader fr = new FileReader(this.METADATA_FILE_NAME);
            BufferedReader br = new BufferedReader(fr);
            String fileLines = br.readLine();
            while (fileLines != null) {
                metadataFilesLines.add(fileLines);
                fileLines = br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return metadataFilesLines;
    }

    protected void makeXYZ_File(String fileName) {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<Double> xVals = this.xyzDataSet.getX_DataSet();
        ArrayList<Double> yVals = this.xyzDataSet.getY_DataSet();
        ArrayList<Double> zVals = this.xyzDataSet.getZ_DataSet();
        if (this.xyzDataSet.checkXYZ_NumVals()) {
            int size = xVals.size();
            for (int i = 0; i < size; ++i) {
                if (Double.isNaN(zVals.get(i))) continue;
                lines.add(xVals.get(i) + " " + yVals.get(i) + " " + zVals.get(i));
            }
        } else {
            throw new RuntimeException("X, Y and Z dataset does not have equal size");
        }
        this.makeFileFromLines(lines, fileName);
    }

    protected void make_xyzDataSet(String fileName) {
        ArrayList<Double> xVals = new ArrayList<Double>();
        ArrayList<Double> yVals = new ArrayList<Double>();
        ArrayList<Double> zVals = new ArrayList<Double>();
        try {
            FileReader fr = new FileReader(fileName);
            BufferedReader bf = new BufferedReader(fr);
            String str = bf.readLine();
            while (str != null) {
                StringTokenizer tokenizer = new StringTokenizer(str);
                xVals.add(new Double(tokenizer.nextToken()));
                yVals.add(new Double(tokenizer.nextToken()));
                zVals.add(new Double(tokenizer.nextToken()));
                str = bf.readLine();
            }
            bf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.xyzDataSet = new ArbDiscretizedXYZ_DataSet(xVals, yVals, zVals);
    }

    protected void makeFileFromLines(ArrayList lines, String fileName) {
        try {
            FileWriter fw = new FileWriter(fileName);
            BufferedWriter br = new BufferedWriter(fw);
            for (int i = 0; i < lines.size(); ++i) {
                br.write((String)lines.get(i) + "\n");
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMetatdataFileName(String fileName) {
        this.METADATA_FILE_NAME = fileName;
    }

    protected String openServletConnection(GMT_Map map, String metadataLines, String dirName) throws RuntimeException {
        String webaddr = null;
        try {
            URL gmtMapServlet = new URL(SERVLET_URL);
            URLConnection servletConnection = gmtMapServlet.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            outputToServlet.writeObject(dirName);
            outputToServlet.writeObject(map);
            outputToServlet.writeObject(metadataLines);
            outputToServlet.writeObject(DEFAULT_METADATA_FILE_NAME);
            outputToServlet.flush();
            outputToServlet.close();
            ObjectInputStream inputToServlet = new ObjectInputStream(servletConnection.getInputStream());
            Object messageFromServlet = inputToServlet.readObject();
            inputToServlet.close();
            if (!(messageFromServlet instanceof String)) {
                throw (RuntimeException)messageFromServlet;
            }
            webaddr = (String)messageFromServlet;
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Server is down , please try again later");
        }
        return webaddr;
    }

    public void makeMapForCME(String xyzFileName, String pdfFileName, String psFileName, String jpgFileName, String scaleLabel) throws GMT_MapException {
        this.XYZ_FILE_NAME = xyzFileName;
        this.PS_FILE_NAME = psFileName;
        this.JPG_FILE_NAME = jpgFileName;
        this.PDF_FILE_NAME = pdfFileName;
        GMT_PATH = GRAVITY_GMT_PATH;
        GS_PATH = GRAVITY_GS_PATH;
        PS2PDF_PATH = GRAVITY_PS2PDF_PATH;
        CONVERT_PATH = "/usr/bin/convert";
        this.SCALE_LABEL = scaleLabel;
        this.make_xyzDataSet(this.XYZ_FILE_NAME);
        this.checkForLogPlot();
        boolean logPlotCheck = (Boolean)this.logPlotParam.getValue();
        if (logPlotCheck) {
            this.XYZ_FILE_NAME = "Log_" + this.XYZ_FILE_NAME;
            this.makeXYZ_File(this.XYZ_FILE_NAME);
        }
        ArrayList gmtLines = this.getGMT_ScriptLines();
        this.makeFileFromLines(gmtLines, this.GMT_SCRIPT_NAME);
        String[] command = new String[]{"sh", "-c", "sh " + this.GMT_SCRIPT_NAME};
        RunScript.runScript(command);
        this.XYZ_FILE_NAME = DEFAULT_XYZ_FILE_NAME;
        this.PS_FILE_NAME = DEFAULT_PS_FILE_NAME;
        this.JPG_FILE_NAME = DEFAULT_JPG_FILE_NAME;
    }

    public void setParameter(String paramName, Object value) {
        this.adjustableParams.getParameter(paramName).setValue(value);
    }

    public String getGMTFilesWebAddress() {
        return this.imgWebAddr;
    }

    private double getNiceKmScaleLength(double lat, double minLon, double maxLon) {
        double test;
        double target = (maxLon - minLon) * 111.0 * Math.cos(Math.PI * lat / 180.0) / 4.0;
        for (test = 0.1; target > test; test *= 10.0) {
        }
        return Math.ceil(target / (test /= 10.0)) * test;
    }

    private double getNiceMapTickInterval(double minLat, double maxLat, double minLon, double maxLon) {
        double niceTick = Double.NaN;
        double diff = maxLat - minLat < maxLon - minLon ? maxLat - minLat : maxLon - minLon;
        diff /= 2.0;
        boolean finished = false;
        double fact = 100.0;
        while (!finished) {
            double d;
            double d2;
            double d3;
            niceTick = 1.0 * fact;
            if (d3 <= diff) {
                finished = true;
                continue;
            }
            niceTick = 0.5 * fact;
            if (d2 <= diff) {
                finished = true;
                continue;
            }
            niceTick = 0.25 * fact;
            if (d <= diff) {
                finished = true;
                continue;
            }
            fact /= 10.0;
        }
        return (float)niceTick;
    }

    public GriddedRegion getEvenlyGriddedGeographicRegion() throws RegionConstraintException {
        double minLat = (Double)this.minLatParam.getValue();
        double maxLat = (Double)this.maxLatParam.getValue();
        double minLon = (Double)this.minLonParam.getValue();
        double maxLon = (Double)this.maxLonParam.getValue();
        double gridSpacing = (Double)this.gridSpacingParam.getValue();
        return new GriddedRegion(new Location(minLat, minLon), new Location(maxLat, maxLon), gridSpacing, new Location(0.0, 0.0));
    }

    protected ArrayList getGMT_ScriptLines() throws GMT_MapException {
        double colorScaleMax;
        double colorScaleMin;
        ArrayList<String> rmFiles = new ArrayList<String>();
        ArrayList<String> gmtCommandLines = new ArrayList<String>();
        double minLat = (Double)this.minLatParam.getValue();
        double maxTempLat = (Double)this.maxLatParam.getValue();
        double minLon = (Double)this.minLonParam.getValue();
        double maxTempLon = (Double)this.maxLonParam.getValue();
        double gridSpacing = (Double)this.gridSpacingParam.getValue();
        double maxLat = Math.rint((maxTempLat - minLat) / gridSpacing) * gridSpacing + minLat;
        double maxLon = Math.rint((maxTempLon - minLon) / gridSpacing) * gridSpacing + minLon;
        this.region = " -R" + minLon + "/" + maxLon + "/" + minLat + "/" + maxLat + " ";
        String fileName = "temp_junk";
        String grdFileName = fileName + ".grd";
        rmFiles.add(grdFileName);
        String cptFile = SCEC_GMT_DATA_PATH + (String)this.cptFileParam.getValue();
        String colorScaleMode = (String)this.colorScaleModeParam.getValue();
        String coast = (String)this.coastParam.getValue();
        String resolution = (String)this.topoResolutionParam.getValue();
        String topoIntenFile = SCEC_GMT_DATA_PATH + "calTopoInten" + resolution + ".grd";
        if (!resolution.equals(TOPO_RESOLUTION_NONE) && (maxLat > 43.0 || minLat < 32.0 || minLon < -126.0 || maxLon > -115.0)) {
            throw new GMT_MapException("Topography not available for the chosen region; please select \"No Topo\" for the Topo Resolution parameter");
        }
        String showHiwys = (String)this.showHiwysParam.getValue();
        double plotWdth = 6.5;
        this.projWdth = " -JM" + plotWdth + "i ";
        double plotHght = (maxLat - minLat) / (maxLon - minLon) * plotWdth / Math.cos(Math.PI * (maxLat + minLat) / 360.0);
        double yOffset = 11.0 - plotHght - 0.5;
        this.yOff = " -Y" + yOffset + "i ";
        this.xOff = " -X1.0i ";
        gmtCommandLines.add("#!/bin/bash\n\n");
        gmtCommandLines.add("# path variables\n");
        gmtCommandLines.add("GMT_PATH='" + GMT_PATH + "'\n");
        gmtCommandLines.add("CONVERT_PATH='" + CONVERT_PATH + "'\n");
        gmtCommandLines.add("COMMAND_PATH='" + COMMAND_PATH + "'\n");
        gmtCommandLines.add("PS2PDF_PATH='" + PS2PDF_PATH + "'\n\n");
        String commandLine = "${GMT_PATH}xyz2grd " + this.XYZ_FILE_NAME + " -G" + grdFileName + " -I" + gridSpacing + this.region + " -D/degree/degree/amp/=/=/=  -: -H0";
        gmtCommandLines.add(commandLine + "\n");
        if (colorScaleMode.equals(COLOR_SCALE_MODE_MANUALLY)) {
            colorScaleMin = (Double)this.colorScaleMinParam.getValue();
            if (colorScaleMin >= (colorScaleMax = ((Double)this.colorScaleMaxParam.getValue()).doubleValue())) {
                throw new RuntimeException("Error: Color-Scale Min must be less than the Max");
            }
        } else {
            colorScaleMin = this.xyzDataSet.getMinZ();
            colorScaleMax = this.xyzDataSet.getMaxZ();
            System.out.println(colorScaleMin + "," + colorScaleMax);
            if (colorScaleMin == colorScaleMax) {
                throw new RuntimeException("Can't make the image plot because all Z values in the XYZ dataset have the same value ");
            }
        }
        float inc = (float)((colorScaleMax - colorScaleMin) / 20.0);
        commandLine = "${GMT_PATH}makecpt -C" + cptFile + " -T" + colorScaleMin + "/" + colorScaleMax + "/" + inc + " -Z > " + fileName + ".cpt";
        gmtCommandLines.add(commandLine + "\n");
        commandLine = "${GMT_PATH}gmtset ANOT_FONT_SIZE 14p LABEL_FONT_SIZE 18p PAGE_COLOR 0/0/0 PAGE_ORIENTATION portrait PAPER_MEDIA letter";
        gmtCommandLines.add(commandLine + "\n");
        int dpi = (Integer)this.dpiParam.getValue();
        String gmtSmoothOption = "";
        if (!((Boolean)this.gmtSmoothingParam.getValue()).booleanValue()) {
            gmtSmoothOption = " -T ";
        }
        if (resolution.equals(TOPO_RESOLUTION_NONE)) {
            commandLine = "${GMT_PATH}grdimage " + grdFileName + this.xOff + this.yOff + this.projWdth + " -C" + fileName + ".cpt " + gmtSmoothOption + " -K -E" + dpi + this.region + " > " + this.PS_FILE_NAME;
            gmtCommandLines.add(commandLine + "\n");
        } else {
            gridSpacing = new Integer(resolution).doubleValue() / 3600.0;
            double tempNum = Math.ceil((minLat - 32.0) / gridSpacing);
            minLat = tempNum * gridSpacing + 32.0;
            tempNum = Math.ceil((minLon - -126.0) / gridSpacing);
            minLon = tempNum * gridSpacing + -126.0;
            maxLat = Math.floor((maxLat - minLat) / gridSpacing) * gridSpacing + minLat;
            maxLon = Math.floor((maxLon - minLon) / gridSpacing) * gridSpacing + minLon;
            this.region = " -R" + minLon + "/" + maxLon + "/" + minLat + "/" + maxLat + " ";
            String hiResFile = fileName + "HiResData.grd";
            rmFiles.add(hiResFile);
            commandLine = "${GMT_PATH}grdsample " + grdFileName + " -G" + hiResFile + " -I" + resolution + "c -Q " + this.region;
            gmtCommandLines.add(commandLine + "\n");
            String intenFile = fileName + "Inten.grd";
            commandLine = "${GMT_PATH}grdcut " + topoIntenFile + " -G" + intenFile + " " + this.region;
            rmFiles.add(intenFile);
            gmtCommandLines.add(commandLine + "\n");
            commandLine = "${GMT_PATH}grdimage " + hiResFile + " " + this.xOff + this.yOff + this.projWdth + " -I" + fileName + "Inten.grd -C" + fileName + ".cpt " + gmtSmoothOption + "-K -E" + dpi + this.region + " > " + this.PS_FILE_NAME;
            gmtCommandLines.add(commandLine + "\n");
        }
        if (!showHiwys.equals("None")) {
            commandLine = "${GMT_PATH}psxy  " + this.region + this.projWdth + " -K -O -W5/125/125/125 -: -Ms " + SCEC_GMT_DATA_PATH + showHiwys + " >> " + this.PS_FILE_NAME;
            gmtCommandLines.add(commandLine + "\n");
        }
        if (coast.equals("Draw & Fill")) {
            commandLine = "${GMT_PATH}pscoast " + this.region + this.projWdth + " -K -O  -W1/17/73/71 -P -S17/73/71 -Dh -N2 >> " + this.PS_FILE_NAME;
            gmtCommandLines.add(commandLine + "\n");
        } else if (coast.equals(COAST_DRAW)) {
            commandLine = "${GMT_PATH}pscoast " + this.region + this.projWdth + " -K -O  -W4/0/0/0 -P -Dh -N2>> " + this.PS_FILE_NAME;
            gmtCommandLines.add(commandLine + "\n");
        }
        this.addIntermediateGMT_ScriptLines(gmtCommandLines);
        commandLine = "${GMT_PATH}gmtset BASEMAP_FRAME_RGB 255/255/255 PLOT_DEGREE_FORMAT -D FRAME_WIDTH 0.1i COLOR_FOREGROUND 255/255/255";
        gmtCommandLines.add(commandLine + "\n");
        DecimalFormat df2 = new DecimalFormat("0.E0");
        Float tickInc = new Float(df2.format((colorScaleMax - colorScaleMin) / 4.0));
        inc = tickInc.floatValue();
        boolean customLabelSelected = (Boolean)this.customScaleLabelCheckParam.getValue();
        String scaleLabel = "";
        scaleLabel = customLabelSelected ? (String)this.scaleLabelParam.getValue() : this.SCALE_LABEL;
        commandLine = "${GMT_PATH}psscale -Ba" + inc + ":" + scaleLabel + ": -D3.25i/-0.5i/6i/0.3ih -C" + fileName + ".cpt -O -K -N70 >> " + this.PS_FILE_NAME;
        gmtCommandLines.add(commandLine + "\n");
        double niceKmLength = this.getNiceKmScaleLength(minLat, minLon, maxLon);
        double kmScaleXoffset = plotWdth / 2.0;
        double niceTick = this.getNiceMapTickInterval(minLat, maxLat, minLon, maxLon);
        commandLine = "${GMT_PATH}psbasemap -B" + niceTick + "/" + niceTick + "eWNs " + this.projWdth + this.region + " -Lfx" + kmScaleXoffset + "i/0.5i/" + minLat + "/" + niceKmLength + " -O >> " + this.PS_FILE_NAME;
        gmtCommandLines.add(commandLine + "\n");
        boolean use_gs_raster = true;
        int heightInPixels = (int)((11.0 - yOffset + 2.0) * (double)dpi);
        String convertArgs = "-crop 595x" + heightInPixels + "+0+0";
        double imageWidth = (Double)this.imageWidthParam.getValue();
        if (imageWidth != IMAGE_WIDTH_DEFAULT) {
            int wdth = (int)(imageWidth * (double)dpi);
            convertArgs = convertArgs + " -filter Lanczos -geometry " + wdth;
        }
        if (use_gs_raster) {
            int jpeg_quality = 90;
            gmtCommandLines.add("${COMMAND_PATH}cat " + this.PS_FILE_NAME + " | " + GS_PATH + " -sDEVICE=jpeg " + " -dJPEGQ=" + jpeg_quality + " -sOutputFile=" + this.JPG_FILE_NAME + " -\n");
            gmtCommandLines.add("${COMMAND_PATH}cat " + this.PS_FILE_NAME + " | " + GS_PATH + " -sDEVICE=png16m " + " -sOutputFile=" + this.PNG_FILE_NAME + " -\n");
            gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + this.JPG_FILE_NAME + " " + this.JPG_FILE_NAME + "\n");
            gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + this.PNG_FILE_NAME + " " + this.PNG_FILE_NAME + "\n");
        } else {
            convertArgs = "-density " + dpi + " " + convertArgs;
            gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + this.PS_FILE_NAME + " " + this.JPG_FILE_NAME + "\n");
            gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + this.PS_FILE_NAME + " " + this.PNG_FILE_NAME + "\n");
        }
        boolean googleearth = true;
        if (googleearth) {
            System.out.println("Making Google Earth files!");
            String gEarth_psFileName = "gEarth_" + this.PS_FILE_NAME;
            rmFiles.add(gEarth_psFileName);
            String gEarth_proj = " -JQ180/" + plotWdth + "i ";
            String gEarth_kmz_name = "./map.kmz";
            if (resolution.equals(TOPO_RESOLUTION_NONE)) {
                commandLine = "${GMT_PATH}grdimage " + grdFileName + this.xOff + this.yOff + gEarth_proj + " -C" + fileName + ".cpt " + gmtSmoothOption + " -K -E" + dpi + this.region + " > " + gEarth_psFileName;
                gmtCommandLines.add(commandLine + "\n");
            } else {
                commandLine = "${GMT_PATH}grdimage " + fileName + "HiResData.grd " + this.xOff + this.yOff + gEarth_proj + " -I" + fileName + "Inten.grd -C" + fileName + ".cpt " + gmtSmoothOption + "-K -E" + dpi + this.region + " > " + gEarth_psFileName;
                gmtCommandLines.add(commandLine + "\n");
            }
            commandLine = JAVA_PATH + " -cp " + JAVA_CLASSPATH + " " + GMT_KML_Generator.class.getName() + " " + gEarth_psFileName + " " + gEarth_kmz_name + " " + minLat + " " + maxLat + " " + minLon + " " + maxLon;
            gmtCommandLines.add(commandLine + "\n");
        }
        commandLine = "${PS2PDF_PATH}  " + this.PS_FILE_NAME + "  " + this.PDF_FILE_NAME;
        gmtCommandLines.add(commandLine + "\n");
        if (rmFiles.size() > 0) {
            String rmCommand = "${COMMAND_PATH}rm";
            for (String rmFile : rmFiles) {
                rmCommand = rmCommand + " " + rmFile;
            }
            gmtCommandLines.add(rmCommand + "\n");
        }
        this.addFinalGMT_ScriptLines(gmtCommandLines);
        return gmtCommandLines;
    }

    public static String getGMTColorString(Color color) {
        return color.getRed() + "/" + color.getGreen() + "/" + color.getBlue();
    }

    private static String stripFormatLabel(String label) {
        label = label.replaceAll("'", "");
        label = label.replaceAll(";", "");
        return "'" + label + "'";
    }

    public static ArrayList<String> getGMTPathEnvLines() {
        ArrayList<String> gmtCommandLines = new ArrayList<String>();
        gmtCommandLines.add("## path variables ##");
        String gmtPath = GMT_PATH;
        if (gmtPath == null) {
            gmtPath = "";
        }
        gmtCommandLines.add("GMT_PATH='" + gmtPath + "'");
        String convertPath = CONVERT_PATH;
        if (convertPath == null) {
            convertPath = "";
        }
        gmtCommandLines.add("CONVERT_PATH='" + convertPath + "'");
        String cmdPath = COMMAND_PATH;
        if (cmdPath == null) {
            cmdPath = "";
        }
        gmtCommandLines.add("COMMAND_PATH='" + cmdPath + "'");
        String ps2pdfPath = PS2PDF_PATH;
        if (ps2pdfPath == null) {
            ps2pdfPath = "";
        }
        gmtCommandLines.add("PS2PDF_PATH='" + ps2pdfPath + "'");
        String netCDFPath = NETCDF_LIB_PATH;
        if (netCDFPath == null) {
            netCDFPath = "";
        }
        gmtCommandLines.add("NETCDF_LIB_PATH='" + netCDFPath + "'");
        gmtCommandLines.add("");
        gmtCommandLines.add("## ENV info");
        gmtCommandLines.add("echo \"SHELL: $SHELL\"");
        gmtCommandLines.add("echo \"PATH: $PATH\"");
        gmtCommandLines.add("if [[ -d $NETCDF_LIB_PATH ]];then");
        gmtCommandLines.add("\texport LD_LIBRARY_PATH=$NETCDF_LIB_PATH:${LD_LIBRARY_PATH}");
        gmtCommandLines.add("fi");
        gmtCommandLines.add("echo \"LD_LIBRARY_PATH: $LD_LIBRARY_PATH\"");
        gmtCommandLines.add("");
        return gmtCommandLines;
    }

    public ArrayList<String> getGMT_ScriptLines(GMT_Map map, String dir) throws GMT_MapException {
        ArrayList<PSXYSymbol> symbols;
        ArrayList<PSXYPolygon> polys;
        CoastAttributes coastAt;
        double colorScaleMax;
        double colorScaleMin;
        String cptFile;
        System.out.println("Generating map for dir: " + dir);
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        ArrayList<String> rmFiles = new ArrayList<String>();
        ArrayList<String> gmtCommandLines = new ArrayList<String>();
        double minLat = map.getRegion().getMinLat();
        double maxTempLat = map.getRegion().getMaxLat();
        double minLon = map.getRegion().getMinLon();
        double maxTempLon = map.getRegion().getMaxLon();
        double gridSpacing = map.getGriddedDataInc();
        double maxLat = Math.rint((maxTempLat - minLat) / gridSpacing) * gridSpacing + minLat;
        double maxLon = Math.rint((maxTempLon - minLon) / gridSpacing) * gridSpacing + minLon;
        this.region = " -R" + minLon + "/" + maxLon + "/" + minLat + "/" + maxLat + " ";
        String tempFilePrefix = "temp_junk";
        String grdFileName = tempFilePrefix + ".grd";
        rmFiles.add(grdFileName);
        if (map.getCptFile() != null) {
            cptFile = SCEC_GMT_DATA_PATH + map.getCptFile();
        } else {
            cptFile = "cptFile.cpt";
            CPT cpt = map.getCpt();
            try {
                cpt.writeCPTFile(dir + cptFile);
            }
            catch (IOException e) {
                throw new GMT_MapException("Could not write custom CPT file", e);
            }
        }
        String topoIntenFile = null;
        if (map.getTopoResolution() != null) {
            topoIntenFile = SCEC_GMT_DATA_PATH + map.getTopoResolution().fileName();
        }
        if (topoIntenFile != null && !map.getTopoResolution().region().contains(map.getRegion())) {
            throw new GMT_MapException("Topography not available for the chosen region; please select \"No Topo\" for the Topo Resolution parameter");
        }
        double plotWdth = 6.5;
        this.projWdth = " -JM" + plotWdth + "i ";
        double plotHght = (maxLat - minLat) / (maxLon - minLon) * plotWdth / Math.cos(Math.PI * (maxLat + minLat) / 360.0);
        double yOffset = 11.0 - plotHght - 0.5;
        this.yOff = " -Y" + yOffset + "i ";
        this.xOff = " -X1.0i ";
        gmtCommandLines.add("#!/bin/bash");
        gmtCommandLines.add("");
        gmtCommandLines.add("cd " + dir);
        gmtCommandLines.add("");
        gmtCommandLines.addAll(GMT_MapGenerator.getGMTPathEnvLines());
        gmtCommandLines.add("## Plot Script ##");
        gmtCommandLines.add("");
        XYZ_DataSetAPI griddedData = map.getGriddedData();
        try {
            ArbDiscretizedXYZ_DataSet.writeXYZFile(griddedData, dir + map.getXyzFileName());
        }
        catch (IOException e) {
            throw new GMT_MapException("Could not write XYZ data to a file", e);
        }
        gmtCommandLines.add("# convert xyz file to grd file");
        String commandLine = "${GMT_PATH}xyz2grd " + map.getXyzFileName() + " -G" + grdFileName + " -I" + gridSpacing + this.region + " -D/degree/degree/amp/=/=/=  -: -H0";
        gmtCommandLines.add(commandLine);
        if (map.isCustomScale()) {
            colorScaleMin = map.getCustomScaleMin();
            if (colorScaleMin >= (colorScaleMax = map.getCustomScaleMax().doubleValue())) {
                throw new RuntimeException("Error: Color-Scale Min must be less than the Max");
            }
        } else {
            colorScaleMin = griddedData.getMinZ();
            colorScaleMax = griddedData.getMaxZ();
            System.out.println(colorScaleMin + "," + colorScaleMax);
            if (colorScaleMin == colorScaleMax) {
                throw new RuntimeException("Can't make the image plot because all Z values in the XYZ dataset have the same value ");
            }
        }
        if (map.isRescaleCPT()) {
            float inc = (float)((colorScaleMax - colorScaleMin) / 20.0);
            String tempCPT = tempFilePrefix + ".cpt";
            rmFiles.add(tempCPT);
            gmtCommandLines.add("# Rescale the CPT file");
            commandLine = "${GMT_PATH}makecpt -C" + cptFile + " -T" + colorScaleMin + "/" + colorScaleMax + "/" + inc + " -Z > " + tempCPT;
            gmtCommandLines.add(commandLine);
            cptFile = tempCPT;
        }
        String psFileName = map.getPSFileName();
        gmtCommandLines.add("# Set GMT paper/font defaults");
        commandLine = "${GMT_PATH}gmtset ANOT_FONT_SIZE 14p LABEL_FONT_SIZE 18p PAGE_COLOR 0/0/0 PAGE_ORIENTATION portrait PAPER_MEDIA letter";
        gmtCommandLines.add(commandLine + "\n");
        int dpi = map.getDpi();
        String gmtSmoothOption = "";
        if (!map.isUseGMTSmoothing()) {
            gmtSmoothOption = " -T ";
        }
        if (map.getTopoResolution() == null) {
            gmtCommandLines.add("# Plot the gridded data");
            commandLine = "${GMT_PATH}grdimage " + grdFileName + this.xOff + this.yOff + this.projWdth + " -C" + tempFilePrefix + ".cpt " + gmtSmoothOption + " -K -E" + dpi + this.region + " > " + psFileName;
            gmtCommandLines.add(commandLine + "\n");
        } else {
            TopographicSlopeFile topoFile = map.getTopoResolution();
            gridSpacing = ArcsecondConverter.getDegrees(map.getTopoResolution().resolution());
            double tempNum = Math.ceil((minLat - topoFile.region().getMinLat()) / gridSpacing);
            minLat = tempNum * gridSpacing + topoFile.region().getMinLat();
            tempNum = Math.ceil((minLon - topoFile.region().getMinLon()) / gridSpacing);
            minLon = tempNum * gridSpacing + topoFile.region().getMinLon();
            maxLat = Math.floor((maxLat - minLat) / gridSpacing) * gridSpacing + minLat;
            maxLon = Math.floor((maxLon - minLon) / gridSpacing) * gridSpacing + minLon;
            this.region = " -R" + minLon + "/" + maxLon + "/" + minLat + "/" + maxLat + " ";
            String hiResFile = tempFilePrefix + "HiResData.grd";
            rmFiles.add(hiResFile);
            gmtCommandLines.add("# Resample the map to the topo resolution");
            commandLine = "${GMT_PATH}grdsample " + grdFileName + " -G" + hiResFile + " -I" + topoFile.resolution() + "c -Q " + this.region;
            gmtCommandLines.add(commandLine);
            String intenFile = tempFilePrefix + "Inten.grd";
            gmtCommandLines.add("# Cut the topo file to match the data region");
            commandLine = "${GMT_PATH}grdcut " + topoIntenFile + " -G" + intenFile + " " + this.region;
            rmFiles.add(intenFile);
            gmtCommandLines.add(commandLine);
            gmtCommandLines.add("# Plot the gridded data with topographic shading");
            commandLine = "${GMT_PATH}grdimage " + hiResFile + " " + this.xOff + this.yOff + this.projWdth + " -I" + tempFilePrefix + "Inten.grd -C" + tempFilePrefix + ".cpt " + gmtSmoothOption + "-K -E" + dpi + this.region + " > " + psFileName;
            gmtCommandLines.add(commandLine);
        }
        gmtCommandLines.add("");
        if (map.getHighwayFile() != null) {
            gmtCommandLines.add("# Add highways to plot");
            commandLine = "${GMT_PATH}psxy  " + this.region + this.projWdth + " -K -O -W5/125/125/125 -: -Ms " + SCEC_GMT_DATA_PATH + map.getHighwayFile().fileName() + " >> " + psFileName;
            gmtCommandLines.add(commandLine);
        }
        if ((coastAt = map.getCoast()) != null) {
            String fillColor = "";
            if (coastAt.getFillColor() != null) {
                fillColor = "-S" + GMT_MapGenerator.getGMTColorString(coastAt.getFillColor());
            }
            String lineColor = "";
            if (coastAt.getLineColor() != null) {
                lineColor = "-W" + coastAt.getLineSize() + "/" + GMT_MapGenerator.getGMTColorString(coastAt.getLineColor());
            }
            gmtCommandLines.add("# Draw coastline");
            commandLine = "${GMT_PATH}pscoast " + this.region + this.projWdth + " -K -O " + lineColor + " -P " + fillColor + " -Dh -N2 >> " + psFileName;
            gmtCommandLines.add(commandLine);
        }
        if ((polys = map.getPolys()) != null && polys.size() > 0) {
            System.out.println("Map has " + polys.size() + " polygons!");
            gmtCommandLines.add("");
            gmtCommandLines.add("# Lines/Polygons");
            String polyFile = "polys.xy";
            gmtCommandLines.add("${COMMAND_PATH}cat  << END > " + polyFile);
            for (int i = 0; i < polys.size(); ++i) {
                PSXYPolygon poly = polys.get(i);
                if (!poly.isValid()) {
                    throw new GMT_MapException("Polygons must have at least 2 points");
                }
                String sep = "> " + poly.getPenString();
                if (poly.size() > 2) {
                    sep = sep + " " + poly.getFillString();
                }
                gmtCommandLines.add(sep);
                for (DataPoint2D point : poly.getPoints()) {
                    gmtCommandLines.add(point.getX() + "\t" + point.getY());
                }
            }
            gmtCommandLines.add("END");
            gmtCommandLines.add("${GMT_PATH}psxy " + polyFile + " " + this.region + this.projWdth + " -K -O -M >> " + psFileName);
        }
        if ((symbols = map.getSymbols()) != null && symbols.size() > 0) {
            System.out.println("Map has " + symbols.size() + " symbols!");
            gmtCommandLines.add("");
            gmtCommandLines.add("# Symbols");
            for (int i = 0; i < symbols.size(); ++i) {
                PSXYSymbol symbol = symbols.get(i);
                DataPoint2D point = symbol.getPoint();
                String line = "echo " + point.getX() + " " + point.getY() + " | ${GMT_PATH}psxy " + symbol.getSymbolString() + " " + symbol.getFillString();
                if (symbol.getPenColor() != null) {
                    line = line + " " + symbol.getPenString();
                }
                line = line + " " + this.region + this.projWdth + " -K -O >> " + psFileName;
                gmtCommandLines.add(line);
            }
        }
        if (map.getSymbolSet() != null) {
            PSXYSymbolSet symSet = map.getSymbolSet();
            System.out.println("Map has a symbol set!");
            gmtCommandLines.add("");
            gmtCommandLines.add("# Symbol set");
            String symbolCPTFile = "symbol_set.cpt";
            gmtCommandLines.add("${COMMAND_PATH}cat  << END > " + symbolCPTFile);
            gmtCommandLines.add(symSet.getCpt().toString());
            gmtCommandLines.add("END");
            String symbolFile = "symbol_set.xy";
            gmtCommandLines.add("${COMMAND_PATH}cat  << END > " + symbolFile);
            symbols = symSet.getSymbols();
            ArrayList<Double> vals = symSet.getVals();
            for (int i = 0; i < symbols.size(); ++i) {
                PSXYSymbol symbol = symbols.get(i);
                double val = vals.get(i);
                DataPoint2D point = symbol.getPoint();
                String line = point.getX() + "\t" + point.getY() + "\t" + val + "\t" + symbol.getSymbol().val() + symbol.getWidth() + "i";
                gmtCommandLines.add(line);
            }
            gmtCommandLines.add("END");
            String penStr = "";
            if (symSet.getPenColor() != null) {
                penStr = " " + symSet.getPenString();
            }
            gmtCommandLines.add("${GMT_PATH}psxy " + symbolFile + " -C" + symbolCPTFile + penStr + " -S " + this.region + this.projWdth + " -K -O >> " + psFileName);
        }
        gmtCommandLines.add("# Set GMT map property defaults");
        commandLine = "${GMT_PATH}gmtset BASEMAP_FRAME_RGB 255/255/255 PLOT_DEGREE_FORMAT -D FRAME_WIDTH 0.1i COLOR_FOREGROUND 255/255/255";
        gmtCommandLines.add(commandLine);
        DecimalFormat df2 = new DecimalFormat("0.E0");
        Float tickInc = new Float(df2.format((colorScaleMax - colorScaleMin) / 4.0));
        String scaleLabel = map.getCustomLabel();
        if (scaleLabel == null) {
            scaleLabel = " ";
        }
        scaleLabel = GMT_MapGenerator.stripFormatLabel(scaleLabel);
        gmtCommandLines.add("# Colorbar/label");
        commandLine = "${GMT_PATH}psscale -Ba" + tickInc + ":" + scaleLabel + ": -D3.25i/-0.5i/6i/0.3ih -C" + tempFilePrefix + ".cpt -O -K -N70 >> " + psFileName;
        gmtCommandLines.add(commandLine);
        double niceKmLength = this.getNiceKmScaleLength(minLat, minLon, maxLon);
        double kmScaleXoffset = plotWdth / 2.0;
        double niceTick = this.getNiceMapTickInterval(minLat, maxLat, minLon, maxLon);
        gmtCommandLines.add("# Map frame and KM scale label");
        commandLine = "${GMT_PATH}psbasemap -B" + niceTick + "/" + niceTick + "eWNs " + this.projWdth + this.region + " -Lfx" + kmScaleXoffset + "i/0.5i/" + minLat + "/" + niceKmLength + " -O >> " + psFileName;
        gmtCommandLines.add(commandLine);
        gmtCommandLines.add("");
        gmtCommandLines.add("## PostScript conversion ##");
        boolean use_gs_raster = true;
        String jpgFileName = map.getJPGFileName();
        String pngFileName = map.getPNGFileName();
        int heightInPixels = (int)((11.0 - yOffset + 2.0) * (double)dpi);
        String convertArgs = "-crop 595x" + heightInPixels + "+0+0";
        double imageWidth = map.getImageWidth();
        if (imageWidth != IMAGE_WIDTH_DEFAULT) {
            int wdth = (int)(imageWidth * (double)dpi);
            convertArgs = convertArgs + " -filter Lanczos -geometry " + wdth;
        }
        if (use_gs_raster) {
            int jpeg_quality = 90;
            gmtCommandLines.add("${COMMAND_PATH}cat " + psFileName + " | " + GS_PATH + " -sDEVICE=jpeg " + " -dJPEGQ=" + jpeg_quality + " -sOutputFile=" + jpgFileName + " -");
            gmtCommandLines.add("${COMMAND_PATH}cat " + psFileName + " | " + GS_PATH + " -sDEVICE=png16m " + " -sOutputFile=" + pngFileName + " -");
            gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + jpgFileName + " " + jpgFileName);
            gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + pngFileName + " " + pngFileName);
        } else {
            convertArgs = "-density " + dpi + " " + convertArgs;
            gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + psFileName + " " + jpgFileName);
            gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + psFileName + " " + pngFileName);
        }
        commandLine = "${PS2PDF_PATH}  " + psFileName + "  " + map.getPDFFileName();
        gmtCommandLines.add(commandLine);
        boolean googleearth = false;
        if (googleearth) {
            gmtCommandLines.add("## Google earth files ##");
            System.out.println("Making Google Earth files!");
            String gEarth_psFileName = "gEarth_" + psFileName;
            rmFiles.add(gEarth_psFileName);
            String gEarth_proj = " -JQ180/" + plotWdth + "i ";
            String gEarth_kmz_name = "./map.kmz";
            gmtCommandLines.add("# Make PS file for google earth");
            if (map.getTopoResolution() == null) {
                commandLine = "${GMT_PATH}grdimage " + grdFileName + this.xOff + this.yOff + gEarth_proj + " -C" + tempFilePrefix + ".cpt " + gmtSmoothOption + " -E" + dpi + this.region + " > " + gEarth_psFileName;
                gmtCommandLines.add(commandLine);
            } else {
                commandLine = "${GMT_PATH}grdimage " + tempFilePrefix + "HiResData.grd " + this.xOff + this.yOff + gEarth_proj + " -I" + tempFilePrefix + "Inten.grd -C" + tempFilePrefix + ".cpt " + gmtSmoothOption + "-E" + dpi + this.region + " > " + gEarth_psFileName;
                gmtCommandLines.add(commandLine);
            }
            commandLine = JAVA_PATH + " -cp " + JAVA_CLASSPATH + " " + GMT_KML_Generator.class.getName() + " " + gEarth_psFileName + " " + gEarth_kmz_name + " " + minLat + " " + maxLat + " " + minLon + " " + maxLon;
            gmtCommandLines.add(commandLine);
        }
        if (rmFiles.size() > 0) {
            gmtCommandLines.add("");
            gmtCommandLines.add("# Clean up");
            String rmCommand = "${COMMAND_PATH}rm";
            for (String rmFile : rmFiles) {
                rmCommand = rmCommand + " " + rmFile;
            }
            gmtCommandLines.add(rmCommand);
        }
        this.addFinalGMT_ScriptLines(gmtCommandLines);
        return gmtCommandLines;
    }

    protected void addIntermediateGMT_ScriptLines(ArrayList gmtLines) {
    }

    protected void addFinalGMT_ScriptLines(ArrayList gmtCommandLines) {
    }

    private void checkForLogPlot() {
        boolean logPlotCheck = (Boolean)this.logPlotParam.getValue();
        if (logPlotCheck) {
            ArrayList<Double> zLinearVals = this.xyzDataSet.getZ_DataSet();
            int size = zLinearVals.size();
            for (int i = 0; i < size; ++i) {
                double zVal = zLinearVals.get(i);
                if (zVal == 0.0) {
                    zLinearVals.set(i, new Double(Double.NaN));
                    continue;
                }
                zLinearVals.set(i, new Double(0.4343 * StrictMath.log(zVal)));
            }
            this.SCALE_LABEL = "\"log@-10@-(" + this.SCALE_LABEL + ")\"";
        }
    }

    public void createMapInfoFile(String mapInfo) {
        ArrayList<String> mapInfoLines = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(mapInfo, "\n");
        while (st.hasMoreTokens()) {
            mapInfoLines.add(st.nextToken());
        }
        this.makeFileFromLines(mapInfoLines, this.METADATA_FILE_NAME);
    }
}

