/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param;

import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.DependentParameter;
import org.opensha.commons.param.DependentParameterAPI;
import org.opensha.commons.param.DoubleConstraint;
import org.opensha.commons.param.DoubleDiscreteParameter;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterConstraintAPI;
import org.opensha.commons.param.editor.ConstrainedDoubleParameterEditor;
import org.opensha.commons.param.editor.DoubleParameterEditor;
import org.opensha.commons.param.editor.ParameterEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleParameter
extends DependentParameter<Double>
implements DependentParameterAPI<Double>,
ParameterAPI<Double> {
    private static final long serialVersionUID = 198247413L;
    protected static final String C = "DoubleParameter";
    protected static final boolean D = false;
    private transient ParameterEditor paramEdit = null;

    public DoubleParameter(String name) {
        super(name, null, null, null);
    }

    public DoubleParameter(String name, String units) {
        super(name, null, units, null);
    }

    public DoubleParameter(String name, double min, double max) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), null, null);
    }

    public DoubleParameter(String name, double min, double max, String units) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), units, null);
    }

    public DoubleParameter(String name, Double min, Double max) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), null, null);
    }

    public DoubleParameter(String name, Double min, Double max, String units) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), units, null);
    }

    public DoubleParameter(String name, DoubleConstraint constraint) throws ConstraintException {
        super(name, constraint, null, null);
    }

    public DoubleParameter(String name, DoubleConstraint constraint, String units) throws ConstraintException {
        super(name, constraint, units, null);
    }

    public DoubleParameter(String name, Double value) {
        super(name, null, null, value);
    }

    public DoubleParameter(String name, String units, Double value) throws ConstraintException {
        super(name, null, units, value);
    }

    public DoubleParameter(String name, double min, double max, Double value) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), null, value);
    }

    public DoubleParameter(String name, Double min, Double max, Double value) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), null, value);
    }

    public DoubleParameter(String name, DoubleConstraint constraint, Double value) throws ConstraintException {
        super(name, constraint, null, value);
    }

    public DoubleParameter(String name, double min, double max, String units, Double value) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), units, value);
    }

    public DoubleParameter(String name, Double min, Double max, String units, Double value) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), units, value);
    }

    public DoubleParameter(String name, DoubleConstraint constraint, String units, Double value) throws ConstraintException {
        super(name, constraint, units, value);
    }

    @Override
    public void setConstraint(ParameterConstraintAPI constraint) throws ParameterException, EditableException {
        String S = "DoubleParameter: setConstraint(): ";
        this.checkEditable(S);
        if (!(constraint instanceof DoubleConstraint)) {
            throw new ParameterException(S + "This parameter only accepts DoubleConstraints, unable to set the constraint.");
        }
        super.setConstraint(constraint);
    }

    public Double getMin() throws Exception {
        if (this.constraint != null) {
            return ((DoubleConstraint)this.constraint).getMin();
        }
        return null;
    }

    public Double getMax() {
        if (this.constraint != null) {
            return ((DoubleConstraint)this.constraint).getMax();
        }
        return null;
    }

    @Override
    public String getType() {
        String type = C;
        ParameterConstraintAPI constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + type;
        }
        return type;
    }

    @Override
    public int compareTo(Object obj) throws ClassCastException {
        String S = "DoubleParameter:compareTo(): ";
        if (!(obj instanceof DoubleParameter) && !(obj instanceof DoubleDiscreteParameter)) {
            throw new ClassCastException(S + "Object not a DoubleParameter, or DoubleDiscreteParameter, unable to compare");
        }
        Double n1 = (Double)this.getValue();
        Double n2 = null;
        if (obj instanceof DoubleParameter) {
            DoubleParameter param = (DoubleParameter)obj;
            n2 = (Double)param.getValue();
        } else if (obj instanceof DoubleDiscreteParameter) {
            DoubleDiscreteParameter param = (DoubleDiscreteParameter)obj;
            n2 = (Double)param.getValue();
        }
        return n1.compareTo(n2);
    }

    @Override
    public void setValue(double value) throws ConstraintException, ParameterException {
        this.setValue(new Double(value));
    }

    @Override
    public boolean isAllowed(Double d) {
        return super.isAllowed(d);
    }

    @Override
    public boolean equals(Object obj) throws ClassCastException {
        String S = "DoubleParameter:equals(): ";
        if (!(obj instanceof DoubleParameter) && !(obj instanceof DoubleDiscreteParameter)) {
            throw new ClassCastException(S + "Object not a DoubleParameter, or DoubleDiscreteParameter, unable to compare");
        }
        String otherName = ((DoubleParameter)obj).getName();
        return this.compareTo(obj) == 0 && this.getName().equals(otherName);
    }

    @Override
    public Object clone() {
        DoubleConstraint c1 = null;
        if (this.constraint != null) {
            c1 = (DoubleConstraint)this.constraint.clone();
        }
        DoubleParameter param = null;
        param = this.value == null ? new DoubleParameter(this.name, c1, this.units) : new DoubleParameter(this.name, c1, this.units, new Double(((Double)this.value).toString()));
        if (param == null) {
            return null;
        }
        param.editable = true;
        param.info = this.info;
        return param;
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        try {
            Double val = Double.parseDouble(el.attributeValue("value"));
            this.setValue(val);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public ParameterEditor getEditor() {
        if (this.paramEdit == null) {
            try {
                this.paramEdit = this.constraint == null ? new DoubleParameterEditor(this) : new ConstrainedDoubleParameterEditor(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.paramEdit;
    }
}

