/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param;

import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.param.ParameterConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerConstraint
extends ParameterConstraint<Integer> {
    protected static final String C = "IntegerConstraint";
    protected static final boolean D = false;
    protected Integer min = null;
    protected Integer max = null;

    public IntegerConstraint() {
    }

    public IntegerConstraint(int min, int max) {
        this.min = new Integer(min);
        this.max = new Integer(max);
    }

    public IntegerConstraint(Integer min, Integer max) {
        this.min = min;
        this.max = max;
    }

    public void setMinMax(Integer min, Integer max) throws EditableException {
        String S = "IntegerConstraint: setMinMax(): ";
        this.checkEditable(S);
        this.min = min;
        this.max = max;
    }

    public void setMinMax(int min, int max) throws EditableException {
        this.setMinMax(new Integer(min), new Integer(max));
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getMax() {
        return this.max;
    }

    @Override
    public boolean isAllowed(Integer i) {
        if (this.nullAllowed && i == null) {
            return true;
        }
        if (this.min == null || this.max == null) {
            return true;
        }
        return i.compareTo(this.min) >= 0 && i.compareTo(this.max) <= 0;
    }

    @Override
    public boolean isAllowed(int i) {
        return this.isAllowed(new Integer(i));
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer b = new StringBuffer();
        if (this.name != null) {
            b.append(TAB + "Name = " + this.name + '\n');
        }
        if (this.min != null) {
            b.append(TAB + "Min = " + this.min.toString() + '\n');
        }
        if (this.max != null) {
            b.append(TAB + "Max = " + this.max.toString() + '\n');
        }
        b.append(TAB + "Null Allowed = " + this.nullAllowed + '\n');
        return b.toString();
    }

    @Override
    public Object clone() {
        IntegerConstraint c1 = new IntegerConstraint(this.min, this.max);
        c1.setName(this.name);
        c1.setNullAllowed(this.nullAllowed);
        c1.editable = true;
        return c1;
    }
}

