/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.ListIterator;
import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.param.DependentParameterAPI;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterConstraintAPI;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Parameter<E>
implements ParameterAPI<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String C = "Parameter";
    public static final String XML_GROUP_METADATA_NAME = "Parameters";
    public static final String XML_METADATA_NAME = "Parameter";
    public static final String XML_COMPLEX_VAL_EL_NAME = "ComplexValue";
    protected static final boolean D = false;
    protected String name = "";
    protected String info = "";
    protected String units = "";
    protected ParameterConstraintAPI constraint = null;
    protected boolean editable = true;
    protected E value = null;
    protected E defaultValue = null;
    private transient ArrayList changeListeners;
    private transient ArrayList failListeners;

    public Parameter() {
    }

    protected void checkEditable(String S) throws EditableException {
        if (!this.editable) {
            throw new EditableException(S + "This parameter is currently not editable");
        }
    }

    public Parameter(String name, ParameterConstraintAPI constraint, String units, E value) throws ConstraintException {
        String S = "Parameter: Constructor(): ";
        if (value != null && constraint != null && !constraint.isAllowed(value)) {
            System.out.println(S + "Value not allowed");
            throw new ConstraintException(S + "Value not allowed");
        }
        this.constraint = constraint;
        this.name = name;
        this.value = value;
        this.units = units;
    }

    @Override
    public boolean isAllowed(E obj) {
        if (obj == null && !this.isNullAllowed()) {
            return false;
        }
        if (this.constraint != null) {
            return this.constraint.isAllowed(obj);
        }
        return true;
    }

    @Override
    public void setValue(E value) throws ConstraintException, ParameterException {
        String S = this.getName() + ": setValue(): ";
        if (!this.isAllowed(value)) {
            throw new ConstraintException(S + "Value is not allowed: " + value.toString());
        }
        if (this.value != null && this.value.equals(value)) {
            return;
        }
        ParameterChangeEvent event = new ParameterChangeEvent(this, this.getName(), this.value, value);
        this.value = value;
        this.firePropertyChange(event);
    }

    @Override
    public void setDefaultValue(E defaultValue) throws ConstraintException {
        this.checkEditable("Parameter: setDefaultValue(): ");
        if (!this.isAllowed(defaultValue)) {
            throw new ConstraintException(this.getName() + ": setDefaultValue(): Value is not allowed: " + defaultValue.toString());
        }
        this.defaultValue = defaultValue;
    }

    @Override
    public void setValueAsDefault() throws ConstraintException, ParameterException {
        this.setValue(this.defaultValue);
    }

    @Override
    public E getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void unableToSetValue(E value) throws ConstraintException {
        String S = "Parameter: unableToSetValue():";
        ParameterChangeFailEvent event = new ParameterChangeFailEvent(this, this.getName(), this.getValue(), value);
        this.firePropertyChangeFailed(event);
    }

    @Override
    public synchronized void addParameterChangeFailListener(ParameterChangeFailListener listener) {
        if (this.failListeners == null) {
            this.failListeners = new ArrayList();
        }
        if (!this.failListeners.contains(listener)) {
            this.failListeners.add(listener);
        }
    }

    @Override
    public String getConstraintName() {
        if (this.constraint != null) {
            String name = this.constraint.getName();
            if (name == null) {
                return "";
            }
            return name;
        }
        return "";
    }

    @Override
    public synchronized void removeParameterChangeFailListener(ParameterChangeFailListener listener) {
        if (this.failListeners != null && this.failListeners.contains(listener)) {
            this.failListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void firePropertyChangeFailed(ParameterChangeFailEvent event) {
        ArrayList vector;
        String S = "Parameter: firePropertyChange(): ";
        Parameter parameter = this;
        synchronized (parameter) {
            if (this.failListeners == null) {
                return;
            }
            vector = (ArrayList)this.failListeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ParameterChangeFailListener listener = (ParameterChangeFailListener)vector.get(i);
            listener.parameterChangeFailed(event);
        }
    }

    @Override
    public synchronized void addParameterChangeListener(ParameterChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    @Override
    public synchronized void removeParameterChangeListener(ParameterChangeListener listener) {
        if (this.changeListeners != null && this.changeListeners.contains(listener)) {
            this.changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void firePropertyChange(ParameterChangeEvent event) {
        ArrayList vector;
        String S = "Parameter: firePropertyChange(): ";
        Parameter parameter = this;
        synchronized (parameter) {
            if (this.changeListeners == null) {
                return;
            }
            vector = (ArrayList)this.changeListeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ParameterChangeListener listener = (ParameterChangeListener)vector.get(i);
            listener.parameterChange(event);
        }
    }

    @Override
    public boolean isNullAllowed() {
        if (this.constraint != null) {
            return this.constraint.isNullAllowed();
        }
        return true;
    }

    @Override
    public void setInfo(String info) throws EditableException {
        this.checkEditable("Parameter: setInfo(): ");
        this.info = info;
    }

    @Override
    public void setUnits(String units) throws EditableException {
        this.checkEditable("Parameter: setUnits(): ");
        this.units = units;
    }

    @Override
    public E getValue() {
        return this.value;
    }

    @Override
    public String getUnits() {
        return this.units;
    }

    @Override
    public ParameterConstraintAPI getConstraint() {
        return this.constraint;
    }

    @Override
    public void setConstraint(ParameterConstraintAPI constraint) throws EditableException {
        this.checkEditable("Parameter: setConstraint(): ");
        this.constraint = constraint;
        E value = this.getValue();
        if (!constraint.isAllowed(value)) {
            constraint.setNullAllowed(true);
            this.setValue(null);
            constraint.setNullAllowed(false);
        }
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public void setNonEditable() {
        this.editable = false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.checkEditable("Parameter: setName(): ");
        this.name = name;
    }

    @Override
    public String getType() {
        return "Parameter";
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public String getMetadataString() {
        if (this.value != null) {
            return this.name + " = " + this.value.toString();
        }
        return this.name + " = " + "null";
    }

    @Override
    public abstract Object clone();

    @Override
    public Element toXMLMetadata(Element root) {
        return this.toXMLMetadata(root, "Parameter");
    }

    @Override
    public Element toXMLMetadata(Element root, String elementName) {
        DependentParameterAPI param;
        int num;
        Element xml = root.addElement(elementName);
        xml.addAttribute("name", this.getName());
        xml.addAttribute("type", this.getType());
        xml.addAttribute("units", this.getUnits());
        E val = this.getValue();
        if (val == null) {
            xml.addAttribute("value", "");
        } else if (val instanceof XMLSaveable) {
            Element valEl = xml.addElement(XML_COMPLEX_VAL_EL_NAME);
            ((XMLSaveable)val).toXMLMetadata(valEl);
        } else {
            xml.addAttribute("value", val.toString());
        }
        if (this instanceof DependentParameterAPI && (num = (param = (DependentParameterAPI)((Object)this)).getNumIndependentParameters()) > 0) {
            Element dependent = xml.addElement("IndependentParameters");
            ListIterator it = param.getIndependentParametersIterator();
            while (it.hasNext()) {
                dependent = ((ParameterAPI)it.next()).toXMLMetadata(dependent);
            }
        }
        return root;
    }
}

