/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.DataPoint2DException;
import org.opensha.commons.param.ArbitrarilyDiscretizedFuncParameter;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.editor.ArbitrarilyDiscretizedFuncTableModel;
import org.opensha.commons.param.editor.ParameterEditor;

public class ArbitrarilyDiscretizedFuncParameterEditor
extends ParameterEditor
implements ActionListener,
DocumentListener,
TableModelListener {
    protected static final String C = "DiscretizedFuncParameterEditor";
    protected static final boolean D = false;
    private ArbitrarilyDiscretizedFuncTableModel tableModel;
    private JTable table;
    private JButton addButton;
    private JButton removeButton;
    private JTextField xField;
    private JTextField yField;
    boolean xDataGood;
    boolean yDataGood;
    private boolean isFocusListenerForX = false;
    private ArbitrarilyDiscretizedFuncTableModel.ArbitrarilyDiscretizedFuncTableCellRenderer renderer;

    public ArbitrarilyDiscretizedFuncParameterEditor() {
    }

    public ArbitrarilyDiscretizedFuncParameterEditor(ParameterAPI model) throws Exception {
        super(model);
        String S = "DiscretizedFuncParameterEditor: Constructor(model): ";
    }

    public void setXEnabled(boolean isEnabled) {
    }

    protected void addWidget() {
        String S = "DiscretizedFuncParameterEditor: addWidget(): ";
        ArbitrarilyDiscretizedFunc function = (ArbitrarilyDiscretizedFunc)this.model.getValue();
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel leftButtonPanel = new JPanel();
        leftButtonPanel.setLayout(new BoxLayout(leftButtonPanel, 0));
        if (this.addButton == null) {
            this.addButton = new JButton("+");
            this.addButton.addActionListener(this);
            this.addButton.setEnabled(false);
        }
        if (this.removeButton == null) {
            this.removeButton = new JButton("-");
            this.removeButton.addActionListener(this);
        }
        if (this.xField == null) {
            this.xField = new JTextField();
            this.xField.getDocument().addDocumentListener(this);
            this.xField.setColumns(4);
            this.xDataGood = false;
        }
        if (this.yField == null) {
            this.yField = new JTextField();
            this.yField.getDocument().addDocumentListener(this);
            this.yField.setColumns(4);
            this.yDataGood = false;
        }
        leftButtonPanel.add(new JLabel("x: "));
        leftButtonPanel.add(this.xField);
        leftButtonPanel.add(new JLabel("y: "));
        leftButtonPanel.add(this.yField);
        leftButtonPanel.add(this.addButton);
        buttonPanel.add((Component)leftButtonPanel, "West");
        buttonPanel.add((Component)this.removeButton, "East");
        this.tableModel = new ArbitrarilyDiscretizedFuncTableModel(function);
        this.table = new JTable(this.tableModel);
        this.tableModel.addTableModelListener(this);
        this.renderer = this.tableModel.getRenderer();
        this.table.setDefaultRenderer(Double.class, this.renderer);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setPreferredSize(new Dimension(100, 200));
        this.widgetPanel.setLayout(new BorderLayout());
        this.widgetPanel.add((Component)scroll, "Center");
        this.widgetPanel.add((Component)buttonPanel, "South");
        this.widgetPanel.setBackground(null);
        this.widgetPanel.validate();
        this.widgetPanel.repaint();
    }

    protected void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createLineBorder(FORE_COLOR, 1), "");
        this.titledBorder1.setTitleColor(FORE_COLOR);
        this.titledBorder1.setTitleFont(DEFAULT_LABEL_FONT);
        this.titledBorder1.setTitle("Parameter Name");
        this.border1 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(0, 0, 3, 0));
        this.setLayout(GBL);
        this.outerPanel.setLayout(GBL);
        this.outerPanel.setBorder(this.border1);
        this.widgetPanel.setMinimumSize(WIGET_PANEL_DIM);
        this.widgetPanel.setPreferredSize(null);
        this.nameLabel.setMaximumSize(LABEL_DIM);
        this.nameLabel.setMinimumSize(LABEL_DIM);
        this.nameLabel.setPreferredSize(LABEL_DIM);
        this.nameLabel.setHorizontalAlignment(2);
        this.nameLabel.setHorizontalTextPosition(2);
        this.nameLabel.setText("This is the Label");
        this.nameLabel.setFont(DEFAULT_LABEL_FONT);
        this.outerPanel.add((Component)this.widgetPanel, WIDGET_PANEL_GBC);
        this.add((Component)this.outerPanel, OUTER_PANEL_GBC);
    }

    public void focusLost(FocusEvent e) throws ConstraintException {
        String S = "DiscretizedFuncParameterEditor: focusLost(): ";
        super.focusLost(e);
        this.focusLostProcessing = false;
        if (this.keyTypeProcessing) {
            return;
        }
        this.focusLostProcessing = true;
        this.setValueInParameter();
        if (!this.isFocusListenerForX) {
            this.isFocusListenerForX = true;
        }
        this.focusLostProcessing = false;
    }

    private void setValueInParameter() throws DataPoint2DException, HeadlessException, NumberFormatException {
        this.refreshParamEditor();
    }

    public void setParameter(ParameterAPI model) {
        String S = "DiscretizedFuncParameterEditor: setParameter(): ";
        if (model != null && !(model instanceof ArbitrarilyDiscretizedFuncParameter)) {
            throw new RuntimeException(S + "Input model parameter must be a DiscretizedFuncParameter.");
        }
        super.setParameter(model);
    }

    public void refreshParamEditor() {
        ArbitrarilyDiscretizedFunc func = (ArbitrarilyDiscretizedFunc)this.model.getValue();
        if (func != null) {
            this.tableModel.updateData(func);
        } else {
            this.tableModel.updateData(new ArbitrarilyDiscretizedFunc());
        }
        this.repaint();
    }

    public void setEnabled(boolean isEnabled) {
        this.table.setEnabled(isEnabled);
        this.tableModel.setEnabled(isEnabled);
        this.addButton.setEnabled(isEnabled);
        this.removeButton.setEnabled(isEnabled);
    }

    public void actionPerformed(ActionEvent e) {
        int[] selected;
        if (e.getSource() == this.addButton) {
            double x = Double.parseDouble(this.xField.getText());
            double y = Double.parseDouble(this.yField.getText());
            this.tableModel.addPoint(x, y);
        } else if (e.getSource() == this.removeButton && (selected = this.table.getSelectedRows()).length > 0) {
            this.tableModel.removePoints(selected);
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.validateAddInput();
    }

    public void insertUpdate(DocumentEvent e) {
        this.validateAddInput();
    }

    public void removeUpdate(DocumentEvent e) {
        this.validateAddInput();
    }

    private void validateAddInput() {
        try {
            Double x = Double.parseDouble(this.xField.getText());
            Double y = Double.parseDouble(this.yField.getText());
            boolean bad = x.isNaN() || y.isNaN() || x.isInfinite() || y.isInfinite();
            this.addButton.setEnabled(!bad);
        }
        catch (NumberFormatException e1) {
            this.addButton.setEnabled(false);
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.model.setValue(this.tableModel.getFunction().deepClone());
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame();
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        func.set(0.1, 5.5);
        func.set(0.2, 90.5);
        func.set(0.4, 2.5);
        func.set(0.8, 1.5);
        ArbitrarilyDiscretizedFuncParameter param = new ArbitrarilyDiscretizedFuncParameter("Param", func);
        ArbitrarilyDiscretizedFuncParameterEditor editor = new ArbitrarilyDiscretizedFuncParameterEditor(param);
        frame.setSize(500, 500);
        frame.setContentPane(editor);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        editor.validate();
        editor.refreshParamEditor();
    }
}

