/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.text.DecimalFormat;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbitrarilyDiscretizedFuncTableModel
extends AbstractTableModel {
    protected boolean D = false;
    private ArbitrarilyDiscretizedFunc func;
    private boolean xEditable = true;
    public static DecimalFormat format;
    public static final Color disabledColor;
    ArbitrarilyDiscretizedFuncTableCellRenderer renderer = null;

    public ArbitrarilyDiscretizedFuncTableModel(ArbitrarilyDiscretizedFunc func) {
        this.func = func;
    }

    public void updateData(ArbitrarilyDiscretizedFunc newFunc) {
        if (!ArbitrarilyDiscretizedFuncTableModel.areFunctionPointsEqual(this.func, newFunc)) {
            if (this.D) {
                System.out.println("Update called with new data...");
                System.out.println("Old First: " + this.func.getX(0) + ", " + this.func.getY(0));
                System.out.println("New First: " + newFunc.getX(0) + ", " + newFunc.getY(0));
            }
            this.func.clear();
            for (int i = 0; i < newFunc.getNum(); ++i) {
                double x = newFunc.getX(i);
                double y = newFunc.getY(i);
                this.func.set(x, y);
            }
            if (this.D) {
                System.out.println("Update firing event");
            }
            this.fireTableDataChanged();
        } else if (this.D) {
            System.out.println("Update called with old data");
            System.out.println("Old First: " + this.func.getX(0) + ", " + this.func.getY(0));
            System.out.println("New First: " + newFunc.getX(0) + ", " + newFunc.getY(0));
        }
        if (this.D) {
            System.out.println("Update call DONE");
        }
    }

    public static boolean areFunctionPointsEqual(ArbitrarilyDiscretizedFunc func1, ArbitrarilyDiscretizedFunc func2) {
        int size = func1.getNum();
        if (size != func2.getNum()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            double x1 = func1.getX(i);
            double x2 = func2.getX(i);
            double y1 = func1.getY(i);
            double y2 = func2.getY(i);
            if (x1 == x2 && y1 == y2) continue;
            return false;
        }
        return true;
    }

    public ArbitrarilyDiscretizedFunc getFunction() {
        return this.func;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public void setXEditable(boolean xEditable) {
        this.xEditable = xEditable;
    }

    @Override
    public int getRowCount() {
        if (this.func == null) {
            if (this.D) {
                System.out.println("ROW COUNT ON NULL FUNC!");
            }
            return 0;
        }
        int rows = this.func.getNum();
        return rows;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            String name = this.func.getXAxisName();
            if (name == null || name.length() == 0) {
                name = "x";
            }
            return name;
        }
        String name = this.func.getYAxisName();
        if (name == null || name.length() == 0) {
            name = "y";
        }
        return name;
    }

    public void removePoint(int index) {
        int[] indexes = new int[]{index};
        this.doRemovePoints(indexes);
        this.fireTableDataChanged();
    }

    private void doRemovePoints(int[] indexes) {
        ArbitrarilyDiscretizedFunc old = this.func.deepClone();
        this.func.clear();
        for (int i = 0; i < old.getNum(); ++i) {
            boolean match = false;
            for (int j : indexes) {
                if (i != j) continue;
                if (this.D) {
                    System.out.println("Removing point: " + i);
                }
                match = true;
                break;
            }
            if (match) continue;
            this.func.set(old.get(i));
        }
    }

    public void removePoints(int[] indexes) {
        this.doRemovePoints(indexes);
        this.fireTableDataChanged();
    }

    public void addPoint(double x, double y) {
        this.func.set(x, y);
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int c) {
        super.getColumnClass(c);
        return Double.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return new Double(this.func.getX(rowIndex));
        }
        return new Double(this.func.getY(rowIndex));
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0 || this.xEditable;
    }

    public void setEnabled(boolean isEnabled) {
        ArbitrarilyDiscretizedFuncTableCellRenderer renderer = this.getRenderer();
        if (isEnabled) {
            renderer.setBackground(Color.WHITE);
        } else {
            renderer.setBackground(disabledColor);
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        double val = (Double)aValue;
        if (columnIndex == 1) {
            this.func.set(rowIndex, val);
        } else {
            double origY = this.func.getY(rowIndex);
            int[] indexes = new int[]{rowIndex};
            this.doRemovePoints(indexes);
            this.func.set(val, origY);
        }
        this.fireTableDataChanged();
    }

    public ArbitrarilyDiscretizedFuncTableCellRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new ArbitrarilyDiscretizedFuncTableCellRenderer();
        }
        return this.renderer;
    }

    static {
        disabledColor = new Color(210, 210, 210);
        format = new DecimalFormat();
        format.setMaximumFractionDigits(10);
    }

    class ArbitrarilyDiscretizedFuncTableCellRenderer
    extends DefaultTableCellRenderer.UIResource {
        public ArbitrarilyDiscretizedFuncTableCellRenderer() {
            this.setHorizontalAlignment(4);
            this.setPreferredSize(new Dimension(20, 8));
        }

        public void setValue(Object value) {
            this.setText(value == null ? "" : format.format(value));
        }
    }
}

