/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import com.sun.rowset.CachedRowSetImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import org.opensha.commons.data.estimate.DiscreteValueEstimate;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.data.estimate.FractileListEstimate;
import org.opensha.commons.data.estimate.IntegerEstimate;
import org.opensha.commons.data.estimate.LogNormalEstimate;
import org.opensha.commons.data.estimate.MinMaxPrefEstimate;
import org.opensha.commons.data.estimate.NormalEstimate;
import org.opensha.commons.data.estimate.PDF_Estimate;
import org.opensha.commons.util.ClassUtils;
import org.opensha.refFaultParamDb.dao.EstimateDAO_API;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DiscreteValueEstimateDB_DAO;
import org.opensha.refFaultParamDb.dao.db.EstimateTypeDB_DAO;
import org.opensha.refFaultParamDb.dao.db.FractileListEstimateDB_DAO;
import org.opensha.refFaultParamDb.dao.db.IntegerEstimateDB_DAO;
import org.opensha.refFaultParamDb.dao.db.LogNormalEstimateDB_DAO;
import org.opensha.refFaultParamDb.dao.db.MinMaxPrefEstimateDB_DAO;
import org.opensha.refFaultParamDb.dao.db.NormalEstimateDB_DAO;
import org.opensha.refFaultParamDb.dao.db.PDF_EstimateDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.vo.EstimateInstances;

public class EstimateInstancesDB_DAO {
    private static final String TABLE_NAME = "Est_Instances";
    private static final String SEQUENCE_NAME = "Est_Instances_Sequence";
    private static final String EST_ID = "Est_Id";
    private static final String EST_TYPE_ID = "Est_Type_Id";
    private static final String UNITS = "Est_Units";
    private static final String COMMENTS = "Comments";
    private static final String ESTIMATES_DB_DAO_PACKAGE = "org.opensha.refFaultParamDb.dao.db.";
    private static final String ESTIMATES_DB_DAO_SUFFIX = "DB_DAO";
    private DB_AccessAPI dbAccessAPI;

    public EstimateInstancesDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
    }

    public int addEstimateInstance(EstimateInstances estimateInstance) throws InsertException {
        Estimate estimate = estimateInstance.getEstimate();
        EstimateDAO_API estimateDAO = this.getEstimateDAO(estimate);
        EstimateTypeDB_DAO estimateTypeDB_DAO = new EstimateTypeDB_DAO(this.dbAccessAPI);
        int estimateTypeId = estimateTypeDB_DAO.getEstimateType(estimateDAO.getEstimateTypeName()).getEstimateTypeId();
        int estimateInstanceId = -1;
        try {
            estimateInstanceId = this.dbAccessAPI.getNextSequenceNumber(SEQUENCE_NAME);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        String sql = "insert into Est_Instances(Est_Id,Est_Type_Id,Est_Units,Comments) values(" + estimateInstanceId + "," + estimateTypeId + ",'" + estimateInstance.getUnits() + "','" + estimate.getComments() + "')";
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            estimateDAO.addEstimate(estimateInstanceId, estimate);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        return estimateInstanceId;
    }

    private EstimateDAO_API getEstimateDAO(Estimate estimate) {
        EstimateDAO_API estimateDAO_API = null;
        if (estimate instanceof NormalEstimate) {
            estimateDAO_API = new NormalEstimateDB_DAO(this.dbAccessAPI);
        } else if (estimate instanceof LogNormalEstimate) {
            estimateDAO_API = new LogNormalEstimateDB_DAO(this.dbAccessAPI);
        } else if (estimate instanceof IntegerEstimate) {
            estimateDAO_API = new IntegerEstimateDB_DAO(this.dbAccessAPI);
        } else if (estimate instanceof FractileListEstimate) {
            estimateDAO_API = new FractileListEstimateDB_DAO(this.dbAccessAPI);
        } else if (estimate instanceof MinMaxPrefEstimate) {
            estimateDAO_API = new MinMaxPrefEstimateDB_DAO(this.dbAccessAPI);
        } else if (estimate instanceof DiscreteValueEstimate) {
            estimateDAO_API = new DiscreteValueEstimateDB_DAO(this.dbAccessAPI);
        } else if (estimate instanceof PDF_Estimate) {
            estimateDAO_API = new PDF_EstimateDB_DAO(this.dbAccessAPI);
        }
        return estimateDAO_API;
    }

    public EstimateInstances getEstimateInstance(int estimateInstanceId) throws QueryException {
        EstimateInstances estimateInstance = null;
        String condition = " where Est_Id=" + estimateInstanceId;
        ArrayList estimateList = this.query(condition);
        if (estimateList.size() > 0) {
            estimateInstance = (EstimateInstances)estimateList.get(0);
        }
        return estimateInstance;
    }

    public boolean removeEstimateInstance(int estimateInstanceId) throws UpdateException {
        String sql = "select Est_Id,Est_Type_Id,Est_Units,Comments from Est_Instances where Est_Id=" + estimateInstanceId;
        try {
            CachedRowSetImpl rs = this.dbAccessAPI.queryData(sql);
            EstimateTypeDB_DAO estimateTypeDB_DAO = new EstimateTypeDB_DAO(this.dbAccessAPI);
            while (rs.next()) {
                String estimateTypeName = estimateTypeDB_DAO.getEstimateType(rs.getInt(EST_TYPE_ID)).getEstimateName();
                EstimateDAO_API estimateDAO_API = this.getEstimateDAO_API(estimateTypeName);
                estimateDAO_API.removeEstimate(estimateInstanceId);
                String delSql = "delete from Est_Instances where Est_Id=" + estimateInstanceId;
                int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(delSql);
                if (numRows != 1) continue;
                return true;
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return false;
    }

    private EstimateDAO_API getEstimateDAO_API(String estimateTypeName) {
        EstimateDAO_API estimateDAO_API = (EstimateDAO_API)ClassUtils.createNoArgConstructorClassInstance(ESTIMATES_DB_DAO_PACKAGE + estimateTypeName + ESTIMATES_DB_DAO_SUFFIX);
        estimateDAO_API.setDB_Connection(this.dbAccessAPI);
        return estimateDAO_API;
    }

    public ArrayList getAllEstimateInstances() throws QueryException {
        return this.query(" ");
    }

    private ArrayList query(String condition) throws QueryException {
        ArrayList<EstimateInstances> estimateInstancesList = new ArrayList<EstimateInstances>();
        String sql = "select Est_Id,Est_Type_Id,Est_Units,Comments from Est_Instances " + condition;
        try {
            CachedRowSetImpl rs = this.dbAccessAPI.queryData(sql);
            EstimateTypeDB_DAO estimateTypeDB_DAO = new EstimateTypeDB_DAO(this.dbAccessAPI);
            while (rs.next()) {
                EstimateInstances estimateInstances = new EstimateInstances();
                estimateInstances.setUnits(rs.getString(UNITS));
                estimateInstances.setEstimateInstanceId(rs.getInt(EST_ID));
                String estimateTypeName = estimateTypeDB_DAO.getEstimateType(rs.getInt(EST_TYPE_ID)).getEstimateName();
                EstimateDAO_API estimateDAO_API = this.getEstimateDAO_API(estimateTypeName);
                Estimate estimate = estimateDAO_API.getEstimate(rs.getInt(EST_ID));
                estimate.setComments(rs.getString(COMMENTS));
                estimateInstances.setEstimate(estimate);
                estimate.setUnits(estimateInstances.getUnits());
                estimateInstancesList.add(estimateInstances);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return estimateInstancesList;
    }
}

