/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.observedEarthquake;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.opensha.commons.data.Location;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.step.calc.RegionDefaults;

public class CubeToObsEqkRupture {
    private ObsEqkRupList eqkRupList;

    public CubeToObsEqkRupture(String eventFile, Calendar startTime, Calendar endTime) throws FileNotFoundException, IOException {
        ArrayList<String> fileLines = FileUtils.loadFile(eventFile);
        int numEvents = fileLines.size();
        this.eqkRupList = new ObsEqkRupList();
        for (int i = 0; i < numEvents; ++i) {
            String obsEqkRupString = fileLines.get(i);
            ObsEqkRupture obsEqkEvent = this.readFile(obsEqkRupString);
            if ((obsEqkEvent = this.checkTime(obsEqkEvent, startTime, endTime)) == null) continue;
            this.eqkRupList.addObsEqkEvent(obsEqkEvent);
        }
        fileLines = null;
    }

    private ObsEqkRupture checkTime(ObsEqkRupture obsEqkEvent, Calendar startTime, Calendar stopTime) {
        if (obsEqkEvent == null) {
            return null;
        }
        GregorianCalendar oriTime = obsEqkEvent.getOriginTime();
        if (startTime != null && (oriTime.before(startTime) || oriTime.equals(startTime))) {
            return null;
        }
        if (stopTime != null && oriTime.after(stopTime)) {
            return null;
        }
        return obsEqkEvent;
    }

    private GregorianCalendar getEventTime(ObsEqkRupture obsEqkRupture) {
        return obsEqkRupture.getOriginTime();
    }

    protected ObsEqkRupture readFile(String obsEqkEvent) {
        String sMsgType = obsEqkEvent.substring(0, 2).trim();
        ObsEqkRupture rupture = null;
        if (sMsgType.equals("E")) {
            String sEventId = obsEqkEvent.substring(2, 10).trim();
            String sDataSource = obsEqkEvent.substring(10, 12).trim();
            char sEventVersion = obsEqkEvent.substring(12, 13).trim().charAt(0);
            String sYear = obsEqkEvent.substring(13, 17).trim();
            String sMonth = obsEqkEvent.substring(17, 19).trim();
            String sDay = obsEqkEvent.substring(19, 21).trim();
            String sHour = obsEqkEvent.substring(21, 23).trim();
            String sMinute = obsEqkEvent.substring(23, 25).trim();
            String sSecond = this.divideAndGetString(obsEqkEvent.substring(25, 28), 10.0);
            String sLatitude = this.divideAndGetString(obsEqkEvent.substring(28, 35), 10000.0);
            String sLongitude = this.divideAndGetString(obsEqkEvent.substring(35, 43), 10000.0);
            String sDepth = this.divideAndGetString(obsEqkEvent.substring(43, 47), 10.0);
            double lat = Double.parseDouble(sLatitude);
            double lon = Double.parseDouble(sLongitude);
            double depth = Double.parseDouble(sDepth);
            if (lat < RegionDefaults.searchLatMin || lat > RegionDefaults.searchLatMax) {
                return null;
            }
            if (lon < RegionDefaults.searchLongMin || lon > RegionDefaults.searchLongMax) {
                return null;
            }
            String sMagnitude = this.divideAndGetString(obsEqkEvent.substring(47, 49), 10.0);
            String sErho = this.divideAndGetString(obsEqkEvent.substring(63, 67), 10.0);
            String sErzz = this.divideAndGetString(obsEqkEvent.substring(67, 71), 10.0);
            String sMagnitudeType = obsEqkEvent.substring(73, 74).trim();
            String sMagnitudeError = this.divideAndGetString(obsEqkEvent.substring(76, 78), 10.0);
            int year = Integer.parseInt(sYear);
            int month = Integer.parseInt(sMonth);
            int day = Integer.parseInt(sDay);
            int hour = Integer.parseInt(sHour);
            int min = Integer.parseInt(sMinute);
            int sec = (int)Double.parseDouble(sSecond);
            GregorianCalendar originTime = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            originTime.set(year, month - 1, day, hour, min, sec);
            originTime.set(14, 0);
            Location hypoLoc = new Location(lat, lon, depth);
            double mag = Double.parseDouble(sMagnitude);
            double horzErr = 0.0;
            double vertErr = 0.0;
            double magErr = 0.0;
            if (sErho != null && !sErho.equals("")) {
                horzErr = Double.parseDouble(sErho);
            }
            if (sErzz != null && !sErzz.equals("")) {
                vertErr = Double.parseDouble(sErzz);
            }
            if (sMagnitudeError != null && !sMagnitudeError.equals("")) {
                magErr = Double.parseDouble(sMagnitudeError);
            }
            rupture = new ObsEqkRupture(sEventId, sDataSource, sEventVersion, originTime, horzErr, vertErr, magErr, sMagnitudeType, hypoLoc, mag);
        }
        return rupture;
    }

    private String divideAndGetString(String sIn, double dDivisor) {
        if (sIn.trim().length() > 0) {
            double dTemp = Double.parseDouble(sIn);
            return Double.toString(dTemp /= dDivisor);
        }
        return "";
    }

    public ObsEqkRupList getAllObsEqkRupEvents() {
        return this.eqkRupList;
    }

    public ObsEqkRupture getObsEqkRupture(int index) {
        return this.eqkRupList.getObsEqkRuptureAt(index);
    }

    public static void main(String[] args) {
        CubeToObsEqkRupture cubeToRup = null;
        try {
            cubeToRup = new CubeToObsEqkRupture("/Users/nitingupta/merge.nts", null, null);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        ObsEqkRupList rupList = cubeToRup.getAllObsEqkRupEvents();
        rupList.sortObsEqkRupListByOriginTime();
        int size = rupList.size();
        try {
            FileWriter fw = new FileWriter("ObsEqkRup.txt");
            for (int i = 0; i < size; ++i) {
                ObsEqkRupture eqkRup = rupList.getObsEqkRuptureAt(i);
                fw.write("Obs EqkRupture: " + i + "\n");
                fw.write(eqkRup.getInfo() + "\n\n");
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

