/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.observedEarthquake;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.ListIterator;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.sha.earthquake.EqkRuptureMagComparator;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupEventOriginTimeComparator;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;

public class ObsEqkRupList
implements Serializable {
    protected static final String C = "ObsEqkRupList";
    protected static final boolean D = false;
    private ArrayList obsEqkList = new ArrayList();

    public ObsEqkRupList getObsEqkRupsAboveMag(double mag) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ObsEqkRupture eqkRup = (ObsEqkRupture)this.obsEqkList.get(i);
            if (!(eqkRup.getMag() >= mag)) continue;
            obsEventList.addObsEqkEvent(eqkRup);
        }
        return obsEventList;
    }

    public ObsEqkRupList getObsEqkRupsBelowMag(double mag) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ObsEqkRupture eqkRup = (ObsEqkRupture)this.obsEqkList.get(i);
            if (!(eqkRup.getMag() < mag)) continue;
            obsEventList.addObsEqkEvent(eqkRup);
        }
        return obsEventList;
    }

    public ObsEqkRupList getObsEqkRupsBetweenMag(double mag1, double mag2) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ObsEqkRupture eqkRup = (ObsEqkRupture)this.obsEqkList.get(i);
            double eventMag = eqkRup.getMag();
            if (!(eventMag >= mag1) || !(eventMag < mag2)) continue;
            obsEventList.addObsEqkEvent(eqkRup);
        }
        return obsEventList;
    }

    public ObsEqkRupList getObsEqkRupsBefore(GregorianCalendar cal) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ObsEqkRupture eqkRup = (ObsEqkRupture)this.obsEqkList.get(i);
            GregorianCalendar eventTime = eqkRup.getOriginTime();
            if (!eventTime.before(cal)) continue;
            obsEventList.addObsEqkEvent(eqkRup);
        }
        return obsEventList;
    }

    public ObsEqkRupList getObsEqkRupsAfter(GregorianCalendar cal) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ObsEqkRupture eqkRup = (ObsEqkRupture)this.obsEqkList.get(i);
            GregorianCalendar eventTime = eqkRup.getOriginTime();
            if (!eventTime.after(cal)) continue;
            obsEventList.addObsEqkEvent(eqkRup);
        }
        return obsEventList;
    }

    public ObsEqkRupList getObsEqkRupsBetween(GregorianCalendar cal1, GregorianCalendar cal2) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ObsEqkRupture eqkRup = (ObsEqkRupture)this.obsEqkList.get(i);
            GregorianCalendar eventTime = eqkRup.getOriginTime();
            if (!eventTime.after(cal1) || !eventTime.before(cal2)) continue;
            obsEventList.addObsEqkEvent(eqkRup);
        }
        return obsEventList;
    }

    public ObsEqkRupList getObsEqkRupsInside(Region region) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ObsEqkRupture eqkRup = (ObsEqkRupture)this.obsEqkList.get(i);
            Location loc = eqkRup.getHypocenterLocation();
            if (!region.contains(loc)) continue;
            obsEventList.addObsEqkEvent(eqkRup);
        }
        return obsEventList;
    }

    public ObsEqkRupList getObsEqkRupsOutside(Region region) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ObsEqkRupture eqkRup = (ObsEqkRupture)this.obsEqkList.get(i);
            Location loc = eqkRup.getHypocenterLocation();
            if (region.contains(loc)) continue;
            obsEventList.addObsEqkEvent(eqkRup);
        }
        return obsEventList;
    }

    public ArrayList getObsEqkRupEventList() {
        return this.obsEqkList;
    }

    public ObsEqkRupture getObsEqkRuptureAt(int index) throws InvalidRangeException {
        this.checkIndex(index);
        return (ObsEqkRupture)this.obsEqkList.get(index);
    }

    private void checkIndex(int index) throws InvalidRangeException {
        if (this.size() < index + 1) {
            throw new InvalidRangeException("ObsEqkRupList: getLocationAt(): Specified index larger than array size.");
        }
    }

    public void replaceObsEqkRupEventAt(ObsEqkRupture obsEqkEvent, int index) throws InvalidRangeException {
        this.checkIndex(index);
        this.obsEqkList.set(index, obsEqkEvent);
    }

    public void addObsEqkEventAt(ObsEqkRupture obsEqkEvent, int index) {
        this.obsEqkList.add(index, obsEqkEvent);
    }

    public boolean addAllObsEqkRupEvents(ObsEqkRupList obsRupEventList) {
        return this.obsEqkList.addAll(obsRupEventList.getObsEqkRupEventList());
    }

    public int size() {
        return this.obsEqkList.size();
    }

    public void addObsEqkEvent(ObsEqkRupture obsEqkEvent) {
        this.obsEqkList.add(obsEqkEvent);
    }

    public ListIterator listIterator() {
        return this.obsEqkList.listIterator();
    }

    public void clear() {
        this.obsEqkList.clear();
    }

    public void sortObsEqkRupListByMag() {
        Collections.sort(this.obsEqkList, new EqkRuptureMagComparator());
    }

    public void sortObsEqkRupListByOriginTime() {
        Collections.sort(this.obsEqkList, new ObsEqkRupEventOriginTimeComparator());
    }

    public int compareTo(Object obj) {
        ObsEqkRupture event2;
        ObsEqkRupture event1;
        boolean compareFlag = true;
        if (!(obj instanceof ObsEqkRupList)) {
            throw new ClassCastException("ObsEqkRupListObject not a ObsEqkRupList, unable to compare");
        }
        ObsEqkRupList obsEventList = (ObsEqkRupList)obj;
        ListIterator it = obsEventList.listIterator();
        ListIterator it1 = this.listIterator();
        if (this.size() != obsEventList.size()) {
            return -1;
        }
        while (it.hasNext() && (compareFlag = (event1 = (ObsEqkRupture)it.next()).equals(event2 = (ObsEqkRupture)it1.next()))) {
        }
        if (!compareFlag) {
            return -1;
        }
        return 0;
    }

    public int getIndex(ObsEqkRupture obsEqkEvent) {
        return this.obsEqkList.indexOf(obsEqkEvent);
    }
}

