/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.data.SegRateConstraint;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.data.SegmentTimeDepData;
import org.opensha.sha.faultSurface.SimpleFaultData;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultSegmentData
implements Serializable {
    private ArrayList sectionToSegmentData;
    private ArrayList simpleFaultDataList;
    private boolean aseisReducesArea;
    private double totalArea;
    private double totalMoRate;
    private double totalMoRateIgnoringAseis;
    private double totalLength;
    private double[] segArea;
    private double[] segOrigArea;
    private double[] segLength;
    private double[] segMoRate;
    private double[] segMoRateIgnoringAseis;
    private double[] segSlipRate;
    private double[] segSlipRateStdDev;
    private String[] segName;
    private String[] sectionsInSegString;
    private String faultName;
    private ArrayList<SegRateConstraint> segRates;
    private ArrayList<SegmentTimeDepData> segTimeDepDataList;

    public FaultSegmentData(ArrayList sectionToSegmentData, String[] segNames, boolean aseisReducesArea, String faultName, ArrayList<SegRateConstraint> segRateConstraints, ArrayList<SegmentTimeDepData> segTimeDepDataList) {
        this.segTimeDepDataList = segTimeDepDataList;
        this.segRates = segRateConstraints;
        this.faultName = faultName;
        this.sectionToSegmentData = sectionToSegmentData;
        this.aseisReducesArea = aseisReducesArea;
        this.calcAll();
        this.segName = segNames == null ? this.sectionsInSegString : segNames;
    }

    public ArrayList getSectionToSegmentData() {
        return this.sectionToSegmentData;
    }

    public String getFaultName() {
        return this.faultName;
    }

    public double getTotalArea() {
        return this.totalArea;
    }

    public int getNumSegments() {
        return this.sectionToSegmentData.size();
    }

    public double getSegmentArea(int index) {
        return this.segArea[index];
    }

    public double getOrigSegmentArea(int index) {
        return this.segOrigArea[index];
    }

    public double getOrigSegmentDownDipWidth(int index) {
        return this.segOrigArea[index] / this.segLength[index];
    }

    public double getSegmentLength(int index) {
        return this.segLength[index];
    }

    public double getAveSegAseisFactor(int index) {
        return 1.0 - this.segMoRate[index] / this.segMoRateIgnoringAseis[index];
    }

    public double getTotalLength() {
        return this.totalLength;
    }

    public double getSegmentSlipRate(int index) {
        return this.segSlipRate[index];
    }

    public double getSegSlipRateStdDev(int index) {
        return this.segSlipRateStdDev[index];
    }

    public SegmentTimeDepData getSegTimeDependentData(int index) {
        return this.segTimeDepDataList.get(index);
    }

    public double getSegCalYearOfLastEvent(int index) {
        return this.segTimeDepDataList.get(index).getLastEventCalendarYr();
    }

    public double getSegAperiodicity(int index) {
        return this.segTimeDepDataList.get(index).getAperiodicity();
    }

    public double getSegAveSlipInLastEvent(int index) {
        return this.segTimeDepDataList.get(index).getSlip();
    }

    public double getTotalAveSlipRate() {
        return this.totalMoRate / (this.totalArea * 3.0E10);
    }

    public double getRecurInterval(int segIndex) {
        ArrayList<SegRateConstraint> segmentConstraints = this.getSegRateConstraints(segIndex);
        if (segmentConstraints.size() == 0) {
            return Double.NaN;
        }
        SegRateConstraint meanSegmentConstraint = SegRateConstraint.getWeightMean(segmentConstraints);
        return 1.0 / meanSegmentConstraint.getMean();
    }

    public ArrayList<SegRateConstraint> getSegRateConstraints(int index) {
        ArrayList<SegRateConstraint> segmentConstraints = new ArrayList<SegRateConstraint>();
        for (int i = 0; this.segRates != null && i < this.segRates.size(); ++i) {
            if (this.segRates.get(i).getSegIndex() != index) continue;
            segmentConstraints.add(this.segRates.get(i));
        }
        return segmentConstraints;
    }

    public double getSegRateStdDevOfMean(int index) {
        ArrayList<SegRateConstraint> segmentConstraints = this.getSegRateConstraints(index);
        if (segmentConstraints.size() == 0) {
            return Double.NaN;
        }
        SegRateConstraint meanSegmentConstraint = SegRateConstraint.getWeightMean(segmentConstraints);
        return meanSegmentConstraint.getStdDevOfMean();
    }

    public double getSegRateMean(int index) {
        ArrayList<SegRateConstraint> segmentConstraints = this.getSegRateConstraints(index);
        if (segmentConstraints.size() == 0) {
            return Double.NaN;
        }
        SegRateConstraint meanSegmentConstraint = SegRateConstraint.getWeightMean(segmentConstraints);
        return meanSegmentConstraint.getMean();
    }

    public double getSegLower95Conf(int index) {
        ArrayList<SegRateConstraint> segmentConstraints = this.getSegRateConstraints(index);
        if (segmentConstraints.size() == 0) {
            return Double.NaN;
        }
        double lower95Conf = Double.MIN_VALUE;
        for (int i = 0; i < segmentConstraints.size(); ++i) {
            if (!(segmentConstraints.get(i).getLower95Conf() > lower95Conf)) continue;
            lower95Conf = segmentConstraints.get(i).getLower95Conf();
        }
        return lower95Conf;
    }

    public double getSegUpper95Conf(int index) {
        ArrayList<SegRateConstraint> segmentConstraints = this.getSegRateConstraints(index);
        if (segmentConstraints.size() == 0) {
            return Double.NaN;
        }
        double upper95Conf = Double.MAX_VALUE;
        for (int i = 0; i < segmentConstraints.size(); ++i) {
            if (!(segmentConstraints.get(i).getUpper95Conf() < upper95Conf)) continue;
            upper95Conf = segmentConstraints.get(i).getUpper95Conf();
        }
        return upper95Conf;
    }

    public double getRecurIntervalSigma(int index) {
        ArrayList<SegRateConstraint> segmentConstraints = this.getSegRateConstraints(index);
        if (segmentConstraints.size() == 0) {
            return Double.NaN;
        }
        SegRateConstraint meanSegmentConstraint = SegRateConstraint.getWeightMean(segmentConstraints);
        return meanSegmentConstraint.getStdDevOfMean() / Math.pow(meanSegmentConstraint.getMean(), 2.0);
    }

    public ArrayList<SegRateConstraint> getSegRateConstraints() {
        return this.segRates;
    }

    public double getSegmentMomentRate(int index) {
        return this.segMoRate[index];
    }

    public double getTotalMomentRate() {
        return this.totalMoRate;
    }

    public double getTotalAveAseismicityFactor() {
        double aseisFactor = 1.0 - this.totalMoRate / this.totalMoRateIgnoringAseis;
        if (aseisFactor < 0.0) {
            aseisFactor = 0.0;
        }
        return aseisFactor;
    }

    public String getSegmentName(int index) {
        return this.segName[index];
    }

    public String getSectionsInSeg(int index) {
        return this.sectionsInSegString[index];
    }

    public String[] getSegmentNames() {
        return this.segName;
    }

    public ArrayList getPrefFaultSectionDataList() {
        ArrayList faultSectionList = new ArrayList();
        for (int i = 0; i < this.sectionToSegmentData.size(); ++i) {
            ArrayList prefDataList = (ArrayList)this.sectionToSegmentData.get(i);
            faultSectionList.addAll(prefDataList);
        }
        return faultSectionList;
    }

    public StirlingGriddedSurface getCombinedGriddedSurface(double gridSpacing, double increaseDDW_Factor) {
        int[] segIndices = new int[this.getNumSegments()];
        for (int i = 0; i < segIndices.length; ++i) {
            segIndices[i] = i;
        }
        return this.getCombinedGriddedSurface(segIndices, gridSpacing, increaseDDW_Factor);
    }

    public StirlingGriddedSurface getCombinedGriddedSurface(int[] segIndex, double gridSpacing, double increaseDDW_Factor) {
        int numSectionsOnSeg1;
        int i;
        ArrayList<SimpleFaultData> simpleFaultDataCloneList = new ArrayList<SimpleFaultData>();
        int lastSegmentIndex = this.getNumSegments() - 1;
        boolean fixStepOver = false;
        if (this.faultName.equals("San Jacinto") || this.faultName.equals("Elsinore")) {
            for (i = 0; i < segIndex.length - 1; ++i) {
                if (segIndex[i] != 1 || segIndex[i + 1] != 2) continue;
                fixStepOver = true;
            }
        }
        if (fixStepOver && (numSectionsOnSeg1 = ((ArrayList)this.simpleFaultDataList.get(2)).size()) == 1) {
            fixStepOver = false;
        }
        for (i = 0; i < segIndex.length; ++i) {
            if (segIndex[i] < 0 || segIndex[i] > lastSegmentIndex) {
                throw new RuntimeException("Segment indices should can have value from  0 to " + lastSegmentIndex);
            }
            ArrayList sectionData = (ArrayList)this.simpleFaultDataList.get(segIndex[i]);
            for (int index = 0; index < sectionData.size(); ++index) {
                SimpleFaultData simpleFaultDataClone = ((SimpleFaultData)sectionData.get(index)).clone();
                simpleFaultDataClone.setLowerSeismogenicDepth(simpleFaultDataClone.getUpperSeismogenicDepth() + (simpleFaultDataClone.getLowerSeismogenicDepth() - simpleFaultDataClone.getUpperSeismogenicDepth()) * increaseDDW_Factor);
                if (fixStepOver && segIndex[i] == 1 && index == 1 || fixStepOver && segIndex[i] == 2 && index == 0) continue;
                simpleFaultDataCloneList.add(simpleFaultDataClone);
            }
        }
        return new StirlingGriddedSurface(simpleFaultDataCloneList, gridSpacing);
    }

    public StirlingGriddedSurface getCombinedGriddedSurface(int[] segIndex, double gridSpacing) {
        int numSectionsOnSeg1;
        int i;
        ArrayList<SimpleFaultData> simpleFaultData = new ArrayList<SimpleFaultData>();
        int lastSegmentIndex = this.getNumSegments() - 1;
        boolean fixStepOver = false;
        if (this.faultName.equals("San Jacinto") || this.faultName.equals("Elsinore")) {
            for (i = 0; i < segIndex.length - 1; ++i) {
                if (segIndex[i] != 1 || segIndex[i + 1] != 2) continue;
                fixStepOver = true;
            }
        }
        if (fixStepOver && (numSectionsOnSeg1 = ((ArrayList)this.simpleFaultDataList.get(2)).size()) == 1) {
            fixStepOver = false;
        }
        for (i = 0; i < segIndex.length; ++i) {
            if (segIndex[i] < 0 || segIndex[i] > lastSegmentIndex) {
                throw new RuntimeException("Segment indices should can have value from  0 to " + lastSegmentIndex);
            }
            if (fixStepOver && segIndex[i] == 1) {
                simpleFaultData.add((SimpleFaultData)((ArrayList)this.simpleFaultDataList.get(segIndex[i])).get(0));
                continue;
            }
            if (fixStepOver && segIndex[i] == 2) {
                simpleFaultData.add((SimpleFaultData)((ArrayList)this.simpleFaultDataList.get(segIndex[i])).get(1));
                continue;
            }
            simpleFaultData.addAll((ArrayList)this.simpleFaultDataList.get(segIndex[i]));
        }
        return new StirlingGriddedSurface(simpleFaultData, gridSpacing);
    }

    public StirlingGriddedSurface getCombinedGriddedSurface(double gridSpacing) {
        int[] segIndices = new int[this.getNumSegments()];
        for (int i = 0; i < segIndices.length; ++i) {
            segIndices[i] = i;
        }
        return this.getCombinedGriddedSurface(segIndices, gridSpacing);
    }

    public double getAveRake() {
        int[] segIndices = new int[this.getNumSegments()];
        for (int i = 0; i < segIndices.length; ++i) {
            segIndices[i] = i;
        }
        return this.getAveRake(segIndices);
    }

    public double getAveRake(int[] segIndex) {
        int lastSegmentIndex = this.getNumSegments() - 1;
        double totRake = 0.0;
        double totArea = 0.0;
        for (int i = 0; i < segIndex.length; ++i) {
            if (segIndex[i] < 0 || segIndex[i] > lastSegmentIndex) {
                throw new RuntimeException("Segment indices should can have value from  0 to " + lastSegmentIndex);
            }
            ArrayList faultSectionPrefDataList = (ArrayList)this.sectionToSegmentData.get(segIndex[i]);
            for (int j = 0; j < faultSectionPrefDataList.size(); ++j) {
                double area = ((FaultSectionPrefData)faultSectionPrefDataList.get(j)).getLength() * ((FaultSectionPrefData)faultSectionPrefDataList.get(j)).getDownDipWidth();
                totArea += area;
                totRake += area * ((FaultSectionPrefData)faultSectionPrefDataList.get(j)).getAveRake();
            }
        }
        double rake = totRake / totArea;
        double tolerance = 1.0E-6;
        if (rake > 180.0 && rake - 180.0 < tolerance) {
            rake = 180.0;
        }
        return rake;
    }

    private void calcAll() {
        this.totalArea = 0.0;
        this.totalMoRate = 0.0;
        this.totalMoRateIgnoringAseis = 0.0;
        this.segArea = new double[this.sectionToSegmentData.size()];
        this.segOrigArea = new double[this.sectionToSegmentData.size()];
        this.segLength = new double[this.sectionToSegmentData.size()];
        this.segMoRate = new double[this.sectionToSegmentData.size()];
        this.segMoRateIgnoringAseis = new double[this.sectionToSegmentData.size()];
        this.segSlipRate = new double[this.sectionToSegmentData.size()];
        this.segSlipRateStdDev = new double[this.sectionToSegmentData.size()];
        this.sectionsInSegString = new String[this.sectionToSegmentData.size()];
        this.simpleFaultDataList = new ArrayList();
        for (int seg = 0; seg < this.sectionToSegmentData.size(); ++seg) {
            this.segArea[seg] = 0.0;
            this.segOrigArea[seg] = 0.0;
            this.segLength[seg] = 0.0;
            this.segMoRate[seg] = 0.0;
            this.segMoRateIgnoringAseis[seg] = 0.0;
            double stdDevTotal = 0.0;
            ArrayList segmentDatum = (ArrayList)this.sectionToSegmentData.get(seg);
            Iterator it = segmentDatum.iterator();
            this.sectionsInSegString[seg] = "";
            ArrayList<SimpleFaultData> simpleFaultData = new ArrayList<SimpleFaultData>();
            while (it.hasNext()) {
                FaultSectionPrefData sectData = (FaultSectionPrefData)it.next();
                simpleFaultData.add(sectData.getSimpleFaultData(this.aseisReducesArea));
                if (it.hasNext()) {
                    int n = seg;
                    this.sectionsInSegString[n] = this.sectionsInSegString[n] + sectData.getSectionName() + " + ";
                } else {
                    int n = seg;
                    this.sectionsInSegString[n] = this.sectionsInSegString[n] + sectData.getSectionName();
                }
                int n = seg;
                this.segLength[n] = this.segLength[n] + sectData.getLength() * 1000.0;
                double ddw = sectData.getDownDipWidth() * 1000.0;
                double area = ddw * sectData.getLength() * 1000.0;
                double slipRate = sectData.getAveLongTermSlipRate() * 0.001;
                double alpha = 1.0 - sectData.getAseismicSlipFactor();
                int n2 = seg;
                this.segMoRateIgnoringAseis[n2] = this.segMoRateIgnoringAseis[n2] + FaultMomentCalc.getMoment(area, slipRate);
                int n3 = seg;
                this.segOrigArea[n3] = this.segOrigArea[n3] + area;
                if (this.aseisReducesArea) {
                    int n4 = seg;
                    this.segArea[n4] = this.segArea[n4] + area * alpha;
                    stdDevTotal += sectData.getSlipRateStdDev() / sectData.getAveLongTermSlipRate() * area * alpha;
                    int n5 = seg;
                    this.segMoRate[n5] = this.segMoRate[n5] + FaultMomentCalc.getMoment(area * alpha, slipRate);
                    continue;
                }
                int n6 = seg;
                this.segArea[n6] = this.segArea[n6] + area;
                stdDevTotal += sectData.getSlipRateStdDev() / sectData.getAveLongTermSlipRate() * area;
                int n7 = seg;
                this.segMoRate[n7] = this.segMoRate[n7] + FaultMomentCalc.getMoment(area, slipRate * alpha);
            }
            this.simpleFaultDataList.add(simpleFaultData);
            this.segSlipRate[seg] = FaultMomentCalc.getSlip(this.segArea[seg], this.segMoRate[seg]);
            this.segSlipRateStdDev[seg] = stdDevTotal / this.segArea[seg] * this.segSlipRate[seg];
            this.totalArea += this.segArea[seg];
            this.totalMoRate += this.segMoRate[seg];
            this.totalMoRateIgnoringAseis += this.segMoRateIgnoringAseis[seg];
            this.totalLength += this.segLength[seg];
        }
    }
}

