/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.calc.MomentMagCalc;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.Ellsworth_B_WG02_MagAreaRel;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.HanksBakun2002_MagAreaRel;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.Somerville_2006_MagAreaRel;
import org.opensha.commons.data.Direction;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_TypeB_EqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.EmpiricalModel;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.UCERF2;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfaceAPI;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.faultSurface.GriddedSubsetSurface;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsegmentedSource
extends ProbEqkSource {
    private static String C = new String("UnsegmentedSource");
    private static final boolean D = false;
    ArrayList<ProbEqkRupture> ruptureList;
    private double rake;
    protected double duration;
    private static final double RUPTURE_WIDTH = 100.0;
    private double rupOffset = 5.0;
    private int totNumRups;
    private int totNumGR_rups;
    private int totNumChar_rups;
    private EvenlyGriddedSurface surface;
    private ArrayList gr_mags;
    private ArrayList char_mags;
    private ArrayList gr_rates;
    private ArrayList char_rates;
    public static final double DEFAULT_DURATION = 1.0;
    protected String NAME = "Unsegmented Source";
    private int num_seg;
    private double[] segRate;
    private double[] segVisibleRate;
    private ArbDiscrEmpiricalDistFunc[] segSlipDist;
    private ArbDiscrEmpiricalDistFunc[] segVisibleSlipDist;
    private IncrementalMagFreqDist sourceMFD;
    private IncrementalMagFreqDist grMFD;
    private IncrementalMagFreqDist charMFD;
    private IncrementalMagFreqDist visibleSourceMFD;
    private IncrementalMagFreqDist[] segSourceMFD;
    private IncrementalMagFreqDist[] visibleSegSourceMFD;
    private double sourceMag;
    private FaultSegmentData segmentData;
    private MagAreaRelationship magAreaRel;
    private double fixMag;
    private double fixRate;
    private double mag_lowerGR;
    private double b_valueGR;
    private double moRateReduction;
    private double moRate;
    protected LocationList surfaceLocList;
    private EmpiricalModel empiricalModel;
    private double empirical_weight;
    private double sourceGain;
    protected ArbitrarilyDiscretizedFunc origSlipRateFunc;
    protected ArbitrarilyDiscretizedFunc predSlipRateFunc;
    private ArrayList<ArbitrarilyDiscretizedFunc> magBasedUncorrSlipRateFuncs;
    private static HanksBakun2002_MagAreaRel hb_MagAreaRel = new HanksBakun2002_MagAreaRel();
    private static Ellsworth_B_WG02_MagAreaRel ellB_magAreaRel = new Ellsworth_B_WG02_MagAreaRel();
    private static Somerville_2006_MagAreaRel somerville_magAreaRel = new Somerville_2006_MagAreaRel();
    public static final int FULL_DDW_FLOATER = 0;
    public static final int STRIKE_AND_DOWNDIP_FLOATER = 1;
    public static final int CENTERED_DOWNDIP_FLOATER = 2;

    public UnsegmentedSource(FaultSegmentData segmentData, EmpiricalModel empiricalModel, double rupOffset, double weight, double empiricalModelWeight, double duration, boolean applyCyberShakeDDW_Corr, int floaterType) {
        this(segmentData, empiricalModel, rupOffset, 0.8, 0.0, weight, empiricalModelWeight, duration, segmentData.getTotalMomentRate(), 0.67, applyCyberShakeDDW_Corr, floaterType);
    }

    public UnsegmentedSource(FaultSegmentData segmentData, EmpiricalModel empiricalModel, double rupOffset, double b_valueGR_1, double b_valueGR_2, double weight, double empiricalModelWeight, double duration, double moRate, double fractCharVsGR, boolean applyCyberShakeDDW_Corr, int floaterType) {
        StirlingGriddedSurface combinedGriddedSurface;
        GutenbergRichterMagFreqDist tempGR_MFD;
        GaussianMagFreqDist tempCharMFD;
        this.isPoissonian = true;
        this.empirical_weight = empiricalModelWeight;
        this.rupOffset = rupOffset;
        this.mag_lowerGR = 6.5;
        this.segmentData = segmentData;
        double min_mag = 5.05;
        double max_mag = 8.95;
        int num_mag = UCERF2.NUM_MAG;
        double delta_mag = (max_mag - min_mag) / (double)(num_mag - 1);
        double charMagSigma = 0.12;
        double charMagTruncLevel = 2.0;
        this.moRateReduction = 0.1;
        moRate *= 1.0 - this.moRateReduction;
        this.empiricalModel = empiricalModel;
        double sourceMag1 = hb_MagAreaRel.getMedianMag(segmentData.getTotalArea() / 1000000.0);
        sourceMag1 = (double)Math.round(sourceMag1 / delta_mag) * delta_mag;
        double sourceMag2 = ellB_magAreaRel.getMedianMag(segmentData.getTotalArea() / 1000000.0);
        sourceMag2 = (double)Math.round(sourceMag2 / delta_mag) * delta_mag;
        if (segmentData.getFaultName().equals("San Andreas (Creeping Segment)")) {
            this.moRateReduction = 0.0;
            this.mag_lowerGR = 6.0;
            b_valueGR_1 = 0.91;
            b_valueGR_2 = 0.91;
            sourceMag1 = 6.7;
            sourceMag2 = 6.7;
            fractCharVsGR = 0.0;
            moRate = 3.8593E16;
        }
        this.sourceMFD = new SummedMagFreqDist(min_mag, max_mag, num_mag);
        this.charMFD = new SummedMagFreqDist(min_mag, max_mag, num_mag);
        this.grMFD = new SummedMagFreqDist(min_mag, max_mag, num_mag);
        this.sourceMag = sourceMag1;
        if (this.sourceMag <= this.mag_lowerGR) {
            tempCharMFD = new GaussianMagFreqDist(min_mag, max_mag, num_mag, this.sourceMag, charMagSigma, moRate * weight * 0.5, charMagTruncLevel, 2);
            ((SummedMagFreqDist)this.charMFD).addIncrementalMagFreqDist(tempCharMFD);
        } else {
            tempCharMFD = new GaussianMagFreqDist(min_mag, max_mag, num_mag, this.sourceMag, charMagSigma, moRate * fractCharVsGR * weight * 0.5, charMagTruncLevel, 2);
            ((SummedMagFreqDist)this.charMFD).addIncrementalMagFreqDist(tempCharMFD);
            this.b_valueGR = b_valueGR_1;
            tempGR_MFD = new GutenbergRichterMagFreqDist(min_mag, num_mag, delta_mag, this.mag_lowerGR + delta_mag / 2.0, this.sourceMag - delta_mag / 2.0, moRate * (1.0 - fractCharVsGR) * weight * 0.5 * 0.5, this.b_valueGR);
            ((SummedMagFreqDist)this.grMFD).addIncrementalMagFreqDist(tempGR_MFD);
            this.b_valueGR = b_valueGR_2;
            tempGR_MFD = new GutenbergRichterMagFreqDist(min_mag, num_mag, delta_mag, this.mag_lowerGR + delta_mag / 2.0, this.sourceMag - delta_mag / 2.0, moRate * (1.0 - fractCharVsGR) * weight * 0.5 * 0.5, this.b_valueGR);
            ((SummedMagFreqDist)this.grMFD).addIncrementalMagFreqDist(tempGR_MFD);
        }
        this.sourceMag = sourceMag2;
        if (this.sourceMag <= this.mag_lowerGR) {
            tempCharMFD = new GaussianMagFreqDist(min_mag, max_mag, num_mag, this.sourceMag, charMagSigma, moRate * weight * 0.5, charMagTruncLevel, 2);
            ((SummedMagFreqDist)this.charMFD).addIncrementalMagFreqDist(tempCharMFD);
        } else {
            tempCharMFD = new GaussianMagFreqDist(min_mag, max_mag, num_mag, this.sourceMag, charMagSigma, moRate * fractCharVsGR * weight * 0.5, charMagTruncLevel, 2);
            ((SummedMagFreqDist)this.charMFD).addIncrementalMagFreqDist(tempCharMFD);
            this.b_valueGR = b_valueGR_1;
            tempGR_MFD = new GutenbergRichterMagFreqDist(min_mag, num_mag, delta_mag, this.mag_lowerGR + delta_mag / 2.0, this.sourceMag - delta_mag / 2.0, moRate * (1.0 - fractCharVsGR) * weight * 0.5 * 0.5, this.b_valueGR);
            ((SummedMagFreqDist)this.grMFD).addIncrementalMagFreqDist(tempGR_MFD);
            this.b_valueGR = b_valueGR_2;
            tempGR_MFD = new GutenbergRichterMagFreqDist(min_mag, num_mag, delta_mag, this.mag_lowerGR + delta_mag / 2.0, this.sourceMag - delta_mag / 2.0, moRate * (1.0 - fractCharVsGR) * weight * 0.5 * 0.5, this.b_valueGR);
            ((SummedMagFreqDist)this.grMFD).addIncrementalMagFreqDist(tempGR_MFD);
        }
        ((SummedMagFreqDist)this.sourceMFD).addIncrementalMagFreqDist(this.charMFD);
        ((SummedMagFreqDist)this.sourceMFD).addIncrementalMagFreqDist(this.grMFD);
        this.num_seg = segmentData.getNumSegments();
        if (applyCyberShakeDDW_Corr) {
            double ddwCorrFactor = somerville_magAreaRel.getMedianArea((sourceMag1 + sourceMag2) / 2.0) / (segmentData.getTotalArea() / 1000000.0);
            combinedGriddedSurface = segmentData.getCombinedGriddedSurface(1.0, ddwCorrFactor);
        } else {
            combinedGriddedSurface = segmentData.getCombinedGriddedSurface(1.0);
        }
        this.mkRuptureList(combinedGriddedSurface, rupOffset, segmentData.getAveRake(), duration, segmentData.getFaultName(), applyCyberShakeDDW_Corr, floaterType);
        String new_info = "Source MFD\n" + this.sourceMFD.getInfo();
        new_info = new_info + "|n\nRescaled to:\n\n\tMoment Rate: " + (float)this.sourceMFD.getTotalMomentRate() + "\n\n\tNew Total Rate: " + (float)this.sourceMFD.getCumRate(0);
        this.sourceMFD.setInfo(new_info);
    }

    public UnsegmentedSource(FaultSegmentData segmentData, MagAreaRelationship magAreaRel, double fractCharVsGR, double min_mag, double max_mag, int num_mag, double charMagSigma, double charMagTruncLevel, double mag_lowerGR, double b_valueGR, double moRateReduction, double fixMag, double fixRate, double meanMagCorrection, EmpiricalModel empiricalModel, int floaterType) {
        this.isPoissonian = true;
        this.empirical_weight = 1.0;
        this.segmentData = segmentData;
        this.magAreaRel = magAreaRel;
        this.fixMag = fixMag;
        this.fixRate = fixRate * (1.0 - moRateReduction);
        double delta_mag = (max_mag - min_mag) / (double)(num_mag - 1);
        this.moRateReduction = moRateReduction;
        this.mag_lowerGR = mag_lowerGR;
        this.b_valueGR = b_valueGR;
        this.empiricalModel = empiricalModel;
        this.sourceMag = magAreaRel.getMedianMag(segmentData.getTotalArea() / 1000000.0) + meanMagCorrection;
        this.sourceMag = (double)Math.round(this.sourceMag / delta_mag) * delta_mag;
        this.moRate = segmentData.getTotalMomentRate() * (1.0 - moRateReduction);
        if (segmentData.getFaultName().equals("San Andreas (Creeping Segment)")) {
            this.moRateReduction = moRateReduction = 0.0;
            this.mag_lowerGR = mag_lowerGR = 6.0;
            this.b_valueGR = b_valueGR = 0.91;
            this.sourceMag = 6.7;
            fractCharVsGR = 0.0;
            this.moRate = 3.8593E16;
        }
        if (this.sourceMag <= mag_lowerGR) {
            if (Double.isNaN(fixMag)) {
                this.charMFD = new GaussianMagFreqDist(min_mag, max_mag, num_mag, this.sourceMag, charMagSigma, this.moRate, charMagTruncLevel, 2);
            } else {
                this.charMFD = new GaussianMagFreqDist(min_mag, max_mag, num_mag, fixMag, charMagSigma, 1.0, charMagTruncLevel, 2);
                this.charMFD.scaleToCumRate(0, this.fixRate);
            }
            this.sourceMFD = this.charMFD;
        } else {
            this.sourceMFD = new SummedMagFreqDist(min_mag, max_mag, num_mag);
            if (Double.isNaN(fixMag)) {
                this.charMFD = new GaussianMagFreqDist(min_mag, max_mag, num_mag, this.sourceMag, charMagSigma, this.moRate * fractCharVsGR, charMagTruncLevel, 2);
            } else {
                this.charMFD = new GaussianMagFreqDist(min_mag, max_mag, num_mag, fixMag, charMagSigma, 1.0, charMagTruncLevel, 2);
                this.charMFD.scaleToCumRate(0, this.fixRate);
            }
            ((SummedMagFreqDist)this.sourceMFD).addIncrementalMagFreqDist(this.charMFD);
            this.grMFD = new GutenbergRichterMagFreqDist(min_mag, num_mag, delta_mag, mag_lowerGR + delta_mag / 2.0, this.sourceMag - delta_mag / 2.0, this.moRate * (1.0 - fractCharVsGR), b_valueGR);
            ((SummedMagFreqDist)this.sourceMFD).addIncrementalMagFreqDist(this.grMFD);
        }
        this.num_seg = segmentData.getNumSegments();
        this.visibleSourceMFD = this.sourceMFD.deepClone();
        for (int i = 0; i < this.sourceMFD.getNum(); ++i) {
            this.visibleSourceMFD.set(i, this.sourceMFD.getY(i) * this.getProbVisible(this.sourceMFD.getX(i)));
        }
        this.mkRuptureList(segmentData.getCombinedGriddedSurface(1.0), this.rupOffset, segmentData.getAveRake(), 1.0, segmentData.getFaultName(), false, floaterType);
        this.getSegSourceMFD();
        this.visibleSegSourceMFD = new IncrementalMagFreqDist[this.num_seg];
        for (int s = 0; s < this.num_seg; ++s) {
            this.visibleSegSourceMFD[s] = this.segSourceMFD[s].deepClone();
            for (int i = 0; i < this.sourceMFD.getNum(); ++i) {
                this.visibleSegSourceMFD[s].set(i, this.segSourceMFD[s].getY(i) * this.getProbVisible(this.segSourceMFD[s].getX(i)));
            }
        }
        String new_info = "Source MFD\n" + this.sourceMFD.getInfo();
        new_info = new_info + "|n\nRescaled to:\n\n\tMoment Rate: " + (float)this.sourceMFD.getTotalMomentRate() + "\n\n\tNew Total Rate: " + (float)this.sourceMFD.getCumRate(0);
        this.sourceMFD.setInfo(new_info);
        new_info = "Visible Source MFD\n" + this.visibleSourceMFD.getInfo();
        new_info = new_info + "|n\nRescaled to:\n\n\tMoment Rate: " + (float)this.visibleSourceMFD.getTotalMomentRate() + "\n\n\tNew Total Rate: " + (float)this.visibleSourceMFD.getCumRate(0);
        this.visibleSourceMFD.setInfo(new_info);
        this.segRate = new double[this.num_seg];
        this.segVisibleRate = new double[this.num_seg];
        for (int s = 0; s < this.num_seg; ++s) {
            this.segRate[s] = this.segSourceMFD[s].getTotalIncrRate();
            this.segVisibleRate[s] = this.visibleSegSourceMFD[s].getTotalIncrRate();
        }
        this.computeSegSlipDist();
        this.saveSurfaceLocs();
    }

    private void saveSurfaceLocs() {
        EvenlyGriddedSurface sourceSurface = this.getSourceSurface();
        int numCols = sourceSurface.getNumCols();
        this.surfaceLocList = new LocationList();
        for (int col = 0; col < numCols; ++col) {
            this.surfaceLocList.addLocation(sourceSurface.getLocation(0, col));
        }
    }

    public ArrayList<ArbitrarilyDiscretizedFunc> getMagBasedFinalSlipRateListAlongFault() {
        if (this.magBasedUncorrSlipRateFuncs == null) {
            this.getFinalSlipRateAlongFault();
        }
        return this.magBasedUncorrSlipRateFuncs;
    }

    protected void computeSlipRateAlongFault(ArbitrarilyDiscretizedFunc slipRateFunc, ArrayList<ArbitrarilyDiscretizedFunc> magBasedFuncs, boolean isSlipRateCorrection) {
        int numRups = this.getNumRuptures();
        EvenlyGriddedSurface sourceSurface = this.getSourceSurface();
        int numCols = sourceSurface.getNumCols();
        for (int col = 0; col < numCols; ++col) {
            slipRateFunc.set((double)col, 0.0);
        }
        HashMap<Double, ArbitrarilyDiscretizedFunc> magFuncMap = new HashMap<Double, ArbitrarilyDiscretizedFunc>();
        int numMags = this.sourceMFD.getNum();
        for (int i = 0; i < numMags; ++i) {
            if (this.sourceMFD.getY(i) == 0.0) continue;
            ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
            for (int col = 0; col < numCols; ++col) {
                func.set((double)col, 0.0);
            }
            magFuncMap.put(this.sourceMFD.getX(i), func);
            magBasedFuncs.add(func);
        }
        double totMoRate = 0.0;
        for (int rupIndex = 0; rupIndex < numRups; ++rupIndex) {
            ProbEqkRupture rupture = isSlipRateCorrection ? this.getRupture(rupIndex) : this.getRupture(rupIndex);
            EvenlyGriddedSurfaceAPI rupSurface = rupture.getRuptureSurface();
            double area = rupSurface.getSurfaceLength() * rupSurface.getSurfaceWidth();
            double moRate = MomentMagCalc.getMoment(rupture.getMag());
            totMoRate += moRate * rupture.getMeanAnnualRate(this.duration);
            double slip = FaultMomentCalc.getSlip(area * 1000000.0, moRate);
            double slipRate = rupture.getMeanAnnualRate(this.duration) * slip;
            ArbitrarilyDiscretizedFunc magBasedFunc = (ArbitrarilyDiscretizedFunc)magFuncMap.get(rupture.getMag());
            int index1 = this.surfaceLocList.getLocationIndex(rupSurface.getLocation(0, 0));
            int index2 = this.surfaceLocList.getLocationIndex(rupSurface.getLocation(0, rupSurface.getNumCols() - 1));
            for (int col = index1; col <= index2; ++col) {
                slipRateFunc.set(col, slipRateFunc.getY(col) + slipRate);
                magBasedFunc.set(col, magBasedFunc.getY(col) + slipRate);
            }
        }
    }

    public ArbitrarilyDiscretizedFunc getFinalSlipRateAlongFault() {
        if (this.predSlipRateFunc != null) {
            return this.predSlipRateFunc;
        }
        this.predSlipRateFunc = new ArbitrarilyDiscretizedFunc();
        this.predSlipRateFunc.setName("Final slip rate along fault");
        this.magBasedUncorrSlipRateFuncs = new ArrayList();
        this.computeSlipRateAlongFault(this.predSlipRateFunc, this.magBasedUncorrSlipRateFuncs, false);
        return this.predSlipRateFunc;
    }

    public ArbitrarilyDiscretizedFunc getOrigSlipRateAlongFault() {
        if (this.origSlipRateFunc != null) {
            return this.origSlipRateFunc;
        }
        ArbitrarilyDiscretizedFunc segLengths = new ArbitrarilyDiscretizedFunc();
        double totSegLength = 0.0;
        for (int segIndex = 0; segIndex < this.num_seg; ++segIndex) {
            segLengths.set((double)segIndex, totSegLength += this.segmentData.getSegmentLength(segIndex) / 1000.0);
        }
        EvenlyGriddedSurface sourceSurface = this.getSourceSurface();
        int numCols = sourceSurface.getNumCols();
        double slipRate = 0.0;
        this.origSlipRateFunc = new ArbitrarilyDiscretizedFunc();
        this.origSlipRateFunc.setName("Orig slip rate along fault");
        for (int col = 0; col < numCols; ++col) {
            double length = (double)col * 1.0;
            for (int segIndex = 0; segIndex < this.num_seg; ++segIndex) {
                if (!(length < segLengths.getY(segIndex))) continue;
                slipRate = this.segmentData.getSegmentSlipRate(segIndex) * (1.0 - this.moRateReduction);
                break;
            }
            this.origSlipRateFunc.set((double)col, slipRate);
        }
        return this.origSlipRateFunc;
    }

    public double getMoRateReduction() {
        return this.moRateReduction;
    }

    public double getMomentRate() {
        return this.moRate;
    }

    public double[] getNormModSlipRateResids() {
        int numSegments = this.getFaultSegmentData().getNumSegments();
        double[] normResids = new double[numSegments];
        double reduction = 1.0 - this.getMoRateReduction();
        for (int segIndex = 0; segIndex < numSegments; ++segIndex) {
            normResids[segIndex] = this.getFinalAveSegSlipRate(segIndex) - this.getFaultSegmentData().getSegmentSlipRate(segIndex) * reduction;
            int n = segIndex;
            normResids[n] = normResids[n] / (this.getFaultSegmentData().getSegSlipRateStdDev(segIndex) * reduction);
        }
        return normResids;
    }

    public double getSourceMag() {
        return this.sourceMag;
    }

    public double getFixMag() {
        return this.fixMag;
    }

    public double getFixRate() {
        return this.fixRate;
    }

    public FaultSegmentData getFaultSegmentData() {
        return this.segmentData;
    }

    private void getSegSourceMFD() {
        int i;
        double[] segLengths = new double[this.num_seg];
        for (int i2 = 0; i2 < this.num_seg; ++i2) {
            segLengths[i2] = 0.001 * this.segmentData.getSegmentLength(i2);
        }
        double totalLength = this.segmentData.getTotalLength() * 0.001;
        double aveDDW = this.segmentData.getTotalArea() * 1.0E-6 / totalLength;
        this.segSourceMFD = new IncrementalMagFreqDist[this.num_seg];
        for (i = 0; i < this.num_seg; ++i) {
            this.segSourceMFD[i] = this.sourceMFD.deepClone();
        }
        for (i = 0; i < this.sourceMFD.getNum(); ++i) {
            double mag = this.sourceMFD.getX(i);
            double rupLength = this.magAreaRel.getMedianArea(mag) / aveDDW;
            double[] segProbs = this.getProbSegObsRupture(segLengths, totalLength, rupLength);
            for (int j = 0; j < this.num_seg; ++j) {
                this.segSourceMFD[j].set(i, segProbs[j] * this.segSourceMFD[j].getY(i));
            }
        }
    }

    private double[] getProbSegObsRupture(double[] segLengths, double totalLength, double rupLength) {
        double[] segProbs = new double[segLengths.length];
        if (rupLength > totalLength) {
            for (int j = 0; j < segLengths.length; ++j) {
                segProbs[j] = 1.0;
            }
            return segProbs;
        }
        EvenlyDiscretizedFunc probFunc = new EvenlyDiscretizedFunc(0.0, totalLength, 100);
        if (rupLength < totalLength / 2.0) {
            double multFactor = rupLength / (totalLength - rupLength);
            for (int i = 0; i < probFunc.getNum(); ++i) {
                double l = probFunc.getX(i);
                double prob = l < rupLength ? l / rupLength * multFactor : (l < totalLength - rupLength ? multFactor : (totalLength - l) * multFactor / rupLength);
                probFunc.set(i, prob);
            }
        } else {
            for (int i = 0; i < probFunc.getNum(); ++i) {
                double l = probFunc.getX(i);
                double prob = l < totalLength - rupLength ? l / (totalLength - rupLength) : (l <= rupLength ? 1.0 : (totalLength - l) / (totalLength - rupLength));
                probFunc.set(i, prob);
            }
        }
        double firstLength = 0.0;
        for (int i = 0; i < segLengths.length; ++i) {
            int index1 = (int)Math.ceil((firstLength - probFunc.getMinX()) / probFunc.getDelta());
            double lastLength = firstLength + segLengths[i];
            int index2 = (int)Math.floor((lastLength - probFunc.getMinX()) / probFunc.getDelta());
            double total = 0.0;
            for (int j = index1; j <= index2; ++j) {
                total += probFunc.getY(j);
            }
            segProbs[i] = total / (double)(index2 - index1 + 1);
            firstLength = lastLength;
        }
        return segProbs;
    }

    private double getProbVisible(double mag) {
        return Math.exp(-12.51 + mag * 2.053) / (1.0 + Math.exp(-12.51 + mag * 2.053));
    }

    public double getFinalAveSegSlipRate(int ithSegment) {
        ArbDiscrEmpiricalDistFunc segmenstSlipDist = this.getSegmentSlipDist(ithSegment);
        double slipRate = 0.0;
        for (int i = 0; i < segmenstSlipDist.getNum(); ++i) {
            slipRate += segmenstSlipDist.getX(i) * segmenstSlipDist.getY(i);
        }
        return slipRate;
    }

    public ArbDiscrEmpiricalDistFunc getSegmentSlipDist(int ithSegment) {
        return this.segSlipDist[ithSegment];
    }

    public ArbDiscrEmpiricalDistFunc getSegmentVisibleSlipDist(int ithSegment) {
        return this.segVisibleSlipDist[ithSegment];
    }

    public IncrementalMagFreqDist getMagFreqDist() {
        return this.sourceMFD;
    }

    public IncrementalMagFreqDist getCharMagFreqDist() {
        return this.charMFD;
    }

    public IncrementalMagFreqDist getGR_MagFreqDist() {
        return this.grMFD;
    }

    public IncrementalMagFreqDist getVisibleSourceMagFreqDist() {
        return this.visibleSourceMFD;
    }

    private void computeSegSlipDist() {
        this.segSlipDist = new ArbDiscrEmpiricalDistFunc[this.num_seg];
        this.segVisibleSlipDist = new ArbDiscrEmpiricalDistFunc[this.num_seg];
        for (int seg = 0; seg < this.num_seg; ++seg) {
            this.segSlipDist[seg] = new ArbDiscrEmpiricalDistFunc();
            this.segVisibleSlipDist[seg] = new ArbDiscrEmpiricalDistFunc();
            IncrementalMagFreqDist segMFD = this.segSourceMFD[seg];
            IncrementalMagFreqDist visibleSegMFD = this.visibleSegSourceMFD[seg];
            for (int i = 0; i < segMFD.getNum(); ++i) {
                double mag = segMFD.getX(i);
                double moment = MomentMagCalc.getMoment(mag);
                double slip = FaultMomentCalc.getSlip(this.magAreaRel.getMedianArea(mag) * 1000000.0, moment);
                this.segSlipDist[seg].set(slip, segMFD.getY(i));
                this.segVisibleSlipDist[seg].set(slip, visibleSegMFD.getY(i));
            }
        }
    }

    public double getPredSlipRate(Location loc) {
        EvenlyGriddedSurface surface = this.getSourceSurface();
        double minDist = Double.MAX_VALUE;
        for (int col = 0; col < surface.getNumCols(); ++col) {
            double dist = RelativeLocation.getApproxHorzDistance(surface.getLocation(0, col), loc);
            if (!(dist < minDist)) continue;
            minDist = dist;
        }
        double distanceCutOff = minDist + 0.001;
        if (distanceCutOff > 2.0) {
            throw new RuntimeException("Location:(" + loc.getLatitude() + "," + loc.getLongitude() + ") is more than 2 km from any rupture");
        }
        double slipRate = 0.0;
        int numRups = this.getNumRuptures();
        block1: for (int rupIndex = 0; rupIndex < numRups; ++rupIndex) {
            ProbEqkRupture rupture = this.getRupture(rupIndex);
            ListIterator it = rupture.getRuptureSurface().getLocationsIterator();
            while (it.hasNext()) {
                Location surfaceLoc = (Location)it.next();
                if (!(RelativeLocation.getApproxHorzDistance(surfaceLoc, loc) < distanceCutOff)) continue;
                double area = rupture.getRuptureSurface().getSurfaceLength() * rupture.getRuptureSurface().getSurfaceWidth();
                double slip = FaultMomentCalc.getSlip(area * 1000000.0, MomentMagCalc.getMoment(rupture.getMag()));
                slipRate += rupture.getMeanAnnualRate(this.duration) * slip;
                continue block1;
            }
        }
        if (slipRate == 0.0) {
            throw new RuntimeException("No rupture close to event rate location:" + loc.getLatitude() + "," + loc.getLongitude());
        }
        return slipRate;
    }

    public double getPredEventRate(Location loc) {
        EvenlyGriddedSurface surface = this.getSourceSurface();
        double minDist = Double.MAX_VALUE;
        for (int col = 0; col < surface.getNumCols(); ++col) {
            double dist = RelativeLocation.getApproxHorzDistance(surface.getLocation(0, col), loc);
            if (!(dist < minDist)) continue;
            minDist = dist;
        }
        double distanceCutOff = minDist + 0.001;
        if (distanceCutOff > 2.0) {
            throw new RuntimeException("Location:(" + loc.getLatitude() + "," + loc.getLongitude() + ") is more than 2 km from any rupture");
        }
        double rate = 0.0;
        int numRups = this.getNumRuptures();
        block1: for (int rupIndex = 0; rupIndex < numRups; ++rupIndex) {
            ProbEqkRupture rupture = this.getRupture(rupIndex);
            ListIterator it = rupture.getRuptureSurface().getLocationsIterator();
            while (it.hasNext()) {
                Location surfaceLoc = (Location)it.next();
                if (!(RelativeLocation.getApproxHorzDistance(surfaceLoc, loc) < distanceCutOff)) continue;
                rate += rupture.getMeanAnnualRate(this.duration);
                continue block1;
            }
        }
        return rate;
    }

    public double getPredObsEventRate(Location loc) {
        EvenlyGriddedSurface surface = this.getSourceSurface();
        double minDist = Double.MAX_VALUE;
        for (int col = 0; col < surface.getNumCols(); ++col) {
            double dist = RelativeLocation.getApproxHorzDistance(surface.getLocation(0, col), loc);
            if (!(dist < minDist)) continue;
            minDist = dist;
        }
        double distanceCutOff = minDist + 0.001;
        if (distanceCutOff > 2.0) {
            throw new RuntimeException("Location:(" + loc.getLatitude() + "," + loc.getLongitude() + ") is more than 2 km from any rupture");
        }
        double rate = 0.0;
        int numRups = this.getNumRuptures();
        block1: for (int rupIndex = 0; rupIndex < numRups; ++rupIndex) {
            ProbEqkRupture rupture = this.getRupture(rupIndex);
            double probVis = this.getProbVisible(rupture.getMag());
            ListIterator it = rupture.getRuptureSurface().getLocationsIterator();
            while (it.hasNext()) {
                Location surfaceLoc = (Location)it.next();
                if (!(RelativeLocation.getApproxHorzDistance(surfaceLoc, loc) < distanceCutOff)) continue;
                rate += rupture.getMeanAnnualRate(this.duration) * probVis;
                continue block1;
            }
        }
        return rate;
    }

    public String getNSHMP_GR_SrcFileString() {
        if (this.sourceMag <= 6.5) {
            return this.getNSHMP_Char_SrcFileString();
        }
        StringBuffer strBuffer = new StringBuffer("");
        strBuffer.append("2\t");
        double rake = this.segmentData.getAveRake();
        String rakeStr = "";
        if (rake >= -45.0 && rake <= 45.0 || rake >= 135.0 || rake <= -135.0) {
            rakeStr = "1";
        } else if (rake > 45.0 && rake < 135.0) {
            rakeStr = "2";
        } else if (rake > -135.0 && rake < -45.0) {
            rakeStr = "3";
        } else {
            throw new RuntimeException("Invalid Rake:" + rake);
        }
        strBuffer.append(rakeStr + "\t" + "1" + "\t" + this.segmentData.getFaultName() + "\n");
        int numNonZeroMags = (int)Math.round((this.sourceMag - this.mag_lowerGR) / this.sourceMFD.getDelta() + 1.0);
        double moRate = this.sourceMFD.getTotalMomentRate();
        double delta = this.sourceMFD.getDelta();
        double a_value = this.getNSHMP_aValue(this.mag_lowerGR + delta / 2.0, numNonZeroMags - 1, delta, moRate, this.b_valueGR);
        double momentCheck = this.getMomentRate(this.mag_lowerGR + delta / 2.0, numNonZeroMags - 1, delta, a_value, this.b_valueGR);
        double wt = 1.0;
        if (momentCheck / moRate < 0.999 || momentCheck / moRate > 1.001) {
            System.out.println("WARNING -- Bad a-value!: " + this.segmentData.getFaultName() + "  " + momentCheck + "  " + moRate);
        }
        strBuffer.append((float)a_value + "\t" + (float)this.b_valueGR + "\t" + (float)this.mag_lowerGR + "\t" + (float)this.sourceMag + "\t" + (float)delta + "\t" + (float)wt + "\t" + (float)moRate + "\n");
        StirlingGriddedSurface surface = (StirlingGriddedSurface)this.getSourceSurface();
        strBuffer.append((float)surface.getAveDip() + "\t" + (float)surface.getSurfaceWidth() + "\t" + (float)surface.getUpperSeismogenicDepth() + "\t" + (float)surface.getSurfaceLength() + "\n");
        FaultTrace faultTrace = surface.getFaultTrace();
        strBuffer.append(faultTrace.getNumLocations() + "\n");
        for (int locIndex = 0; locIndex < faultTrace.getNumLocations(); ++locIndex) {
            strBuffer.append(faultTrace.getLocationAt(locIndex).getLatitude() + "\t" + faultTrace.getLocationAt(locIndex).getLongitude() + "\n");
        }
        return strBuffer.toString();
    }

    public String getNSHMP_Char_SrcFileString() {
        StringBuffer strBuffer = new StringBuffer("");
        strBuffer.append("1\t");
        double rake = this.segmentData.getAveRake();
        String rakeStr = "";
        if (rake >= -45.0 && rake <= 45.0 || rake >= 135.0 || rake <= -135.0) {
            rakeStr = "1";
        } else if (rake > 45.0 && rake < 135.0) {
            rakeStr = "2";
        } else if (rake > -135.0 && rake < -45.0) {
            rakeStr = "3";
        } else {
            throw new RuntimeException("Invalid Rake:" + rake);
        }
        strBuffer.append(rakeStr + "\t" + "1" + "\t" + this.segmentData.getFaultName() + "\n");
        int numNonZeroMags = (int)Math.round((this.sourceMag - this.mag_lowerGR) / this.sourceMFD.getDelta() + 1.0);
        double moRate = this.sourceMFD.getTotalMomentRate();
        double rate = moRate / MomentMagCalc.getMoment(this.sourceMag);
        double wt = 1.0;
        strBuffer.append((float)this.sourceMag + "\t" + rate + "\t" + wt + "\t" + (float)moRate + "\n");
        StirlingGriddedSurface surface = (StirlingGriddedSurface)this.getSourceSurface();
        strBuffer.append((float)surface.getAveDip() + "\t" + (float)surface.getSurfaceWidth() + "\t" + (float)surface.getUpperSeismogenicDepth() + "\t" + (float)surface.getSurfaceLength() + "\n");
        FaultTrace faultTrace = surface.getFaultTrace();
        strBuffer.append(faultTrace.getNumLocations() + "\n");
        for (int locIndex = 0; locIndex < faultTrace.getNumLocations(); ++locIndex) {
            strBuffer.append(faultTrace.getLocationAt(locIndex).getLatitude() + "\t" + faultTrace.getLocationAt(locIndex).getLongitude() + "\n");
        }
        return strBuffer.toString();
    }

    private double getMomentRate(double magLower, int numMag, double deltaMag, double aVal, double bVal) {
        double mo = 0.0;
        for (int i = 0; i < numMag; ++i) {
            double mag = magLower + (double)i * deltaMag;
            mo += Math.pow(10.0, aVal - bVal * mag + 1.5 * mag + 9.05);
        }
        return mo;
    }

    private double getNSHMP_aValue(double magLower, int numMag, double deltaMag, double moRate, double bVal) {
        double sum = 0.0;
        for (int i = 0; i < numMag; ++i) {
            double mag = magLower + (double)i * deltaMag;
            sum += Math.pow(10.0, -bVal * mag + 1.5 * mag + 9.05);
        }
        return Math.log10(moRate / sum);
    }

    private void mkRuptureList(EvenlyGriddedSurface surface, double rupOffset, double rake, double duration, String sourceName, boolean applyCyberShakeDDW_Corr, int floaterType) {
        this.surface = surface;
        this.rupOffset = rupOffset;
        this.rake = rake;
        this.duration = duration;
        this.name = sourceName;
        this.ruptureList = new ArrayList();
        double totSrcRate = 0.0;
        double totSrcRateEmp = 0.0;
        for (int i = 0; this.grMFD != null && i < this.grMFD.getNum(); ++i) {
            double rate = this.grMFD.getY(i);
            if (rate == 0.0) continue;
            double mag = this.grMFD.getX(i);
            double rupArea = applyCyberShakeDDW_Corr ? somerville_magAreaRel.getMedianArea(mag) : hb_MagAreaRel.getMedianArea(mag);
            double rup_width = Math.sqrt(rupArea);
            if (rup_width > surface.getSurfaceWidth()) {
                rup_width = surface.getSurfaceWidth();
            }
            double rupLen = rupArea / rup_width;
            int numRup = -1;
            int firstRupIndex = -1;
            int lastRupIndex = -1;
            int rupIndexOffset = -1;
            double finalRupOffset = 0.0;
            double finalRupWidth = 0.0;
            if (floaterType == 2) {
                int numRupAlongAt1kmOffset = surface.getNumSubsetSurfaces(rupLen, 100.0, 1.0);
                int totNumRupAt1kmOffset = surface.getNumSubsetSurfaces(rupLen, rup_width, 1.0);
                firstRupIndex = totNumRupAt1kmOffset / numRupAlongAt1kmOffset / 2 * numRupAlongAt1kmOffset;
                lastRupIndex = firstRupIndex + numRupAlongAt1kmOffset;
                rupIndexOffset = (int)Math.round(rupOffset);
                numRup = surface.getNumSubsetSurfaces(rupLen, 100.0, rupOffset);
                finalRupOffset = 1.0;
                finalRupWidth = rup_width;
            } else if (floaterType == 1) {
                numRup = surface.getNumSubsetSurfaces(rupLen, rup_width, rupOffset);
                firstRupIndex = 0;
                lastRupIndex = numRup;
                rupIndexOffset = 1;
                finalRupOffset = rupOffset;
                finalRupWidth = rup_width;
            } else if (floaterType == 0) {
                finalRupWidth = 100.0;
                numRup = surface.getNumSubsetSurfaces(rupLen, finalRupWidth, rupOffset);
                firstRupIndex = 0;
                lastRupIndex = numRup;
                rupIndexOffset = 1;
                finalRupOffset = rupOffset;
            }
            rate /= (double)numRup;
            for (int r = firstRupIndex; r < lastRupIndex; r += rupIndexOffset) {
                ProbEqkRupture rup = new ProbEqkRupture();
                rup.setAveRake(rake);
                rup.setMag(mag);
                GriddedSubsetSurface rupSurf = surface.getNthSubsetSurface(rupLen, finalRupWidth, finalRupOffset, r);
                rup.setRuptureSurface(rupSurf);
                double empiricalCorr = 1.0;
                if (this.empiricalModel != null) {
                    empiricalCorr = this.empiricalModel.getCorrection(rupSurf) * this.empirical_weight + (1.0 - this.empirical_weight);
                }
                double rupRate = rate * empiricalCorr;
                totSrcRate += rate;
                totSrcRateEmp += rupRate;
                rup.setProbability(1.0 - Math.exp(-duration * rupRate));
                this.ruptureList.add(rup);
            }
        }
        this.totNumGR_rups = this.ruptureList.size();
        double empiricalCorr = 1.0;
        if (this.empiricalModel != null) {
            empiricalCorr = this.empiricalModel.getCorrection(surface) * this.empirical_weight + (1.0 - this.empirical_weight);
        }
        for (int i = 0; this.charMFD != null && i < this.charMFD.getNum(); ++i) {
            double rate = this.charMFD.getY(i);
            if (rate == 0.0) continue;
            double mag = this.charMFD.getX(i);
            ProbEqkRupture rup = new ProbEqkRupture();
            rup.setAveRake(rake);
            rup.setMag(mag);
            rup.setRuptureSurface(surface);
            double rupRate = rate * empiricalCorr;
            totSrcRate += rate;
            totSrcRateEmp += rupRate;
            rup.setProbability(1.0 - Math.exp(-duration * rupRate));
            this.ruptureList.add(rup);
        }
        this.totNumChar_rups = this.ruptureList.size() - this.totNumGR_rups;
        this.sourceGain = totSrcRateEmp / totSrcRate;
    }

    @Override
    public EvenlyGriddedSurface getSourceSurface() {
        return this.surface;
    }

    @Override
    public int getNumRuptures() {
        return this.ruptureList.size();
    }

    @Override
    public ProbEqkRupture getRupture(int nthRupture) {
        return this.ruptureList.get(nthRupture);
    }

    public double getSourceGain() {
        return this.sourceGain;
    }

    public void setDuration(double yrs) {
        double oldDuration = this.duration;
        for (int r = 0; r < this.ruptureList.size(); ++r) {
            ProbEqkRupture rup = this.ruptureList.get(r);
            double oldRate = rup.getMeanAnnualRate(oldDuration);
            rup.setProbability(1.0 - Math.exp(-yrs * oldRate));
        }
        this.duration = yrs;
    }

    @Override
    public double getMinDistance(Site site) {
        Direction dir = RelativeLocation.getDirection(site.getLocation(), (Location)this.surface.get(0, 0));
        double min = dir.getHorzDistance();
        if (min > (dir = RelativeLocation.getDirection(site.getLocation(), (Location)this.surface.get(0, this.surface.getNumCols() - 1))).getHorzDistance()) {
            min = dir.getHorzDistance();
        }
        if (min > (dir = RelativeLocation.getDirection(site.getLocation(), (Location)this.surface.get(0, this.surface.getNumCols() / 2))).getHorzDistance()) {
            min = dir.getHorzDistance();
        }
        return min;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static void main(String[] args) {
        FaultTrace fltTr = new FaultTrace("name");
        fltTr.addLocation(new Location(33.0, -122.0, 0.0));
        fltTr.addLocation(new Location(34.0, -122.0, 0.0));
        FrankelGriddedSurface surface = new FrankelGriddedSurface(fltTr, 90.0, 0.0, 10.0, 1.0);
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(6.5, 3, 0.5, 6.5, 7.5, 1.0E14, 1.0);
        System.out.println("cumRate=" + (float)gr.getTotCumRate());
        Frankel02_TypeB_EqkSource src = new Frankel02_TypeB_EqkSource(gr, surface, 10.0, 0.0, 1.0, "name");
        for (int i = 0; i < src.getNumRuptures(); ++i) {
            ProbEqkRupture rup = src.getRupture(i);
            System.out.print("rup #" + i + ":\n\tmag=" + rup.getMag() + "\n\tprob=" + rup.getProbability() + "\n\tRup Ends: " + (float)rup.getRuptureSurface().getLocation(0, 0).getLatitude() + "  " + (float)rup.getRuptureSurface().getLocation(0, rup.getRuptureSurface().getNumCols() - 1).getLatitude() + "\n\n");
        }
    }

    @Override
    public LocationList getAllSourceLocs() {
        LocationList locList = new LocationList();
        ListIterator it = this.surface.getAllByRowsIterator();
        while (it.hasNext()) {
            locList.addLocation((Location)it.next());
        }
        return locList;
    }

    public int getNumGR_rups() {
        return this.totNumGR_rups;
    }
}

