/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.util.FileUtils;

public class B_FaultFixes
implements Serializable {
    private static final String IN_FILE = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/B_FaultFixes.txt";
    private static final String DELIMITER = ",";
    private ArrayList sectionNames;
    private ArrayList rates;
    private ArrayList mags;

    public B_FaultFixes() {
        try {
            this.sectionNames = new ArrayList();
            this.rates = new ArrayList();
            this.mags = new ArrayList();
            ArrayList<String> fileLines = FileUtils.loadFile(IN_FILE);
            for (int i = 0; i < fileLines.size(); ++i) {
                String line = fileLines.get(i);
                if (line.startsWith("#")) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, DELIMITER);
                this.sectionNames.add(tokenizer.nextToken().trim());
                this.mags.add(new Double(tokenizer.nextToken().trim()));
                this.rates.add(new Double(tokenizer.nextToken().trim()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double getMag(String bFaultName) {
        int index = this.sectionNames.indexOf(bFaultName);
        if (index < 0) {
            return Double.NaN;
        }
        return (Double)this.mags.get(index);
    }

    public double getRate(String bFaultName) {
        int index = this.sectionNames.indexOf(bFaultName);
        if (index < 0) {
            return Double.NaN;
        }
        return (Double)this.rates.get(index);
    }

    public boolean isBFaultInList(String bFaultName) {
        int index = this.sectionNames.indexOf(bFaultName);
        return index >= 0;
    }
}

