/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.calc.MomentMagCalc;
import org.opensha.commons.data.Location;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FaultRuptureSource;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_AdjustableEqkRupForecast;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_TypeB_EqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.EmpiricalModel;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonCA_FaultsFetcher
implements Serializable {
    private ArrayList<FaultRuptureSource> charSources = new ArrayList();
    private ArrayList<Frankel02_TypeB_EqkSource> grSources = new ArrayList();
    private ArrayList<FaultRuptureSource> lessThan6_5_Sources = new ArrayList();
    private SummedMagFreqDist summedMFD;

    public ArrayList<ProbEqkSource> getSources(String fileName, double duration, double charMagSigma, double charMagTruncLevel, double rupOffset, EmpiricalModel empiricalModel) {
        GaussianMagFreqDist charMFD = null;
        GutenbergRichterMagFreqDist grMFD = null;
        this.summedMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
        this.charSources = new ArrayList();
        this.grSources = new ArrayList();
        this.lessThan6_5_Sources = new ArrayList();
        try {
            ArrayList<String> fileLines = FileUtils.loadJarFile(fileName);
            int numLines = fileLines.size();
            double mag = 0.0;
            int i = 0;
            while (i < numLines) {
                IncrementalMagFreqDist modMagFreqDist;
                String line = fileLines.get(i++);
                StringTokenizer tokenizer = new StringTokenizer(line);
                int srcTypeId = Integer.parseInt(tokenizer.nextToken().trim());
                int rakeId = Integer.parseInt(tokenizer.nextToken().trim());
                double rake = rakeId == 1 ? 0.0 : (rakeId == 2 ? 90.0 : -90.0);
                int numMags = Integer.parseInt(tokenizer.nextToken().trim());
                if (numMags != 1) {
                    throw new RuntimeException("Only one mag supported");
                }
                tokenizer.nextToken();
                String faultName = "";
                while (tokenizer.hasMoreTokens()) {
                    faultName = faultName + tokenizer.nextToken() + " ";
                }
                line = fileLines.get(i++);
                tokenizer = new StringTokenizer(line);
                if (srcTypeId == 1) {
                    mag = Double.parseDouble(tokenizer.nextToken().trim());
                    double rate = Double.parseDouble(tokenizer.nextToken().trim());
                    double moRate = rate * MomentMagCalc.getMoment(mag);
                    double wt = Double.parseDouble(tokenizer.nextToken().trim());
                    double wt2 = 1.0;
                    if (mag > 6.5) {
                        wt2 = 0.666;
                    }
                    charMFD = new GaussianMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG, mag, charMagSigma, moRate *= wt * wt2, charMagTruncLevel, 2);
                    this.summedMFD.addIncrementalMagFreqDist(charMFD);
                } else if (srcTypeId == 2) {
                    double aVal = Double.parseDouble(tokenizer.nextToken().trim());
                    double bVal = Double.parseDouble(tokenizer.nextToken().trim());
                    double magLower = Double.parseDouble(tokenizer.nextToken().trim());
                    double magUpper = Double.parseDouble(tokenizer.nextToken().trim());
                    double deltaMag = Double.parseDouble(tokenizer.nextToken());
                    if (magUpper != magLower) {
                        magLower += deltaMag / 2.0;
                        magUpper -= deltaMag / 2.0;
                    } else {
                        magUpper = magLower = (double)Math.round((float)((magUpper - 5.05) / deltaMag)) * deltaMag + 5.05;
                    }
                    numMags = Math.round((float)((magUpper - magLower) / deltaMag + 1.0));
                    double moRate = Frankel02_AdjustableEqkRupForecast.getMomentRate(magLower, numMags, deltaMag, aVal, bVal);
                    double wt = Double.parseDouble(tokenizer.nextToken().trim());
                    double wt2 = 0.334;
                    grMFD = new GutenbergRichterMagFreqDist(magLower, numMags, deltaMag, moRate *= wt * wt2, bVal);
                    this.summedMFD.addResampledMagFreqDist(grMFD, true);
                } else {
                    throw new RuntimeException("Src type not supported");
                }
                line = fileLines.get(i++);
                tokenizer = new StringTokenizer(line);
                double dip = Double.parseDouble(tokenizer.nextToken().trim());
                double downDipWidth = Double.parseDouble(tokenizer.nextToken().trim());
                double upperSeisDepth = Double.parseDouble(tokenizer.nextToken().trim());
                double lowerSeisDepth = upperSeisDepth + downDipWidth * Math.sin(Math.toRadians(Math.abs(dip)));
                line = fileLines.get(i++);
                int numLocations = Integer.parseInt(line.trim());
                FaultTrace faultTrace = new FaultTrace(faultName);
                for (int locIndex = 0; locIndex < numLocations; ++locIndex) {
                    line = fileLines.get(i++);
                    tokenizer = new StringTokenizer(line);
                    double latitude = Double.parseDouble(tokenizer.nextToken());
                    double longitude = Double.parseDouble(tokenizer.nextToken());
                    faultTrace.addLocation(new Location(latitude, longitude));
                }
                StirlingGriddedSurface surface = new StirlingGriddedSurface(faultTrace, dip, upperSeisDepth, lowerSeisDepth, 1.0);
                double empiricalCorr = 1.0;
                if (empiricalModel != null) {
                    empiricalCorr = empiricalModel.getCorrection(surface);
                }
                if (srcTypeId == 1) {
                    modMagFreqDist = charMFD.deepClone();
                    for (int magIndex = 0; magIndex < modMagFreqDist.getNum() && empiricalModel != null; ++magIndex) {
                        modMagFreqDist.set(magIndex, empiricalCorr * modMagFreqDist.getY(magIndex));
                    }
                    FaultRuptureSource frs = new FaultRuptureSource(modMagFreqDist, (EvenlyGriddedSurface)surface, rake, duration);
                    frs.setName(faultName + " Char");
                    if (mag > 6.5) {
                        this.charSources.add(frs);
                        continue;
                    }
                    this.lessThan6_5_Sources.add(frs);
                    continue;
                }
                modMagFreqDist = grMFD.deepClone();
                for (int magIndex = 0; magIndex < modMagFreqDist.getNum() && empiricalModel != null; ++magIndex) {
                    modMagFreqDist.set(magIndex, empiricalCorr * modMagFreqDist.getY(magIndex));
                }
                Frankel02_TypeB_EqkSource fgrs = new Frankel02_TypeB_EqkSource(modMagFreqDist, surface, rupOffset, rake, duration, faultName + " GR");
                this.grSources.add(fgrs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<ProbEqkSource> allSources = new ArrayList<ProbEqkSource>();
        allSources.addAll(this.charSources);
        allSources.addAll(this.lessThan6_5_Sources);
        allSources.addAll(this.grSources);
        return allSources;
    }

    public SummedMagFreqDist getSummedMFD() {
        return this.summedMFD;
    }

    public static void main(String[] args) {
        NonCA_FaultsFetcher nonCA_FaultsFetcher = new NonCA_FaultsFetcher();
        String fileName = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/NearCA_NSHMP/NonCA_Faults.txt";
        nonCA_FaultsFetcher.getSources(fileName, 1.0, 0.12, 2.0, 1.0, null);
    }
}

