/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data;

import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegRateConstraint
implements Serializable {
    private String faultName;
    private int segIndex;
    private double meanSegRate;
    private double stdDevToMean;
    private double lower95Conf;
    private double upper95Conf;

    public SegRateConstraint(String faultName) {
        this.faultName = faultName;
    }

    public String getFaultName() {
        return this.faultName;
    }

    public void setSegRate(int segIndex, double meanRate, double stdDevtoMean, double lower95Conf, double upper95Conf) {
        this.segIndex = segIndex;
        this.meanSegRate = meanRate;
        this.stdDevToMean = stdDevtoMean;
        this.lower95Conf = lower95Conf;
        this.upper95Conf = upper95Conf;
    }

    public int getSegIndex() {
        return this.segIndex;
    }

    public double getMean() {
        return this.meanSegRate;
    }

    public double getStdDevOfMean() {
        return this.stdDevToMean;
    }

    public static SegRateConstraint getWeightMean(ArrayList<SegRateConstraint> segRateConstraintList) {
        double total = 0.0;
        double sigmaTotal = 0.0;
        String faultName = null;
        int segIndex = -1;
        for (int i = 0; i < segRateConstraintList.size(); ++i) {
            SegRateConstraint segRateConstraint = segRateConstraintList.get(i);
            faultName = segRateConstraint.getFaultName();
            segIndex = segRateConstraint.getSegIndex();
            double sigmaSq = 1.0 / (segRateConstraint.getStdDevOfMean() * segRateConstraint.getStdDevOfMean());
            sigmaTotal += sigmaSq;
            total += sigmaSq * segRateConstraint.getMean();
        }
        SegRateConstraint finalSegRateConstraint = new SegRateConstraint(faultName);
        finalSegRateConstraint.setSegRate(segIndex, total / sigmaTotal, Math.sqrt(1.0 / sigmaTotal), Double.NaN, Double.NaN);
        return finalSegRateConstraint;
    }

    public double getLower95Conf() {
        return this.lower95Conf;
    }

    public void setLower95Conf(double lower95Conf) {
        this.lower95Conf = lower95Conf;
    }

    public double getUpper95Conf() {
        return this.upper95Conf;
    }

    public void setUpper95Conf(double upper95Conf) {
        this.upper95Conf = upper95Conf;
    }
}

