/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DeformationModelSummaryDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.vo.DeformationModelSummary;

public class DeformationModelSummaryFinal
implements Serializable {
    private static ArrayList<DeformationModelSummary> deformationModelSummariesList;
    private static final String XML_DATA_FILENAME = "DeformationModelSummaries.xml";

    public DeformationModelSummaryFinal() {
        this.readDeformationModelSummariesXML_File();
    }

    public DeformationModelSummary getDeformationModel(int deformationModelId) throws QueryException {
        for (DeformationModelSummary def : deformationModelSummariesList) {
            if (def.getDeformationModelId() != deformationModelId) continue;
            return def;
        }
        return null;
    }

    public ArrayList getAllDeformationModels() throws QueryException {
        return deformationModelSummariesList;
    }

    public DeformationModelSummary getDeformationModel(String deformationModelName) throws QueryException {
        for (DeformationModelSummary def : deformationModelSummariesList) {
            if (!def.getDeformationModelName().equals(deformationModelName)) continue;
            return def;
        }
        return null;
    }

    private void writeDeformationModelSummariesXML_File() {
        DeformationModelSummaryDB_DAO deformationModelSummaryDB_DAO = new DeformationModelSummaryDB_DAO(DB_AccessAPI.dbConnection);
        ArrayList deformationModelSummariesFromDatabaseList = deformationModelSummaryDB_DAO.getAllDeformationModels();
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("DeformationModelSummaries");
        for (int i = 0; i < deformationModelSummariesFromDatabaseList.size(); ++i) {
            DeformationModelSummary deformationModelSummary = (DeformationModelSummary)deformationModelSummariesFromDatabaseList.get(i);
            root = deformationModelSummary.toXMLMetadata(root);
        }
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            System.out.println("Writing Deformation Model Summary to DeformationModelSummaries.xml");
            XMLWriter writer = new XMLWriter(new FileWriter(XML_DATA_FILENAME), format);
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        deformationModelSummariesList = deformationModelSummariesFromDatabaseList;
    }

    private void readDeformationModelSummariesXML_File() {
        SAXReader reader = new SAXReader();
        deformationModelSummariesList = new ArrayList();
        try {
            URL xmlURL = DeformationModelSummaryFinal.class.getResource(XML_DATA_FILENAME);
            Document document = reader.read(xmlURL);
            Element root = document.getRootElement();
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                DeformationModelSummary def = DeformationModelSummary.fromXMLMetadata(el);
                deformationModelSummariesList.add(def);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        DeformationModelSummaryFinal test = new DeformationModelSummaryFinal();
    }
}

