/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.data.Container2D;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.exceptions.LocationException;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfaceAPI;
import org.opensha.sha.faultSurface.GriddedSubsetSurface;

public abstract class EvenlyGriddedSurface
extends Container2D
implements EvenlyGriddedSurfaceAPI {
    protected static final String C = "EvenlyGriddedSurface";
    protected static final boolean D = false;
    protected double aveStrike = Double.NaN;
    protected double aveDip = Double.NaN;
    protected double gridSpacing;
    static final char TAB = '\t';

    protected EvenlyGriddedSurface() {
    }

    public EvenlyGriddedSurface(int numRows, int numCols, double gridSpacing) {
        super(numRows, numCols);
        this.gridSpacing = gridSpacing;
    }

    public void set(int row, int column, Object obj) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("EvenlyGriddedSurface does not allow the user to set locations.");
    }

    protected void setLocation(int row, int column, Location location) {
        super.set(row, column, location);
    }

    public Location getLocation(int row, int col) throws LocationException {
        String S = "EvenlyGriddedSurface: getLocation():";
        if (this.exist(row, col)) {
            return (Location)this.get(row, col);
        }
        throw new LocationException(S + "Requested object doesn't exist in " + row + ", " + col);
    }

    public double getAveStrike() {
        return this.aveStrike;
    }

    public double getAveDip() {
        return this.aveDip;
    }

    public ListIterator getLocationsIterator() {
        return super.listIterator();
    }

    public LocationList getLocationList() {
        LocationList locList = new LocationList();
        ListIterator it = this.getLocationsIterator();
        while (it.hasNext()) {
            locList.addLocation((Location)it.next());
        }
        return locList;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("EvenlyGriddedSurface\n");
        if (this.aveStrike != Double.NaN) {
            b.append("Ave. Strike = " + this.aveStrike + '\n');
        }
        if (this.aveDip != Double.NaN) {
            b.append("Ave. Dip = " + this.aveDip + '\n');
        }
        b.append("Row\tCol\tLatitude\tLongitude\tDepth");
        String superStr = super.toString();
        b.append('\n' + superStr);
        return b.toString();
    }

    public double getGridSpacing() {
        return this.gridSpacing;
    }

    public GriddedSubsetSurface getNthSubsetSurface(int numSubSurfaceCols, int numSubSurfaceRows, int numSubSurfaceOffset, int n) {
        int nSubSurfaceDown;
        int nSubSurfaceAlong = (int)Math.floor((this.numCols - numSubSurfaceCols) / numSubSurfaceOffset + 1);
        if (nSubSurfaceAlong <= 1) {
            nSubSurfaceAlong = 1;
        }
        if (numSubSurfaceCols > this.numCols) {
            numSubSurfaceCols = this.numCols;
        }
        if ((nSubSurfaceDown = (int)Math.floor((this.numRows - numSubSurfaceRows) / numSubSurfaceOffset + 1)) <= 1) {
            nSubSurfaceDown = 1;
        }
        if (numSubSurfaceRows > this.numRows) {
            numSubSurfaceRows = this.numRows;
        }
        return this.getNthSubsetSurface(numSubSurfaceCols, numSubSurfaceRows, numSubSurfaceOffset, nSubSurfaceAlong, n);
    }

    private GriddedSubsetSurface getNthSubsetSurface(int numSubSurfaceCols, int numSubSurfaceRows, int numSubSurfaceOffset, int nSubSurfaceAlong, int n) {
        int row = n / nSubSurfaceAlong * numSubSurfaceOffset;
        int col = n % nSubSurfaceAlong * numSubSurfaceOffset;
        return new GriddedSubsetSurface(numSubSurfaceRows, numSubSurfaceCols, row, col, this);
    }

    public GriddedSubsetSurface getNthSubsetSurface(double subSurfaceLength, double subSurfaceWidth, double subSurfaceOffset, int n) {
        return this.getNthSubsetSurface((int)Math.rint(subSurfaceLength / this.gridSpacing + 1.0), (int)Math.rint(subSurfaceWidth / this.gridSpacing + 1.0), (int)Math.rint(subSurfaceOffset / this.gridSpacing), n);
    }

    public GriddedSubsetSurface getNthSubsetSurfaceCenteredDownDip(double subSurfaceLength, double subSurfaceWidth, double subSurfaceOffset, int n) {
        int numSubSurfaceCols = (int)Math.rint(subSurfaceLength / this.gridSpacing + 1.0);
        int startCol = -1;
        if (numSubSurfaceCols > this.numCols) {
            numSubSurfaceCols = this.numCols;
            startCol = 0;
        } else {
            startCol = n * (int)Math.rint(subSurfaceOffset / this.gridSpacing);
        }
        int numSubSurfaceRows = (int)Math.rint(subSurfaceWidth / this.gridSpacing + 1.0);
        int startRow = -1;
        if (numSubSurfaceRows >= this.numRows) {
            numSubSurfaceRows = this.numRows;
            startRow = 0;
        } else {
            startRow = (int)Math.floor((this.numRows - numSubSurfaceRows) / 2);
        }
        System.out.println("subSurfaceLength=" + subSurfaceLength + ", subSurfaceWidth=" + subSurfaceWidth + ", subSurfaceOffset=" + subSurfaceOffset + ", numRows=" + this.numRows + ", numCols=" + this.numCols + ", numSubSurfaceRows=" + numSubSurfaceRows + ", numSubSurfaceCols=" + numSubSurfaceCols + ", startRow=" + startRow + ", startCol=" + startCol);
        return new GriddedSubsetSurface(numSubSurfaceRows, numSubSurfaceCols, startRow, startCol, this);
    }

    public Iterator getSubsetSurfacesIterator(int numSubSurfaceCols, int numSubSurfaceRows, int numSubSurfaceOffset) {
        int nSubSurfaceDown;
        ArrayList<GriddedSubsetSurface> v = new ArrayList<GriddedSubsetSurface>();
        int nSubSurfaceAlong = (int)Math.floor((this.numCols - numSubSurfaceCols) / numSubSurfaceOffset + 1);
        if (nSubSurfaceAlong <= 1) {
            nSubSurfaceAlong = 1;
            numSubSurfaceCols = this.numCols;
        }
        if ((nSubSurfaceDown = (int)Math.floor((this.numRows - numSubSurfaceRows) / numSubSurfaceOffset + 1)) <= 1) {
            nSubSurfaceDown = 1;
            numSubSurfaceRows = this.numRows;
        }
        int totalSubSetSurface = nSubSurfaceAlong * nSubSurfaceDown;
        v.clear();
        for (int i = 0; i < totalSubSetSurface; ++i) {
            v.add(this.getNthSubsetSurface(numSubSurfaceCols, numSubSurfaceRows, numSubSurfaceOffset, nSubSurfaceAlong, i));
        }
        return v.iterator();
    }

    public Iterator getSubsetSurfacesIterator(double subSurfaceLength, double subSurfaceWidth, double subSurfaceOffset) {
        return this.getSubsetSurfacesIterator((int)Math.rint(subSurfaceLength / this.gridSpacing + 1.0), (int)Math.rint(subSurfaceWidth / this.gridSpacing + 1.0), (int)Math.rint(subSurfaceOffset / this.gridSpacing));
    }

    public int getNumSubsetSurfaces(double subSurfaceLength, double subSurfaceWidth, double subSurfaceOffset) {
        int nSubSurfaceDown;
        int lengthCols = (int)Math.rint(subSurfaceLength / this.gridSpacing + 1.0);
        int widthCols = (int)Math.rint(subSurfaceWidth / this.gridSpacing + 1.0);
        int offsetCols = (int)Math.rint(subSurfaceOffset / this.gridSpacing);
        int totalSubSurfaces = 1;
        int nSubSurfaceAlong = (int)Math.floor((this.numCols - lengthCols) / offsetCols + 1);
        if (nSubSurfaceAlong <= 1) {
            nSubSurfaceAlong = 1;
        }
        if ((nSubSurfaceDown = (int)Math.floor((this.numRows - widthCols) / offsetCols + 1)) <= 1) {
            nSubSurfaceDown = 1;
        }
        totalSubSurfaces = nSubSurfaceAlong * nSubSurfaceDown;
        return totalSubSurfaces;
    }

    public int getNumSubsetSurfacesAlongLength(double subSurfaceLength, double subSurfaceOffset) {
        int offsetCols;
        int lengthCols = (int)Math.rint(subSurfaceLength / this.gridSpacing + 1.0);
        int nSubSurfaceAlong = (int)Math.floor((this.numCols - lengthCols) / (offsetCols = (int)Math.rint(subSurfaceOffset / this.gridSpacing)) + 1);
        if (nSubSurfaceAlong <= 1) {
            nSubSurfaceAlong = 1;
        }
        return nSubSurfaceAlong;
    }

    public double getSurfaceLength() {
        return this.getGridSpacing() * (double)(this.getNumCols() - 1);
    }

    public double getSurfaceWidth() {
        return this.getGridSpacing() * (double)(this.getNumRows() - 1);
    }

    public double getSurfaceArea() {
        return this.getSurfaceWidth() * this.getSurfaceLength();
    }

    public double getMinDistance(EvenlyGriddedSurfaceAPI surface) {
        ListIterator it = this.getLocationsIterator();
        double min3dDist = Double.POSITIVE_INFINITY;
        while (it.hasNext()) {
            Location loc1 = (Location)it.next();
            ListIterator it2 = surface.getLocationsIterator();
            while (it2.hasNext()) {
                Location loc2 = (Location)it2.next();
                double dist = RelativeLocation.getApproxHorzDistance(loc1, loc2);
                if (!(dist < min3dDist)) continue;
                min3dDist = dist;
            }
        }
        return min3dDist;
    }

    public LocationList getSurfacePerimeterLocsList() {
        int r;
        int c;
        LocationList locList = new LocationList();
        for (c = 0; c < this.getNumCols(); ++c) {
            locList.addLocation(this.getLocation(0, c));
        }
        for (r = 0; r < this.getNumRows(); ++r) {
            locList.addLocation(this.getLocation(r, this.getNumCols() - 1));
        }
        for (c = this.getNumCols() - 1; c >= 0; --c) {
            locList.addLocation(this.getLocation(this.getNumRows() - 1, c));
        }
        for (r = this.getNumRows() - 1; r >= 0; --r) {
            locList.addLocation(this.getLocation(r, 0));
        }
        return locList;
    }

    public String getSurfaceMetadata() {
        String surfaceMetadata = (float)this.aveDip + "\t";
        surfaceMetadata = surfaceMetadata + (float)this.getSurfaceLength() + "\t";
        surfaceMetadata = surfaceMetadata + (float)this.getSurfaceWidth() + "\t";
        surfaceMetadata = surfaceMetadata + "NaN\t";
        int numRows = this.getNumRows();
        int numCols = this.getNumCols();
        surfaceMetadata = surfaceMetadata + numRows + "\t";
        surfaceMetadata = surfaceMetadata + numCols + "\t";
        surfaceMetadata = surfaceMetadata + numRows * numCols + "\n";
        surfaceMetadata = surfaceMetadata + "#Surface locations (Lat Lon Depth) \n";
        ListIterator it = this.getLocationsIterator();
        while (it.hasNext()) {
            Location loc = (Location)it.next();
            surfaceMetadata = surfaceMetadata + (float)loc.getLatitude() + "\t";
            surfaceMetadata = surfaceMetadata + (float)loc.getLongitude() + "\t";
            surfaceMetadata = surfaceMetadata + (float)loc.getDepth() + "\n";
        }
        return surfaceMetadata;
    }
}

