/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import java.io.Serializable;
import java.util.ArrayList;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.data.Location;
import org.opensha.sha.faultSurface.FaultTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFaultData
implements Serializable {
    private double upperSeismogenicDepth;
    private double lowerSeismogenicDepth;
    private double aveDip;
    private FaultTrace faultTrace;
    protected static final String C = "SimpleFaultData";
    private static final String TAB = "  ";

    public SimpleFaultData() {
    }

    public SimpleFaultData(double aveDip, double lowerSeisDepth, double upperSeisDepth, FaultTrace faultTrace) {
        this.aveDip = aveDip;
        this.lowerSeismogenicDepth = lowerSeisDepth;
        this.upperSeismogenicDepth = upperSeisDepth;
        this.faultTrace = faultTrace;
    }

    public void setUpperSeismogenicDepth(double upperSeismogenicDepth) {
        this.upperSeismogenicDepth = upperSeismogenicDepth;
    }

    public double getUpperSeismogenicDepth() {
        return this.upperSeismogenicDepth;
    }

    public void setLowerSeismogenicDepth(double lowerSeismogenicDepth) {
        this.lowerSeismogenicDepth = lowerSeismogenicDepth;
    }

    public double getLowerSeismogenicDepth() {
        return this.lowerSeismogenicDepth;
    }

    public void setAveDip(double aveDip) {
        this.aveDip = aveDip;
    }

    public double getAveDip() {
        return this.aveDip;
    }

    public void setFaultTrace(FaultTrace faultTrace) {
        this.faultTrace = faultTrace;
    }

    public FaultTrace getFaultTrace() {
        return this.faultTrace;
    }

    public static SimpleFaultData getCombinedSimpleFaultData(ArrayList<SimpleFaultData> simpleFaultDataList) {
        int i;
        if (simpleFaultDataList.size() == 1) {
            return simpleFaultDataList.get(0);
        }
        FaultTrace faultTrace1 = simpleFaultDataList.get(0).getFaultTrace();
        FaultTrace faultTrace2 = simpleFaultDataList.get(1).getFaultTrace();
        double minDist = Double.MAX_VALUE;
        boolean reverse = false;
        ArrayList<Integer> reversedIndices = new ArrayList<Integer>();
        double distance = RelativeLocation.getHorzDistance(faultTrace1.getLocationAt(0), faultTrace2.getLocationAt(0));
        if (distance < minDist) {
            minDist = distance;
            reverse = true;
        }
        if ((distance = RelativeLocation.getHorzDistance(faultTrace1.getLocationAt(0), faultTrace2.getLocationAt(faultTrace2.getNumLocations() - 1))) < minDist) {
            minDist = distance;
            reverse = true;
        }
        if ((distance = RelativeLocation.getHorzDistance(faultTrace1.getLocationAt(faultTrace1.getNumLocations() - 1), faultTrace2.getLocationAt(0))) < minDist) {
            minDist = distance;
            reverse = false;
        }
        if ((distance = RelativeLocation.getHorzDistance(faultTrace1.getLocationAt(faultTrace1.getNumLocations() - 1), faultTrace2.getLocationAt(faultTrace2.getNumLocations() - 1))) < minDist) {
            minDist = distance;
            reverse = false;
        }
        if (reverse) {
            reversedIndices.add(0);
            faultTrace1.reverse();
            if (simpleFaultDataList.get(0).getAveDip() != 90.0) {
                simpleFaultDataList.get(0).setAveDip(-simpleFaultDataList.get(0).getAveDip());
            }
        }
        double combinedDip = 0.0;
        double combinedUpperSeisDepth = 0.0;
        double totArea = 0.0;
        double totLength = 0.0;
        FaultTrace combinedFaultTrace = new FaultTrace("Combined Fault Sections");
        int num = simpleFaultDataList.size();
        for (i = 0; i < num; ++i) {
            FaultTrace faultTrace = simpleFaultDataList.get(i).getFaultTrace();
            int numLocations = faultTrace.getNumLocations();
            if (i > 0) {
                FaultTrace prevFaultTrace = simpleFaultDataList.get(i - 1).getFaultTrace();
                Location lastLoc = prevFaultTrace.getLocationAt(prevFaultTrace.getNumLocations() - 1);
                double distance1 = RelativeLocation.getHorzDistance(lastLoc, faultTrace.getLocationAt(0));
                double distance2 = RelativeLocation.getHorzDistance(lastLoc, faultTrace.getLocationAt(faultTrace.getNumLocations() - 1));
                if (distance2 < distance1) {
                    faultTrace.reverse();
                    reversedIndices.add(i);
                    if (simpleFaultDataList.get(i).getAveDip() != 90.0) {
                        simpleFaultDataList.get(i).setAveDip(-simpleFaultDataList.get(i).getAveDip());
                    }
                }
                if (distance2 > 1.0 && distance1 > 1.0) {
                    combinedFaultTrace.addLocation(faultTrace.getLocationAt(0).copy());
                }
                for (int locIndex = 1; locIndex < numLocations; ++locIndex) {
                    combinedFaultTrace.addLocation(faultTrace.getLocationAt(locIndex).copy());
                }
            } else {
                for (int locIndex = 0; locIndex < numLocations; ++locIndex) {
                    combinedFaultTrace.addLocation(faultTrace.getLocationAt(locIndex).copy());
                }
            }
            double length = faultTrace.getTraceLength();
            double dip = simpleFaultDataList.get(i).getAveDip();
            double area = Math.abs(length * (simpleFaultDataList.get(i).getLowerSeismogenicDepth() - simpleFaultDataList.get(i).getUpperSeismogenicDepth()) / Math.sin(dip * Math.PI / 180.0));
            totLength += length;
            totArea += area;
            combinedUpperSeisDepth += area * simpleFaultDataList.get(i).getUpperSeismogenicDepth();
            if (dip > 0.0) {
                combinedDip += area * dip;
                continue;
            }
            combinedDip += area * (dip + 180.0);
        }
        for (i = 0; i < reversedIndices.size(); ++i) {
            int index = (Integer)reversedIndices.get(i);
            simpleFaultDataList.get(index).getFaultTrace().reverse();
            if (simpleFaultDataList.get(index).getAveDip() == 90.0) continue;
            simpleFaultDataList.get(index).setAveDip(-simpleFaultDataList.get(index).getAveDip());
        }
        double dip = combinedDip / totArea;
        if (dip > 90.0) {
            dip = 180.0 - dip;
            combinedFaultTrace.reverse();
        }
        SimpleFaultData simpleFaultData = new SimpleFaultData();
        simpleFaultData.setAveDip(dip);
        double upperSeismogenicDepth = combinedUpperSeisDepth / totArea;
        simpleFaultData.setUpperSeismogenicDepth(upperSeismogenicDepth);
        for (int locIndex = 0; locIndex < combinedFaultTrace.getNumLocations(); ++locIndex) {
            combinedFaultTrace.getLocationAt(locIndex).setDepth(simpleFaultData.getUpperSeismogenicDepth());
        }
        simpleFaultData.setLowerSeismogenicDepth(totArea / totLength * Math.sin(dip * Math.PI / 180.0) + upperSeismogenicDepth);
        simpleFaultData.setFaultTrace(combinedFaultTrace);
        return simpleFaultData;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(C);
        b.append('\n');
        b.append("  Ave. Dip = " + this.aveDip);
        b.append("  Upper Seismogenic Depth = " + this.upperSeismogenicDepth);
        b.append("  Lower Seismogenic Depth = " + this.lowerSeismogenicDepth);
        b.append("  Fault Trace = " + this.faultTrace.toString());
        return b.toString();
    }

    public SimpleFaultData clone() {
        SimpleFaultData simpleFaultData = new SimpleFaultData();
        simpleFaultData.setUpperSeismogenicDepth(this.upperSeismogenicDepth);
        simpleFaultData.setLowerSeismogenicDepth(this.lowerSeismogenicDepth);
        simpleFaultData.setAveDip(this.aveDip);
        simpleFaultData.setFaultTrace(this.faultTrace);
        return simpleFaultData;
    }
}

