/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.opensha.sha.gui.controls.AxisLimitsControlPanelAPI;

public class AxisLimitsControlPanel
extends JDialog {
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private JPanel panel1 = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private JTextField jTextMinX = new JTextField();
    private JLabel jLabel2 = new JLabel();
    private JTextField jTextMaxX = new JTextField();
    private JLabel jLabel3 = new JLabel();
    private JTextField jTextMinY = new JTextField();
    private JLabel jLabel4 = new JLabel();
    private JTextField jTextMaxY = new JTextField();
    private JButton ok = new JButton();
    private JButton cancel = new JButton();
    private AxisLimitsControlPanelAPI axisLimitAPI;
    private JComboBox rangeComboBox = new JComboBox();
    private JLabel jLabel5 = new JLabel();
    public static final String AUTO_SCALE = "Auto Scale";
    public static final String CUSTOM_SCALE = "Custom Scale";
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();

    public AxisLimitsControlPanel(AxisLimitsControlPanelAPI axisLimitAPI, Component parent, String scale, double minX, double maxX, double minY, double maxY) {
        this.axisLimitAPI = axisLimitAPI;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.setModal(true);
        this.setLocation(parent.getX() + parent.getWidth() / 2, parent.getY() + parent.getHeight() / 2);
        this.rangeComboBox.addItem(AUTO_SCALE);
        this.rangeComboBox.addItem(CUSTOM_SCALE);
        try {
            this.jbInit();
            this.rangeComboBox.setSelectedItem(scale);
        }
        catch (Exception e) {
            System.out.println("Error Occured while running range combo box: " + e);
        }
    }

    public void setParams(String scale, double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.jTextMinX.setText("" + this.minX);
        this.jTextMaxX.setText("" + this.maxX);
        this.jTextMinY.setText("" + this.minY);
        this.jTextMaxY.setText("" + this.maxY);
        this.rangeComboBox.setSelectedItem(scale);
    }

    void jbInit() throws Exception {
        this.rangeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisLimitsControlPanel.this.rangeComboBox_actionPerformed(e);
            }
        });
        this.panel1.setLayout(this.gridBagLayout1);
        this.setTitle("Axis Control Panel");
        this.panel1.add((Component)this.jLabel5, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(14, 0, 0, 0), 17, 11));
        this.panel1.add((Component)this.rangeComboBox, new GridBagConstraints(3, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(14, 0, 0, 67), -30, 0));
        this.panel1.add((Component)this.jTextMinY, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(8, 0, 0, 0), 82, 3));
        this.panel1.add((Component)this.jTextMinX, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 84, 3));
        this.panel1.add((Component)this.ok, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 19, 5, 11), 0, 3));
        this.panel1.add((Component)this.cancel, new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 9), 10, 3));
        this.panel1.add((Component)this.jLabel2, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 36, 0, 0), 17, 3));
        this.panel1.add((Component)this.jLabel4, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 37, 6, 0), 15, -2));
        this.panel1.add((Component)this.jTextMaxX, new GridBagConstraints(5, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 9), 72, 3));
        this.panel1.add((Component)this.jTextMaxY, new GridBagConstraints(5, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 9), 72, 3));
        this.panel1.add((Component)this.jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 11, 0, 0), 14, 0));
        this.panel1.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(11, 11, 0, 0), 26, 3));
        this.jLabel1.setForeground(Color.black);
        this.jLabel1.setText("Min X:");
        this.jLabel2.setForeground(Color.black);
        this.jLabel2.setText("Max X:");
        this.jLabel3.setForeground(Color.black);
        this.jLabel3.setText("Min Y:");
        this.jLabel4.setForeground(Color.black);
        this.jLabel4.setText("Max Y:");
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisLimitsControlPanel.this.ok_actionPerformed(e);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisLimitsControlPanel.this.cancel_actionPerformed(e);
            }
        });
        this.getContentPane().setLayout(this.gridBagLayout2);
        this.panel1.setMaximumSize(new Dimension(348, 143));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jTextMinX.setText("" + this.minX);
        this.jTextMaxX.setText("" + this.maxX);
        this.jTextMinY.setText("" + this.minY);
        this.jTextMaxY.setText("" + this.maxY);
        this.rangeComboBox.setFont(new Font("Dialog", 1, 12));
        this.jLabel5.setForeground(Color.black);
        this.jLabel5.setText("Axis Scale:");
        this.getContentPane().add((Component)this.panel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 6, 6), -49, 5));
    }

    void ok_actionPerformed(ActionEvent e) {
        String selectedRange = this.rangeComboBox.getSelectedItem().toString();
        if (selectedRange.equalsIgnoreCase(AUTO_SCALE)) {
            this.axisLimitAPI.setAutoRange();
            this.dispose();
        } else {
            try {
                double xMin = Double.parseDouble(this.jTextMinX.getText());
                double xMax = Double.parseDouble(this.jTextMaxX.getText());
                double yMin = Double.parseDouble(this.jTextMinY.getText());
                double yMax = Double.parseDouble(this.jTextMaxY.getText());
                if (xMin >= xMax) {
                    JOptionPane.showMessageDialog(this, new String("Max X must be greater than Min X"), new String("Check Axis Range"), 0);
                    return;
                }
                if (yMin >= yMax) {
                    JOptionPane.showMessageDialog(this, new String("Max Y must be greater than Min Y"), new String("Check Axis Range"), 0);
                    return;
                }
                this.axisLimitAPI.setAxisRange(xMin, xMax, yMin, yMax);
                this.dispose();
            }
            catch (Exception ex) {
                System.out.println("Exception:" + ex);
                JOptionPane.showMessageDialog(this, new String("Text Entered must be a valid numerical value"), new String("Check Axis Range"), 0);
            }
        }
    }

    void cancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void rangeComboBox_actionPerformed(ActionEvent e) {
        String selectedRange = this.rangeComboBox.getSelectedItem().toString();
        if (selectedRange.equalsIgnoreCase(AUTO_SCALE)) {
            this.jTextMinX.setEnabled(false);
            this.jTextMaxX.setEnabled(false);
            this.jTextMinY.setEnabled(false);
            this.jTextMaxY.setEnabled(false);
        } else {
            this.jTextMinX.setEnabled(true);
            this.jTextMaxX.setEnabled(true);
            this.jTextMinY.setEnabled(true);
            this.jTextMaxY.setEnabled(true);
        }
    }
}

