/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.dom4j.Element;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.metadata.MetadataLoader;
import org.opensha.commons.param.DependentParameterAPI;
import org.opensha.commons.param.DoubleParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.IntensityMeasureRelationshipAPI;
import org.opensha.sha.imr.PropagationEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntensityMeasureRelationship
implements IntensityMeasureRelationshipAPI {
    private static final String NAME = "Intensity Measure Relationship";
    protected String url_info_string;
    public static final String XML_METADATA_NAME = "IMR";
    public static final String XML_METADATA_IMT_NAME = "IntensityMeasure";
    public static final String XML_METADATA_SITE_PARAMETERS_NAME = "SiteParameters";
    protected static final String C = "IntensityMeasureRelationship";
    protected static final boolean D = false;
    protected DoubleParameter exceedProbParam = null;
    public static final String EXCEED_PROB_NAME = "Exceed. Prob.";
    protected static final Double EXCEED_PROB_DEFAULT = new Double(0.5);
    public static final String EXCEED_PROB_INFO = "Exceedance Probability";
    public static final Double EXCEED_PROB_MIN = new Double(1.0E-6);
    public static final Double EXCEED_PROB_MAX = new Double(0.999999);
    protected ParameterList siteParams = new ParameterList();
    protected ParameterList eqkRuptureParams = new ParameterList();
    protected ParameterList propagationEffectParams = new ParameterList();
    protected ParameterList supportedIMParams = new ParameterList();
    protected ParameterList otherParams = new ParameterList();
    protected Site site;
    protected EqkRupture eqkRupture;
    protected PropagationEffect propEffect;
    protected ParameterAPI im;
    protected boolean intensityMeasureChanged;

    public IntensityMeasureRelationship() {
        this.exceedProbParam = new DoubleParameter(EXCEED_PROB_NAME, EXCEED_PROB_MIN, EXCEED_PROB_MAX, EXCEED_PROB_DEFAULT);
        this.exceedProbParam.setInfo(EXCEED_PROB_INFO);
        this.exceedProbParam.setNonEditable();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setSite(Site site) {
        this.site = site;
    }

    @Override
    public void setPropagationEffect(PropagationEffect propEffect) {
        this.setSite(propEffect.getSite());
        this.setEqkRupture(propEffect.getEqkRupture());
    }

    @Override
    public Site getSite() {
        return this.site;
    }

    @Override
    public EqkRupture getEqkRupture() {
        return this.eqkRupture;
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) {
        this.eqkRupture = eqkRupture;
    }

    @Override
    public Object getIntensityMeasureLevel() {
        return this.im.getValue();
    }

    @Override
    public void setIntensityMeasureLevel(Object iml) throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("IntensityMeasureRelationship: setIntensityMeasureLevel(): The Intensity Measure has not been set yet, unable to set the level.");
        }
        this.im.setValue(iml);
    }

    @Override
    public ParameterAPI getIntensityMeasure() {
        return this.im;
    }

    @Override
    public void setIntensityMeasure(ParameterAPI intensityMeasure) throws ParameterException, ConstraintException {
        if (this.isIntensityMeasureSupported(intensityMeasure)) {
            this.setIntensityMeasure(intensityMeasure.getName());
            ListIterator it = ((DependentParameterAPI)intensityMeasure).getIndependentParametersIterator();
            while (it.hasNext()) {
                ParameterAPI param = (ParameterAPI)it.next();
                this.getParameter(param.getName()).setValue(param.getValue());
            }
        } else {
            throw new ParameterException("This im is not supported, name = " + intensityMeasure.getName());
        }
    }

    @Override
    public void setIntensityMeasure(String intensityMeasureName) throws ParameterException {
        this.im = this.supportedIMParams.getParameter(intensityMeasureName);
        this.intensityMeasureChanged = true;
    }

    @Override
    public void setExceedProb(double prob) throws ParameterException {
        this.exceedProbParam.setValue(prob);
    }

    @Override
    public boolean isIntensityMeasureSupported(ParameterAPI intensityMeasure) {
        if (this.supportedIMParams.containsParameter(intensityMeasure)) {
            int numIndParams = ((DependentParameterAPI)this.supportedIMParams.getParameter(intensityMeasure.getName())).getNumIndependentParameters();
            ListIterator it = ((DependentParameterAPI)intensityMeasure).getIndependentParametersIterator();
            while (it.hasNext()) {
                ParameterAPI param = (ParameterAPI)it.next();
                if (this.getParameter(param.getName()).isAllowed(param.getValue())) continue;
                return false;
            }
            return ((DependentParameterAPI)intensityMeasure).getNumIndependentParameters() == numIndParams;
        }
        return false;
    }

    @Override
    public boolean isIntensityMeasureSupported(String intensityMeasure) {
        return this.supportedIMParams.containsParameter(intensityMeasure);
    }

    @Override
    public void setAll(EqkRupture eqkRupture, Site site, ParameterAPI intensityMeasure) throws ParameterException, IMRException, ConstraintException {
        this.setSite(site);
        this.setEqkRupture(eqkRupture);
        this.setIntensityMeasure(intensityMeasure);
    }

    @Override
    public ParameterAPI getParameter(String name) throws ParameterException {
        if (name.equals(EXCEED_PROB_NAME)) {
            return this.exceedProbParam;
        }
        try {
            return this.siteParams.getParameter(name);
        }
        catch (ParameterException e) {
            try {
                return this.eqkRuptureParams.getParameter(name);
            }
            catch (ParameterException e2) {
                try {
                    return this.propagationEffectParams.getParameter(name);
                }
                catch (ParameterException e3) {
                    try {
                        return this.supportedIMParams.getParameter(name);
                    }
                    catch (ParameterException e4) {
                        ListIterator<ParameterAPI> it = this.supportedIMParams.getParametersIterator();
                        while (it.hasNext()) {
                            DependentParameterAPI param = (DependentParameterAPI)it.next();
                            if (!param.containsIndependentParameter(name)) continue;
                            return param.getIndependentParameter(name);
                        }
                        try {
                            return this.otherParams.getParameter(name);
                        }
                        catch (ParameterException parameterException) {
                            throw new ParameterException("IntensityMeasureRelationship: getParameter(): Parameter doesn't exist named " + name);
                        }
                    }
                }
            }
        }
    }

    @Override
    public ListIterator<ParameterAPI> getSiteParamsIterator() {
        return this.siteParams.getParametersIterator();
    }

    @Override
    public ListIterator<ParameterAPI> getOtherParamsIterator() {
        return this.otherParams.getParametersIterator();
    }

    @Override
    public ListIterator<ParameterAPI> getEqkRuptureParamsIterator() {
        return this.eqkRuptureParams.getParametersIterator();
    }

    @Override
    public ListIterator<ParameterAPI> getPropagationEffectParamsIterator() {
        return this.propagationEffectParams.getParametersIterator();
    }

    @Override
    public ListIterator<ParameterAPI> getSupportedIntensityMeasuresIterator() {
        return this.supportedIMParams.getParametersIterator();
    }

    @Override
    public ParameterList getSupportedIntensityMeasuresList() {
        return this.supportedIMParams;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement(XML_METADATA_NAME);
        xml.addAttribute("className", this.getClass().getName());
        ListIterator<ParameterAPI> paramIt = this.getOtherParamsIterator();
        Element paramsElement = xml.addElement("Parameters");
        while (paramIt.hasNext()) {
            Parameter param = (Parameter)paramIt.next();
            paramsElement = param.toXMLMetadata(paramsElement);
        }
        paramIt = this.getSiteParamsIterator();
        Element siteParamsElement = xml.addElement(XML_METADATA_SITE_PARAMETERS_NAME);
        while (paramIt.hasNext()) {
            Parameter param = (Parameter)paramIt.next();
            siteParamsElement = param.toXMLMetadata(siteParamsElement);
        }
        ParameterAPI imt = this.getIntensityMeasure();
        if (imt != null) {
            imt.toXMLMetadata(xml, XML_METADATA_IMT_NAME);
        }
        return root;
    }

    public static IntensityMeasureRelationship fromXMLMetadata(Element root, ParameterChangeWarningListener listener) throws InvocationTargetException {
        Element imtElem;
        String className = root.attribute("className").getValue();
        System.out.println("Loading IMR: " + className);
        ArrayList<Object> args = new ArrayList<Object>();
        ArrayList<String> argNames = new ArrayList<String>();
        args.add(listener);
        argNames.add(ParameterChangeWarningListener.class.getName());
        IntensityMeasureRelationship imr = (IntensityMeasureRelationship)MetadataLoader.createClassInstance(className, args, argNames);
        imr.setParamDefaults();
        System.out.println("Setting params...");
        Element paramsElement = root.element("Parameters");
        ListIterator<ParameterAPI> paramIt = imr.getOtherParamsIterator();
        while (paramIt.hasNext()) {
            Parameter param = (Parameter)paramIt.next();
            if (param.getName().equals("Tectonic Region")) continue;
            System.out.println("Setting param " + param.getName());
            Iterator it = paramsElement.elementIterator();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                if (!param.getName().equals(el.attribute("name").getValue())) continue;
                System.out.println("Found a match!");
                if (param.setValueFromXMLMetadata(el)) {
                    System.out.println("Parameter set successfully!");
                    continue;
                }
                System.out.println("Parameter could not be set from XML!");
                System.out.println("It is possible that the parameter type doesn't yet support loading from XML");
            }
        }
        System.out.println("Setting site params...");
        Element siteParamsElement = root.element(XML_METADATA_SITE_PARAMETERS_NAME);
        if (siteParamsElement != null) {
            paramIt = imr.getSiteParamsIterator();
            while (paramIt.hasNext()) {
                Parameter param = (Parameter)paramIt.next();
                System.out.println("Setting param " + param.getName());
                Iterator it = siteParamsElement.elementIterator();
                while (it.hasNext()) {
                    Element el = (Element)it.next();
                    if (!param.getName().equals(el.attribute("name").getValue())) continue;
                    System.out.println("Found a match!");
                    if (param.setValueFromXMLMetadata(el)) {
                        System.out.println("Parameter set successfully!");
                        continue;
                    }
                    System.out.println("Parameter could not be set from XML!");
                    System.out.println("It is possible that the parameter type doesn't yet support loading from XML");
                }
            }
        }
        if ((imtElem = root.element(XML_METADATA_IMT_NAME)) != null) {
            String imtName = imtElem.attributeValue("name");
            System.out.println("IMT Name: " + imtName);
            imr.setIntensityMeasure(imtName);
            ParameterAPI imt = imr.getIntensityMeasure();
            imt.setValueFromXMLMetadata(imtElem);
        }
        return imr;
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL(null);
    }
}

