/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.opensha.commons.data.NamedObjectAPI;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.DoubleConstraint;
import org.opensha.commons.param.DoubleDiscreteConstraint;
import org.opensha.commons.param.StringConstraint;
import org.opensha.commons.param.StringParameter;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.PropagationEffect;
import org.opensha.sha.imr.ScalarIntensityMeasureRelationshipAPI;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;

public class SadighEtAl_1997_AttenRel
extends AttenuationRelationship
implements ScalarIntensityMeasureRelationshipAPI,
NamedObjectAPI {
    private static final String C = "SCEMY_1997_AttenRel";
    private static final boolean D = false;
    public static final String NAME = "Sadigh et al (1997)";
    public static final String SHORT_NAME = "SadighEtAl1997";
    private static final long serialVersionUID = 1234567890987654366L;
    public static final String FLT_TYPE_OTHER = "Other";
    public static final String FLT_TYPE_REVERSE = "Reverse";
    private StringParameter siteTypeParam = null;
    public static final String SITE_TYPE_NAME = "Sadigh Site Type";
    public static final String SITE_TYPE_INFO = "Geological conditions as the site";
    public static final String SITE_TYPE_ROCK = "Rock";
    public static final String SITE_TYPE_SOIL = "Deep-Soil";
    public static final String SITE_TYPE_DEFAULT = "Deep-Soil";
    protected static final Double MAG_WARN_MIN = new Double(4.0);
    protected static final Double MAG_WARN_MAX = new Double(8.25);
    protected static final Double DISTANCE_RUP_WARN_MIN = new Double(0.0);
    protected static final Double DISTANCE_RUP_WARN_MAX = new Double(100.0);
    private SCEMY_1997_AttenRelCoefficients coeff = null;
    protected Hashtable coefficients = new Hashtable();
    private transient ParameterChangeWarningListener warningListener = null;

    protected void setFaultTypeFromRake(double rake) throws InvalidRangeException {
        FaultUtils.assertValidRake(rake);
        if (rake > 45.0 && rake < 135.0) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE);
        } else {
            this.fltTypeParam.setValue(FLT_TYPE_OTHER);
        }
    }

    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(new Double(eqkRupture.getMag()));
        this.setFaultTypeFromRake(eqkRupture.getAveRake());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    public void setSite(Site site) throws ParameterException {
        this.siteTypeParam.setValue((String)site.getParameter(SITE_TYPE_NAME).getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    public void setPropagationEffect(PropagationEffect propEffect) throws ParameterException, InvalidRangeException {
        this.site = propEffect.getSite();
        this.eqkRupture = propEffect.getEqkRupture();
        this.siteTypeParam.setValue((String)this.site.getParameter(SITE_TYPE_NAME).getValue());
        this.magParam.setValueIgnoreWarning(new Double(this.eqkRupture.getMag()));
        this.setFaultTypeFromRake(this.eqkRupture.getAveRake());
        propEffect.setParamValue(this.distanceRupParam);
    }

    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void updateCoefficients() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("SCEMY_1997_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        StringBuffer key = new StringBuffer(this.im.getName());
        if (this.im.getName().equalsIgnoreCase("SA")) {
            key.append("/" + this.saPeriodParam.getValue());
        }
        if (!this.coefficients.containsKey(key.toString())) {
            throw new ParameterException("SCEMY_1997_AttenRel: setIntensityMeasureType(): Unable to locate coefficients with key = " + key);
        }
        this.coeff = (SCEMY_1997_AttenRelCoefficients)this.coefficients.get(key.toString());
    }

    public SadighEtAl_1997_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.initCoefficients();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return SHORT_NAME;
    }

    public double getMean() throws IMRException {
        double mean;
        String siteType;
        String fltType;
        double dist;
        double mag;
        try {
            mag = (Double)this.magParam.getValue();
            dist = (Double)this.distanceRupParam.getValue();
            fltType = ((String)this.fltTypeParam.getValue()).toString();
            siteType = ((String)this.siteTypeParam.getValue()).toString();
            String component = ((String)this.componentParam.getValue()).toString();
        }
        catch (NullPointerException e) {
            throw new IMRException("SCEMY_1997_AttenRel: getMean(): Not all parameters have been set");
        }
        if (dist > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        this.updateCoefficients();
        double c2_rlt = 1.0;
        double c2_rgt = 1.1;
        double c5_rlt = 1.29649;
        double c5_rgt = -0.48451;
        double c6_rlt = 0.25;
        double c6_rgt = 0.524;
        double c1_s_ss = -2.17;
        double c1_s_rv = -1.92;
        double c2_s = 1.0;
        double c3_s = 1.7;
        double c4_slt = 2.1863;
        double c4_sgt = 0.3825;
        double c5_slt = 0.32;
        double c5_sgt = 0.5882;
        if (siteType.equals(SITE_TYPE_ROCK)) {
            mean = mag <= 6.5 ? this.coeff.c1_rlt + c2_rlt * mag + this.coeff.c3 * Math.pow(8.5 - mag, 2.5) + this.coeff.c4 * Math.log(dist + Math.exp(c5_rlt + c6_rlt * mag)) + this.coeff.c7_r * Math.log(dist + 2.0) : this.coeff.c1_rgt + c2_rgt * mag + this.coeff.c3 * Math.pow(8.5 - mag, 2.5) + this.coeff.c4 * Math.log(dist + Math.exp(c5_rgt + c6_rgt * mag)) + this.coeff.c7_r * Math.log(dist + 2.0);
            if (fltType.equals(FLT_TYPE_REVERSE)) {
                mean += 0.1823;
            }
        } else {
            mean = mag <= 6.5 ? c2_s * mag - c3_s * Math.log(dist + c4_slt * Math.exp(c5_slt * mag)) + this.coeff.c7_s * Math.pow(8.5 - mag, 2.5) : c2_s * mag - c3_s * Math.log(dist + c4_sgt * Math.exp(c5_sgt * mag)) + this.coeff.c7_s * Math.pow(8.5 - mag, 2.5);
            mean = fltType.equals(FLT_TYPE_REVERSE) ? (mean += c1_s_rv + this.coeff.c6_s_rv) : (mean += c1_s_ss + this.coeff.c6_s_ss);
        }
        return mean;
    }

    public double getStdDev() throws IMRException {
        double mag;
        String siteType;
        if (((String)this.stdDevTypeParam.getValue()).equals("None (zero)")) {
            return 0.0;
        }
        try {
            siteType = ((String)this.siteTypeParam.getValue()).toString();
            mag = (Double)this.magParam.getValue();
        }
        catch (NullPointerException e) {
            throw new IMRException("SCEMY_1997_AttenRel: getMean(): Not all parameters have been set");
        }
        this.updateCoefficients();
        if (siteType.equals(SITE_TYPE_ROCK)) {
            if (mag <= 7.21) {
                return this.coeff.sigma_ri - mag * 0.14;
            }
            return this.coeff.sigma_ri - 1.01;
        }
        if (mag <= 7.0) {
            return this.coeff.sigma_si - mag * 0.16;
        }
        return this.coeff.sigma_si - 1.12;
    }

    public void setParamDefaults() {
        this.siteTypeParam.setValue("Deep-Soil");
        this.magParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.siteTypeParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.siteTypeParam);
        this.stdDevIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameter(this.distanceRupParam);
        this.exceedProbIndependentParams.addParameter(this.siteTypeParam);
        this.exceedProbIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.addParameter(this.fltTypeParam);
        this.exceedProbIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    protected void initSiteParams() {
        StringConstraint siteConstraint = new StringConstraint();
        siteConstraint.addString(SITE_TYPE_ROCK);
        siteConstraint.addString("Deep-Soil");
        siteConstraint.setNonEditable();
        this.siteTypeParam = new StringParameter(SITE_TYPE_NAME, siteConstraint, null);
        this.siteTypeParam.setInfo(SITE_TYPE_INFO);
        this.siteTypeParam.setNonEditable();
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
    }

    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_REVERSE);
        constraint.addString(FLT_TYPE_OTHER);
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, FLT_TYPE_OTHER);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
    }

    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        this.distanceRupParam.addParameterChangeWarningListener(this.warningListener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
    }

    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        TreeSet<Double> set = new TreeSet<Double>();
        Enumeration keys = this.coefficients.keys();
        while (keys.hasMoreElements()) {
            SCEMY_1997_AttenRelCoefficients coeff = (SCEMY_1997_AttenRelCoefficients)this.coefficients.get(keys.nextElement());
            if (!(coeff.period >= 0.0)) continue;
            set.add(new Double(coeff.period));
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            periodConstraint.addDouble((Double)it.next());
        }
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint constraint = new StringConstraint();
        constraint.addString("Average Horizontal");
        constraint.setNonEditable();
        this.componentParam = new ComponentParam(constraint, "Average Horizontal");
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    protected void initCoefficients() {
        String S = "SCEMY_1997_AttenRel: initCoefficients():";
        this.coefficients.clear();
        SCEMY_1997_AttenRelCoefficients coeff = new SCEMY_1997_AttenRelCoefficients("PGA", 0.0, -0.624, -1.274, 0.0, -2.1, 0.0, 0.0, 0.0, 0.0, 1.39, 1.52);
        SCEMY_1997_AttenRelCoefficients coeff0 = new SCEMY_1997_AttenRelCoefficients("SA/" + new Double("0.0"), 0.0, -0.624, -1.274, 0.0, -2.1, 0.0, 0.0, 0.0, 0.0, 1.39, 1.52);
        SCEMY_1997_AttenRelCoefficients coeff1 = new SCEMY_1997_AttenRelCoefficients("SA/" + new Double("0.075"), 0.075, 0.11, -0.54, 0.006, -2.128, -0.082, 0.4572, 0.4572, 0.005, 1.4, 1.54);
        SCEMY_1997_AttenRelCoefficients coeff2 = new SCEMY_1997_AttenRelCoefficients("SA/" + new Double("0.1"), 0.1, 0.275, -0.375, 0.006, -2.148, -0.041, 0.6395, 0.6395, 0.005, 1.41, 1.54);
        SCEMY_1997_AttenRelCoefficients coeff3 = new SCEMY_1997_AttenRelCoefficients("SA/" + new Double("0.2"), 0.2, 0.153, -0.497, -0.004, -2.08, 0.0, 0.9187, 0.9187, -0.004, 1.43, 1.565);
        SCEMY_1997_AttenRelCoefficients coeff4 = new SCEMY_1997_AttenRelCoefficients("SA/" + new Double("0.3"), 0.3, -0.057, -0.707, -0.017, -2.028, 0.0, 0.9547, 0.9547, -0.014, 1.45, 1.58);
        SCEMY_1997_AttenRelCoefficients coeff5 = new SCEMY_1997_AttenRelCoefficients("SA/" + new Double("0.4"), 0.4, -0.298, -0.948, -0.028, -1.99, 0.0, 0.9251, 0.9005, -0.024, 1.48, 1.595);
        SCEMY_1997_AttenRelCoefficients coeff6 = new SCEMY_1997_AttenRelCoefficients("SA/" + new Double("0.5"), 0.5, -0.588, -1.238, -0.04, -1.945, 0.0, 0.8494, 0.8285, -0.033, 1.5, 1.61);
        SCEMY_1997_AttenRelCoefficients coeff7 = new SCEMY_1997_AttenRelCoefficients("SA/" + new Double("0.75"), 0.75, -1.208, -1.858, -0.05, -1.865, 0.0, 0.701, 0.6802, -0.051, 1.52, 1.635);
        SCEMY_1997_AttenRelCoefficients coeff8 = new SCEMY_1997_AttenRelCoefficients("SA/" + new Double("1.0"), 1.0, -1.705, -2.355, -0.055, -1.8, 0.0, 0.5665, 0.5075, -0.065, 1.53, 1.66);
        SCEMY_1997_AttenRelCoefficients coeff9 = new SCEMY_1997_AttenRelCoefficients("SA/" + new Double("1.5"), 1.5, -2.407, -3.057, -0.065, -1.725, 0.0, 0.3235, 0.2215, -0.09, 1.53, 1.69);
        SCEMY_1997_AttenRelCoefficients coeff10 = new SCEMY_1997_AttenRelCoefficients("SA/" + new Double("2.0"), 2.0, -2.945, -3.595, -0.07, -1.67, 0.0, 0.1001, -0.0526, -0.108, 1.53, 1.7);
        SCEMY_1997_AttenRelCoefficients coeff11 = new SCEMY_1997_AttenRelCoefficients("SA/" + new Double("3.0"), 3.0, -3.7, -4.35, -0.08, -1.61, 0.0, -0.2801, -0.4905, -0.139, 1.53, 1.71);
        SCEMY_1997_AttenRelCoefficients coeff12 = new SCEMY_1997_AttenRelCoefficients("SA/" + new Double("4.0"), 4.0, -4.23, -4.88, -0.1, -1.57, 0.0, -0.6274, -0.8907, -0.16, 1.53, 1.71);
        this.coefficients.put(coeff.getName(), coeff);
        this.coefficients.put(coeff0.getName(), coeff0);
        this.coefficients.put(coeff1.getName(), coeff1);
        this.coefficients.put(coeff2.getName(), coeff2);
        this.coefficients.put(coeff3.getName(), coeff3);
        this.coefficients.put(coeff4.getName(), coeff4);
        this.coefficients.put(coeff5.getName(), coeff5);
        this.coefficients.put(coeff6.getName(), coeff6);
        this.coefficients.put(coeff7.getName(), coeff7);
        this.coefficients.put(coeff8.getName(), coeff8);
        this.coefficients.put(coeff9.getName(), coeff9);
        this.coefficients.put(coeff10.getName(), coeff10);
        this.coefficients.put(coeff11.getName(), coeff11);
        this.coefficients.put(coeff12.getName(), coeff12);
    }

    public URL getInfoURL() throws MalformedURLException {
        return new URL("http://www.opensha.org/documentation/modelsImplemented/attenRel/SadighEtAl_1997.html");
    }

    class SCEMY_1997_AttenRelCoefficients
    implements NamedObjectAPI {
        protected static final String C = "SCEMY_1997_AttenRelCoefficients";
        protected static final boolean D = true;
        private static final long serialVersionUID = 1234567890987654328L;
        protected String name;
        protected double period = -1.0;
        protected double c1_rlt;
        protected double c1_rgt;
        protected double c3;
        protected double c4;
        protected double c7_r;
        protected double c6_s_ss;
        protected double c6_s_rv;
        protected double c7_s;
        protected double sigma_ri;
        protected double sigma_si;

        public SCEMY_1997_AttenRelCoefficients(String name) {
            this.name = name;
        }

        public SCEMY_1997_AttenRelCoefficients(String name, double period, double c1_rlt, double c1_rgt, double c3, double c4, double c7_r, double c6_s_ss, double c6_s_rv, double c7_s, double sigma_ri, double sigma_si) {
            this.name = name;
            this.period = period;
            this.c1_rlt = c1_rlt;
            this.c1_rgt = c1_rgt;
            this.c3 = c3;
            this.c4 = c4;
            this.c7_r = c7_r;
            this.c6_s_ss = c6_s_ss;
            this.c6_s_rv = c6_s_rv;
            this.c7_s = c7_s;
            this.sigma_ri = sigma_ri;
            this.sigma_si = sigma_si;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(C);
            b.append("\n  Period = " + this.period);
            b.append("\n  c1_rlt = " + this.c1_rlt);
            b.append("\n  c1_rgt = " + this.c1_rgt);
            b.append("\n  c3 = " + this.c3);
            b.append("\n  c4 = " + this.c4);
            b.append("\n  c7_r = " + this.c7_r);
            b.append("\n  c6_s_ss = " + this.c6_s_ss);
            b.append("\n  c6_s_rv = " + this.c6_s_rv);
            b.append("\n c7_s = " + this.c7_s);
            b.append("\n  sigma_ri = " + this.sigma_ri);
            b.append("\n  sigma_si = " + this.sigma_si);
            return b.toString();
        }
    }
}

