/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.magdist;

import org.opensha.commons.exceptions.DataPoint2DException;
import org.opensha.commons.exceptions.DiscretizedFuncException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.MagFreqDistException;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class GutenbergRichterMagFreqDist
extends IncrementalMagFreqDist {
    public static String NAME = new String("Gutenberg Richter Dist");
    private boolean D = false;
    private double magLower;
    private double magUpper;
    private double bValue;

    public GutenbergRichterMagFreqDist(double min, int num, double delta) throws InvalidRangeException {
        super(min, num, delta);
        this.magLower = min;
    }

    public GutenbergRichterMagFreqDist(double min, double max, int num) throws DiscretizedFuncException, InvalidRangeException {
        super(min, max, num);
    }

    public GutenbergRichterMagFreqDist(double bValue, double totCumRate, double min, double max, int num) throws DiscretizedFuncException, InvalidRangeException {
        super(min, max, num);
        this.setAllButTotMoRate(min, max, totCumRate, bValue);
    }

    public GutenbergRichterMagFreqDist(double min, int num, double delta, double totMoRate, double bValue) throws DataPoint2DException {
        super(min, num, delta);
        this.setAllButTotCumRate(this.minX, this.maxX, totMoRate, bValue);
    }

    public GutenbergRichterMagFreqDist(double min, int num, double delta, double magLower, double magUpper, double totMoRate, double bValue) throws InvalidRangeException, DataPoint2DException {
        super(min, num, delta);
        this.setAllButTotCumRate(magLower, magUpper, totMoRate, bValue);
    }

    public void setAllButTotCumRate(double magLower, double magUpper, double totMoRate, double bValue) throws DataPoint2DException {
        this.magLower = magLower;
        this.magUpper = magUpper;
        this.bValue = bValue;
        this.calculateRelativeRates();
        this.scaleToTotalMomentRate(totMoRate);
    }

    public void setAllButTotMoRate(double magLower, double magUpper, double totCumRate, double bValue) throws DataPoint2DException {
        this.magLower = magLower;
        this.magUpper = magUpper;
        this.bValue = bValue;
        this.calculateRelativeRates();
        this.scaleToCumRate(magLower, totCumRate);
    }

    public void setAllButMagUpper(double magLower, double totMoRate, double totCumRate, double bValue, boolean relaxTotMoRate) throws MagFreqDistException, DiscretizedFuncException, DataPoint2DException {
        int index;
        if (this.D) {
            System.out.println("magLower = " + magLower);
        }
        if (this.D) {
            System.out.println("totMoRate = " + totMoRate);
        }
        if (this.D) {
            System.out.println("totCumRate = " + totCumRate);
        }
        if (this.D) {
            System.out.println("bValue = " + bValue);
        }
        if (this.D) {
            System.out.println("relaxCumRate = " + relaxTotMoRate);
        }
        double b = bValue;
        double N = totCumRate;
        double z = 1.5 - b;
        double X = N * b * Math.pow(10.0, 9.05) / z;
        double M1 = magLower;
        double tempTotMoRate = 0.0;
        double lastMoRate = 0.0;
        for (index = this.getXIndex(M1) + 1; tempTotMoRate < totMoRate && index < this.num; ++index) {
            lastMoRate = tempTotMoRate;
            double M2 = this.getX(index);
            tempTotMoRate = X * (Math.pow(10.0, z * M2) - Math.pow(10.0, z * M1)) / (Math.pow(10.0, -b * M1) - Math.pow(10.0, -b * M2));
        }
        --index;
        if (this.D) {
            System.out.println("just above target: index=" + index + "; mag=" + this.getX(index));
        }
        if (this.D) {
            System.out.println("lastMoRate = " + lastMoRate);
        }
        if (this.D) {
            System.out.println("tempTotMoRate = " + tempTotMoRate);
        }
        if (this.D) {
            System.out.println("targetMoRate = " + totMoRate);
        }
        if (lastMoRate <= totMoRate && tempTotMoRate >= totMoRate) {
            double diff2 = totMoRate - lastMoRate;
            double diff1 = tempTotMoRate - totMoRate;
            if (diff2 < diff1) {
                --index;
            }
        } else {
            throw new MagFreqDistException("Moment rate not attainable");
        }
        this.magUpper = this.getX(index);
        if (this.D) {
            System.out.println("chosen magUpper=" + this.magUpper);
        }
        if (relaxTotMoRate) {
            this.setAllButTotMoRate(magLower, this.magUpper, totCumRate, bValue);
        } else {
            this.setAllButTotCumRate(magLower, this.magUpper, totMoRate, bValue);
        }
    }

    private void calculateRelativeRates() throws DataPoint2DException {
        int i;
        if (this.magLower < this.minX || this.magLower > this.maxX) {
            throw new DataPoint2DException("magLower should lie between minX and maxX");
        }
        if (this.magLower > this.magUpper) {
            throw new InvalidRangeException("magLower must be < magUpper");
        }
        int indexLow = this.getXIndex(this.magLower);
        int indexUp = this.getXIndex(this.magUpper);
        for (i = 0; i < indexLow; ++i) {
            super.set(i, 0.0);
        }
        for (i = indexLow; i <= indexUp; ++i) {
            super.set(i, Math.pow(10.0, -this.bValue * this.getX(i)));
        }
        for (i = indexUp + 1; i < this.num; ++i) {
            super.set(i, 0.0);
        }
    }

    public double getTotCumRate() throws DataPoint2DException {
        return this.getCumRate(this.magLower);
    }

    public double get_bValue() {
        return this.bValue;
    }

    public double getMagLower() {
        return this.magLower;
    }

    public double getMagUpper() {
        return this.magUpper;
    }

    public String getDefaultName() {
        return NAME;
    }

    public String getDefaultInfo() throws DataPoint2DException {
        return "minMag=" + this.minX + "; maxMag=" + this.maxX + "; numMag=" + this.num + "; bValue=" + this.bValue + "; magLower=" + this.magLower + "; magUpper=" + (float)this.magUpper + "; totMoRate=" + (float)this.getTotalMomentRate() + "; totCumRate=" + (float)this.getCumRate(this.magLower);
    }
}

