/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.ListIterator;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.data.siteData.util.SiteDataTypeParameterNameMap;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.StringParameter;
import org.opensha.commons.param.WarningDoubleParameter;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIntensityMeasureRelationshipAPI;
import org.opensha.sha.imr.attenRelImpl.AS_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Abrahamson_2000_AttenRel;
import org.opensha.sha.imr.attenRelImpl.BJF_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CB_2003_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CB_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CS_2005_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CY_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Campbell_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.DahleEtAl_1995_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Field_2000_AttenRel;
import org.opensha.sha.imr.attenRelImpl.SEA_1999_AttenRel;
import org.opensha.sha.imr.attenRelImpl.SadighEtAl_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.ShakeMap_2003_AttenRel;
import org.opensha.sha.imr.attenRelImpl.USGS_Combined_2004_AttenRel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteTranslator
implements Serializable {
    private static final String C = "SiteTranslator";
    private static final boolean D = false;
    public static final String WILLS_B = "B";
    public static final String WILLS_BC = "BC";
    public static final String WILLS_C = "C";
    public static final String WILLS_CD = "CD";
    public static final String WILLS_D = "D";
    public static final String WILLS_DE = "DE";
    public static final String WILLS_E = "E";
    public static final HashMap<String, Double> wills_vs30_map = new HashMap();
    public static SiteDataTypeParameterNameMap DATA_TYPE_PARAM_NAME_MAP;

    public static ArrayList<String> getSortedWillsValues() {
        ArrayList<String> wills = new ArrayList<String>();
        wills.add(WILLS_B);
        wills.add(WILLS_BC);
        wills.add(WILLS_C);
        wills.add(WILLS_CD);
        wills.add(WILLS_D);
        wills.add(WILLS_DE);
        wills.add(WILLS_E);
        return wills;
    }

    public static double getVS30FromWillsClass(String wills) {
        if (wills_vs30_map.keySet().contains(wills)) {
            return wills_vs30_map.get(wills);
        }
        return Double.NaN;
    }

    public static String getWillsVs30TranslationString() {
        String str = "";
        for (String wills : SiteTranslator.getSortedWillsValues()) {
            if (str.length() > 0) {
                str = str + "\n";
            }
            str = str + wills + "\t=>\t" + wills_vs30_map.get(wills);
        }
        return str;
    }

    private static SiteDataTypeParameterNameMap createMap() {
        SiteDataTypeParameterNameMap map = new SiteDataTypeParameterNameMap();
        map.addMapping("Wills Class", "Campbell-Basin-Depth");
        map.addMapping("Wills Class", "Wills Site Class");
        map.addMapping("Vs30", "Vs30");
        map.addMapping("Wills Class", "Vs30");
        map.addMapping("Vs30", "Vs30 Type");
        map.addMapping("Wills Class", "Vs30 Type");
        map.addMapping("Vs30", "AS Site Type");
        map.addMapping("Wills Class", "AS Site Type");
        map.addMapping("Vs30", "Sadigh Site Type");
        map.addMapping("Wills Class", "Sadigh Site Type");
        map.addMapping("Vs30", "Campbell Site Type");
        map.addMapping("Wills Class", "Campbell Site Type");
        map.addMapping("Vs30", "Campbell-2003 Site Type");
        map.addMapping("Wills Class", "Campbell-2003 Site Type");
        map.addMapping("Vs30", "Soft Soil Case");
        map.addMapping("Wills Class", "Soft Soil Case");
        map.addMapping("Depth to Vs = 2.5 km/sec", "Depth 2.5 km/sec");
        map.addMapping("Depth to Vs = 2.5 km/sec", "Field-Basin-Depth");
        map.addMapping("Depth to Vs = 2.5 km/sec", "Campbell-Basin-Depth");
        map.addMapping("Depth to Vs = 1.0 km/sec", "Depth 1.0 km/sec");
        return map;
    }

    public boolean setParameterValue(ParameterAPI param, SiteDataValue<?> data) {
        ArrayList datas = new ArrayList();
        datas.add(data);
        return this.setParameterValue(param, datas);
    }

    public boolean setParameterValue(ParameterAPI param, Collection<SiteDataValue<?>> datas) {
        String paramName = param.getName();
        boolean mapping = false;
        for (SiteDataValue<?> data : datas) {
            if (!DATA_TYPE_PARAM_NAME_MAP.isValidMapping(data, paramName)) continue;
            mapping = true;
            break;
        }
        if (mapping) {
            if (paramName.equals("Vs30")) {
                return this.setVS30Param(param, datas);
            }
            if (paramName.equals("Vs30 Type")) {
                return this.setVS30FlagParam(param, datas);
            }
            if (paramName.equals("AS Site Type")) {
                return this.setAS_SiteType(param, datas);
            }
            if (paramName.equals("Sadigh Site Type")) {
                return this.setSCEMY_SiteType(param, datas);
            }
            if (paramName.equals("Campbell-Basin-Depth")) {
                return this.setCampbellBasinDepth(param, datas);
            }
            if (paramName.equals("Campbell Site Type")) {
                return this.setCampbellSiteType(param, datas);
            }
            if (paramName.equals("Campbell-2003 Site Type")) {
                return this.setCB03SiteType(param, datas);
            }
            if (paramName.equals("Wills Site Class")) {
                return this.setWillsSiteTypeName(param, datas);
            }
            if (paramName.equals("Soft Soil Case")) {
                return this.setCS05SoftSoil(param, datas);
            }
            if (paramName.equals("Depth 2.5 km/sec")) {
                return this.setDepthTo2p5Param(param, datas);
            }
            if (paramName.equals("Depth 1.0 km/sec")) {
                return this.setDepthTo1p0Param(param, datas);
            }
            if (paramName.equals("Field-Basin-Depth")) {
                return this.setDepthTo2p5Param(param, datas);
            }
        } else {
            return false;
        }
        return false;
    }

    public boolean setAllSiteParams(ScalarIntensityMeasureRelationshipAPI imr, SiteDataValue<?> data) {
        ArrayList datas = new ArrayList();
        datas.add(data);
        return this.setAllSiteParams(imr, datas);
    }

    public boolean setAllSiteParams(ScalarIntensityMeasureRelationshipAPI imr, Collection<SiteDataValue<?>> datas) {
        boolean setSomething = false;
        ListIterator it = imr.getSiteParamsIterator();
        while (it.hasNext()) {
            ParameterAPI param = (ParameterAPI)it.next();
            if (!this.setParameterValue(param, datas)) continue;
            setSomething = true;
        }
        return setSomething;
    }

    private SiteDataValue<?> getDataForType(Collection<SiteDataValue<?>> datas, String type) {
        for (SiteDataValue<?> data : datas) {
            if (!data.getDataType().equals(type)) continue;
            return data;
        }
        return null;
    }

    private boolean isVS30ValueValid(Double vsValue) {
        return vsValue != null && !vsValue.isNaN() && vsValue > 0.0;
    }

    public boolean setVS30Param(ParameterAPI param, Collection<SiteDataValue<?>> datas) {
        Double vsValue = null;
        for (SiteDataValue<?> data : datas) {
            if (data.getDataType().equals("Vs30")) {
                vsValue = (Double)data.getValue();
                if (!this.isVS30ValueValid(vsValue)) continue;
                param.setValue(vsValue);
                return true;
            }
            if (!data.getDataType().equals("Wills Class") || !this.isVS30ValueValid(vsValue = Double.valueOf(SiteTranslator.getVS30FromWillsClass((String)data.getValue())))) continue;
            param.setValue(vsValue);
            return true;
        }
        return false;
    }

    public boolean setVS30FlagParam(ParameterAPI param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            Double vsValue = null;
            if (data.getDataType().equals("Vs30")) {
                vsValue = (Double)data.getValue();
            } else if (data.getDataType().equals("Wills Class")) {
                vsValue = SiteTranslator.getVS30FromWillsClass((String)data.getValue());
            }
            if (!this.isVS30ValueValid(vsValue)) continue;
            if (data.getDataMeasurementType().equals("Measured")) {
                param.setValue("Measured");
                return true;
            }
            param.setValue("Inferred");
            return true;
        }
        return false;
    }

    public boolean setDepthTo2p5Param(ParameterAPI param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            Double val;
            if (!data.getDataType().equals("Depth to Vs = 2.5 km/sec") || Double.isNaN(val = (Double)data.getValue())) continue;
            if (param instanceof WarningDoubleParameter) {
                ((WarningDoubleParameter)param).setValueIgnoreWarning(val);
            } else {
                param.setValue(val);
            }
            return true;
        }
        return false;
    }

    public boolean setDepthTo1p0Param(ParameterAPI param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            Double val;
            if (!data.getDataType().equals("Depth to Vs = 1.0 km/sec") || Double.isNaN(val = (Double)data.getValue())) continue;
            val = val * 1000.0;
            param.setValue(val);
            return true;
        }
        return false;
    }

    public boolean setAS_SiteType(ParameterAPI param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            if (data.getDataType().equals("Vs30")) {
                Double vsVal = (Double)data.getValue();
                if (!this.isVS30ValueValid(vsVal)) continue;
                SiteDataValue<?> dep2p5Data = this.getDataForType(datas, "Depth to Vs = 2.5 km/sec");
                Double dep = null;
                if (dep2p5Data != null) {
                    dep = (Double)dep2p5Data.getValue();
                }
                if (vsVal <= 400.0 && (dep == null || !Double.isNaN(dep) && dep > 0.1)) {
                    param.setValue("Deep-Soil");
                } else {
                    param.setValue("Rock/Shallow-Soil");
                }
                return true;
            }
            if (!data.getDataType().equals("Wills Class")) continue;
            String wc = (String)data.getValue();
            if (wc.equals(WILLS_DE) || wc.equals(WILLS_D) || wc.equals(WILLS_CD)) {
                param.setValue("Deep-Soil");
                return true;
            }
            if (!wc.equals(WILLS_C) && !wc.equals(WILLS_BC) && !wc.equals(WILLS_B)) continue;
            param.setValue("Rock/Shallow-Soil");
            return true;
        }
        return false;
    }

    public boolean setSCEMY_SiteType(ParameterAPI param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            if (data.getDataType().equals("Vs30")) {
                Double vsVal = (Double)data.getValue();
                if (!this.isVS30ValueValid(vsVal)) continue;
                SiteDataValue<?> dep2p5Data = this.getDataForType(datas, "Depth to Vs = 2.5 km/sec");
                Double dep = null;
                if (dep2p5Data != null) {
                    dep = (Double)dep2p5Data.getValue();
                }
                if (vsVal <= 400.0 && (dep == null || !Double.isNaN(dep) && dep > 0.1)) {
                    param.setValue("Deep-Soil");
                } else {
                    param.setValue("Rock");
                }
                return true;
            }
            if (!data.getDataType().equals("Wills Class")) continue;
            String wc = (String)data.getValue();
            if (wc.equals(WILLS_DE) || wc.equals(WILLS_D) || wc.equals(WILLS_CD)) {
                param.setValue("Deep-Soil");
                return true;
            }
            if (!wc.equals(WILLS_C) && !wc.equals(WILLS_BC) && !wc.equals(WILLS_B)) continue;
            param.setValue("Rock");
            return true;
        }
        return false;
    }

    public boolean setCampbellBasinDepth(ParameterAPI param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            if (data.getDataType().equals("Wills Class")) {
                String wc = (String)data.getValue();
                if (wc.equals(WILLS_DE) || wc.equals(WILLS_D) || wc.equals(WILLS_CD)) {
                    param.setValue(new Double(5.0));
                    return true;
                }
                if (wc.equals(WILLS_C)) {
                    param.setValue(new Double(1.0));
                    return true;
                }
                if (!wc.equals(WILLS_BC) && !wc.equals(WILLS_B)) continue;
                param.setValue(new Double(0.0));
                return true;
            }
            if (!data.getDataType().equals("Depth to Vs = 2.5 km/sec")) continue;
            Double depth = (Double)data.getValue();
            if (depth.isNaN()) {
                return false;
            }
            param.setValue(depth);
            return true;
        }
        return false;
    }

    public boolean setCampbellSiteType(ParameterAPI param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            if (data.getDataType().equals("Vs30")) {
                Double vsVal = (Double)data.getValue();
                if (!this.isVS30ValueValid(vsVal)) continue;
                if (vsVal > 180.0 && vsVal <= 400.0) {
                    param.setValue("Firm-Soil");
                    return true;
                }
                if (vsVal > 400.0 && vsVal <= 500.0) {
                    param.setValue("Soft-Rock");
                    return true;
                }
                if (!(vsVal > 500.0)) continue;
                param.setValue("Hard-Rock");
                return true;
            }
            if (!data.getDataType().equals("Wills Class")) continue;
            String wc = (String)data.getValue();
            if (wc.equals(WILLS_DE) || wc.equals(WILLS_D) || wc.equals(WILLS_CD)) {
                param.setValue("Firm-Soil");
                return true;
            }
            if (wc.equals(WILLS_C)) {
                param.setValue("Soft-Rock");
                return true;
            }
            if (!wc.equals(WILLS_BC) && !wc.equals(WILLS_B)) continue;
            param.setValue("Hard-Rock");
            return true;
        }
        return false;
    }

    public boolean setCB03SiteType(ParameterAPI param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            if (data.getDataType().equals("Vs30")) {
                Double vsVal = (Double)data.getValue();
                if (vsVal > 180.0 && vsVal <= 300.0) {
                    param.setValue("Firm-Soil");
                    return true;
                }
                if (vsVal > 300.0 && vsVal <= 400.0) {
                    param.setValue("Very-Firm-Soil");
                    return true;
                }
                if (vsVal > 400.0 && vsVal <= 500.0) {
                    param.setValue("Soft-Rock");
                    return true;
                }
                if (!(vsVal > 500.0)) continue;
                param.setValue("Firm-Rock");
                return true;
            }
            if (!data.getDataType().equals("Wills Class")) continue;
            String wc = (String)data.getValue();
            if (wc.equals(WILLS_DE) || wc.equals(WILLS_D)) {
                param.setValue("Firm-Soil");
                return true;
            }
            if (wc.equals(WILLS_CD)) {
                param.setValue("Very-Firm-Soil");
                return true;
            }
            if (wc.equals(WILLS_C)) {
                param.setValue("Soft-Rock");
                return true;
            }
            if (wc.equals(WILLS_BC)) {
                param.setValue("BC-Boundary");
                return true;
            }
            if (!wc.equals(WILLS_B)) continue;
            param.setValue("Firm-Rock");
            return true;
        }
        return false;
    }

    public boolean setWillsSiteTypeName(ParameterAPI param, Collection<SiteDataValue<?>> datas) {
        String wc;
        SiteDataValue<?> willsData = this.getDataForType(datas, "Wills Class");
        if (willsData != null && param.isAllowed(wc = (String)willsData.getValue())) {
            param.setValue(wc);
            return true;
        }
        return false;
    }

    public boolean setCS05SoftSoil(ParameterAPI param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            if (data.getDataType().equals("Vs30")) {
                Double vsVal = (Double)data.getValue();
                if (this.isVS30ValueValid(vsVal)) {
                    param.setValue(new Boolean(vsVal < 180.0));
                    return true;
                }
                return false;
            }
            if (!data.getDataType().equals("Wills Class")) continue;
            String wc = (String)data.getValue();
            if (wc.equals(WILLS_E)) {
                param.setValue(new Boolean(true));
            } else {
                param.setValue(new Boolean(false));
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean setParameterValue(ParameterAPI param, String willsClass, double basinDepth) {
        SiteDataValue<Object> willsData = null;
        String wc = willsClass;
        if (wills_vs30_map.keySet().contains(wc)) {
            willsData = new SiteDataValue<String>("Wills Class", "Measured", wc);
        } else {
            try {
                double vs = Double.parseDouble(wc);
                willsData = new SiteDataValue<Double>("Vs30", "Measured", vs);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        SiteDataValue<Double> basinData = null;
        basinData = new SiteDataValue<Double>("Depth to Vs = 2.5 km/sec", "Measured", basinDepth / 1000.0);
        boolean setWills = this.setParameterValue(param, willsData);
        boolean setBasin = this.setParameterValue(param, basinData);
        return setWills || setBasin;
    }

    public void test(ParameterAPI param) {
        System.out.println(param.getName() + "  Parameter (basin depth = NaN):");
        if (this.setParameterValue(param, WILLS_B, Double.NaN)) {
            System.out.println("\tB --> " + param.getValue());
        } else {
            System.out.println("\tB --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_BC, Double.NaN)) {
            System.out.println("\tBC --> " + param.getValue());
        } else {
            System.out.println("\tBC --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_C, Double.NaN)) {
            System.out.println("\tC --> " + param.getValue());
        } else {
            System.out.println("\tC --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_CD, Double.NaN)) {
            System.out.println("\tCD --> " + param.getValue());
        } else {
            System.out.println("\tCD --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_D, Double.NaN)) {
            System.out.println("\tD --> " + param.getValue());
        } else {
            System.out.println("\tD --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_DE, Double.NaN)) {
            System.out.println("\tDE --> " + param.getValue());
        } else {
            System.out.println("\tDE --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_E, Double.NaN)) {
            System.out.println("\tE --> " + param.getValue());
        } else {
            System.out.println("\tE --> *** can't set ***");
        }
        System.out.println(param.getName() + "  Parameter (basin depth = 1.0):");
        if (this.setParameterValue(param, WILLS_B, 1.0)) {
            System.out.println("\tB --> " + param.getValue());
        } else {
            System.out.println("\tB --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_BC, 1.0)) {
            System.out.println("\tBC --> " + param.getValue());
        } else {
            System.out.println("\tBC --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_C, 1.0)) {
            System.out.println("\tC --> " + param.getValue());
        } else {
            System.out.println("\tC --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_CD, 1.0)) {
            System.out.println("\tCD --> " + param.getValue());
        } else {
            System.out.println("\tCD --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_D, 1.0)) {
            System.out.println("\tD --> " + param.getValue());
        } else {
            System.out.println("\tD --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_DE, 1.0)) {
            System.out.println("\tDE --> " + param.getValue());
        } else {
            System.out.println("\tDE --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_E, 1.0)) {
            System.out.println("\tE --> " + param.getValue());
        } else {
            System.out.println("\tE --> *** can't set ***");
        }
    }

    private ArrayList<ParameterAPI> getTableParameters() {
        ArrayList<ParameterAPI> params = new ArrayList<ParameterAPI>();
        String attenNames = "";
        AttenuationRelationship ar = new CB_2008_AttenRel(null);
        attenNames = attenNames + ",(multiple),(multiple)";
        params.add(ar.getParameter("Vs30"));
        params.add(ar.getParameter("Depth 2.5 km/sec"));
        ar = new CY_2008_AttenRel(null);
        attenNames = attenNames + ",(multiple)";
        params.add(ar.getParameter("Depth 1.0 km/sec"));
        ar = new AS_1997_AttenRel(null);
        attenNames = attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("AS Site Type"));
        ar = new CB_2003_AttenRel(null);
        attenNames = attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("Campbell-2003 Site Type"));
        ar = new CS_2005_AttenRel(null);
        attenNames = attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("Soft Soil Case"));
        ar = new Campbell_1997_AttenRel(null);
        attenNames = attenNames + "," + ar.getName().replaceAll(",", "") + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("Campbell Site Type"));
        params.add(ar.getParameter("Campbell-Basin-Depth"));
        ar = new DahleEtAl_1995_AttenRel(null);
        attenNames = attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("Dahle Site Type"));
        ar = new Field_2000_AttenRel(null);
        attenNames = attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("Field-Basin-Depth"));
        ar = new SadighEtAl_1997_AttenRel(null);
        attenNames = attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("Sadigh Site Type"));
        ar = new SEA_1999_AttenRel(null);
        attenNames = attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("SEA Site Type"));
        ar = new ShakeMap_2003_AttenRel(null);
        attenNames = attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("Wills Site Class"));
        params.add(new StringParameter("Atten Rel Names", attenNames));
        return params;
    }

    private String getTableValLine(ArrayList<ParameterAPI> params, SiteDataValue<?> val) {
        String line = val.getValue() + "";
        for (ParameterAPI param : params) {
            boolean flag = this.setParameterValue(param, val);
            if (flag) {
                line = line + "," + param.getValue();
                continue;
            }
            line = line + ",N/A";
        }
        return line;
    }

    private void generateConversionTables() throws IOException {
        ArrayList<ParameterAPI> params = this.getTableParameters();
        String attenTitles = (String)params.remove(params.size() - 1).getValue();
        FileWriter fw = new FileWriter("siteTrans.csv");
        String empty = "";
        String paramNames = "";
        for (ParameterAPI param : params) {
            paramNames = paramNames + "," + param.getName();
            empty = empty + ",";
        }
        fw.write("Vs30" + empty.substring(1) + "\n");
        fw.write(attenTitles + "\n");
        fw.write(paramNames + "\n");
        SiteDataValue<Object> val = new SiteDataValue<Double>("Vs30", "Inferred", Double.NaN);
        String line = this.getTableValLine(params, val);
        fw.write(line + "\n");
        for (double vs30 = 150.0; vs30 < 1000.0; vs30 += 10.0) {
            val = new SiteDataValue<Double>("Vs30", "Inferred", vs30);
            line = this.getTableValLine(params, val);
            fw.write(line + "\n");
        }
        fw.write(empty + "\n");
        fw.write("Wills Class" + empty.substring(1) + "\n");
        fw.write(attenTitles + "\n");
        fw.write(paramNames + "\n");
        val = new SiteDataValue<String>("Wills Class", "Inferred", "NA");
        line = this.getTableValLine(params, val);
        fw.write(line + "\n");
        for (String wills : SiteTranslator.getSortedWillsValues()) {
            val = new SiteDataValue<String>("Wills Class", "Inferred", wills);
            line = this.getTableValLine(params, val);
            fw.write(line + "\n");
        }
        fw.write(empty + "\n");
        fw.write("Depth to Vs=2.5" + empty.substring(1) + "\n");
        fw.write(attenTitles + "\n");
        fw.write(paramNames + "\n");
        val = new SiteDataValue<Double>("Depth to Vs = 2.5 km/sec", "Inferred", Double.NaN);
        line = this.getTableValLine(params, val);
        fw.write(line + "\n");
        for (double depth2_5 = 0.0; depth2_5 < 3.0; depth2_5 += 0.1) {
            val = new SiteDataValue<Double>("Depth to Vs = 2.5 km/sec", "Inferred", depth2_5);
            line = this.getTableValLine(params, val);
            fw.write(line + "\n");
        }
        fw.write(empty + "\n");
        fw.write("Depth to Vs=1.0" + empty.substring(1) + "\n");
        fw.write(attenTitles + "\n");
        fw.write(paramNames + "\n");
        val = new SiteDataValue<Double>("Depth to Vs = 1.0 km/sec", "Inferred", Double.NaN);
        line = this.getTableValLine(params, val);
        fw.write(line + "\n");
        for (double depth1_0 = 0.0; depth1_0 < 3.0; depth1_0 += 0.1) {
            val = new SiteDataValue<Double>("Depth to Vs = 1.0 km/sec", "Inferred", depth1_0);
            line = this.getTableValLine(params, val);
            fw.write(line + "\n");
        }
        fw.write(empty + "\n");
        fw.close();
    }

    public static void main(String[] args) throws IOException {
        SiteTranslator siteTrans = new SiteTranslator();
        siteTrans.generateConversionTables();
        AttenuationRelationship ar = new AS_1997_AttenRel(null);
        siteTrans.test(ar.getParameter("AS Site Type"));
        ar = new SadighEtAl_1997_AttenRel(null);
        siteTrans.test(ar.getParameter("Sadigh Site Type"));
        ar = new BJF_1997_AttenRel(null);
        siteTrans.test(ar.getParameter("Vs30"));
        ar = new Campbell_1997_AttenRel(null);
        siteTrans.test(ar.getParameter("Campbell Site Type"));
        siteTrans.test(ar.getParameter("Campbell-Basin-Depth"));
        ar = new Field_2000_AttenRel(null);
        siteTrans.test(ar.getParameter("Vs30"));
        siteTrans.test(ar.getParameter("Field-Basin-Depth"));
        ar = new Abrahamson_2000_AttenRel(null);
        siteTrans.test(ar.getParameter("AS Site Type"));
        ar = new CB_2003_AttenRel(null);
        siteTrans.test(ar.getParameter("Campbell-2003 Site Type"));
        ar = new ShakeMap_2003_AttenRel(null);
        siteTrans.test(ar.getParameter("Wills Site Class"));
        ar = new USGS_Combined_2004_AttenRel(null);
        siteTrans.test(ar.getParameter("Vs30"));
    }

    static {
        wills_vs30_map.put(WILLS_B, 1000.0);
        wills_vs30_map.put(WILLS_BC, 760.0);
        wills_vs30_map.put(WILLS_C, 560.0);
        wills_vs30_map.put(WILLS_CD, 360.0);
        wills_vs30_map.put(WILLS_D, 270.0);
        wills_vs30_map.put(WILLS_DE, 180.0);
        wills_vs30_map.put(WILLS_E, Double.NaN);
        DATA_TYPE_PARAM_NAME_MAP = SiteTranslator.createMap();
    }
}

