/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

public class MagHist {
    int[] bins;
    int numBins;
    private double[] binEdges;
    private double minMag;
    private double maxMag;
    private double deltaBin;
    private int overFlows = 0;
    private int underFlows = 0;

    public MagHist() {
    }

    public MagHist(double[] magList, double minMag, double maxMag, double deltaBin) {
        this.setMags(magList, minMag, maxMag, deltaBin);
    }

    public int[] getNumInBins() {
        return this.bins;
    }

    public double[] getBinEdges() {
        return this.binEdges;
    }

    public void setMags(double[] magList, double _minMag, double _maxMag, double _deltaBin) {
        this.minMag = _minMag;
        this.maxMag = _maxMag;
        this.deltaBin = _deltaBin;
        this.numBins = (int)Math.round((this.maxMag - this.minMag) / this.deltaBin);
        this.bins = new int[this.numBins];
        this.binEdges = new double[this.numBins];
        for (int bLoop = 0; bLoop <= this.numBins - 1; ++bLoop) {
            this.binEdges[bLoop] = this.minMag + (double)bLoop * this.deltaBin;
        }
        this.calcHist(magList);
    }

    private void calcHist(double[] magList) {
        int size = magList.length;
        for (int magLoop = 0; magLoop < size; ++magLoop) {
            if (magList[magLoop] < this.minMag) {
                ++this.underFlows;
                continue;
            }
            if (magList[magLoop] > this.maxMag) {
                ++this.overFlows;
                continue;
            }
            int bin = (int)((magList[magLoop] - this.minMag) / this.deltaBin);
            if (bin < 0 || bin >= this.numBins) continue;
            int n = bin;
            this.bins[n] = this.bins[n] + 1;
        }
    }

    public static void main(String[] args) {
        double deltaBin = 0.1;
        double minMag = 3.0;
        double maxMag = 8.0;
        double[] magList = new double[10];
        double startMag = 3.0;
        for (int synMag = 0; synMag < 10; ++synMag) {
            magList[synMag] = startMag;
            startMag += 1.0;
        }
        MagHist hist = new MagHist();
        hist.setMags(magList, minMag, maxMag, deltaBin);
        int[] numInBins = hist.getNumInBins();
        int length = numInBins.length;
        for (int lLoop = 1; lLoop < length; ++lLoop) {
            System.out.println("Number in bins is: " + numInBins[lLoop - 1] + " Lower Bin Edge is: " + hist.getBinEdges()[lLoop - 1]);
        }
    }
}

