/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.opensha.commons.util.FileUtils;
import org.opensha.step.calc.STEP_main;

public class RegionDefaults {
    private static Logger logger = Logger.getLogger(RegionDefaults.class);
    private static final String CONFIG_FILE = "config/defaults.properties";
    public static String INPUT_DIR = "data/mattg_test";
    public static String OUTPUT_DIR = "output";
    public static int GENERIC_MODEL_TYPE = 0;
    public static final int MODEL_FORMAT_CSEP = 1;
    public static final int MODEL_FORMAT_OTHER = 0;
    public static int MODEL_FORMAT = 0;
    public static boolean PARAM_FILE_BY_COMMAND_ARGS = false;
    public static int REGION_CF = 0;
    public static int REGION_NZ = 1;
    public static String paramFilePath = INPUT_DIR + "/CSEP_params.txt";
    public static String cubeFilePath = INPUT_DIR + "/merge_NZ.nts";
    public static String backgroundHazardPath = INPUT_DIR + "/NZDailyHaz_shifted.txt";
    public static String BACKGROUND_RATES_FILE_NAME = INPUT_DIR + "/NZdailyRates_shifted.txt";
    public static String STEP_SORCE_FILE = INPUT_DIR + "/ChCh/Determin6.0.txt";
    public static String outputHazardPath = OUTPUT_DIR + "/STEP_Probs.txt";
    public static String STEP_AftershockObjectFile = OUTPUT_DIR + "/STEP_AftershockObj";
    public static String outputAftershockRatePath = OUTPUT_DIR + "/TimeDepRates.txt";
    public static String forecastStartTimeFile = OUTPUT_DIR + "/forecastStartTime.txt";
    public static String outputHazCurvePath = OUTPUT_DIR + "/HazCurve_Probs.txt";
    public static String outputSTEP_Rates = OUTPUT_DIR + "/STEP_Rates.txt";
    public static double minMagForMainshock = 3.0;
    public static double minForecastMag = 4.0;
    public static double maxForecastMag = 8.0;
    public static double deltaForecastMag = 0.1;
    public static double forecastLengthDays = 1.0;
    public static boolean startForecastAtCurrentTime = true;
    public static GregorianCalendar forecastStartTime;
    public static GregorianCalendar EVENT_START_TIME;
    public static int daysFromQDM_Cat;
    public static double Min_Aftershock_R;
    public static final double searchLatMin_CF = 32.0;
    public static final double searchLatMax_CF = 42.2;
    public static final double searchLongMin_CF = -124.6;
    public static final double searchLongMax_CF = -112.0;
    public static final double searchLatMin_NZ = -42.6;
    public static final double searchLatMax_NZ = -39.6;
    public static final double searchLongMin_NZ = 172.8;
    public static final double searchLongMax_NZ = 175.8;
    public static double searchLatMin;
    public static double searchLatMax;
    public static double searchLongMin;
    public static double searchLongMax;
    public static double gridSpacing;
    public static double gridPrecisionCF;
    public static double gridPrecisionNZ;
    public static double gridPrecision;
    public static double grid_anchor;
    public static double MIN_Z;
    public static double MAX_Z;
    public static double addToMc;
    public static double lowerSeismoDepth;
    public static double upperSeismoDepth;
    public static boolean useFixed_cValue;
    public static int genNumFreeParams;
    public static int seqNumFreeParams;
    public static int spaNumFreeParams;
    public static int minCompareMag;
    public static final double RAKE = 100.0;
    public static final double DIP = 90.0;
    public static boolean useCoulomb;
    public static double bluePercent;
    public static double redPercent;
    public static double coulombFaultRadius;
    public static String coulombFilterPath;
    public static String outputCoulombRatePath;
    public static double minCoulombMS_Mag;
    public static double extFaultLat1;
    public static double extFaultLon1;
    public static double extFaultLat2;
    public static double extFaultLon2;
    public static double extFaultLat3;
    public static double extFaultLon3;
    public static boolean hasExternalFaultModel;
    public static double CUTOFF_DISTANCE;
    public static final int EVENT_SOURCE_FILE = 0;
    public static final int EVENT_SOURCE_GEONET = 1;
    public static final int EVENT_SOURCE_CHINA = 2;
    public static final int EVENT_SOURCE_CSEP = 3;
    public static int EVENT_DATA_SOURCE;
    public static boolean FORECAST_PARAM_FIXED;
    public static double FORECAST_A_VALUE;
    public static double FORECAST_B_VALUE;
    public static double FORECAST_P_VALUE;
    public static double FORECAST_C_VALUE;
    public static String GEONET_QUAKEML_URL;
    public static String DEFAULT_TEST_TIMES;
    public static int DEFAULT_TEST_READ_BACK;
    public static SimpleDateFormat dateformater;
    public static final String PATTERN_SPACE = "[ \t]+";
    public static final double SOURCE_MAX_DEPTH = 40.0;
    public static final double SOURCE_MIN_MAG = 2.5;
    public static boolean SAVE_MODELS;
    public static boolean SAVE_FORECAST_TIME;

    public static synchronized void setBoundary(double minLat, double maxLat, double minLon, double maxLon) {
        searchLatMin = minLat;
        searchLatMax = maxLat;
        searchLongMin = minLon;
        searchLongMax = maxLon;
    }

    public static synchronized void setRegion(int regionNum) {
        if (regionNum == REGION_CF) {
            cubeFilePath = INPUT_DIR + "/merge.nts";
            backgroundHazardPath = INPUT_DIR + "/STEP_backGround.txt";
            BACKGROUND_RATES_FILE_NAME = INPUT_DIR + "/AllCal96ModelDaily.txt";
            gridPrecision = gridPrecisionCF;
            grid_anchor = 0.0;
            RegionDefaults.setBoundary(32.0, 42.2, -124.6, -112.0);
        } else if (regionNum == REGION_NZ) {
            cubeFilePath = INPUT_DIR + "/merge_NZ.nts";
            backgroundHazardPath = INPUT_DIR + "/NZDailyHaz_shifted.txt";
            BACKGROUND_RATES_FILE_NAME = INPUT_DIR + "/NZdailyRates_shifted.txt";
            gridPrecision = gridPrecisionNZ;
            grid_anchor = 0.0;
            RegionDefaults.setBoundary(-42.6, -39.6, 172.8, 175.8);
        }
    }

    public static synchronized void initProperties() {
        dateformater.setTimeZone(TimeZone.getTimeZone("UTC"));
        Properties props = new Properties();
        try {
            System.out.println("CONFIG_FILE=" + new File(CONFIG_FILE).getAbsolutePath());
            props.load(new FileInputStream(CONFIG_FILE));
            INPUT_DIR = props.getProperty("data.dir", "data/mattg_test");
            backgroundHazardPath = INPUT_DIR + "/" + props.getProperty("input.file.bg.haz", "NZDailyHaz_shifted.txt");
            BACKGROUND_RATES_FILE_NAME = INPUT_DIR + "/" + props.getProperty("input.file.bg.rates", "NZdailyRates_shifted.txt");
            OUTPUT_DIR = props.getProperty("output.dir", "output");
            File outputDirectory = new File(OUTPUT_DIR);
            File outputParent = outputDirectory.getParentFile();
            if (outputParent != null && !outputParent.exists()) {
                outputParent.mkdir();
            }
            if (!outputDirectory.exists()) {
                outputDirectory.mkdir();
            }
            logger.info("outputDirectory " + outputDirectory.getAbsolutePath());
            outputHazardPath = OUTPUT_DIR + "/" + props.getProperty("output.file.step.prob", "STEP_Probs.txt");
            STEP_AftershockObjectFile = OUTPUT_DIR + "/" + props.getProperty("output.file.step.aftershock.obj", "STEP_AftershockObj");
            outputHazCurvePath = OUTPUT_DIR + "/" + props.getProperty("output.file.haz.curv.prob", "HazCurve_Probs.txt");
            minMagForMainshock = Double.parseDouble(props.getProperty("min.mag.main", "3.0"));
            minForecastMag = Double.parseDouble(props.getProperty("min.mag.forcast", "4.0"));
            maxForecastMag = Double.parseDouble(props.getProperty("max.mag.forcast", "8.0"));
            deltaForecastMag = Double.parseDouble(props.getProperty("delta.mag.forcast", "0.1"));
            daysFromQDM_Cat = Integer.parseInt(props.getProperty("days.from.qdm", "7.0"));
            Min_Aftershock_R = Double.parseDouble(props.getProperty("min.aftershock.radium", "5.0"));
            gridSpacing = Double.parseDouble(props.getProperty("grid.spacing", "0.1"));
            gridPrecision = Double.parseDouble(props.getProperty("grid.precision", "0.01"));
            grid_anchor = Double.parseDouble(props.getProperty("grid.anchor", "0.0"));
            CUTOFF_DISTANCE = Double.parseDouble(props.getProperty("grid.cutoff", "0.5"));
            searchLatMin = Double.parseDouble(props.getProperty("bg.min.lat", "-47.9"));
            searchLatMax = Double.parseDouble(props.getProperty("bg.max.lat", "-34.1"));
            searchLongMin = Double.parseDouble(props.getProperty("bg.min.lon", "164.1"));
            searchLongMax = Double.parseDouble(props.getProperty("bg.max.lon", "179.9"));
            MODEL_FORMAT = Integer.parseInt(props.getProperty("model.format", "0"));
            SAVE_MODELS = Integer.parseInt(props.getProperty("save.models", "1")) == 1;
            logger.info("SAVE_MODELS " + SAVE_MODELS);
            GENERIC_MODEL_TYPE = Integer.parseInt(props.getProperty("generic.model.type", "0"));
            if (MODEL_FORMAT == 1) {
                PARAM_FILE_BY_COMMAND_ARGS = Integer.parseInt(props.getProperty("params.file.option", "0")) == 1;
                logger.info("PARAM_FILE_BY_COMMAND_ARGS " + PARAM_FILE_BY_COMMAND_ARGS);
                if (!PARAM_FILE_BY_COMMAND_ARGS) {
                    paramFilePath = props.getProperty("model.params.file", INPUT_DIR + "/CSEP_params.txt");
                    RegionDefaults.setCsepParams(paramFilePath);
                }
                outputSTEP_Rates = OUTPUT_DIR + "/" + props.getProperty("output.file.step.rates", "STEP_Rates.txt");
                startForecastAtCurrentTime = false;
                EVENT_DATA_SOURCE = 3;
            } else {
                cubeFilePath = INPUT_DIR + "/" + props.getProperty("input.file.cube", "merge_NZ.nts");
                EVENT_START_TIME = RegionDefaults.parseTime2Cal(props.getProperty("event.start.time"));
                forecastStartTime = RegionDefaults.parseTime2Cal(props.getProperty("forecast.start.time"));
                startForecastAtCurrentTime = Integer.parseInt(props.getProperty("start.forecast.current", "1")) == 1;
                forecastLengthDays = Double.parseDouble(props.getProperty("forecast.len.days", "1.0"));
                outputSTEP_Rates = OUTPUT_DIR + "/" + props.getProperty("output.file.step.rates", "STEP_Rates.txt");
                outputAftershockRatePath = OUTPUT_DIR + "/" + props.getProperty("output.file.time.dep.rates", "TimeDepRates.txt");
                EVENT_DATA_SOURCE = Integer.parseInt(props.getProperty("quake.datasource", "0"));
                GEONET_QUAKEML_URL = props.getProperty("geonet.quake.url", "http://app-dev.geonet.org.nz/services/quake/quakeml/1.0.1/query");
            }
            DEFAULT_TEST_TIMES = props.getProperty("default.test.times");
            DEFAULT_TEST_READ_BACK = Integer.parseInt(props.getProperty("default.test.read.back", "7"));
            FORECAST_PARAM_FIXED = 1 == Integer.parseInt(props.getProperty("forecast.param.fixed", "0"));
            FORECAST_A_VALUE = Double.parseDouble(props.getProperty("a.value", "-1.67"));
            FORECAST_B_VALUE = Double.parseDouble(props.getProperty("b.value", "0.91"));
            FORECAST_P_VALUE = Double.parseDouble(props.getProperty("p.value", "1.08"));
            FORECAST_C_VALUE = Double.parseDouble(props.getProperty("c.value", "0.05"));
            useCoulomb = Boolean.parseBoolean(props.getProperty("cf.useCoulomb", "FALSE"));
            System.out.print(props.getProperty("cf.useCoulomb"));
            logger.info("Use Coulomb = " + useCoulomb);
            bluePercent = Double.parseDouble(props.getProperty("cf.bluePercent", "0.07"));
            redPercent = Double.parseDouble(props.getProperty("cf.redPercent", "0.93"));
            coulombFaultRadius = Double.parseDouble(props.getProperty("cf.coulombFaultRadius", "0"));
            coulombFilterPath = INPUT_DIR + "/" + props.getProperty("cf.coulombFilterFile)", "stress_tst_big.dat");
            outputCoulombRatePath = OUTPUT_DIR + "/" + props.getProperty("cf.outputCoulombRateFile", "coulombRates.txt");
            minCoulombMS_Mag = Double.parseDouble(props.getProperty("cf.minCoulombMS_Mag", "7.0"));
            extFaultLat1 = Double.parseDouble(props.getProperty("cf.extFaultLat1", "-41.07"));
            extFaultLon1 = Double.parseDouble(props.getProperty("cf.extFaultLon1", "175.195"));
            extFaultLat2 = Double.parseDouble(props.getProperty("cf.extFaultLat2", "-41.275"));
            extFaultLon2 = Double.parseDouble(props.getProperty("cf.extFaultLon2", "174.775"));
            extFaultLat3 = Double.parseDouble(props.getProperty("cf.extFaultLat3", "-55"));
            logger.info("extFault = " + extFaultLat3);
            extFaultLon3 = Double.parseDouble(props.getProperty("cf.extFaultLon3", "174.552"));
            hasExternalFaultModel = Boolean.parseBoolean(props.getProperty("cf.hasExternalFaultModel", "FALSE"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setCsepParams(String filePath) throws FileNotFoundException, IOException {
        logger.info(">> setCsepParams filePath " + filePath);
        ArrayList<String> fileLines = FileUtils.loadFile(filePath);
        String line = fileLines.get(0);
        logger.info("catalog start date " + line);
        EVENT_START_TIME = RegionDefaults.parseCsepTime2Cal(line);
        logger.info("EVENT_START_TIME " + dateformater.format(EVENT_START_TIME.getTime()));
        line = fileLines.get(1);
        logger.info("catalog end date " + line);
        forecastStartTime = RegionDefaults.parseCsepTime2Cal(line);
        logger.info("forecastStartTime " + dateformater.format(forecastStartTime.getTime()));
        line = fileLines.get(2);
        logger.info("forecast length " + line);
        forecastLengthDays = Integer.parseInt(line.trim());
        line = fileLines.get(3);
        logger.info("catalog input file " + line);
        cubeFilePath = line;
        line = fileLines.get(4);
        logger.info("forecast output file " + line);
        outputAftershockRatePath = line;
        line = fileLines.get(5);
        logger.info("background rate input file " + line);
        BACKGROUND_RATES_FILE_NAME = line;
        line = fileLines.get(6);
        logger.info("Coulomb input file " + line);
        coulombFilterPath = line;
    }

    private static GregorianCalendar parseCsepTime2Cal(String timestr) {
        String[] dateElements;
        GregorianCalendar cal = null;
        if (timestr != null && (dateElements = timestr.split(PATTERN_SPACE)).length == 6) {
            cal = STEP_main.getCurrentGregorianTime();
            cal.set(5, Integer.parseInt(dateElements[0]));
            cal.set(2, Integer.parseInt(dateElements[1]) - 1);
            cal.set(1, Integer.parseInt(dateElements[2]));
            cal.set(11, Integer.parseInt(dateElements[3]));
            cal.set(12, Integer.parseInt(dateElements[4]));
            cal.set(13, Integer.parseInt(dateElements[5]));
        }
        return cal;
    }

    private static GregorianCalendar parseTime2Cal(String timestr) {
        GregorianCalendar cal;
        if (timestr != null) {
            try {
                Date time = dateformater.parse(timestr);
                cal = STEP_main.getCurrentGregorianTime();
                cal.setTime(time);
            }
            catch (ParseException e) {
                logger.error(e);
                cal = null;
            }
        } else {
            cal = null;
        }
        return cal;
    }

    static {
        daysFromQDM_Cat = 7;
        Min_Aftershock_R = 5.0;
        searchLatMin = -42.6;
        searchLatMax = -39.6;
        searchLongMin = 172.8;
        searchLongMax = 175.8;
        gridSpacing = 0.1;
        gridPrecisionCF = 0.1;
        gridPrecision = gridPrecisionNZ = 0.01;
        grid_anchor = 0.0;
        MIN_Z = 0.0;
        MAX_Z = 40.0;
        addToMc = 0.02;
        lowerSeismoDepth = 10.0;
        upperSeismoDepth = 10.0;
        useFixed_cValue = true;
        genNumFreeParams = 0;
        seqNumFreeParams = 0;
        spaNumFreeParams = 3;
        minCompareMag = 0;
        useCoulomb = true;
        bluePercent = 0.07;
        redPercent = 0.93;
        coulombFaultRadius = 5.1;
        coulombFilterPath = INPUT_DIR + "/stress_tst_big.dat";
        outputCoulombRatePath = OUTPUT_DIR + "/coulombRates.txt";
        minCoulombMS_Mag = 7.0;
        extFaultLat1 = -41.07;
        extFaultLon1 = 175.195;
        extFaultLat2 = -41.275;
        extFaultLon2 = 174.775;
        extFaultLat3 = -41.47;
        extFaultLon3 = 174.552;
        hasExternalFaultModel = false;
        CUTOFF_DISTANCE = 0.5;
        EVENT_DATA_SOURCE = 0;
        FORECAST_PARAM_FIXED = true;
        FORECAST_A_VALUE = -1.59;
        FORECAST_B_VALUE = 1.03;
        FORECAST_P_VALUE = 1.07;
        FORECAST_C_VALUE = 0.04;
        GEONET_QUAKEML_URL = "http://app-dev.geonet.org.nz/services/quake/quakeml/1.0.1/query";
        DEFAULT_TEST_TIMES = "{1}{1}{1,3,7,30,100,300}";
        DEFAULT_TEST_READ_BACK = 7;
        dateformater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        SAVE_MODELS = true;
        SAVE_FORECAST_TIME = true;
        RegionDefaults.initProperties();
    }
}

