/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.region.SitesInGriddedRegion;
import org.opensha.commons.exceptions.RegionConstraintException;
import org.opensha.sha.calc.disaggregation.DisaggregationSourceRuptureInfo;
import org.opensha.sha.earthquake.rupForecastImpl.PointEqkSource;
import org.opensha.sha.imr.ScalarIntensityMeasureRelationshipAPI;
import org.opensha.step.calc.RegionDefaults;
import org.opensha.step.calc.STEP_HazardDataSet;
import org.opensha.step.calc.STEP_main;
import org.opensha.step.calc.StepDisaggregationCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STEP_HazardDataDisaggegate
extends STEP_HazardDataSet {
    public STEP_HazardDataDisaggegate(boolean includeWillsSiteClass) {
        super(includeWillsSiteClass);
    }

    public static void main(String[] args) {
        STEP_HazardDataDisaggegate step = new STEP_HazardDataDisaggegate(false);
        step.runSTEP();
        System.exit(0);
    }

    public void runSTEP() {
        if (this.stepMain == null) {
            this.stepMain = new STEP_main();
        }
        this.stepMain.loadBgGrid();
        this.createShakeMapAttenRelInstance();
        ArrayList<PointEqkSource> sourceList = this.createStepSourcesFromFile();
        String scripts = this.runAggregate(sourceList);
        if (scripts != null) {
            this.saveScript2File(scripts.toString());
        }
    }

    protected String runAggregate(ArrayList<PointEqkSource> sourceList) {
        double MAX_DISTANCE = 500.0;
        SitesInGriddedRegion sites = this.getDefaultRegion();
        try {
            sites.addSiteParams(this.attenRel.getSiteParamsIterator());
            Site site = sites.getSite(0);
            site.setLocation(new Location(-43.5, 172.75));
            this.log("site " + site);
            site.setValue("McVerryetal Site Type", "D-Soft-or-Deep-Soil");
            StepDisaggregationCalculator calculator = new StepDisaggregationCalculator();
            calculator.setNumSourcestoShow(sourceList.size());
            List<DisaggregationSourceRuptureInfo> disaggregatedSourceList = calculator.disaggregate(IML_VALUE, site, (ScalarIntensityMeasureRelationshipAPI)this.attenRel, sourceList, MAX_DISTANCE, null);
            this.log("disaggregatedSourceList" + disaggregatedSourceList.size());
            for (DisaggregationSourceRuptureInfo info : disaggregatedSourceList) {
                this.log(".. " + info.getName() + " " + sourceList.get(info.getId()).getLocation() + " " + info.getRate());
            }
            ArrayList<String> gmtScriptList = calculator.createGMTScriptForDisaggregationPlot(".");
            this.log("GMT script >>>>>> ");
            StringBuffer scripts = new StringBuffer();
            for (String script : gmtScriptList) {
                scripts.append(script).append("\n");
            }
            this.log(scripts.toString());
            return scripts.toString();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (RegionConstraintException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void saveScript2File(String contents) {
        File outoutFile = new File(RegionDefaults.OUTPUT_DIR + "/disaggregate.gmt");
        if (outoutFile.exists()) {
            outoutFile.delete();
        }
        try {
            FileWriter fr = new FileWriter(outoutFile);
            fr.write(contents);
            fr.close();
        }
        catch (IOException ee) {
            ee.printStackTrace();
        }
    }

    private void log(String string) {
        System.out.println(string);
    }
}

