/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.util.Iterator;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.sha.earthquake.griddedForecast.GenericAfterHypoMagFreqDistForecast;
import org.opensha.sha.earthquake.griddedForecast.STEP_AftershockForecast;
import org.opensha.sha.earthquake.griddedForecast.SequenceAfterHypoMagFreqDistForecast;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.SimpleFaultData;

public class SmoothKVal_Calc {
    private STEP_AftershockForecast aftershockModel;
    private GriddedRegion aftershockZone;
    private double global_aVal;
    private double global_bVal;
    private double global_Mc;
    private double mainshockMag;
    private double numInd;
    private double seq_kVal;
    private ObsEqkRupture mainshock;
    private FaultTrace faultTrace;
    private double[] nodeTaperGen_k;
    private double[] nodeTaperSeq_k;
    private double[] nodePerc;
    private int numLocs;

    public void setAftershockModel(GenericAfterHypoMagFreqDistForecast aftershockModel) {
        this.aftershockZone = aftershockModel.getAfterShockZone();
        this.global_aVal = aftershockModel.get_a_valueGeneric();
        this.global_bVal = aftershockModel.get_b_valueGeneric();
        this.global_Mc = aftershockModel.get_genNodeCompletenessMag();
        SimpleFaultData mainshockFault = aftershockModel.get_FaultModel();
        this.mainshock = aftershockModel.getMainShock();
        this.faultTrace = mainshockFault.getFaultTrace();
        this.mainshockMag = this.mainshock.getMag();
        this.setNodePerc();
    }

    public void setAftershockModel(SequenceAfterHypoMagFreqDistForecast aftershockModel) {
        this.aftershockZone = aftershockModel.getAfterShockZone();
        this.global_aVal = aftershockModel.get_aValSequence();
        this.global_bVal = aftershockModel.get_bValSequence();
        this.global_Mc = aftershockModel.getSeqNodeCompletenessMag();
        SimpleFaultData mainshockFault = aftershockModel.get_FaultModel();
        this.mainshock = aftershockModel.getMainShock();
        this.faultTrace = mainshockFault.getFaultTrace();
    }

    private void setNodePerc() {
        int indLoop;
        double sumInvDist = 0.0;
        this.numLocs = this.aftershockZone.getNodeCount();
        double[] nodeDistFromFault = new double[this.numLocs];
        double[] invDist = new double[this.numLocs];
        this.nodePerc = new double[this.numLocs];
        Iterator<Location> it = this.aftershockZone.getNodeList().iterator();
        int ind = 0;
        int numFaultPoints = this.faultTrace.size();
        double totDistFromFault = 0.0;
        while (it.hasNext()) {
            nodeDistFromFault[ind++] = RelativeLocation.getApproxHorzDistToLine(this.faultTrace.getLocationAt(0), this.faultTrace.getLocationAt(numFaultPoints), it.next());
            totDistFromFault += Math.pow(nodeDistFromFault[ind - 1], 2.0);
        }
        for (indLoop = 0; indLoop < this.numLocs; ++indLoop) {
            invDist[indLoop] = totDistFromFault / Math.pow(nodeDistFromFault[indLoop], 2.0);
            sumInvDist += invDist[indLoop];
        }
        for (indLoop = 0; indLoop < ind - 1; ++indLoop) {
            this.nodePerc[indLoop] = invDist[indLoop] / sumInvDist;
        }
        this.numInd = ind;
    }

    public void setSeq_kVal(double seq_kVal) {
        this.seq_kVal = seq_kVal;
        this.calcSeqGrid_kVal();
    }

    private void calcGenGrid_kVal() {
        double rightSide = this.global_aVal + this.global_bVal * (this.mainshockMag - this.global_Mc);
        double generic_k = Math.pow(10.0, rightSide);
        this.nodeTaperGen_k = new double[this.numLocs];
        int indLoop = 0;
        while ((double)indLoop < this.numInd - 1.0) {
            this.nodeTaperGen_k[indLoop] = generic_k * this.nodePerc[indLoop];
            ++indLoop;
        }
    }

    private void calcSeqGrid_kVal() {
        this.nodeTaperSeq_k = new double[this.numLocs];
        int indLoop = 0;
        while ((double)indLoop < this.numInd - 1.0) {
            this.nodeTaperSeq_k[indLoop] = this.seq_kVal * this.nodePerc[indLoop];
            ++indLoop;
        }
    }

    public double[] get_SmoothGen_kVal() {
        this.calcGenGrid_kVal();
        return this.nodeTaperGen_k;
    }

    public double[] get_SmoothSeq_kVal() {
        return this.nodeTaperSeq_k;
    }
}

