/*
 * Decompiled with CFR 0.152.
 */
package xni;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.xerces.parsers.XMLDocumentParser;
import org.apache.xerces.parsers.XMLParser;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xerces.xni.parser.XMLPullParserConfiguration;

public class Writer
extends XMLDocumentParser
implements XMLErrorHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DEFAULT_PARSER_CONFIG = "org.apache.xerces.parsers.IntegratedParserConfiguration";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_CANONICAL = false;
    protected static final boolean DEFAULT_INCREMENTAL = false;
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected int fElementDepth;
    protected boolean fSeenRootElement;

    public Writer(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
        ((XMLParser)this).fConfiguration.setErrorHandler((XMLErrorHandler)this);
    }

    public void setCanonical(boolean bl) {
        this.fCanonical = bl;
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(java.io.Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void startDocument(XMLLocator xMLLocator, String string, Augmentations augmentations) throws XNIException {
        this.fSeenRootElement = false;
        this.fElementDepth = 0;
        if (!this.fCanonical) {
            this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.fOut.flush();
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fSeenRootElement = true;
        ++this.fElementDepth;
        this.fOut.print('<');
        this.fOut.print(qName.rawname);
        if (xMLAttributes != null) {
            int n = xMLAttributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.fOut.print(' ');
                this.fOut.print(xMLAttributes.getQName(n2));
                this.fOut.print("=\"");
                this.normalizeAndPrint(xMLAttributes.getValue(n2));
                this.fOut.print('\"');
                ++n2;
            }
        }
        this.fOut.print('>');
        this.fOut.flush();
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fSeenRootElement = true;
        ++this.fElementDepth;
        this.fOut.print('<');
        this.fOut.print(qName.rawname);
        if (xMLAttributes != null) {
            int n = xMLAttributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.fOut.print(' ');
                this.fOut.print(xMLAttributes.getQName(n2));
                this.fOut.print("=\"");
                this.normalizeAndPrint(xMLAttributes.getValue(n2));
                this.fOut.print('\"');
                ++n2;
            }
        }
        this.fOut.print("/>");
        this.fOut.flush();
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fSeenRootElement) {
            this.fOut.print('\n');
        }
        this.fOut.print("<?");
        this.fOut.print(string);
        if (xMLString != null && xMLString.length > 0) {
            this.fOut.print(' ');
            this.fOut.print(xMLString.toString());
        }
        this.fOut.print("?>");
        if (!this.fSeenRootElement) {
            this.fOut.print('\n');
        }
        this.fOut.flush();
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (!this.fCanonical) {
            if (this.fSeenRootElement && this.fElementDepth == 0) {
                this.fOut.print('\n');
            }
            this.fOut.print("<!--");
            this.fOut.print(xMLString.toString());
            this.fOut.print("-->");
            if (!this.fSeenRootElement) {
                this.fOut.print('\n');
            }
            this.fOut.flush();
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.normalizeAndPrint(xMLString);
        this.fOut.flush();
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.characters(xMLString, augmentations);
        this.fOut.flush();
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        --this.fElementDepth;
        this.fOut.print("</");
        this.fOut.print(qName.rawname);
        this.fOut.print('>');
        this.fOut.flush();
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
    }

    public void processingInstruction(String string, XMLString xMLString) throws XNIException {
        if (this.fSeenRootElement) {
            this.fOut.print('\n');
        }
        this.fOut.print("<?");
        this.fOut.print(string);
        if (xMLString != null && xMLString.length > 0) {
            this.fOut.print(' ');
            this.fOut.print(xMLString.toString());
        }
        this.fOut.print("?>");
        if (!this.fSeenRootElement) {
            this.fOut.print('\n');
        }
        this.fOut.flush();
    }

    public void comment(XMLString xMLString) throws XNIException {
        if (!this.fCanonical) {
            if (this.fSeenRootElement) {
                this.fOut.print('\n');
            }
            this.fOut.print("<!--");
            this.normalizeAndPrint(xMLString);
            this.fOut.print("-->");
            if (!this.fSeenRootElement) {
                this.fOut.print('\n');
            }
            this.fOut.flush();
        }
    }

    public void warning(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Warning", xMLParseException);
    }

    public void error(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Error", xMLParseException);
    }

    public void fatalError(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Fatal Error", xMLParseException);
        throw xMLParseException;
    }

    protected void normalizeAndPrint(String string) {
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.normalizeAndPrint(c);
            ++n2;
        }
    }

    protected void normalizeAndPrint(XMLString xMLString) {
        int n = 0;
        while (n < xMLString.length) {
            this.normalizeAndPrint(xMLString.ch[xMLString.offset + n]);
            ++n;
        }
    }

    protected void normalizeAndPrint(char c) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                this.fOut.print("&quot;");
                break;
            }
            case '\n': 
            case '\r': {
                if (this.fCanonical) {
                    this.fOut.print("&#");
                    this.fOut.print(Integer.toString(c));
                    this.fOut.print(';');
                    break;
                }
            }
            default: {
                this.fOut.print(c);
            }
        }
    }

    protected void printError(String string, XMLParseException xMLParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = xMLParseException.getExpandedSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(xMLParseException.getLineNumber());
        System.err.print(':');
        System.err.print(xMLParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(xMLParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            Writer.printUsage();
            System.exit(1);
        }
        var1_1 = null;
        var2_2 = null;
        var3_3 = true;
        var4_4 = false;
        var5_5 = false;
        var6_6 = false;
        var7_7 = false;
        var8_8 = false;
        var9_9 = 0;
        while (var9_9 < var0.length) {
            block42: {
                var10_10 = var0[var9_9];
                if (!var10_10.startsWith("-")) ** GOTO lbl-1000
                var11_11 = var10_10.substring(1);
                if (var11_11.equals("p")) {
                    if (++var9_9 == var0.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    var12_19 = var0[var9_9];
                    try {
                        var2_2 = (XMLParserConfiguration)ObjectFactory.newInstance((String)var12_19, (ClassLoader)ObjectFactory.findClassLoader(), (boolean)true);
                        var1_1 = null;
                    }
                    catch (Exception var13_23) {
                        var2_2 = null;
                        System.err.println("error: Unable to instantiate parser configuration (" + var12_19 + ")");
                        var13_23.printStackTrace(System.err);
                    }
                } else if (var11_11.equalsIgnoreCase("n")) {
                    var3_3 = var11_11.equals("n");
                } else if (var11_11.equalsIgnoreCase("v")) {
                    var4_4 = var11_11.equals("v");
                } else if (var11_11.equalsIgnoreCase("s")) {
                    var5_5 = var11_11.equals("s");
                } else if (var11_11.equalsIgnoreCase("f")) {
                    var6_6 = var11_11.equals("f");
                } else if (var11_11.equalsIgnoreCase("c")) {
                    var7_7 = var11_11.equals("c");
                } else if (var11_11.equalsIgnoreCase("i")) {
                    var8_8 = var11_11.equals("i");
                } else if (var11_11.equals("h")) {
                    Writer.printUsage();
                } else lbl-1000:
                // 2 sources

                {
                    block44: {
                        block43: {
                            if (var2_2 == null) {
                                try {
                                    var2_2 = (XMLParserConfiguration)ObjectFactory.newInstance((String)"org.apache.xerces.parsers.IntegratedParserConfiguration", (ClassLoader)ObjectFactory.findClassLoader(), (boolean)true);
                                }
                                catch (Exception var11_12) {
                                    System.err.println("error: Unable to instantiate parser configuration (org.apache.xerces.parsers.IntegratedParserConfiguration)");
                                    var11_12.printStackTrace(System.err);
                                    break block42;
                                }
                            }
                            if (var1_1 == null) {
                                var1_1 = new Writer(var2_2);
                            }
                            try {
                                var2_2.setFeature("http://xml.org/sax/features/namespaces", var3_3);
                            }
                            catch (XMLConfigurationException var11_13) {
                                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                            }
                            try {
                                var2_2.setFeature("http://xml.org/sax/features/validation", var4_4);
                            }
                            catch (XMLConfigurationException var11_14) {
                                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                            }
                            try {
                                var2_2.setFeature("http://apache.org/xml/features/validation/schema", var5_5);
                            }
                            catch (XMLConfigurationException var11_15) {
                                if (var11_15.getType() != 1) break block43;
                                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                            }
                        }
                        try {
                            var2_2.setFeature("http://apache.org/xml/features/validation/schema-full-checking", var6_6);
                        }
                        catch (XMLConfigurationException var11_16) {
                            if (var11_16.getType() != 1) break block44;
                            System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                        }
                    }
                    try {
                        var1_1.setOutput(System.out, "UTF8");
                    }
                    catch (UnsupportedEncodingException var11_17) {
                        System.err.println("error: Unable to set output. Exiting.");
                        System.exit(1);
                    }
                    var1_1.setCanonical(var7_7);
                    try {
                        if (var8_8 && var2_2 instanceof XMLPullParserConfiguration) {
                            var11_11 = (XMLPullParserConfiguration)var2_2;
                            var11_11.setInputSource(new XMLInputSource(null, var10_10, null));
                            var12_20 = true;
                            while (var11_11.parse(false)) {
                            }
                        } else {
                            var1_1.parse(new XMLInputSource(null, var10_10, null));
                        }
                    }
                    catch (XMLParseException var11_18) {
                    }
                    catch (Exception var12_21) {
                        System.err.println("error: Parse error occurred - " + var12_21.getMessage());
                        if (var12_21 instanceof XNIException) {
                            var12_22 = ((XNIException)var12_21).getException();
                        }
                        var12_22.printStackTrace(System.err);
                    }
                }
            }
            ++var9_9;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java sax.Writer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Select parser configuration by name.");
        System.err.println("  -n | -N  Turn on/off namespace processing.");
        System.err.println("  -v | -V  Turn on/off validation.");
        System.err.println("  -s | -S  Turn on/off Schema validation support.");
        System.err.println("           NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F Turn on/off Schema full checking.");
        System.err.println("           NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -i | -I  Incremental mode.");
        System.err.println("           NOTE: This feature only works if the configuration used");
        System.err.println("                 implements XMLPullParserConfiguration.");
        System.err.println("  -h       This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Config:     org.apache.xerces.parsers.IntegratedParserConfiguration");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Incremental:  ");
        System.err.println("off");
    }
}

