/*
 * Decompiled with CFR 0.152.
 */
package nz.org.geonet.quakeml.v1_0_1.client;

import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.XMLGregorianCalendar;
import nz.org.geonet.quakeml.v1_0_1.domain.Arrival;
import nz.org.geonet.quakeml.v1_0_1.domain.Event;
import nz.org.geonet.quakeml.v1_0_1.domain.Magnitude;
import nz.org.geonet.quakeml.v1_0_1.domain.Origin;
import nz.org.geonet.quakeml.v1_0_1.domain.Pick;
import nz.org.geonet.quakeml.v1_0_1.domain.Quakeml;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuakemlUtils {
    public static Event getFirstEvent(Quakeml quakeml) {
        try {
            return quakeml.getEventParameters().getEvent().get(0);
        }
        catch (NullPointerException npe) {
            Logger.getLogger(QuakemlUtils.class.getName()).log(Level.WARNING, "Either quakeml, EventParameters, or List<Event> is null.");
        }
        catch (IndexOutOfBoundsException iobe) {
            Logger.getLogger(QuakemlUtils.class.getName()).log(Level.WARNING, "Event list is empty.");
        }
        return null;
    }

    public static Origin getPreferredOrigin(Event event) {
        String preferredOriginId = event.getPreferredOriginID();
        if (preferredOriginId == null) {
            Logger.getLogger(QuakemlUtils.class.getName()).log(Level.WARNING, "Event does not have preferredOriginID set.");
            return null;
        }
        return QuakemlUtils.getSingleOriginFromSingleEventByOriginPublicId(event, preferredOriginId);
    }

    public static Magnitude getPreferredMagnitude(Event event) {
        String preferredMagnitudeId = event.getPreferredMagnitudeID();
        if (preferredMagnitudeId == null) {
            Logger.getLogger(QuakemlUtils.class.getName()).log(Level.WARNING, "Event does not have preferredMagnitudeId set.");
            return null;
        }
        return QuakemlUtils.getSingleMagnitudeFromSingleEventByMagnitudePublicId(event, preferredMagnitudeId);
    }

    public static DateTime getOriginTime(Origin origin) {
        try {
            XMLGregorianCalendar xmlcal = origin.getTime().getValue();
            DateTime dt = new DateTime(xmlcal.getYear(), xmlcal.getMonth(), xmlcal.getDay(), xmlcal.getHour(), xmlcal.getMinute(), xmlcal.getSecond(), xmlcal.getMillisecond(), DateTimeZone.forTimeZone((TimeZone)xmlcal.getTimeZone(0)));
            return dt;
        }
        catch (NullPointerException npe) {
            Logger.getLogger(QuakemlUtils.class.getName()).log(Level.WARNING, "Either origin or time is null.");
            return null;
        }
    }

    public static Pick getPickAssociatedWithArrival(List<Pick> allPicksAssociatedWithAnEvent, Arrival arrival) {
        String pickId = arrival.getPickID();
        if (pickId != null) {
            for (Pick pick : allPicksAssociatedWithAnEvent) {
                if (!pick.getPublicID().equals(pickId)) continue;
                return pick;
            }
        }
        return null;
    }

    public static Origin getSingleOriginFromSingleEventByOriginPublicId(Event event, String originID) {
        List<Origin> origins = event.getOrigin();
        for (Origin origin : origins) {
            String publicID = origin.getPublicID();
            if (publicID == null || !publicID.equals(originID)) continue;
            return origin;
        }
        Logger.getLogger(QuakemlUtils.class.getName()).log(Level.WARNING, "No Origin found with publicID" + originID);
        return null;
    }

    private static Magnitude getSingleMagnitudeFromSingleEventByMagnitudePublicId(Event event, String magnitudeID) {
        List<Magnitude> magnitudes = event.getMagnitude();
        for (Magnitude magnitude : magnitudes) {
            String publicID = magnitude.getPublicID();
            if (publicID == null || !publicID.equals(magnitudeID)) continue;
            return magnitude;
        }
        Logger.getLogger(QuakemlUtils.class.getName()).log(Level.WARNING, "No magnitude found with publicID" + magnitudeID);
        return null;
    }
}

