/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.calc;

import java.text.DecimalFormat;
import org.opensha.data.function.EvenlyDiscretizedFunc;

public final class GaussianDistCalc {
    static double d1 = 0.049867347;
    static double d2 = 0.0211410061;
    static double d3 = 0.0032776263;
    static double d4 = 3.80036E-5;
    static double d5 = 4.88906E-5;
    static double d6 = 5.383E-6;

    public static double getExceedProb(double standRandVariable) {
        return 1.0 - GaussianDistCalc.getCDF(standRandVariable);
    }

    public static double getExceedProb(double standRandVariable, int truncType, double truncLevel) {
        if (truncType == 2) {
            if (truncLevel <= 0.0) {
                throw new RuntimeException("GaussianDistCalc.getExceedProb(): truncLevel must be greater than zero for truncType=2");
            }
        } else if (truncLevel < 0.0) {
            throw new RuntimeException("GaussianDistCalc.getExceedProb(): truncLevel cannot be negative");
        }
        double prob = GaussianDistCalc.getCDF(standRandVariable);
        if (truncType == 1) {
            if (standRandVariable > truncLevel) {
                return 0.0;
            }
            double pUp = GaussianDistCalc.getCDF(truncLevel);
            return 1.0 - prob / pUp;
        }
        if (truncType == 2) {
            if (standRandVariable > truncLevel) {
                return 0.0;
            }
            if (standRandVariable < -truncLevel) {
                return 1.0;
            }
            double pUp = GaussianDistCalc.getCDF(truncLevel);
            double pLow = GaussianDistCalc.getCDF(-truncLevel);
            return (pUp - prob) / (pUp - pLow);
        }
        if (truncType == 0) {
            return 1.0 - prob;
        }
        throw new RuntimeException("GaussianDistCalc.getExceedProb(): truncType must be 0, 1, or 2");
    }

    public static double getExceedProb(double standRandVariable, double lowerTruncLevel, double upperTruncLevel) {
        if (lowerTruncLevel >= upperTruncLevel) {
            throw new RuntimeException("GaussianDistCalc.getExceedProb(): lowerTruncLevel should be less than upperTruncLevel");
        }
        double prob = GaussianDistCalc.getCDF(standRandVariable);
        if (standRandVariable > upperTruncLevel) {
            return 0.0;
        }
        if (standRandVariable < lowerTruncLevel) {
            return 1.0;
        }
        double pUp = GaussianDistCalc.getCDF(upperTruncLevel);
        double pLow = GaussianDistCalc.getCDF(lowerTruncLevel);
        return (pUp - prob) / (pUp - pLow);
    }

    public static double getCDF(double standRandVariable) {
        double val = Math.abs(standRandVariable);
        double result = 0.5 * Math.pow((((((d6 * val + d5) * val + d4) * val + d3) * val + d2) * val + d1) * val + 1.0, -16.0);
        if (standRandVariable < 0.0) {
            return result;
        }
        return 1.0 - result;
    }

    public static double getStandRandVar(double exceedProb, int truncType, double truncLevel, double tolerance) {
        float delta = 1.0f;
        double testNum = 100.0;
        double oldNum = 0.0;
        double prob = 100.0;
        if (tolerance < 1.0E-6 || tolerance > 0.1) {
            throw new RuntimeException("GaussianDistCalc.getStandRandVar(): tolerance is not within the allowed range");
        }
        if (exceedProb <= 0.5 && exceedProb > 0.0) {
            oldNum = -3.0;
            do {
                testNum = oldNum;
                while ((prob = GaussianDistCalc.getExceedProb(testNum += (double)delta, truncType, truncLevel)) >= exceedProb + tolerance * exceedProb) {
                }
                oldNum = testNum - (double)delta;
                delta /= 10.0f;
            } while (testNum - oldNum > tolerance);
            return testNum;
        }
        if (exceedProb > 0.5 && exceedProb < 1.0) {
            oldNum = 1.0;
            do {
                testNum = oldNum;
                while ((prob = GaussianDistCalc.getExceedProb(testNum -= (double)delta, truncType, truncLevel)) <= exceedProb - tolerance * exceedProb) {
                }
                oldNum = testNum + (double)delta;
                delta /= 10.0f;
            } while (oldNum - testNum > tolerance);
            return testNum;
        }
        if (exceedProb == 0.0) {
            if (truncType == 0) {
                return Double.POSITIVE_INFINITY;
            }
            return truncLevel;
        }
        if (exceedProb == 1.0) {
            if (truncType != 2) {
                return Double.NEGATIVE_INFINITY;
            }
            return -truncLevel;
        }
        throw new RuntimeException("invalid exceed probability (prob=" + exceedProb + ")");
    }

    public static double getStandRandVar(double exceedProb, double lowerTruncLevel, double upperTruncLevel, double tolerance) {
        if (lowerTruncLevel >= 0.0) {
            throw new RuntimeException("GaussianDistCalc.getStandRandVar(): lowerTruncLevel should be < 0");
        }
        if (upperTruncLevel < 0.0) {
            throw new RuntimeException("GaussianDistCalc.getStandRandVar(): upperTruncLevel should be \u2265 0");
        }
        float delta = 1.0f;
        double testNum = 100.0;
        double oldNum = 0.0;
        double prob = 100.0;
        if (tolerance < 1.0E-6 || tolerance > 0.1) {
            throw new RuntimeException("GaussianDistCalc.getStandRandVar(): tolerance is not within the allowed range");
        }
        if (exceedProb <= 0.5 && exceedProb > 0.0) {
            oldNum = -3.0;
            do {
                testNum = oldNum;
                while ((prob = GaussianDistCalc.getExceedProb(testNum += (double)delta, lowerTruncLevel, upperTruncLevel)) >= exceedProb + tolerance * exceedProb) {
                }
                oldNum = testNum - (double)delta;
                delta /= 10.0f;
            } while (testNum - oldNum > tolerance);
            return testNum;
        }
        if (exceedProb > 0.5 && exceedProb < 1.0) {
            oldNum = 1.0;
            do {
                testNum = oldNum;
                while ((prob = GaussianDistCalc.getExceedProb(testNum -= (double)delta, lowerTruncLevel, upperTruncLevel)) <= exceedProb - tolerance * exceedProb) {
                }
                oldNum = testNum + (double)delta;
                delta /= 10.0f;
            } while (oldNum - testNum > tolerance);
            return testNum;
        }
        if (exceedProb == 0.0) {
            return upperTruncLevel;
        }
        if (exceedProb == 1.0) {
            return lowerTruncLevel;
        }
        throw new RuntimeException("invalid exceed probability (prob=" + exceedProb + ")");
    }

    public static void test_getCDF() {
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(-7.5, 151, 0.1);
        func.setTolerance(1.0E-5);
        func.set(-7.5, 3.0E-14);
        func.set(-7.4, 7.0E-14);
        func.set(-7.3, 1.4E-13);
        func.set(-7.2, 3.0E-13);
        func.set(-7.1, 6.3E-13);
        func.set(-7.0, 1.29E-12);
        func.set(-6.9, 2.62E-12);
        func.set(-6.8, 5.26E-12);
        func.set(-6.7, 1.048E-11);
        func.set(-6.6, 2.067E-11);
        func.set(-6.5, 4.036E-11);
        func.set(-6.4, 7.805E-11);
        func.set(-6.3, 1.4947E-10);
        func.set(-6.2, 2.8347E-10);
        func.set(-6.1, 5.3238E-10);
        func.set(-6.0, 9.9012E-10);
        func.set(-5.9, 1.82358E-9);
        func.set(-5.8, 3.32605E-9);
        func.set(-5.7, 6.00765E-9);
        func.set(-5.6, 1.074622E-8);
        func.set(-5.5, 1.90364E-8);
        func.set(-5.4, 3.339612E-8);
        func.set(-5.3, 5.802207E-8);
        func.set(-5.2, 9.98344E-8);
        func.set(-5.1, 1.7012231E-7);
        func.set(-5.0, 2.87105E-7);
        func.set(-4.9, 4.7986955E-7);
        func.set(-4.8, 7.9435267E-7);
        func.set(-4.7, 1.30231565E-6);
        func.set(-4.6, 2.11464338E-6);
        func.set(-4.5, 3.40080306E-6);
        func.set(-4.4, 5.41695305E-6);
        func.set(-4.3, 8.54602119E-6);
        func.set(-4.2, 1.335409733E-5);
        func.set(-4.1, 2.066871577E-5);
        func.set(-4.0, 3.168603461E-5);
        func.set(-3.9, 4.811551887E-5);
        func.set(-3.8, 7.237243427E-5);
        func.set(-3.7, 1.0783014541E-4);
        func.set(-3.6, 1.5914571377E-4);
        func.set(-3.5, 2.3267337367E-4);
        func.set(-3.4, 3.3698082293E-4);
        func.set(-3.3, 4.8348253664E-4);
        func.set(-3.2, 6.8720208079E-4);
        func.set(-3.1, 9.676712356E-4);
        func.set(-3.0, 0.00134996722324);
        func.set(-2.9, 0.00186588014039);
        func.set(-2.8, 0.00255519064153);
        func.set(-2.7, 0.00346702305311);
        func.set(-2.6, 0.00466122178265);
        func.set(-2.5, 0.00620967985875);
        func.set(-2.4, 0.00819752886943);
        func.set(-2.3, 0.01072408105972);
        func.set(-2.2, 0.01390339890832);
        func.set(-2.1, 0.01786435741803);
        func.set(-2.0, 0.02275006203619);
        func.set(-1.9, 0.02871649286457);
        func.set(-1.8, 0.03593026551383);
        func.set(-1.7, 0.04456543178248);
        func.set(-1.6, 0.05479928945388);
        func.set(-1.5, 0.06680722879345);
        func.set(-1.4, 0.0807567112563);
        func.set(-1.3, 0.09680054949574);
        func.set(-1.2, 0.11506973171771);
        func.set(-1.1, 0.13566610150762);
        func.set(-1.0, 0.158655259759);
        func.set(-0.9, 0.18406009173192);
        func.set(-0.8, 0.21185533393828);
        func.set(-0.7, 0.24196357848479);
        func.set(-0.6, 0.27425306493856);
        func.set(-0.5, 0.30853753263572);
        func.set(-0.4, 0.34457830341314);
        func.set(-0.3, 0.38208864252738);
        func.set(-0.2, 0.42074031283329);
        func.set(-0.1, 0.46017210446634);
        func.set(0.0, 0.5);
        func.set(0.1, 0.53982789553366);
        func.set(0.2, 0.57925968716672);
        func.set(0.3, 0.61791135747262);
        func.set(0.4, 0.65542169658687);
        func.set(0.5, 0.69146246736428);
        func.set(0.6, 0.72574693506144);
        func.set(0.7, 0.75803642151521);
        func.set(0.8, 0.78814466606172);
        func.set(0.9, 0.81593990826808);
        func.set(1.0, 0.841344740241);
        func.set(1.1, 0.86433389849238);
        func.set(1.2, 0.88493026828229);
        func.set(1.3, 0.90319945050426);
        func.set(1.4, 0.9192432887437);
        func.set(1.5, 0.93319277120655);
        func.set(1.6, 0.94520071054612);
        func.set(1.7, 0.95543456821752);
        func.set(1.8, 0.96406973448618);
        func.set(1.9, 0.97128350713543);
        func.set(2.0, 0.97724993796381);
        func.set(2.1, 0.98213564258197);
        func.set(2.2, 0.98609660109168);
        func.set(2.3, 0.98927591894028);
        func.set(2.4, 0.99180247113057);
        func.set(2.5, 0.99379032014125);
        func.set(2.6, 0.99533877821735);
        func.set(2.7, 0.99653297694689);
        func.set(2.8, 0.99744480935848);
        func.set(2.9, 0.99813411985961);
        func.set(3.0, 0.99865003277676);
        func.set(3.1, 0.9990323287644);
        func.set(3.2, 0.99931279791921);
        func.set(3.3, 0.99951651746336);
        func.set(3.4, 0.99966301917707);
        func.set(3.5, 0.99976732662633);
        func.set(3.6, 0.99984085428623);
        func.set(3.7, 0.99989216985459);
        func.set(3.8, 0.99992762756573);
        func.set(3.9, 0.99995188448114);
        func.set(4.0, 0.99996831396539);
        func.set(4.1, 0.99997933128423);
        func.set(4.2, 0.99998664590267);
        func.set(4.3, 0.99999145397881);
        func.set(4.4, 0.99999458304695);
        func.set(4.5, 0.99999659919694);
        func.set(4.6, 0.99999788535662);
        func.set(4.7, 0.99999869768435);
        func.set(4.8, 0.99999920564733);
        func.set(4.9, 0.99999952013045);
        func.set(5.0, 0.999999712895);
        func.set(5.1, 0.99999982987769);
        func.set(5.2, 0.9999999001656);
        func.set(5.3, 0.99999994197793);
        func.set(5.4, 0.99999996660388);
        func.set(5.5, 0.9999999809636);
        func.set(5.6, 0.99999998925378);
        func.set(5.7, 0.99999999399235);
        func.set(5.8, 0.99999999667395);
        func.set(5.9, 0.99999999817642);
        func.set(6.0, 0.99999999900988);
        func.set(6.1, 0.99999999946763);
        func.set(6.2, 0.99999999971653);
        func.set(6.3, 0.99999999985053);
        func.set(6.4, 0.99999999992195);
        func.set(6.5, 0.99999999995964);
        func.set(6.6, 0.99999999997934);
        func.set(6.7, 0.99999999998952);
        func.set(6.8, 0.99999999999474);
        func.set(6.9, 0.99999999999738);
        func.set(7.0, 0.99999999999871);
        func.set(7.1, 0.99999999999937);
        func.set(7.2, 0.9999999999997);
        func.set(7.3, 0.99999999999986);
        func.set(7.4, 0.99999999999993);
        func.set(7.5, 0.99999999999997);
        for (int i = 0; i < func.getNum(); ++i) {
            double x = func.getX(i);
            double y = func.getY(i);
            double y_computed = GaussianDistCalc.getCDF(x);
            System.out.println("SRV = " + (float)x + "; Computed Prob = " + y_computed + ";  Ratio = " + y_computed / y);
        }
    }

    public static boolean test1_getStandRandVar(double tol, int trTyp, double trLev) {
        double val_incr = 0.1;
        boolean success = true;
        DecimalFormat df2 = new DecimalFormat("#.0000");
        for (double val = -7.5; val <= 7.5; val += val_incr) {
            boolean testB;
            double p3;
            boolean testA;
            double n1 = (double)((int)(val * 10.0)) / 10.0;
            double p = GaussianDistCalc.getExceedProb(n1, trTyp, trLev);
            double n2 = GaussianDistCalc.getStandRandVar(p, trTyp, trLev, tol);
            double p2 = GaussianDistCalc.getExceedProb(n2, trTyp, trLev);
            if (p != 0.0) {
                testA = Math.abs((p - p2) / p) < tol;
            } else {
                boolean bl = testA = p2 == 0.0;
            }
            if (p > 0.5) {
                p3 = GaussianDistCalc.getExceedProb(n2 + tol, trTyp, trLev);
                testB = (p - p3) / p > tol;
            } else {
                p3 = GaussianDistCalc.getExceedProb(n2 - tol, trTyp, trLev);
                boolean bl = testB = (p3 - p) / p > tol;
            }
            if (p == 1.0 && trTyp == 2) {
                testB = true;
            }
            if (testA && testB) continue;
            success = false;
            System.out.println("n1=" + n1 + ";  p=" + p + ";  n2=" + n2 + ";  p2=" + p2 + ";  p3=" + p3 + ";  testA=" + testA + ";  testB=" + testB);
        }
        System.out.println("Success=" + success + " with tol=" + tol + " trTyp=" + trTyp + " & trLev=" + trLev);
        return success;
    }

    public static void test2_getStandRandVar() {
        GaussianDistCalc.test1_getStandRandVar(0.1, 0, 2.0);
        GaussianDistCalc.test1_getStandRandVar(0.1, 1, 0.0);
        GaussianDistCalc.test1_getStandRandVar(0.1, 1, 0.5);
        GaussianDistCalc.test1_getStandRandVar(0.1, 1, 1.5);
        GaussianDistCalc.test1_getStandRandVar(0.1, 1, 2.5);
        GaussianDistCalc.test1_getStandRandVar(0.1, 1, 3.5);
        GaussianDistCalc.test1_getStandRandVar(0.1, 2, 0.5);
        GaussianDistCalc.test1_getStandRandVar(0.1, 2, 1.5);
        GaussianDistCalc.test1_getStandRandVar(0.1, 2, 2.5);
        GaussianDistCalc.test1_getStandRandVar(0.1, 2, 3.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 0, 2.0);
        GaussianDistCalc.test1_getStandRandVar(0.01, 1, 0.0);
        GaussianDistCalc.test1_getStandRandVar(0.01, 1, 0.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 1, 1.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 1, 2.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 1, 3.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 2, 0.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 2, 1.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 2, 2.5);
        GaussianDistCalc.test1_getStandRandVar(0.01, 2, 3.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 0, 2.0);
        GaussianDistCalc.test1_getStandRandVar(0.001, 1, 0.0);
        GaussianDistCalc.test1_getStandRandVar(0.001, 1, 0.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 1, 1.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 1, 2.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 1, 3.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 2, 0.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 2, 1.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 2, 2.5);
        GaussianDistCalc.test1_getStandRandVar(0.001, 2, 3.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 0, 2.0);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 1, 0.0);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 1, 0.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 1, 1.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 1, 2.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 1, 3.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 2, 0.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 2, 1.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 2, 2.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-4, 2, 3.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 0, 2.0);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 1, 0.0);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 1, 0.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 1, 1.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 1, 2.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 1, 3.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 2, 0.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 2, 1.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 2, 2.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-5, 2, 3.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 0, 2.0);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 1, 0.0);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 1, 0.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 1, 1.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 1, 2.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 1, 3.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 2, 0.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 2, 1.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 2, 2.5);
        GaussianDistCalc.test1_getStandRandVar(1.0E-6, 2, 3.5);
    }

    public static void testSpeed_getStandRandVar() {
        System.out.println("starting tol=1e-1");
        int i = 0;
        while ((double)i < 100000.0) {
            GaussianDistCalc.getStandRandVar(0.2, 0, 2.0, 0.1);
            ++i;
        }
        System.out.println("done");
        System.out.println("starting tol=1e-2");
        i = 0;
        while ((double)i < 100000.0) {
            GaussianDistCalc.getStandRandVar(0.2, 0, 2.0, 0.01);
            ++i;
        }
        System.out.println("done");
        System.out.println("starting tol=1e-3");
        i = 0;
        while ((double)i < 100000.0) {
            GaussianDistCalc.getStandRandVar(0.2, 0, 2.0, 0.001);
            ++i;
        }
        System.out.println("done");
        System.out.println("starting tol=1e-4");
        i = 0;
        while ((double)i < 100000.0) {
            GaussianDistCalc.getStandRandVar(0.2, 0, 2.0, 1.0E-4);
            ++i;
        }
        System.out.println("done");
        System.out.println("starting tol=1e-5");
        i = 0;
        while ((double)i < 100000.0) {
            GaussianDistCalc.getStandRandVar(0.2, 0, 2.0, 1.0E-5);
            ++i;
        }
        System.out.println("done");
        System.out.println("starting tol=1e-6");
        i = 0;
        while ((double)i < 100000.0) {
            GaussianDistCalc.getStandRandVar(0.2, 0, 2.0, 1.0E-6);
            ++i;
        }
        System.out.println("done");
    }

    public static void test_symmetry_getStandRandVar() {
        DecimalFormat df2 = new DecimalFormat("#.00");
        for (double prob = 0.1; prob >= 1.0E-7; prob /= 10.0) {
            for (double t = 0.1; t >= 1.0E-6; t /= 10.0) {
                System.out.println("getStandRandVar(" + (float)prob + ",0,2," + (float)t + ") = " + df2.format(GaussianDistCalc.getStandRandVar(prob, 0, 2.0, t)));
                System.out.println("getStandRandVar(" + (float)(1.0 - prob) + ",0,2," + (float)t + ") = " + df2.format(GaussianDistCalc.getStandRandVar(1.0 - prob, 0, 2.0, t)));
            }
            System.out.println("  ");
        }
    }

    public static void main(String[] args) {
        System.out.println(GaussianDistCalc.getCDF(Double.NEGATIVE_INFINITY));
        System.out.println(GaussianDistCalc.getCDF(Double.POSITIVE_INFINITY));
    }
}

