/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.opensha.data.DataPoint2D;
import org.opensha.data.DataPoint2DComparatorAPI;
import org.opensha.data.DataPoint2DToleranceComparator;
import org.opensha.data.DataPoint2DTreeMap;
import org.opensha.data.function.DiscretizedFunc;
import org.opensha.data.function.DiscretizedFuncAPI;
import org.opensha.exceptions.DataPoint2DException;
import org.opensha.exceptions.InvalidRangeException;

public class ArbitrarilyDiscretizedFunc
extends DiscretizedFunc
implements Serializable {
    protected static final String C = "ArbitrarilyDiscretizedFunc";
    protected static final boolean D = true;
    protected DataPoint2DTreeMap points = null;
    private static String TAB = "\t";

    public ArbitrarilyDiscretizedFunc(Comparator comparator) {
        if (!(comparator instanceof DataPoint2DComparatorAPI)) {
            throw new DataPoint2DException("Comparator must implement DataPoint2DComparatorAPI");
        }
        this.points = new DataPoint2DTreeMap(comparator);
    }

    public ArbitrarilyDiscretizedFunc(DataPoint2DComparatorAPI comparator) {
        this.points = new DataPoint2DTreeMap(comparator);
    }

    public ArbitrarilyDiscretizedFunc(double toleranace) {
        DataPoint2DToleranceComparator comparator = new DataPoint2DToleranceComparator();
        comparator.setTolerance(this.tolerance);
        this.points = new DataPoint2DTreeMap(comparator);
    }

    public ArbitrarilyDiscretizedFunc() {
        this.points = new DataPoint2DTreeMap();
    }

    public void setTolerance(double newTolerance) throws InvalidRangeException {
        if (newTolerance < 0.0) {
            throw new InvalidRangeException("Tolerance must be larger or equal to 0");
        }
        this.tolerance = newTolerance;
        this.points.setTolerance(newTolerance);
    }

    public int getNum() {
        return this.points.size();
    }

    public double getMinX() {
        return ((DataPoint2D)this.points.firstKey()).getX();
    }

    public double getMaxX() {
        return ((DataPoint2D)this.points.lastKey()).getX();
    }

    public double getMinY() {
        return this.points.getMinY();
    }

    public double getMaxY() {
        return this.points.getMaxY();
    }

    public DataPoint2D get(int index) {
        return this.points.get(index);
    }

    public double getX(int index) {
        return this.get(index).getX();
    }

    public double getY(int index) {
        return this.get(index).getY();
    }

    public double getY(double x) {
        return this.points.get(x).getY();
    }

    public int getIndex(DataPoint2D point) {
        return this.points.getIndex(point);
    }

    public int getXIndex(double x) {
        return this.points.getIndex(new DataPoint2D(x, 0.0));
    }

    public void set(DataPoint2D point) throws DataPoint2DException {
        this.points.put(point);
    }

    public void set(double x, double y) throws DataPoint2DException {
        this.set(new DataPoint2D(x, y));
    }

    public void set(int index, double y) throws DataPoint2DException {
        DataPoint2D point = this.get(index);
        if (point != null) {
            point.setY(y);
            this.set(point);
        }
    }

    public boolean hasPoint(DataPoint2D point) {
        int index = this.getIndex(point);
        return index >= 0;
    }

    public boolean hasPoint(double x, double y) {
        return this.hasPoint(new DataPoint2D(x, y));
    }

    public Iterator getPointsIterator() {
        Set keys = this.points.keySet();
        if (keys != null) {
            return keys.iterator();
        }
        return null;
    }

    public ListIterator getXValuesIterator() {
        ArrayList<Double> list = new ArrayList<Double>();
        int max = this.points.size();
        for (int i = 0; i < max; ++i) {
            list.add(new Double(this.getX(i)));
        }
        return list.listIterator();
    }

    public ListIterator getYValuesIterator() {
        ArrayList<Double> list = new ArrayList<Double>();
        int max = this.points.size();
        for (int i = 0; i < max; ++i) {
            list.add(new Double(this.getY(i)));
        }
        return list.listIterator();
    }

    public double getFirstInterpolatedX(double y) {
        int i;
        int max = this.points.size();
        if (max == 1 && y == this.getY(0)) {
            return this.getX(0);
        }
        double y1 = Double.NaN;
        double y2 = Double.NaN;
        boolean found = false;
        for (i = 0; i < max - 1; ++i) {
            y1 = this.getY(i);
            y2 = this.getY(i + 1);
            if (!(y <= y1 && y >= y2 && y2 <= y1) && (!(y >= y1) || !(y <= y2) || !(y2 >= y1))) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new InvalidRangeException("Y Value (" + y + ") must be within the range: " + this.getY(0) + " and " + this.getY(max - 1));
        }
        double x1 = this.getX(i);
        double x2 = this.getX(i + 1);
        double x = (y - y1) * (x2 - x1) / (y2 - y1) + x1;
        return x;
    }

    public double getFirstInterpolatedX_inLogXLogYDomain(double y) {
        int i;
        int max = this.points.size();
        if (max == 1 && y == this.getY(0)) {
            return this.getX(0);
        }
        double y1 = Double.NaN;
        double y2 = Double.NaN;
        boolean found = false;
        for (i = 0; i < max - 1; ++i) {
            y1 = this.getY(i);
            y2 = this.getY(i + 1);
            if (!(y <= y1 && y >= y2 && y2 <= y1) && (!(y >= y1) || !(y <= y2) || !(y2 >= y1))) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new InvalidRangeException("Y Value (" + y + ") must be within the range: " + this.getY(0) + " and " + this.getY(max - 1));
        }
        double x1 = Math.log(this.getX(i));
        double x2 = Math.log(this.getX(i + 1));
        y1 = Math.log(y1);
        y2 = Math.log(y2);
        y = Math.log(y);
        double x = (y - y1) * (x2 - x1) / (y2 - y1) + x1;
        return Math.exp(x);
    }

    public double getInterpolatedY(double x) {
        int max = this.points.size();
        double x1 = Double.NaN;
        double x2 = Double.NaN;
        if (x > this.getX(max - 1) || x < this.getX(0)) {
            throw new InvalidRangeException("x Value must be within the range: " + this.getX(0) + " and " + this.getX(max - 1));
        }
        if (x == this.getX(max - 1)) {
            return this.getY(x);
        }
        for (int i = 0; i < max - 1; ++i) {
            x1 = this.getX(i);
            x2 = this.getX(i + 1);
            if (x >= x1 && x <= x2) break;
        }
        double y1 = this.getY(x1);
        double y2 = this.getY(x2);
        double y = (y2 - y1) * (x - x1) / (x2 - x1) + y1;
        return y;
    }

    public double getInterpolatedY_inLogXLogYDomain(double x) {
        int max = this.points.size();
        double x1 = Double.NaN;
        double x2 = Double.NaN;
        if (x > this.getX(max - 1) || x < this.getX(0)) {
            throw new InvalidRangeException("x Value must be within the range: " + this.getX(0) + " and " + this.getX(max - 1));
        }
        if (x == this.getX(max - 1)) {
            return this.getY(x);
        }
        for (int i = 0; i < max - 1; ++i) {
            x1 = this.getX(i);
            x2 = this.getX(i + 1);
            if (x >= x1 && x <= x2) break;
        }
        double y1 = Math.log(this.getY(x1));
        double y2 = Math.log(this.getY(x2));
        x1 = Math.log(x1);
        x2 = Math.log(x2);
        x = Math.log(x);
        double y = (y2 - y1) * (x - x1) / (x2 - x1) + y1;
        return Math.exp(y);
    }

    public DiscretizedFuncAPI deepClone() {
        ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
        function.setName(this.getName());
        function.setTolerance(this.getTolerance());
        function.setInfo(this.getInfo());
        function.setXAxisName(this.getXAxisName());
        function.setYAxisName(this.getYAxisName());
        Iterator it = this.getPointsIterator();
        if (it != null) {
            while (it.hasNext()) {
                function.set((DataPoint2D)((DataPoint2D)it.next()).clone());
            }
        }
        return function;
    }

    public boolean equalXValues(DiscretizedFuncAPI function) {
        String S = "ArbitrarilyDiscretizedFunc: equalXValues():";
        if (this.getNum() != function.getNum()) {
            return false;
        }
        Iterator it = this.getPointsIterator();
        while (it.hasNext()) {
            DataPoint2D point = (DataPoint2D)it.next();
            if (function.hasPoint(point)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        Iterator it2 = this.getPointsIterator();
        b.append("Name: " + this.getName() + '\n');
        b.append("Num Points: " + this.getNum() + '\n');
        b.append("Info: " + this.getInfo() + "\n\n");
        b.append("X, Y Data:\n");
        b.append(this.getMetadataString() + '\n');
        return b.toString();
    }

    public String getMetadataString() {
        StringBuffer b = new StringBuffer();
        Iterator it2 = this.getPointsIterator();
        while (it2.hasNext()) {
            DataPoint2D point = (DataPoint2D)it2.next();
            double x = point.getX();
            double y = point.getY();
            b.append((float)x + TAB + (float)y + '\n');
        }
        return b.toString();
    }

    public String toDebugString() {
        StringBuffer b = new StringBuffer();
        b.append("ArbitrarilyDiscretizedFunc: Log values:\n");
        Iterator it = this.getPointsIterator();
        while (it.hasNext()) {
            DataPoint2D point = (DataPoint2D)it.next();
            b.append(point.toString() + '\n');
        }
        return b.toString();
    }

    private void writeObject(ObjectOutputStream s) {
        Iterator it = this.getPointsIterator();
        try {
            s.writeObject(new Integer(this.getNum()));
            while (it.hasNext()) {
                DataPoint2D data = (DataPoint2D)it.next();
                s.writeObject(data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s) {
        try {
            if (this.points == null) {
                this.points = new DataPoint2DTreeMap();
            }
            int num = (Integer)s.readObject();
            for (int i = 0; i < num; ++i) {
                DataPoint2D data = (DataPoint2D)s.readObject();
                this.set(data);
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("IO Exception ");
            e.printStackTrace();
        }
    }

    public ArbitrarilyDiscretizedFunc getYY_Function(DiscretizedFuncAPI function) {
        if (this.getNum() != function.getNum()) {
            throw new InvalidRangeException("This operation cannot be performed on functions with different size");
        }
        ArbitrarilyDiscretizedFunc newFunction = new ArbitrarilyDiscretizedFunc();
        int numPoints = function.getNum();
        for (int j = 0; j < numPoints; ++j) {
            newFunction.set(this.getY(j), function.getY(j));
        }
        return newFunction;
    }

    public boolean areAllXValuesInteger(double tolerance) {
        int num = this.getNum();
        for (int i = 0; i < num; ++i) {
            double x = this.getX(i);
            double diff = Math.abs(x - Math.rint(x));
            if (!(diff > tolerance)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.points.clear();
    }
}

