/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.ParameterAPI;
import org.opensha.param.editor.ParameterEditorAPI;

public class ParameterEditor
extends JPanel
implements ParameterEditorAPI,
FocusListener,
KeyListener {
    protected static final String C = "ParameterEditor";
    protected static final boolean D = false;
    protected static final String DATA_TEXT = "Enter data here";
    protected static final String LABEL_TEXT = "This is the Label";
    protected static final String EMPTY = "";
    public static Color FORE_COLOR = new Color(80, 80, 140);
    protected static Color STRING_BACK_COLOR = Color.lightGray;
    protected static final Dimension LABEL_DIM = new Dimension(100, 20);
    protected static final Dimension LABEL_PANEL_DIM = new Dimension(100, 20);
    protected static final Dimension WIGET_PANEL_DIM = new Dimension(100, 23);
    protected static final Dimension JCOMBO_DIM = new Dimension(100, 22);
    protected static final Dimension JLIST_DIM = new Dimension(100, 100);
    protected static final GridBagLayout GBL = new GridBagLayout();
    protected static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    protected static final Insets FIVE_INSETS = new Insets(0, 5, 0, 0);
    protected static final Insets FIVE_FIVE_INSETS = new Insets(0, 5, 0, 5);
    protected static Font JCOMBO_FONT = new Font("SansSerif", 0, 11);
    public static Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 12);
    public static Font DEFAULT_FONT = new Font("SansSerif", 0, 11);
    protected static final Border CONST_BORDER = BorderFactory.createLineBorder(Color.blue, 1);
    protected static final Border FOCUS_BORDER = BorderFactory.createLineBorder(Color.orange, 1);
    protected static final Border ETCHED = BorderFactory.createEtchedBorder();
    protected static final GridBagConstraints OUTER_PANEL_GBC = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 0, 0, 0), 0, 0);
    protected static final GridBagConstraints WIDGET_PANEL_GBC = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, ZERO_INSETS, 0, 0);
    protected static final GridBagConstraints WIDGET_GBC = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 5, 0, 1), 0, 0);
    protected static final GridBagConstraints COMBO_WIDGET_GBC = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 0, 0, 1), 0, 0);
    protected JPanel outerPanel = new JPanel();
    protected JPanel labelPanel = new JPanel();
    protected JPanel widgetPanel = new JPanel();
    protected JLabel nameLabel = new JLabel();
    protected boolean focusEnabled = true;
    protected Border border1;
    protected TitledBorder titledBorder1;
    protected JComponent valueEditor = null;
    protected ParameterAPI model;
    protected boolean catchConstraint = false;
    protected boolean keyTypeProcessing = false;
    protected boolean focusLostProcessing = false;

    public ParameterEditor() {
        String S = "ParameterEditor: Constructor(): ";
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ParameterEditor(ParameterAPI model) {
        String S = "ParameterEditor: Constructor(model): ";
        if (model == null) {
            throw new NullPointerException(S + "Input Parameter data cannot be null");
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setParameter(model);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(Object value) throws ConstraintException {
        Object obj;
        String S = "ParameterEditor: setValue():";
        if (this.model != null && value == null) {
            if (!this.model.isNullAllowed()) return;
            try {
                this.model.setValue(value);
                return;
            }
            catch (ParameterException ee) {
                ee.printStackTrace();
            }
            return;
        }
        if (this.model == null || (obj = this.model.getValue()) != null && obj.toString().equals(value.toString())) return;
        try {
            this.model.setValue(value);
            return;
        }
        catch (ParameterException ee) {
            ee.printStackTrace();
        }
    }

    public void setParameterInEditor(ParameterAPI model) {
        String S = "ParameterEditor: setParameter(): ";
        if (model == null) {
            throw new NullPointerException(S + "Input Parameter data cannot be null");
        }
        this.model = model;
        String name = EMPTY;
        name = model.getName();
        Object value = model.getValue();
    }

    public void setParameter(ParameterAPI model) {
        this.setParameterInEditor(model);
        this.removeWidget();
        this.addWidget();
        this.setWidgetObject(model.getName(), model.getValue());
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    protected void setWidgetObject(String name, Object obj) {
        this.updateNameLabel(name);
        this.setNameLabelToolTip(this.model.getInfo());
    }

    protected void setNameLabelToolTip(String str) {
        if (str != null && !str.equals(EMPTY)) {
            if (this.nameLabel != null) {
                this.nameLabel.setToolTipText(str);
            }
            this.setToolTipText(str);
        } else {
            if (this.nameLabel != null) {
                this.nameLabel.setToolTipText(null);
            }
            this.setToolTipText(null);
        }
    }

    public void setFocusEnabled(boolean newFocusEnabled) {
        this.focusEnabled = newFocusEnabled;
    }

    public Object getValue() {
        return this.model.getValue();
    }

    public ParameterAPI getParameter() {
        return this.model;
    }

    public String[] getTags() {
        return null;
    }

    public String getAsText() {
        return this.getValue().toString();
    }

    public boolean isFocusEnabled() {
        return this.focusEnabled;
    }

    public void refreshParamEditor() {
    }

    public void unableToSetValue(Object value) throws ConstraintException {
        String S = "ParameterEditor: unableToSetValue():";
        if (value != null && this.model != null) {
            Object obj = this.model.getValue();
            if (obj != null) {
                if (!obj.toString().equals(value.toString())) {
                    this.model.unableToSetValue(value);
                }
            } else {
                this.model.unableToSetValue(value);
            }
        }
    }

    public static JLabel makeConstantEditor(String label) {
        JLabel l = new JLabel();
        l.setPreferredSize(LABEL_DIM);
        l.setMinimumSize(LABEL_DIM);
        l.setFont(JCOMBO_FONT);
        l.setForeground(Color.blue);
        l.setBorder(CONST_BORDER);
        l.setText(label);
        return l;
    }

    protected void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createLineBorder(FORE_COLOR, 1), EMPTY);
        this.titledBorder1.setTitleColor(FORE_COLOR);
        this.titledBorder1.setTitleFont(DEFAULT_LABEL_FONT);
        this.titledBorder1.setTitle("Parameter Name");
        this.border1 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(0, 0, 3, 0));
        this.setLayout(GBL);
        this.outerPanel.setLayout(GBL);
        this.outerPanel.setBorder(this.border1);
        this.widgetPanel.setLayout(GBL);
        this.widgetPanel.setMinimumSize(WIGET_PANEL_DIM);
        this.widgetPanel.setPreferredSize(WIGET_PANEL_DIM);
        this.nameLabel.setMaximumSize(LABEL_DIM);
        this.nameLabel.setMinimumSize(LABEL_DIM);
        this.nameLabel.setPreferredSize(LABEL_DIM);
        this.nameLabel.setHorizontalAlignment(2);
        this.nameLabel.setHorizontalTextPosition(2);
        this.nameLabel.setText(LABEL_TEXT);
        this.nameLabel.setFont(DEFAULT_LABEL_FONT);
        this.outerPanel.add((Component)this.widgetPanel, WIDGET_PANEL_GBC);
        this.add((Component)this.outerPanel, OUTER_PANEL_GBC);
    }

    protected void removeWidget() {
        String S = "ParameterEditor: addWidget(): ";
        if (this.widgetPanel != null && this.valueEditor != null) {
            this.widgetPanel.remove(this.valueEditor);
        }
        this.valueEditor = null;
    }

    protected void addWidget() {
        this.valueEditor = new JTextField();
        this.valueEditor.setBackground(Color.white);
        this.valueEditor.setMinimumSize(LABEL_DIM);
        this.valueEditor.setPreferredSize(LABEL_DIM);
        ((JTextField)this.valueEditor).setText(DATA_TEXT);
        this.widgetPanel.add((Component)this.valueEditor, WIDGET_GBC);
    }

    public void setWidgetBorder(Border b) {
    }

    protected void updateNameLabel(String label) {
        String units = this.model.getUnits();
        if (label == null) {
            this.titledBorder1.setTitle(EMPTY);
        } else if (units != null && !units.equals(EMPTY)) {
            label = label + " (" + units + "):";
            this.titledBorder1.setTitle(label);
        } else {
            label = label + ':';
            this.titledBorder1.setTitle(label);
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void setEnabled(boolean isEnabled) {
        this.valueEditor.setEnabled(isEnabled);
    }

    public JPanel getOuterPanel() {
        return this.outerPanel;
    }
}

