/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.Archivable;
import com.isti.util.LogFile;
import com.isti.util.UtilFns;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class ArchiveManager {
    protected final Constructor archivedClassConstructor;
    protected final String archiveRootDirName;
    protected final String archiveFileNameStr;
    protected OutputStream archiveOutStm = null;
    protected boolean archiveClosedFlag = false;
    protected String archivedItemDelimiter = "\n";
    protected boolean assumeNewlineFlag = true;
    protected boolean purgeIntoArchiveFlag = true;
    protected boolean dontPurgeLastFileFlag = false;
    protected boolean leaveOutputStreamsOpenFlag = true;
    protected String archivedFormPrefixStr = null;
    protected final Object archiveAccessSyncObj = new Object();
    protected Vector filesForDateRangeVec = null;
    protected int timeCheckOffsetMs = 3600000;
    protected Date lastItemArchiveDate = null;
    private LogFile logFileObj;
    private String logPrefixString = "";
    static /* synthetic */ Class class$com$isti$util$Archivable$Marker;
    static /* synthetic */ Class class$java$lang$String;

    public ArchiveManager(Class classObj, String archiveRootDirName, String archiveFileNameStr) throws NoSuchMethodException {
        if (archiveFileNameStr == null) {
            throw new NullPointerException();
        }
        this.archiveRootDirName = archiveRootDirName;
        this.archiveFileNameStr = archiveFileNameStr;
        this.archivedClassConstructor = classObj.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ArchiveManager.class$("java.lang.String")) : class$java$lang$String, class$com$isti$util$Archivable$Marker == null ? (class$com$isti$util$Archivable$Marker = ArchiveManager.class$("com.isti.util.Archivable$Marker")) : class$com$isti$util$Archivable$Marker);
        if (archiveRootDirName != null) {
            new File(archiveRootDirName).mkdirs();
        }
        this.logFileObj = LogFile.getGlobalLogObj(true);
        this.setLogPrefixString("ArchiveManager");
    }

    public ArchiveManager(Class classObj, String archiveFileNameStr) throws NoSuchMethodException {
        this(classObj, null, archiveFileNameStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPurgeIntoArchiveFlag(boolean flgVal) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.purgeIntoArchiveFlag = flgVal;
        }
        if (this.getLogFile() != null) {
            this.getLogFile().debug2(this.getLogPrefixString() + ":  purgeIntoArchiveFlag was set to: " + this.purgeIntoArchiveFlag);
        }
    }

    public boolean getPurgeIntoArchiveFlag() {
        return this.purgeIntoArchiveFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDontPurgeLastFileFlag(boolean flgVal) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.dontPurgeLastFileFlag = flgVal;
        }
        if (this.getLogFile() != null) {
            this.getLogFile().debug2(this.getLogPrefixString() + ":  dontPurgeLastFileFlag was set to: " + this.dontPurgeLastFileFlag);
        }
    }

    public boolean getDontPurgeLastFileFlag() {
        return this.dontPurgeLastFileFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeaveOutputStreamsOpenFlag(boolean flgVal) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.leaveOutputStreamsOpenFlag = flgVal;
        }
        if (this.getLogFile() != null) {
            this.getLogFile().debug2(this.getLogPrefixString() + ":  leaveOutputStreamsOpenFlag was set to: " + this.leaveOutputStreamsOpenFlag);
        }
    }

    public boolean getLeaveOutputStreamsOpenFlag() {
        return this.leaveOutputStreamsOpenFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArchivedItemDelimiter(String str) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.archivedItemDelimiter = str != null ? str : "\n";
            this.assumeNewlineFlag = this.archivedItemDelimiter.equals("\n");
        }
        if (this.getLogFile() != null) {
            this.getLogFile().debug2(this.getLogPrefixString() + ":  archivedItemDelimiter was set to: " + this.archivedItemDelimiter);
        }
    }

    public String getArchivedItemDelimiter() {
        return this.archivedItemDelimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArchivedFormPrefixStr(String str) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.archivedFormPrefixStr = str != null && str.length() > 0 ? str : null;
        }
        if (this.getLogFile() != null) {
            this.getLogFile().debug2(this.getLogPrefixString() + ":  archivedFormPrefixStr was set to: " + this.archivedFormPrefixStr);
        }
    }

    public String getArchivedFormPrefixStr() {
        return this.archivedFormPrefixStr;
    }

    public LogFile getLogFile() {
        return this.logFileObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogFile(LogFile logFileObj) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.logFileObj = logFileObj;
        }
    }

    public String getLogPrefixString() {
        return this.logPrefixString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLogPrefixString(String logPrefixString) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.logPrefixString = logPrefixString != null ? logPrefixString : "";
        }
        if (this.getLogFile() != null) {
            this.getLogFile().debug2(this.getLogPrefixString() + ":  logPrefixString was set to: " + this.logPrefixString);
        }
    }

    public void setTimeCheckOffsetMs(int offsetMsVal) {
        this.timeCheckOffsetMs = offsetMsVal >= 0 ? offsetMsVal : 0;
    }

    public int getTimeCheckOffsetMs() {
        return this.timeCheckOffsetMs;
    }

    public boolean archiveItem(Archivable item) throws IOException {
        return this.archiveItem(item, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean archiveItem(Archivable item, boolean checkDateFlag) throws IOException {
        boolean itemAdded = false;
        if (!this.archiveClosedFlag) {
            Object object = this.archiveAccessSyncObj;
            synchronized (object) {
                IOException throwEx;
                block10: {
                    throwEx = null;
                    try {
                        if (!checkDateFlag || this.checkItemArchiveDate(item)) {
                            OutputStream outStm = this.getOutputStreamForItem(item);
                            this.writeItemToFile(item, outStm);
                            outStm.flush();
                            itemAdded = true;
                        }
                    }
                    catch (IOException ex) {
                        throwEx = ex;
                    }
                    catch (Exception ex) {
                        if (this.getLogFile() == null) break block10;
                        this.getLogFile().warning(this.getLogPrefixString() + ".archiveItem: " + ex);
                        this.getLogFile().debug(UtilFns.getStackTraceString(ex));
                    }
                }
                if (!this.leaveOutputStreamsOpenFlag) {
                    this.closeArchiveOutStms();
                }
                if (throwEx != null) {
                    throw throwEx;
                }
            }
        }
        return itemAdded;
    }

    protected boolean checkItemArchiveDate(Archivable item) {
        Date archiveDate = item.getArchiveDate();
        if (archiveDate.getTime() > System.currentTimeMillis() + (long)this.timeCheckOffsetMs) {
            if (this.getLogFile() != null) {
                this.getLogFile().warning(this.getLogPrefixString() + ":  Archive date (" + archiveDate + ") is after the current time.");
            }
            return false;
        }
        if (this.lastItemArchiveDate == null) {
            Archivable lastItem = this.getNewestItemInEntireArchive();
            this.lastItemArchiveDate = lastItem != null ? lastItem.getArchiveDate() : new Date(0L);
        }
        if (archiveDate.compareTo(this.lastItemArchiveDate) < 0) {
            if (this.getLogFile() != null) {
                this.getLogFile().warning(this.getLogPrefixString() + ":  Archive date (" + archiveDate + ") is older than the last item archived (" + this.lastItemArchiveDate + ")");
            }
            return false;
        }
        this.lastItemArchiveDate = archiveDate;
        return true;
    }

    protected void writeItemToFile(Archivable item, OutputStream outStm) throws IOException {
        outStm.write(item.toArchivedForm().getBytes());
        outStm.write(this.archivedItemDelimiter.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processArchivedItems(Date startDate, Date endDate, ProcessCallBack callBackObj, int maxCount) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            int itemCount = 0;
            Enumeration inputFiles = this.getArchiveFilesForDateRange(startDate, endDate).elements();
            BufferedReader rdrObj = null;
            boolean firstFileFlag = true;
            boolean moreElementsFlag = inputFiles.hasMoreElements();
            BufferedInputStream inStmObj = null;
            File inputFile = null;
            block7: while (!this.archiveClosedFlag && moreElementsFlag) {
                block14: {
                    inStmObj = null;
                    try {
                        inputFile = (File)inputFiles.nextElement();
                        if (inputFile.exists()) {
                            try {
                                inStmObj = new BufferedInputStream(new FileInputStream(inputFile));
                            }
                            catch (FileNotFoundException ex) {
                                if (this.getLogFile() != null) {
                                    this.getLogFile().warning(this.getLogPrefixString() + ":  Error opening file:  " + ex);
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (this.getLogFile() == null) break block14;
                        this.getLogFile().warning(this.getLogPrefixString() + ":  Error with input file:  " + ex);
                        this.getLogFile().debug(UtilFns.getStackTraceString(ex));
                    }
                }
                moreElementsFlag = inputFiles.hasMoreElements();
                if (inStmObj != null) {
                    String itemDataStr;
                    if (this.assumeNewlineFlag) {
                        rdrObj = new BufferedReader(new InputStreamReader(inStmObj));
                    }
                    while (!this.archiveClosedFlag && (itemDataStr = this.assumeNewlineFlag ? this.getNextLineFromFile(rdrObj) : this.getNextItemDataFromFile(inStmObj)) != null) {
                        Archivable itemObj = this.convertStringToArchivable(itemDataStr);
                        if (itemObj == null || (moreElementsFlag || endDate == null || !itemObj.getArchiveDate().after(endDate)) && (firstFileFlag && startDate != null && itemObj.getArchiveDate().before(startDate) || callBackObj.procArchivedItem(itemObj, itemDataStr) && (maxCount <= 0 || ++itemCount < maxCount))) continue;
                        break block7;
                    }
                    this.close(inStmObj);
                    inStmObj = null;
                }
                if (!firstFileFlag) continue;
                firstFileFlag = false;
            }
            if (inStmObj != null) {
                this.close(inStmObj);
            }
        }
    }

    public void processArchivedItems(Date startDate, Date endDate, ProcessCallBack callBackObj) {
        this.processArchivedItems(startDate, endDate, callBackObj, 0);
    }

    public Vector getArchivedItemsVector(Date startDate, Date endDate, int maxCount) {
        final Vector retVec = new Vector();
        this.processArchivedItems(startDate, endDate, new ProcessCallBack(){

            public boolean procArchivedItem(Archivable itemObj, String archivedFormStr) {
                retVec.add(itemObj);
                return true;
            }
        }, maxCount);
        return retVec;
    }

    public Vector getArchivedItemsVector(Date startDate, Date endDate) {
        return this.getArchivedItemsVector(startDate, endDate, 0);
    }

    public Enumeration getArchivedItems(Date startDate, Date endDate, int maxCount) {
        return this.getArchivedItemsVector(startDate, endDate, maxCount).elements();
    }

    public Enumeration getArchivedItems(Date startDate, Date endDate) {
        return this.getArchivedItems(startDate, endDate, 0);
    }

    protected String getNextItemDataFromFile(InputStream stmObj) {
        int itemSizeVal;
        StringBuffer archivedFormBuff = new StringBuffer();
        try {
            do {
                int val;
                if ((val = stmObj.read()) < 0) {
                    return null;
                }
                archivedFormBuff.append((char)val);
            } while ((itemSizeVal = archivedFormBuff.length() - this.archivedItemDelimiter.length()) < 0 || !this.archivedItemDelimiter.equals(archivedFormBuff.substring(itemSizeVal)));
        }
        catch (IOException ex) {
            if (this.getLogFile() != null) {
                this.getLogFile().warning(this.getLogPrefixString() + ":  I/O error getting next item data:  " + ex);
            }
            return null;
        }
        catch (Exception ex) {
            if (this.getLogFile() != null) {
                this.getLogFile().warning(this.getLogPrefixString() + ":  Error getting next item data:  " + ex);
                this.getLogFile().debug(UtilFns.getStackTraceString(ex));
            }
            return null;
        }
        return archivedFormBuff.substring(0, itemSizeVal);
    }

    protected String getNextLineFromFile(BufferedReader rdrObj) {
        try {
            return rdrObj.readLine();
        }
        catch (IOException ex) {
            if (this.getLogFile() != null) {
                this.getLogFile().warning(this.getLogPrefixString() + ":  I/O error getting next line:  " + ex);
            }
            return null;
        }
        catch (Exception ex) {
            if (this.getLogFile() != null) {
                this.getLogFile().warning(this.getLogPrefixString() + ":  Error getting next line:  " + ex);
                this.getLogFile().debug(UtilFns.getStackTraceString(ex));
            }
            return null;
        }
    }

    protected Archivable convertStringToArchivable(String str) {
        block6: {
            if (str != null && (str = str.trim()).length() > 0) {
                int p;
                if (this.archivedFormPrefixStr != null) {
                    p = str.indexOf(this.archivedFormPrefixStr);
                    if (p < 0) {
                        return null;
                    }
                } else {
                    p = 0;
                }
                try {
                    return (Archivable)this.archivedClassConstructor.newInstance(str.substring(p), null);
                }
                catch (Exception ex) {
                    if (this.getLogFile() == null) break block6;
                    this.getLogFile().warning(this.getLogPrefixString() + ":  Error converting string to archive:  " + ex);
                    this.getLogFile().debug(UtilFns.getStackTraceString(ex));
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean purgeArchive(Date cutoffDate) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            boolean retFlag = true;
            File cutoffFileObj = this.getArchiveFileForName(this.getArchiveFileNameForDate(cutoffDate));
            if (!cutoffFileObj.exists()) {
                cutoffFileObj = null;
            }
            BufferedReader rdrObj = null;
            Enumeration e = this.getArchiveFilesForDateRange(null, cutoffDate).elements();
            boolean moreElementsFlag = e.hasMoreElements();
            while (moreElementsFlag) {
                File inFileObj = (File)e.nextElement();
                moreElementsFlag = e.hasMoreElements();
                if (!moreElementsFlag && cutoffFileObj != null && cutoffFileObj.equals(inFileObj)) {
                    if (!this.purgeIntoArchiveFlag) continue;
                    try {
                        String itemDataStr;
                        File tmpFileObj = this.getArchiveFileForName("t" + System.currentTimeMillis() + ".tmp");
                        BufferedOutputStream outStmObj = new BufferedOutputStream(new FileOutputStream(tmpFileObj));
                        BufferedInputStream inStmObj = new BufferedInputStream(new FileInputStream(inFileObj));
                        if (this.assumeNewlineFlag) {
                            rdrObj = new BufferedReader(new InputStreamReader(inStmObj));
                        }
                        boolean skippedFlag = false;
                        boolean writtenFlag = false;
                        while ((itemDataStr = this.assumeNewlineFlag ? this.getNextLineFromFile(rdrObj) : this.getNextItemDataFromFile(inStmObj)) != null) {
                            Archivable itemObj = this.convertStringToArchivable(itemDataStr);
                            if (itemObj == null) continue;
                            if (!itemObj.getArchiveDate().before(cutoffDate)) {
                                writtenFlag = true;
                                this.writeItemToFile(itemObj, outStmObj);
                                continue;
                            }
                            skippedFlag = true;
                        }
                        this.flush(outStmObj);
                        this.close(outStmObj);
                        this.close(inStmObj);
                        if (skippedFlag) {
                            File fileObj = new File(inFileObj.getAbsolutePath());
                            if (this.deleteFile(inFileObj) && writtenFlag) {
                                this.renameTo(tmpFileObj, fileObj);
                                continue;
                            }
                            this.deleteFile(tmpFileObj);
                            continue;
                        }
                        this.deleteFile(tmpFileObj);
                        continue;
                    }
                    catch (Exception ex) {
                        if (this.getLogFile() != null) {
                            this.getLogFile().warning(this.getLogPrefixString() + ":  Error with purge into archive:  " + ex);
                            this.getLogFile().debug(UtilFns.getStackTraceString(ex));
                        }
                        retFlag = false;
                        break;
                    }
                }
                if (this.dontPurgeLastFileFlag && !moreElementsFlag && !this.doesNextArchiveFileExist(inFileObj.getName())) break;
                try {
                    this.deleteFile(inFileObj);
                }
                catch (Exception ex) {
                    if (this.getLogFile() != null) {
                        this.getLogFile().warning(this.getLogPrefixString() + ":  Error deleting file:  " + ex);
                        this.getLogFile().debug(UtilFns.getStackTraceString(ex));
                    }
                    retFlag = false;
                    break;
                }
            }
            return retFlag;
        }
    }

    protected boolean deleteFile(File fileObj) {
        this.closeArchiveOutStms();
        if (!fileObj.delete()) {
            if (this.getLogFile() != null) {
                this.getLogFile().warning(this.getLogPrefixString() + ":  Unable to delete file (" + fileObj.getName() + ")");
            }
            return false;
        }
        return true;
    }

    protected boolean renameTo(File fileObj, File dest) {
        if (!fileObj.renameTo(dest)) {
            if (this.getLogFile() != null) {
                this.getLogFile().warning(this.getLogPrefixString() + ":  Unable to rename file \"" + fileObj.getName() + "\" to \"" + dest.getName() + "\"");
            }
            return false;
        }
        return true;
    }

    protected void flush(OutputStream outStmObj) {
        block2: {
            try {
                outStmObj.flush();
            }
            catch (IOException ex) {
                if (this.getLogFile() == null) break block2;
                this.getLogFile().warning(this.getLogPrefixString() + ":  I/O error flushing output stream:  " + ex);
            }
        }
    }

    protected void close(InputStream inStmObj) {
        block2: {
            try {
                inStmObj.close();
            }
            catch (IOException ex) {
                if (this.getLogFile() == null) break block2;
                this.getLogFile().warning(this.getLogPrefixString() + ":  I/O error closing input stream:  " + ex);
            }
        }
    }

    protected void close(OutputStream outStmObj) {
        block2: {
            try {
                outStmObj.close();
            }
            catch (IOException ex) {
                if (this.getLogFile() == null) break block2;
                this.getLogFile().warning(this.getLogPrefixString() + ":  I/O error closing output stream:  " + ex);
            }
        }
    }

    protected void closeArchiveOutStms() {
        if (this.archiveOutStm != null) {
            this.close(this.archiveOutStm);
            this.archiveOutStm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeArchive() {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.archiveClosedFlag = true;
            this.closeArchiveOutStms();
        }
    }

    public boolean isArchiveClosed() {
        return this.archiveClosedFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getNewestArchiveFile() {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            int i;
            Vector vec = this.getArchiveFilesForDateRange(null, null);
            if (vec != null && (i = vec.size()) > 0) {
                do {
                    Object obj;
                    if (!((obj = vec.elementAt(--i)) instanceof File)) continue;
                    return (File)obj;
                } while (i > 0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getOldestArchiveFile() {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            Vector vec = this.getArchiveFilesForDateRange(null, null);
            if (vec != null) {
                int vecSize = vec.size();
                for (int i = 0; i < vecSize; ++i) {
                    Object obj = vec.elementAt(i);
                    if (!(obj instanceof File)) continue;
                    return (File)obj;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Archivable getNewestItemInArchiveFile(File fileObj) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            String itemDataStr;
            BufferedInputStream inStmObj;
            if (fileObj == null || !fileObj.exists()) {
                return null;
            }
            int bufferSize = 25;
            String[] buff = new String[25];
            int pos = 0;
            int itemCount = 0;
            Archivable itemObj = null;
            try {
                inStmObj = new BufferedInputStream(new FileInputStream(fileObj));
            }
            catch (IOException ex) {
                if (this.getLogFile() != null) {
                    this.getLogFile().warning(this.getLogPrefixString() + ":  I/O error opening file:  " + ex);
                }
                return null;
            }
            BufferedReader rdrObj = null;
            if (this.assumeNewlineFlag) {
                rdrObj = new BufferedReader(new InputStreamReader(inStmObj));
            }
            while ((itemDataStr = this.assumeNewlineFlag ? this.getNextLineFromFile(rdrObj) : this.getNextItemDataFromFile(inStmObj)) != null) {
                if (this.archivedFormPrefixStr != null && itemDataStr.indexOf(this.archivedFormPrefixStr) < 0) continue;
                buff[pos] = itemDataStr;
                if (++pos >= 25) {
                    pos = 0;
                }
                ++itemCount;
            }
            this.close(inStmObj);
            if (itemCount > 25) {
                itemCount = 25;
            }
            while (--itemCount > 0) {
                if (--pos < 0) {
                    pos = 24;
                }
                if ((itemObj = this.convertStringToArchivable(buff[pos])) == null) continue;
            }
            return itemObj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Archivable getNewestItemInEntireArchive() {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            return this.getNewestItemInArchiveFile(this.getNewestArchiveFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Archivable getOldestItemInArchiveFile(File fileObj) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            String itemDataStr;
            BufferedInputStream inStmObj;
            if (fileObj == null || !fileObj.exists()) {
                return null;
            }
            try {
                inStmObj = new BufferedInputStream(new FileInputStream(fileObj));
            }
            catch (IOException ex) {
                if (this.getLogFile() != null) {
                    this.getLogFile().warning(this.getLogPrefixString() + ":  I/O error opening file:  " + ex);
                }
                return null;
            }
            BufferedReader rdrObj = null;
            if (this.assumeNewlineFlag) {
                rdrObj = new BufferedReader(new InputStreamReader(inStmObj));
            }
            while ((itemDataStr = this.assumeNewlineFlag ? this.getNextLineFromFile(rdrObj) : this.getNextItemDataFromFile(inStmObj)) != null) {
                Archivable itemObj;
                if (this.archivedFormPrefixStr != null && itemDataStr.indexOf(this.archivedFormPrefixStr) < 0 || (itemObj = this.convertStringToArchivable(itemDataStr)) == null) continue;
                this.close(inStmObj);
                return itemObj;
            }
            this.close(inStmObj);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Archivable getOldestItemInEntireArchive() {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            return this.getOldestItemInArchiveFile(this.getOldestArchiveFile());
        }
    }

    public Object getArchiveAccessSyncObj() {
        return this.archiveAccessSyncObj;
    }

    protected Vector getArchiveFilesForDateRange(Date startDate, Date endDate) {
        if (this.filesForDateRangeVec == null) {
            this.filesForDateRangeVec = new Vector();
            this.filesForDateRangeVec.add(this.getArchiveFileForName(this.archiveFileNameStr));
        }
        return this.filesForDateRangeVec;
    }

    protected String getArchiveFileNameForDate(Date dateObj) {
        return this.archiveFileNameStr;
    }

    protected File getArchiveFileForName(String fNameStr) {
        return new File(this.archiveRootDirName, fNameStr);
    }

    protected OutputStream getOutputStreamForItem(Archivable item) throws IOException {
        if (this.archiveOutStm == null) {
            this.archiveOutStm = new BufferedOutputStream(new FileOutputStream(this.getArchiveFileForName(this.archiveFileNameStr).getPath(), true));
        }
        return this.archiveOutStm;
    }

    protected boolean doesNextArchiveFileExist(String fNameStr) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ProcessCallBack {
        public boolean procArchivedItem(Archivable var1, String var2);
    }
}

