/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.Archivable;
import com.isti.util.BooleanCp;
import com.isti.util.CfgPropValidator;
import com.isti.util.DataChangedListener;
import com.isti.util.IstiNamedValue;
import com.isti.util.PropItem;
import com.isti.util.PropItemInterface;
import com.isti.util.UtilFns;
import java.awt.Color;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class CfgPropItem
implements Comparable,
Serializable,
PropItemInterface {
    public static final char SWITCH1_CHAR = '-';
    public static final char SWITCH2_CHAR = '/';
    protected final String name;
    protected Object value;
    protected Number numberValue;
    protected boolean booleanValue;
    protected String stringValue;
    protected Color colorValue;
    protected Object defaultValue;
    protected boolean loadedFlag = false;
    protected boolean requiredFlag;
    protected boolean cmdLnLoadedFlag = false;
    protected final String cmdLnParamName;
    protected final String descriptionStr;
    protected final boolean cmdLnEnbFlag;
    protected boolean helpScreenFlag;
    protected final boolean cmdLnOnlyFlag;
    protected boolean ignoreItemFlag = false;
    protected boolean emptyStringDefaultFlag = false;
    protected CfgPropValidator validatorObj = null;
    protected final Vector listenersVec = new Vector();
    protected long lastChangeTime = 0L;
    protected Object groupSelObj = null;
    protected Object auxiliaryObj = null;
    protected boolean startupConfigFlag = false;
    private transient Map.Entry mapEntryObj = null;

    public CfgPropItem(String name, Object defaultValue, boolean requiredFlag, String paramNameStr, String descriptionStr, boolean cmdLnEnbFlag, boolean helpScreenFlag, boolean cmdLnOnlyFlag) {
        this.name = name != null ? name : "";
        this.setDefaultValue(defaultValue);
        this.setValueObject(defaultValue);
        this.requiredFlag = requiredFlag;
        if (paramNameStr != null && paramNameStr.length() > 0 && (paramNameStr.charAt(0) == '-' || paramNameStr.charAt(0) == '/')) {
            paramNameStr = paramNameStr.substring(1);
        }
        this.cmdLnParamName = paramNameStr;
        this.descriptionStr = descriptionStr;
        this.cmdLnEnbFlag = cmdLnEnbFlag;
        this.helpScreenFlag = helpScreenFlag;
        this.cmdLnOnlyFlag = cmdLnOnlyFlag;
    }

    public CfgPropItem(String name, Object defaultValue, boolean requiredFlag, String cmdLnParamName, String descriptionStr) {
        this(name, defaultValue, requiredFlag, cmdLnParamName, descriptionStr, true, true, false);
    }

    public CfgPropItem(String name, Object defaultValue, boolean requiredFlag) {
        this(name, defaultValue, requiredFlag, null, null, true, true, false);
    }

    public CfgPropItem(String name, Object defaultValue, String cmdLnParamName, String descriptionStr, boolean cmdLnEnbFlag, boolean helpScreenFlag) {
        this(name, defaultValue, false, cmdLnParamName, descriptionStr, cmdLnEnbFlag, helpScreenFlag, false);
    }

    public CfgPropItem(String name, Object defaultValue, String cmdLnParamName, String descriptionStr, boolean cmdLnEnbFlag, boolean helpScreenFlag, boolean cmdLnOnlyFlag) {
        this(name, defaultValue, false, cmdLnParamName, descriptionStr, cmdLnEnbFlag, helpScreenFlag, cmdLnOnlyFlag);
    }

    public CfgPropItem(String name, Object defaultValue, String cmdLnParamName, String descriptionStr) {
        this(name, defaultValue, false, cmdLnParamName, descriptionStr, true, true, false);
    }

    public CfgPropItem(String name, Object defaultValue, String cmdLnParamName) {
        this(name, defaultValue, false, cmdLnParamName, null, true, true, false);
    }

    public CfgPropItem(String name, Object defaultValue) {
        this(name, defaultValue, false, null, null, true, true, false);
    }

    public String getName() {
        return this.name;
    }

    public synchronized Object getDefaultValue() {
        return this.defaultValue;
    }

    public final synchronized void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue != null ? defaultValue : "";
    }

    public synchronized void setDefaultAndValue(Object valueObj) {
        this.setDefaultValue(valueObj);
        this.setValueObject(valueObj);
    }

    public synchronized Object getValue() {
        return this.value;
    }

    protected final void setValueObject(Object valueObj) {
        this.value = valueObj;
        this.numberValue = this.value instanceof Number ? (Number)((Number)this.value) : (Number)new Integer(0);
        this.booleanValue = this.value instanceof Boolean ? (Boolean)this.value : (this.value instanceof BooleanCp ? ((BooleanCp)this.value).booleanValue() : false);
        this.stringValue = this.value instanceof String ? (String)this.value : null;
        this.colorValue = this.value instanceof Color ? (Color)this.value : null;
    }

    public synchronized boolean setValue(Object valueObj) {
        if (this.defaultValue instanceof Archivable && valueObj instanceof String) {
            valueObj = UtilFns.parseObject(this.defaultValue, (String)valueObj);
        }
        if (valueObj == null || valueObj.getClass() != this.defaultValue.getClass()) {
            return false;
        }
        if (valueObj.equals(this.value)) {
            return true;
        }
        if (this.validatorObj != null && !this.validatorObj.validateValue(valueObj)) {
            return false;
        }
        this.setValueObject(valueObj);
        this.fireDataChanged();
        return true;
    }

    public boolean setValue(int val) {
        return this.setValue(new Integer(val));
    }

    public boolean setValue(long val) {
        return this.setValue(new Long(val));
    }

    public boolean setValue(float val) {
        return this.setValue(new Float(val));
    }

    public boolean setValue(double val) {
        return this.setValue(new Double(val));
    }

    public boolean setValue(byte val) {
        return this.setValue(new Byte(val));
    }

    public boolean setValue(short val) {
        return this.setValue(new Short(val));
    }

    public boolean setValue(boolean flg) {
        return this.setValue(new Boolean(flg));
    }

    public static Object setValueString(String str, Object defValObj) {
        return IstiNamedValue.setValueString(str, defValObj);
    }

    public synchronized boolean setValueString(String str, boolean defaultFlag) {
        Object obj = CfgPropItem.setValueString(str, this.defaultValue);
        if (obj == null) {
            return false;
        }
        if (!obj.equals(this.value)) {
            if (this.validatorObj != null && !this.validatorObj.validateValue(obj)) {
                return false;
            }
            this.setValueObject(obj);
            this.fireDataChanged();
        }
        if (defaultFlag) {
            this.setDefaultValue(this.value);
        }
        return true;
    }

    public synchronized boolean setValueString(String str) {
        return this.setValueString(str, false);
    }

    public synchronized boolean compareValueString(String str) {
        Object obj = CfgPropItem.setValueString(str, this.defaultValue);
        if (obj == null) {
            return false;
        }
        try {
            return this.value.equals(obj);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public synchronized Object convertValueString(String str) {
        return CfgPropItem.setValueString(str, this.defaultValue);
    }

    public synchronized boolean checkType(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass() == this.defaultValue.getClass();
    }

    public synchronized Class getValueClass() {
        if (this.defaultValue == null) {
            return null;
        }
        return this.defaultValue.getClass();
    }

    public synchronized CfgPropItem setLoadedFlag(boolean flg) {
        this.loadedFlag = flg;
        return this;
    }

    public synchronized boolean getLoadedFlag() {
        return this.loadedFlag;
    }

    public synchronized CfgPropItem setRequiredFlag(boolean flg) {
        this.requiredFlag = flg;
        return this;
    }

    public synchronized boolean getRequiredFlag() {
        return this.requiredFlag;
    }

    public synchronized CfgPropItem setCmdLnLoadedFlag(boolean flg) {
        this.cmdLnLoadedFlag = flg;
        return this;
    }

    public synchronized boolean getCmdLnLoadedFlag() {
        return this.cmdLnLoadedFlag;
    }

    public synchronized CfgPropItem setIgnoreItemFlag(boolean flg) {
        this.ignoreItemFlag = flg;
        if (this.ignoreItemFlag) {
            this.helpScreenFlag = false;
        }
        return this;
    }

    public synchronized boolean getIgnoreItemFlag() {
        return this.ignoreItemFlag;
    }

    public synchronized CfgPropItem setHelpScreenFlag(boolean flg) {
        this.helpScreenFlag = flg;
        return this;
    }

    public synchronized CfgPropItem setEmptyStringDefaultFlag(boolean flg) {
        this.emptyStringDefaultFlag = flg;
        return this;
    }

    public synchronized boolean getEmptyStringDefaultFlag() {
        return this.emptyStringDefaultFlag;
    }

    public String toArchivedForm() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        if (this.value instanceof Color) {
            return UtilFns.colorToPropertyString((Color)this.value);
        }
        if (this.value instanceof Archivable) {
            return ((Archivable)this.value).toArchivedForm();
        }
        return this.value.toString();
    }

    public synchronized String toString() {
        if (!(this.value instanceof Object[])) {
            return this.stringValue();
        }
        Object[] valueArr = (Object[])this.value;
        StringBuffer buff = new StringBuffer();
        if (valueArr.length > 0) {
            int i = 0;
            while (true) {
                if (valueArr[i] != null) {
                    buff.append(valueArr[i]);
                }
                if (++i >= valueArr.length) break;
                buff.append(" ");
            }
        }
        return buff.toString();
    }

    public synchronized int hashCode() {
        if (!(this.value instanceof Object[])) {
            return this.value.hashCode();
        }
        Object[] valueArr = (Object[])this.value;
        int hashVal = 0;
        for (int i = 0; i < valueArr.length; ++i) {
            if (valueArr[i] == null) continue;
            hashVal += valueArr[i].hashCode();
        }
        return hashVal;
    }

    public synchronized boolean equals(Object obj) {
        if (obj instanceof CfgPropItem) {
            obj = ((CfgPropItem)obj).getValue();
        }
        if (!(this.value instanceof Object[])) {
            return this.value.equals(obj);
        }
        if (!(obj instanceof Object[])) {
            return false;
        }
        Object[] objArr = (Object[])obj;
        Object[] valueArr = (Object[])this.value;
        int valueArrLen = valueArr.length;
        if (objArr.length != valueArrLen) {
            return false;
        }
        for (int i = 0; i < valueArrLen; ++i) {
            Object valObj = valueArr[i];
            if (!(valObj != null ? !valObj.equals(objArr[i]) : objArr[i] != null)) continue;
            return false;
        }
        return true;
    }

    public synchronized int intValue() {
        return this.numberValue.intValue();
    }

    public synchronized long longValue() {
        return this.numberValue.longValue();
    }

    public synchronized float floatValue() {
        return this.numberValue.floatValue();
    }

    public synchronized double doubleValue() {
        return this.numberValue.doubleValue();
    }

    public synchronized byte byteValue() {
        return this.numberValue.byteValue();
    }

    public synchronized short shortValue() {
        return this.numberValue.shortValue();
    }

    public synchronized boolean booleanValue() {
        return this.booleanValue;
    }

    public synchronized String stringValue() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        if (this.value instanceof Color) {
            return UtilFns.colorToPropertyString((Color)this.value);
        }
        if (this.value instanceof Float || this.value instanceof Double) {
            return UtilFns.floatNumberToPropertyString(this.value);
        }
        return this.value.toString();
    }

    public Object clone() {
        return this.duplicate();
    }

    public synchronized Color colorValue() {
        return this.colorValue;
    }

    public synchronized int compareTo(Object obj) throws ClassCastException {
        return ((Comparable)this.value).compareTo(obj);
    }

    public String getCmdLnParamName() {
        return this.cmdLnParamName;
    }

    public String getDescriptionStr() {
        return this.descriptionStr;
    }

    public boolean getCmdLnEnbFlag() {
        return this.cmdLnEnbFlag;
    }

    public boolean getHelpScreenFlag() {
        return this.helpScreenFlag;
    }

    public boolean getCmdLnOnlyFlag() {
        return this.cmdLnOnlyFlag;
    }

    public synchronized CfgPropItem duplicate() {
        CfgPropItem itemObj = new CfgPropItem(this.name, this.defaultValue, this.requiredFlag, this.cmdLnParamName, this.descriptionStr, this.cmdLnEnbFlag, this.helpScreenFlag, this.cmdLnOnlyFlag);
        itemObj.setValueObject(this.value);
        itemObj.validatorObj = this.validatorObj;
        return itemObj;
    }

    public synchronized CfgPropItem setValidator(CfgPropValidator validatorObj) {
        if (CfgPropItem.validateValue(validatorObj, this.value)) {
            this.validatorObj = validatorObj;
        }
        return this;
    }

    public CfgPropItem setValidator(Comparable minValueCompObj, Comparable maxValueCompObj) {
        this.setValidator(new CfgPropValidator(minValueCompObj, maxValueCompObj));
        return this;
    }

    public synchronized CfgPropItem setValidator(Object[] objArr) {
        this.setValidator(new CfgPropValidator(objArr));
        return this;
    }

    public synchronized CfgPropItem setValidator(int minValue, int maxValue) {
        this.setValidator(new CfgPropValidator(new Integer(minValue), new Integer(maxValue)));
        return this;
    }

    public synchronized CfgPropItem setValidator(long minValue, long maxValue) {
        this.setValidator(new CfgPropValidator(new Long(minValue), new Long(maxValue)));
        return this;
    }

    public synchronized CfgPropItem setValidator(short minValue, short maxValue) {
        this.setValidator(new CfgPropValidator(new Short(minValue), new Short(maxValue)));
        return this;
    }

    public synchronized CfgPropItem setValidator(byte minValue, byte maxValue) {
        this.setValidator(new CfgPropValidator(new Byte(minValue), new Byte(maxValue)));
        return this;
    }

    public synchronized CfgPropItem setValidator(float minValue, float maxValue) {
        this.setValidator(new CfgPropValidator(new Float(minValue), new Float(maxValue)));
        return this;
    }

    public synchronized CfgPropItem setValidator(double minValue, double maxValue) {
        this.setValidator(new CfgPropValidator(new Double(minValue), new Double(maxValue)));
        return this;
    }

    public synchronized CfgPropValidator getValidator() {
        return this.validatorObj;
    }

    public static boolean validateValue(CfgPropValidator validatorObj, Object valueObj) {
        return PropItem.validateValue(validatorObj, valueObj);
    }

    public synchronized boolean validateValue(Object valueObj) {
        return CfgPropItem.validateValue(this.validatorObj, valueObj);
    }

    public synchronized CfgPropItem addDataChangedListener(DataChangedListener listenerObj) {
        if (listenerObj != null && this.listenersVec.indexOf(listenerObj) < 0) {
            this.listenersVec.add(listenerObj);
        }
        return this;
    }

    public synchronized void removeDataChangedListener(DataChangedListener listenerObj) {
        if (listenerObj != null) {
            this.listenersVec.remove(listenerObj);
        }
    }

    public void fireDataChanged() {
        this.lastChangeTime = System.currentTimeMillis();
        Enumeration e = this.listenersVec.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof DataChangedListener)) continue;
            ((DataChangedListener)obj).dataChanged(this);
        }
    }

    public long getLastChangeTime() {
        return this.lastChangeTime;
    }

    public synchronized CfgPropItem setGroupSelObj(Object obj) {
        this.groupSelObj = obj;
        return this;
    }

    public synchronized Object getGroupSelObj() {
        return this.groupSelObj;
    }

    public synchronized CfgPropItem setAuxiliaryObj(Object obj) {
        this.auxiliaryObj = obj;
        return this;
    }

    public synchronized Object getAuxiliaryObj() {
        return this.auxiliaryObj;
    }

    public synchronized CfgPropItem setStartupConfigFlag(boolean b) {
        this.startupConfigFlag = b;
        return this;
    }

    public boolean isDefaultValue() {
        if (this.value == this.defaultValue) {
            return true;
        }
        if (this.value == null || this.defaultValue == null) {
            return false;
        }
        return this.value.equals(this.defaultValue);
    }

    public synchronized boolean isStartupConfigFlag() {
        return this.startupConfigFlag;
    }

    public synchronized Map.Entry getMapEntry() {
        if (this.mapEntryObj == null) {
            this.mapEntryObj = new MapEntry();
        }
        return this.mapEntryObj;
    }

    public static class ItemGroupSelector {
        private Object selectorObj;
        private boolean enableFlag;

        public ItemGroupSelector(Object selectorObj, boolean enableFlag) {
            this.selectorObj = selectorObj;
            this.enableFlag = enableFlag;
        }

        public ItemGroupSelector(Object selectorObj) {
            this(selectorObj, true);
        }

        public void setSelectObj(Object selObj) {
            this.selectorObj = selObj;
        }

        public Object getSelectObj() {
            return this.enableFlag ? this.selectorObj : null;
        }

        public String getSelectStr() {
            return this.enableFlag && this.selectorObj instanceof String ? (String)this.selectorObj : null;
        }

        public void setEnableFlag(boolean flgVal) {
            this.enableFlag = flgVal;
        }

        public boolean getEnableFlag() {
            return this.enableFlag;
        }
    }

    class MapEntry
    implements Map.Entry {
        MapEntry() {
        }

        public synchronized Object getKey() {
            return CfgPropItem.this.getName();
        }

        public synchronized Object getValue() {
            return CfgPropItem.this.getValue();
        }

        public synchronized Object setValue(Object value) {
            Object oldValue = CfgPropItem.this.getValue();
            if (value == null) {
                throw new NullPointerException();
            }
            if (value.getClass() != CfgPropItem.this.defaultValue.getClass()) {
                throw new ClassCastException();
            }
            if (!CfgPropItem.this.setValue(value)) {
                throw new IllegalArgumentException();
            }
            return oldValue;
        }

        public synchronized boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.getKey() == null ? e.getKey() == null : this.getKey().equals(e.getKey())) && (this.getValue() == null ? e.getValue() == null : this.getValue().equals(e.getValue()));
        }

        public synchronized int hashCode() {
            return this.getKey() == null ? 0 : this.getKey().hashCode() ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

