/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.ErrorMessageMgr;
import com.isti.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class FileDataMonitor
extends ErrorMessageMgr {
    public static final byte[] ERROR_ARRAY = new byte[0];
    public static final byte[] NO_FILE_ARRAY = new byte[0];
    private final String fileNameString;
    private final boolean allowMissingFlag;
    private URL fileAccessUrlObj = null;
    private long fileLastModifiedTimeMs = 0L;
    private long prevFileLastModTimeMs = 0L;

    public FileDataMonitor(String fNameStr, boolean allowMissingFlag) {
        this.fileNameString = fNameStr;
        this.allowMissingFlag = allowMissingFlag;
    }

    public FileDataMonitor(String fNameStr) {
        this(fNameStr, false);
    }

    public byte[] checkReadFileData(int timeOutMs, long maxReadBytesLimit) {
        this.clearErrorMessageString();
        this.fileAccessUrlObj = null;
        DataAccessThread dataAccessThreadObj = new DataAccessThread(this.fileNameString, this.allowMissingFlag, this.fileLastModifiedTimeMs, maxReadBytesLimit);
        int threadSleepDelay = 25;
        while (!dataAccessThreadObj.accessCompletedFlag) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException ex) {
                return null;
            }
            if (timeOutMs <= 0 || (timeOutMs -= 25) > 0) continue;
            this.setErrorMessageString("Timeout while attempting to read from file \"" + this.fileNameString + "\"");
            return ERROR_ARRAY;
        }
        this.fileAccessUrlObj = dataAccessThreadObj.fileAccessUrlObj;
        this.prevFileLastModTimeMs = this.fileLastModifiedTimeMs;
        this.fileLastModifiedTimeMs = dataAccessThreadObj.fileLastModifiedTimeMs;
        if (dataAccessThreadObj.returnedByteArray == ERROR_ARRAY) {
            this.setErrorMessageString(dataAccessThreadObj.getErrorMessageString());
        }
        return dataAccessThreadObj.returnedByteArray;
    }

    public String getFileNameString() {
        return this.fileNameString;
    }

    public URL getFileAccessUrlObj() {
        return this.fileAccessUrlObj;
    }

    public long getFileLastModifiedTimeMs() {
        return this.fileLastModifiedTimeMs;
    }

    public long getPrevFileLastModTimeMs() {
        return this.prevFileLastModTimeMs;
    }

    private static class DataAccessThread
    extends ErrorMessageMgr
    implements Runnable {
        private final String fileNameString;
        private final boolean allowMissingFlag;
        private final long maxReadBytesLimit;
        private URL fileAccessUrlObj = null;
        private long fileLastModifiedTimeMs;
        private boolean accessCompletedFlag = false;
        private byte[] returnedByteArray = null;

        public DataAccessThread(String fileNameString, boolean allowMissingFlag, long fileLastModifiedTimeMs, long maxReadBytesLimit) {
            this.fileNameString = fileNameString;
            this.allowMissingFlag = allowMissingFlag;
            this.fileLastModifiedTimeMs = fileLastModifiedTimeMs;
            this.maxReadBytesLimit = maxReadBytesLimit;
            new Thread((Runnable)this, "FileDataMonitorAccess-" + System.currentTimeMillis()).start();
        }

        public void run() {
            this.returnedByteArray = this.doCheckReadFileData();
            this.accessCompletedFlag = true;
        }

        public byte[] doCheckReadFileData() {
            URLConnection urlConnectionObj;
            InputStream inStmObj;
            byte[] retByteArr;
            block20: {
                retByteArr = null;
                inStmObj = null;
                urlConnectionObj = null;
                try {
                    long lastModTime;
                    this.fileAccessUrlObj = null;
                    try {
                        this.fileAccessUrlObj = FileUtils.fileMultiOpenInputURL(this.fileNameString);
                        if (this.fileAccessUrlObj == null) {
                            if (this.allowMissingFlag) {
                                return NO_FILE_ARRAY;
                            }
                            this.setErrorMessageString("Unable to find file \"" + this.fileNameString + "\"");
                            return ERROR_ARRAY;
                        }
                        urlConnectionObj = this.fileAccessUrlObj.openConnection();
                    }
                    catch (IOException ex) {
                        this.setErrorMessageString("Error accessing file \"" + this.fileNameString + "\":  " + ex);
                        return ERROR_ARRAY;
                    }
                    try {
                        lastModTime = urlConnectionObj.getLastModified();
                    }
                    catch (Exception ex) {
                        lastModTime = 0L;
                    }
                    if (lastModTime <= 0L) {
                        try {
                            lastModTime = new File(this.fileAccessUrlObj.getPath()).lastModified();
                        }
                        catch (Exception ex) {
                            lastModTime = 0L;
                        }
                    }
                    if (lastModTime > 0L) {
                        if (lastModTime == this.fileLastModifiedTimeMs) break block20;
                        this.fileLastModifiedTimeMs = lastModTime;
                        try {
                            inStmObj = urlConnectionObj.getInputStream();
                            if (inStmObj == null) {
                                this.setErrorMessageString("Unable to fetch input stream for file \"" + this.fileNameString + "\"");
                                return ERROR_ARRAY;
                            }
                        }
                        catch (Exception ex) {
                            this.setErrorMessageString("Error fetching input stream for file \"" + this.fileNameString + "\":  " + ex);
                            return ERROR_ARRAY;
                        }
                        ByteArrayOutputStream outStmObj = new ByteArrayOutputStream();
                        try {
                            FileUtils.transferStream(inStmObj, (OutputStream)outStmObj, this.maxReadBytesLimit);
                            inStmObj.close();
                        }
                        catch (Exception ex) {
                            this.setErrorMessageString("Error reading from file \"" + this.fileNameString + "\":  " + ex);
                            inStmObj.close();
                            return ERROR_ARRAY;
                        }
                        return outStmObj.toByteArray();
                    }
                    this.setErrorMessageString("Unable to fetch last-modified time for file \"" + this.fileNameString + "\"");
                    retByteArr = ERROR_ARRAY;
                }
                catch (Exception ex) {
                    this.setErrorMessageString("Error accessing file \"" + this.fileNameString + "\":  " + ex);
                    retByteArr = ERROR_ARRAY;
                }
            }
            try {
                if (urlConnectionObj != null && (inStmObj = urlConnectionObj.getInputStream()) != null) {
                    inStmObj.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return retByteArr;
        }
    }
}

