/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.FileDataMonitor;
import com.isti.util.IstiNotifyThread;

public class FileMonPollingThread
extends IstiNotifyThread {
    public static final byte[] ERROR_ARRAY = FileDataMonitor.ERROR_ARRAY;
    protected final FileDataMonitor fileDataMonitorObj;
    protected final int pollingIntervalMs;
    protected final int fileAccessTimeOutMs;
    protected final long maxReadBytesLimit;
    protected final FileDataCallBack fileDataCallBackObj;

    public FileMonPollingThread(String fNameStr, int pollingIntervalMs, int fileAccessTimeOutMs, long maxReadBytesLimit, FileDataCallBack fileDataCallBackObj) {
        super("FileMonPollingThread-" + fNameStr);
        if (fNameStr == null || fileDataCallBackObj == null) {
            throw new NullPointerException("Null parameter(s)");
        }
        if (pollingIntervalMs <= 0) {
            throw new IllegalArgumentException("pollingIntervalMs <= 0");
        }
        this.fileDataMonitorObj = new FileDataMonitor(fNameStr);
        this.pollingIntervalMs = pollingIntervalMs;
        this.fileAccessTimeOutMs = fileAccessTimeOutMs;
        this.maxReadBytesLimit = maxReadBytesLimit;
        this.fileDataCallBackObj = fileDataCallBackObj;
    }

    public void run() {
        while (!(this.isTerminated() || !this.waitForNotify(this.pollingIntervalMs) && this.isTerminated())) {
            try {
                byte[] byteArr = this.checkReadFileData();
                if (byteArr == null) continue;
                if (byteArr != ERROR_ARRAY) {
                    this.fileDataCallBackObj.callBackMethod(true, byteArr);
                    continue;
                }
                this.fileDataCallBackObj.callBackMethod(false, this.fileDataMonitorObj.getErrorMessageString().getBytes());
            }
            catch (Exception ex) {
                System.err.println("Error in FileMonPollingThread:  " + ex);
                ex.printStackTrace();
            }
        }
    }

    public byte[] checkReadFileData() {
        return this.fileDataMonitorObj.checkReadFileData(this.fileAccessTimeOutMs, this.maxReadBytesLimit);
    }

    public FileDataMonitor getFileDataMonitorObj() {
        return this.fileDataMonitorObj;
    }

    public boolean getErrorMessageFlag() {
        return this.fileDataMonitorObj.getErrorMessageFlag();
    }

    public String getErrorMessageString() {
        return this.fileDataMonitorObj.getErrorMessageString();
    }

    public static interface FileDataCallBack {
        public void callBackMethod(boolean var1, byte[] var2);
    }
}

