/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.Archivable;
import com.isti.util.ExtendedArchiveManager;
import com.isti.util.FileUtils;
import com.isti.util.IstiFileFilter;
import com.isti.util.UtilFns;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class FlatDailyArchiveManager
extends ExtendedArchiveManager {
    public static final String DEF_DATE_FORMAT_STR = "yyyyMMdd";
    public static final String DEF_FNAME_DATE_SEPSTR = "_";
    private DateFormat dateFormatObj = null;
    private boolean dateFormatChangedFlag = false;
    private String fNameDateSepStr = "_";
    private String archiveStmFileNameStr = null;
    private SimpleDateFormat fileNameDateParserObj;

    public FlatDailyArchiveManager(Class classObj, String archiveRootDirName, String baseFileNameStr) throws NoSuchMethodException {
        super(classObj, archiveRootDirName, baseFileNameStr);
        this.setPurgeIntoArchiveFlag(false);
        this.createDefaultDateFormatter();
    }

    public FlatDailyArchiveManager(Class classObj, String baseFileNameStr) throws NoSuchMethodException {
        this(classObj, null, baseFileNameStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDateFormatObj(DateFormat dFormatObj) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            if (dFormatObj != null) {
                this.dateFormatObj = dFormatObj;
            } else {
                this.createDefaultDateFormatter();
            }
            this.dateFormatChangedFlag = true;
        }
    }

    public DateFormat getDateFormatObj() {
        return this.dateFormatObj;
    }

    public void setDateFormatTimeZone(TimeZone timeZoneObj) {
        this.dateFormatObj.setTimeZone(timeZoneObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFNameDateSepStr(String sepStr) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.fNameDateSepStr = sepStr != null ? sepStr : DEF_FNAME_DATE_SEPSTR;
        }
    }

    public String getFNameDateSepStr() {
        return this.fNameDateSepStr;
    }

    protected void createDefaultDateFormatter() {
        this.dateFormatObj = UtilFns.createDateFormatObj(DEF_DATE_FORMAT_STR, UtilFns.GMT_TIME_ZONE_OBJ);
    }

    protected String getArchiveFileNameForDate(Date dateObj) {
        return FileUtils.addStrToFileName(this.archiveFileNameStr, this.fNameDateSepStr + this.dateFormatObj.format(dateObj));
    }

    protected OutputStream getOutputStreamForItem(Archivable item) throws IOException {
        String fileNameStr = this.getArchiveFileNameForDate(item.getArchiveDate());
        if (this.archiveOutStm != null) {
            if (this.archiveStmFileNameStr != null && this.archiveStmFileNameStr.equals(fileNameStr)) {
                return this.archiveOutStm;
            }
            try {
                this.archiveOutStm.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.archiveOutStm = null;
            this.archiveStmFileNameStr = null;
        }
        File fileObj = this.getArchiveFileForName(fileNameStr);
        this.archiveOutStm = new BufferedOutputStream(new FileOutputStream(fileObj.getPath(), true));
        this.archiveStmFileNameStr = fileNameStr;
        return this.archiveOutStm;
    }

    protected Vector getArchiveFilesForDateRange(Date startDate, Date endDate) {
        Vector<Object> retVec = new Vector<Object>();
        Object[] fileArr = new File(this.archiveRootDirName != null ? this.archiveRootDirName : ".").listFiles(IstiFileFilter.createFileFilter(FileUtils.addStrToFileName(this.archiveFileNameStr, this.fNameDateSepStr + "*")));
        if (fileArr != null && fileArr.length > 0) {
            Arrays.sort(fileArr);
            long startDateMsVal = startDate != null ? startDate.getTime() : 0L;
            long endDateMsVal = endDate != null ? endDate.getTime() : 0L;
            for (int i = 0; i < fileArr.length; ++i) {
                long dateMsVal;
                Object fileObj = fileArr[i];
                Date dateObj = this.getDateForArchiveFileName(((File)fileObj).getName());
                long l = dateMsVal = dateObj != null ? dateObj.getTime() : 0L;
                if (dateObj == null || startDate != null && dateMsVal + 86400000L <= startDateMsVal || endDate != null && dateMsVal > endDateMsVal) continue;
                retVec.add(fileObj);
            }
        }
        return retVec;
    }

    public DateFormat getFileNameDateParserObj() {
        if (this.fileNameDateParserObj == null || this.dateFormatChangedFlag) {
            this.dateFormatChangedFlag = false;
            String qt = "'";
            Object obj = this.dateFormatObj.clone();
            if (obj instanceof SimpleDateFormat) {
                this.fileNameDateParserObj = (SimpleDateFormat)obj;
                this.fileNameDateParserObj.applyPattern(FileUtils.addStrToFileName("'" + this.archiveFileNameStr + "'", this.fNameDateSepStr + "'" + this.fileNameDateParserObj.toPattern() + "'"));
            } else {
                this.fileNameDateParserObj = new SimpleDateFormat(FileUtils.addStrToFileName("'" + this.archiveFileNameStr + "'", this.fNameDateSepStr + "'" + DEF_DATE_FORMAT_STR + "'"));
            }
            this.fileNameDateParserObj.setLenient(false);
        }
        return this.fileNameDateParserObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getDateForArchiveFileName(String fNameStr) {
        Date dateObj;
        try {
            DateFormat fnDateParserObj;
            DateFormat dateFormat = fnDateParserObj = this.getFileNameDateParserObj();
            synchronized (dateFormat) {
                dateObj = fnDateParserObj.parse(fNameStr);
            }
        }
        catch (Exception ex) {
            dateObj = null;
        }
        return dateObj;
    }

    protected boolean doesNextArchiveFileExist(String fNameStr) {
        Date dateObj = this.getDateForArchiveFileName(fNameStr);
        return dateObj != null && new File(this.getArchiveFileNameForDate(new Date(dateObj.getTime() + 86400000L))).exists();
    }
}

