/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.FileUtils;
import com.isti.util.LogFile;
import com.isti.util.UtilFns;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.spec.EncodedKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class IstiEncryptionUtils {
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    public static final int DEFAULT_KEYSIZE = 2048;
    public static final String DSA_ALGORITHM = "DSA";
    public static final String RSA_ALGORITHM = "RSA";
    public static final String SHA_ALGORITHM = "SHA";
    public static final String SHA1_WITH_RSA = "SHA1withRSA";
    private static final boolean PRIVATE_KEY_FLAG = false;
    private static final boolean PUBLIC_KEY_FLAG = true;

    private IstiEncryptionUtils() {
    }

    public static byte[] decodeBuffer(InputStream inStream) throws IOException {
        return new BASE64Decoder().decodeBuffer(inStream);
    }

    public static byte[] decodeBuffer(String buffer) throws IOException {
        return new BASE64Decoder().decodeBuffer(buffer);
    }

    private static byte[] decodeKeyBytes(InputStream inStream, boolean publicKeyFlag) {
        byte[] bytes = null;
        try {
            bytes = FileUtils.readStreamToBuffer(inStream);
            BufferedReader rdrObj = FileUtils.getBufferedReader(new ByteArrayInputStream(bytes));
            String str = rdrObj.readLine();
            if (str != null && str.startsWith(IstiEncryptionUtils.getBeginCommentText(publicKeyFlag))) {
                StringWriter strWtrObj = new StringWriter();
                PrintWriter prtWtrObj = new PrintWriter(strWtrObj);
                String endCommentText = IstiEncryptionUtils.getEndCommentText(publicKeyFlag);
                while ((str = rdrObj.readLine()) != null) {
                    if (str.equals(endCommentText)) {
                        String buffer = strWtrObj.toString();
                        bytes = IstiEncryptionUtils.decodeBuffer(buffer);
                        break;
                    }
                    prtWtrObj.println(str);
                }
                prtWtrObj.flush();
            }
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning(IstiEncryptionUtils.generateKeyErrorMessage(publicKeyFlag) + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
        }
        return bytes;
    }

    public static String encode(byte[] byteArray) {
        return new BASE64Encoder().encode(byteArray);
    }

    public static String encrypt(String original, MessageDigest md) {
        if (md != null) {
            try {
                md.reset();
                md.update(original.getBytes(DEFAULT_CHARACTER_ENCODING));
                byte[] raw = md.digest();
                String hash = IstiEncryptionUtils.encode(raw);
                return hash;
            }
            catch (Exception ex) {
                LogFile.getGlobalLogObj(true).warning("Error with encrypt:  " + ex);
                LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            }
        }
        return "";
    }

    public static String encrypt(String original, String algorithm) {
        return IstiEncryptionUtils.encrypt(original, IstiEncryptionUtils.generateMessageDigest(algorithm));
    }

    private static String generateKeyErrorMessage(boolean publicKeyFlag) {
        return "Could not generate " + (publicKeyFlag ? "Public" : "Private") + "Key: ";
    }

    private static String getBeginCommentText(boolean publicKeyFlag) {
        return IstiEncryptionUtils.getCommentText(publicKeyFlag, true);
    }

    private static String getEndCommentText(boolean publicKeyFlag) {
        return IstiEncryptionUtils.getCommentText(publicKeyFlag, false);
    }

    private static String getCommentText(boolean publicKeyFlag, boolean beginFlag) {
        StringBuffer commentText = new StringBuffer("-----");
        if (beginFlag) {
            commentText.append("BEGIN ");
        } else {
            commentText.append("END ");
        }
        if (publicKeyFlag) {
            commentText.append("PUBLIC");
        } else {
            commentText.append("PRIVATE");
        }
        commentText.append(" KEY-----");
        return commentText.toString();
    }

    private static Key generateKey(InputStream inStream, boolean publicKeyFlag) {
        return IstiEncryptionUtils.generateKey(inStream, publicKeyFlag, publicKeyFlag);
    }

    private static Key generateKey(InputStream inStream, boolean publicKeyFlag, boolean isX509EncodedFlag) {
        try {
            String algorithm = RSA_ALGORITHM;
            EncodedKeySpec keySpec = isX509EncodedFlag ? new X509EncodedKeySpec(IstiEncryptionUtils.decodeBuffer(inStream)) : new PKCS8EncodedKeySpec(IstiEncryptionUtils.decodeKeyBytes(inStream, publicKeyFlag));
            return IstiEncryptionUtils.generateKey(algorithm, publicKeyFlag, keySpec);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning(IstiEncryptionUtils.generateKeyErrorMessage(publicKeyFlag) + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    private static Key generateKey(String algorithm, boolean publicKeyFlag, KeySpec keySpec) {
        try {
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            if (publicKeyFlag) {
                return kf.generatePublic(keySpec);
            }
            return kf.generatePrivate(keySpec);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning(IstiEncryptionUtils.generateKeyErrorMessage(publicKeyFlag) + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static KeyPair generateKeyPair(KeyPairGenerator kpg) {
        KeyPair kp = kpg.generateKeyPair();
        return kp;
    }

    public static KeyPairGenerator generateKeyPairGenerator(String algorithm) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(algorithm);
            kpg.initialize(2048);
            return kpg;
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate key pair (" + algorithm + ") :" + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static MessageDigest generateMessageDigest(String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            return md;
        }
        catch (NoSuchAlgorithmException ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate MessageDigest (" + algorithm + ") :" + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static PrivateKey generatePrivateKey(byte[] data) {
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(data);
            return IstiEncryptionUtils.generatePrivateKey(inStream);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate PrivateKey:  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static PrivateKey generatePrivateKey(File privFile) {
        try {
            FileInputStream inStream = new FileInputStream(privFile);
            return IstiEncryptionUtils.generatePrivateKey(inStream);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate PrivateKey:  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static PrivateKey generatePrivateKey(InputStream inStream) {
        return (PrivateKey)IstiEncryptionUtils.generateKey(inStream, false);
    }

    public static PrivateKey generatePrivateKey(String privFile) {
        InputStream inStream = FileUtils.fileMultiOpenInputStream(privFile);
        if (inStream == null) {
            LogFile.getGlobalLogObj(true).warning("Could not open private key file: " + privFile);
            return null;
        }
        return IstiEncryptionUtils.generatePrivateKey(inStream);
    }

    public static PublicKey generatePublicKey(byte[] data) {
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(data);
            return IstiEncryptionUtils.generatePublicKey(inStream);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate PublicKey:  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static PublicKey generatePublicKey(File pubFile) {
        try {
            FileInputStream inStream = new FileInputStream(pubFile);
            return IstiEncryptionUtils.generatePublicKey(inStream);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate PublicKey:  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static PublicKey generatePublicKey(InputStream inStream) {
        return (PublicKey)IstiEncryptionUtils.generateKey(inStream, true);
    }

    public static PublicKey generatePublicKey(String pubFile) {
        InputStream inStream = FileUtils.fileMultiOpenInputStream(pubFile);
        if (inStream == null) {
            LogFile.getGlobalLogObj(true).warning("Could not open public key file: " + pubFile);
            return null;
        }
        return IstiEncryptionUtils.generatePublicKey(inStream);
    }

    public static Signature generateSignature(String algorithm) {
        try {
            Signature sig = Signature.getInstance(algorithm);
            return sig;
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate Signature (" + algorithm + ") :" + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static String generateSignatureText(String msgText, KeyPair kp) {
        return IstiEncryptionUtils.generateSignatureText(msgText, kp.getPrivate());
    }

    public static String generateSignatureText(String msgText, PrivateKey priv) {
        String algorithm = priv.getAlgorithm();
        if (RSA_ALGORITHM.equals(algorithm)) {
            algorithm = SHA1_WITH_RSA;
        }
        try {
            Signature sig = Signature.getInstance(algorithm);
            sig.initSign(priv);
            sig.update(msgText.getBytes(DEFAULT_CHARACTER_ENCODING));
            byte[] raw = sig.sign();
            String sigText = IstiEncryptionUtils.encode(raw);
            return sigText;
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate Signature (" + algorithm + ") :" + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return "";
        }
    }

    public static X509Certificate generateX509Certificate(byte[] data) {
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(data);
            return IstiEncryptionUtils.generateX509Certificate(inStream);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate X509Certificate:  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static X509Certificate generateX509Certificate(File certificateFile) {
        try {
            FileInputStream inStream = new FileInputStream(certificateFile);
            return IstiEncryptionUtils.generateX509Certificate(inStream);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate X509Certificate:  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static X509Certificate generateX509Certificate(InputStream inStream) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
            inStream.close();
            return cert;
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate X509Certificate:  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static X509Certificate generateX509Certificate(String certificateFile) {
        try {
            InputStream inStream = FileUtils.fileMultiOpenInputStream(certificateFile);
            if (inStream == null) {
                LogFile.getGlobalLogObj(true).warning("Could not open certificate file: " + certificateFile);
                return null;
            }
            return IstiEncryptionUtils.generateX509Certificate(inStream);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate X509Certificate:  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static X509CRL generateX509CRL(byte[] data) {
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(data);
            return IstiEncryptionUtils.generateX509CRL(inStream);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate X509CRL:  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static X509CRL generateX509CRL(File crlFile) {
        try {
            FileInputStream inStream = new FileInputStream(crlFile);
            return IstiEncryptionUtils.generateX509CRL(inStream);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate X509CRL:  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static X509CRL generateX509CRL(InputStream inStream) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL crl = (X509CRL)cf.generateCRL(inStream);
            inStream.close();
            return crl;
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate X509CRL:  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static X509CRL generateX509CRL(String crlFile) {
        InputStream inStream = FileUtils.fileMultiOpenInputStream(crlFile);
        if (inStream == null) {
            LogFile.getGlobalLogObj(true).warning("Could not open CRL file: " + crlFile);
            return null;
        }
        return IstiEncryptionUtils.generateX509CRL(inStream);
    }

    public static X509CRLEntry getRevokedCertificate(X509CRL crl, BigInteger serialNumber) {
        try {
            X509CRLEntry revokedCert = crl.getRevokedCertificate(serialNumber);
            return revokedCert;
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("Could not generate X509CRL:  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static X509CRLEntry getRevokedCertificate(X509CRL crl, X509Certificate cert) {
        return IstiEncryptionUtils.getRevokedCertificate(crl, cert.getSerialNumber());
    }

    public static boolean isValidSignatureText(String msgText, String sigText, KeyPair kp) {
        return IstiEncryptionUtils.isValidSignatureText(msgText, sigText, kp.getPublic());
    }

    public static boolean isValidSignatureText(String msgText, String sigText, PublicKey pub) {
        String algorithm = pub.getAlgorithm();
        if (RSA_ALGORITHM.equals(algorithm)) {
            algorithm = SHA1_WITH_RSA;
        }
        try {
            Signature sig = Signature.getInstance(algorithm);
            sig.initVerify(pub);
            return IstiEncryptionUtils.isValidSignatureText(msgText, sigText, sig);
        }
        catch (InvalidKeyException ex) {
            LogFile.getGlobalLogObj(false).debug("Key is invalid: " + ex);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("isValidSignatureText error:  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
        }
        return false;
    }

    public static boolean isValidSignatureText(String msgText, String sigText, Signature sig) {
        try {
            byte[] raw = IstiEncryptionUtils.decodeBuffer(sigText);
            sig.update(msgText.getBytes(DEFAULT_CHARACTER_ENCODING));
            return sig.verify(raw);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("isValidSignatureText error:  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return false;
        }
    }

    public static boolean isValidSignatureText(String msgText, String sigText, X509Certificate cert) {
        try {
            return IstiEncryptionUtils.isValidSignatureText(msgText, sigText, cert.getPublicKey());
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("isValidSignatureText error:  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return false;
        }
    }

    public static boolean isValidX509Certificate(X509Certificate cert) {
        try {
            cert.checkValidity();
            return true;
        }
        catch (CertificateException ex) {
            LogFile.getGlobalLogObj(false).debug("Certificate is not valid: " + ex);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("isValidX509Certificate error: " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
        }
        return false;
    }

    public static boolean isValidX509CRL(X509CRL crl) {
        try {
            Date currentDate = new Date();
            Date nextUpdate = crl.getNextUpdate();
            Date thisUpdate = crl.getThisUpdate();
            if (thisUpdate != null && thisUpdate.after(currentDate)) {
                LogFile.getGlobalLogObj(false).debug("CRL update is after current time");
                return false;
            }
            if (nextUpdate != null && nextUpdate.before(currentDate)) {
                LogFile.getGlobalLogObj(false).debug("CRL next update is before current time");
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("isValidX509CRL error: " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
            return false;
        }
    }

    public static boolean verifyX509Certificate(X509Certificate cert, PublicKey key) {
        try {
            cert.verify(key);
            return true;
        }
        catch (GeneralSecurityException ex) {
            LogFile.getGlobalLogObj(false).debug("Certificate is not valid: " + ex);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("verifyX509Certificate error: " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
        }
        return false;
    }

    public static boolean verifyX509CRL(X509CRL crl, PublicKey key) {
        try {
            crl.verify(key);
            return true;
        }
        catch (GeneralSecurityException ex) {
            LogFile.getGlobalLogObj(false).debug("CRL is not valid: " + ex);
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("verifyX509CRL error: " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
        }
        return false;
    }

    public static boolean verifyX509Information(String certificateFile, String certificateOfAuthorityFile, String crlFile) {
        X509Certificate certificate = IstiEncryptionUtils.generateX509Certificate(certificateFile);
        X509Certificate certificateOfAuthority = IstiEncryptionUtils.generateX509Certificate(certificateOfAuthorityFile);
        X509CRL crl = IstiEncryptionUtils.generateX509CRL(crlFile);
        return IstiEncryptionUtils.verifyX509Information(certificate, certificateOfAuthority, crl);
    }

    public static boolean verifyX509Information(X509Certificate certificate, X509Certificate certificateOfAuthority, X509CRL crl) {
        if (certificate == null || !IstiEncryptionUtils.isValidX509Certificate(certificate)) {
            LogFile.getGlobalLogObj(false).debug("Certificate is not valid");
            return false;
        }
        if (certificateOfAuthority == null || !IstiEncryptionUtils.isValidX509Certificate(certificateOfAuthority)) {
            LogFile.getGlobalLogObj(false).debug("Certificate of authority is not valid");
            return false;
        }
        if (crl == null || !IstiEncryptionUtils.isValidX509CRL(crl)) {
            LogFile.getGlobalLogObj(false).debug("CRL is not valid");
            return false;
        }
        if (!IstiEncryptionUtils.verifyX509Certificate(certificate, certificateOfAuthority.getPublicKey())) {
            LogFile.getGlobalLogObj(false).debug("Certificate is not from certificate of authority");
            return false;
        }
        if (!IstiEncryptionUtils.verifyX509CRL(crl, certificateOfAuthority.getPublicKey())) {
            LogFile.getGlobalLogObj(false).debug("CRL is not from certificate of authority");
            return false;
        }
        if (IstiEncryptionUtils.getRevokedCertificate(crl, certificate) != null) {
            LogFile.getGlobalLogObj(false).debug("Certificate is on the CRL");
            return false;
        }
        return true;
    }
}

