/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import java.applet.Applet;
import java.applet.AppletContext;
import java.net.MalformedURLException;
import java.net.URL;

public class LaunchBrowser {
    public static final int NON_WINDOWS = 0;
    public static final int WINDOWS_98 = 1;
    public static final int WINDOWS_XP = 2;
    public static final int MACINTOSH = 3;
    protected static final String[] osSelStringsArr = new String[]{"Non-Windows", "Windows95/98", "Windows2000/XP", "Macintosh"};
    protected final AppletContext appletContextObj;
    protected int osSelectVal = 0;
    protected static String osNamePropString = null;
    protected String errorMessage = null;
    protected static String NETSCPSP_STR = "netscape ";
    protected static String UBOPENSP_STR = "/usr/bin/open ";
    protected static String STARTSP_STR = "start ";
    protected static String STARTQT_STR = STARTSP_STR + "\"";
    protected static String CMDCQT_STR = "cmd /C \"";
    protected static String EMPTY_STR = "";
    protected static String QUOTE_STR = "\"";
    protected static String NEED_ESC_CHARS = "&|()^";
    protected final String[] httpOsPrefixArr = new String[]{NETSCPSP_STR, STARTQT_STR, CMDCQT_STR + STARTSP_STR, UBOPENSP_STR};
    protected final String[] httpOsSuffixArr = new String[]{EMPTY_STR, QUOTE_STR, QUOTE_STR, EMPTY_STR};
    protected final String[] fileOsPrefixArr = new String[]{NETSCPSP_STR, STARTQT_STR, CMDCQT_STR, UBOPENSP_STR};
    protected final String[] fileOsSuffixArr = new String[]{EMPTY_STR, QUOTE_STR, QUOTE_STR, EMPTY_STR};
    protected String[] httpCmdPrefixArr = null;
    protected String[] httpCmdSuffixArr = null;
    protected String[] fileCmdPrefixArr = null;
    protected String[] fileCmdSuffixArr = null;
    protected int firstCmdArrIdx = 1;
    protected String lastShowURLCmdStr = null;
    protected boolean browserLaunchEnabledFlag = true;

    public LaunchBrowser() {
        this(LaunchBrowser.determineOSType());
    }

    public LaunchBrowser(String cmdPrefixStr) {
        this(LaunchBrowser.determineOSType());
        this.setLaunchCommand(cmdPrefixStr);
    }

    public LaunchBrowser(String cmdPrefixStr, String cmdSuffixStr) {
        this(LaunchBrowser.determineOSType());
        this.setLaunchCommand(cmdPrefixStr, cmdSuffixStr);
    }

    public LaunchBrowser(int selVal) {
        this.appletContextObj = null;
        if (!this.setOSType(selVal)) {
            this.setOSType(0);
        }
    }

    public LaunchBrowser(int selVal, String cmdPrefixStr) {
        this(selVal);
        this.setLaunchCommand(cmdPrefixStr);
    }

    public LaunchBrowser(int selVal, String cmdPrefixStr, String cmdSuffixStr) {
        this(selVal);
        this.setLaunchCommand(cmdPrefixStr, cmdSuffixStr);
    }

    public LaunchBrowser(AppletContext appletContextObj) {
        this.appletContextObj = appletContextObj;
    }

    public LaunchBrowser(Applet appletObj) {
        this.appletContextObj = appletObj != null ? appletObj.getAppletContext() : null;
    }

    public boolean setOSType(int selVal) {
        int i;
        int[] idxValArr = new int[this.httpOsPrefixArr.length];
        switch (selVal) {
            case 0: {
                idxValArr[0] = 0;
                idxValArr[1] = 1;
                idxValArr[2] = 2;
                idxValArr[3] = 3;
                break;
            }
            case 1: {
                idxValArr[0] = 1;
                idxValArr[1] = 2;
                idxValArr[2] = 0;
                idxValArr[3] = 3;
                break;
            }
            case 2: {
                idxValArr[0] = 2;
                idxValArr[1] = 1;
                idxValArr[2] = 0;
                idxValArr[3] = 3;
                break;
            }
            case 3: {
                idxValArr[0] = 3;
                idxValArr[1] = 0;
                idxValArr[2] = 1;
                idxValArr[3] = 2;
                break;
            }
            default: {
                return false;
            }
        }
        this.osSelectVal = selVal;
        if (this.httpCmdPrefixArr == null) {
            this.httpCmdPrefixArr = new String[this.httpOsPrefixArr.length + 1];
            this.httpCmdPrefixArr[0] = this.httpOsPrefixArr[idxValArr[0]];
        }
        if (this.httpCmdSuffixArr == null) {
            this.httpCmdSuffixArr = new String[this.httpOsPrefixArr.length + 1];
            this.httpCmdSuffixArr[0] = this.httpOsSuffixArr[idxValArr[0]];
        }
        for (i = 0; i < this.httpOsPrefixArr.length; ++i) {
            this.httpCmdPrefixArr[i + 1] = this.httpOsPrefixArr[idxValArr[i]];
            this.httpCmdSuffixArr[i + 1] = this.httpOsSuffixArr[idxValArr[i]];
        }
        if (this.fileCmdPrefixArr == null) {
            this.fileCmdPrefixArr = new String[this.fileOsPrefixArr.length + 1];
            this.fileCmdPrefixArr[0] = this.fileOsPrefixArr[idxValArr[0]];
        }
        if (this.fileCmdSuffixArr == null) {
            this.fileCmdSuffixArr = new String[this.fileOsPrefixArr.length + 1];
            this.fileCmdSuffixArr[0] = this.fileOsSuffixArr[idxValArr[0]];
        }
        for (i = 0; i < this.fileOsPrefixArr.length; ++i) {
            this.fileCmdPrefixArr[i + 1] = this.fileOsPrefixArr[idxValArr[i]];
            this.fileCmdSuffixArr[i + 1] = this.fileOsSuffixArr[idxValArr[i]];
        }
        return true;
    }

    public void setLaunchCommand(String cmdPrefixStr, String cmdSuffixStr, boolean addSpaceFlag, boolean httpCmdFlag, boolean fileCmdFlag) {
        int len;
        if (cmdPrefixStr == null && cmdSuffixStr == null) {
            this.firstCmdArrIdx = 1;
            return;
        }
        if (cmdPrefixStr == null) {
            cmdPrefixStr = "";
        }
        if (cmdSuffixStr == null) {
            cmdSuffixStr = "";
        }
        if (!(this.httpCmdPrefixArr != null && this.httpCmdSuffixArr != null || this.setOSType(0))) {
            return;
        }
        if (addSpaceFlag && (len = cmdPrefixStr.length()) > 0 && Character.isUnicodeIdentifierPart(cmdPrefixStr.charAt(len - 1))) {
            cmdPrefixStr = cmdPrefixStr + " ";
        }
        if (httpCmdFlag) {
            this.httpCmdPrefixArr[0] = cmdPrefixStr;
            this.httpCmdSuffixArr[0] = cmdSuffixStr;
        }
        if (fileCmdFlag) {
            this.fileCmdPrefixArr[0] = cmdPrefixStr;
            this.fileCmdSuffixArr[0] = cmdSuffixStr;
        }
        this.firstCmdArrIdx = 0;
    }

    public void setLaunchCommand(String cmdPrefixStr, String cmdSuffixStr, boolean addSpaceFlag) {
        this.setLaunchCommand(cmdPrefixStr, cmdSuffixStr, addSpaceFlag, true, true);
    }

    public void setLaunchCommand(String cmdPrefixStr, String cmdSuffixStr, boolean httpCmdFlag, boolean fileCmdFlag) {
        this.setLaunchCommand(cmdPrefixStr, cmdSuffixStr, true, httpCmdFlag, httpCmdFlag);
    }

    public void setLaunchCommand(String cmdPrefixStr, String cmdSuffixStr) {
        this.setLaunchCommand(cmdPrefixStr, cmdSuffixStr, true, true, true);
    }

    public void setLaunchCommand(String cmdPrefixStr, boolean addSpaceFlag) {
        this.setLaunchCommand(cmdPrefixStr, null, addSpaceFlag, true, true);
    }

    public void setLaunchCommand(String cmdPrefixStr) {
        this.setLaunchCommand(cmdPrefixStr, null, true, true, true);
    }

    public boolean showApplicationURL(String urlStr) {
        String[] cmdSuffixArr;
        String[] cmdPrefixArr;
        if (!this.browserLaunchEnabledFlag) {
            return true;
        }
        boolean fileUrlFlag = false;
        if (urlStr.length() > 6 && urlStr.substring(0, 6).equalsIgnoreCase("file:/")) {
            cmdPrefixArr = this.fileCmdPrefixArr;
            cmdSuffixArr = this.fileCmdSuffixArr;
            fileUrlFlag = true;
        } else if (!LaunchBrowser.isURLAddress(urlStr)) {
            cmdPrefixArr = this.fileCmdPrefixArr;
            cmdSuffixArr = this.fileCmdSuffixArr;
        } else {
            cmdPrefixArr = this.httpCmdPrefixArr;
            cmdSuffixArr = this.httpCmdSuffixArr;
        }
        if (cmdPrefixArr != null && cmdSuffixArr != null) {
            boolean winOSFlag = this.osSelectVal == 2 || this.osSelectVal == 1;
            String escUrlStr = null;
            String errStr = null;
            for (int i = this.firstCmdArrIdx; i < this.httpOsPrefixArr.length; ++i) {
                String cmdStr;
                String prefixStr = cmdPrefixArr[i];
                if (winOSFlag && i > 0 && prefixStr != null && (prefixStr.startsWith(CMDCQT_STR) || prefixStr.startsWith(STARTQT_STR))) {
                    if (escUrlStr == null) {
                        escUrlStr = LaunchBrowser.escSpecialWinChars(urlStr);
                    }
                    cmdStr = prefixStr + (fileUrlFlag ? escUrlStr.substring(6) : escUrlStr) + cmdSuffixArr[i];
                } else {
                    cmdStr = prefixStr + urlStr + cmdSuffixArr[i];
                }
                this.lastShowURLCmdStr = cmdStr;
                try {
                    Runtime.getRuntime().exec(cmdStr);
                    return true;
                }
                catch (Exception ex) {
                    if (errStr != null) continue;
                    errStr = "Runtime.exec('" + cmdStr + "') exception:  " + ex;
                    continue;
                }
            }
            this.setErrorMessage(errStr);
        } else {
            this.setErrorMessage("Invalid application configuration");
        }
        return false;
    }

    public String getPrefApplicationLaunchCmd(String urlStr) {
        return this.httpCmdPrefixArr[this.firstCmdArrIdx] + urlStr + this.httpCmdSuffixArr[this.firstCmdArrIdx];
    }

    public String getPrefApplicationLaunchFileCmd(String urlStr) {
        return this.fileCmdPrefixArr[this.firstCmdArrIdx] + urlStr + this.fileCmdSuffixArr[this.firstCmdArrIdx];
    }

    public String getLastShowURLCmdStr() {
        return this.lastShowURLCmdStr;
    }

    public boolean showAppletURL(String urlStr, String titleStr) {
        if (!this.browserLaunchEnabledFlag) {
            return true;
        }
        if (this.appletContextObj != null) {
            try {
                int len;
                URL urlObj = new URL(urlStr);
                if (titleStr != null && (len = titleStr.length()) > 0) {
                    StringBuffer buff = new StringBuffer(titleStr);
                    boolean changedFlag = false;
                    for (int p = 0; p < len; ++p) {
                        if (Character.isLetterOrDigit(buff.charAt(p))) continue;
                        buff.setCharAt(p, '_');
                        changedFlag = true;
                    }
                    if (changedFlag) {
                        titleStr = buff.toString();
                    }
                } else {
                    titleStr = "_blank";
                }
                this.appletContextObj.showDocument(urlObj, titleStr);
                return true;
            }
            catch (MalformedURLException ex) {
                this.setErrorMessage("Unable to interpret URL:  " + urlStr);
            }
            catch (Exception ex) {
                this.setErrorMessage("Unable to display URL:  " + urlStr);
            }
        } else {
            this.setErrorMessage("Invalid applet context (null)");
        }
        return false;
    }

    public boolean showAppletURL(String urlStr) {
        return this.showAppletURL(urlStr, null);
    }

    public boolean showURL(String urlStr, String titleStr) {
        return this.appletContextObj != null ? this.showAppletURL(urlStr, titleStr) : this.showApplicationURL(urlStr);
    }

    public boolean showURL(String urlStr) {
        this.clearErrorMessage();
        return this.appletContextObj != null ? this.showAppletURL(urlStr, null) : this.showApplicationURL(urlStr);
    }

    public void setEnabled(boolean flgVal) {
        this.browserLaunchEnabledFlag = flgVal;
    }

    public boolean isEnabled() {
        return this.browserLaunchEnabledFlag;
    }

    protected void setErrorMessage(String str) {
        if (this.errorMessage == null) {
            this.errorMessage = str;
        }
    }

    public boolean getErrorFlag() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage != null ? this.errorMessage : "No error";
    }

    public void clearErrorMessage() {
        this.errorMessage = null;
    }

    public int getOSSelectVal() {
        return this.osSelectVal;
    }

    public String getOSSelectString() {
        return this.osSelectVal >= 0 && this.osSelectVal < osSelStringsArr.length ? osSelStringsArr[this.osSelectVal] : "Unknown";
    }

    public String getOsNamePropString() {
        if (osNamePropString == null) {
            LaunchBrowser.determineOSType();
        }
        return osNamePropString;
    }

    public static int determineOSType() {
        osNamePropString = "";
        try {
            osNamePropString = System.getProperty("os.name", "");
            String osNameLwrCase = osNamePropString.toLowerCase();
            if (osNameLwrCase.indexOf("windows") >= 0) {
                return osNamePropString.indexOf("windows 9") >= 0 ? 1 : 2;
            }
            if (osNameLwrCase.startsWith("mac")) {
                return 3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static boolean isURLAddress(String str) {
        if (str == null || str.length() <= 0) {
            return false;
        }
        int p = str.indexOf("://", 1);
        if (p <= 0 || p > 10) {
            return false;
        }
        while (--p >= 0) {
            if (Character.isLetterOrDigit(str.charAt(p))) continue;
            return false;
        }
        return true;
    }

    public static String escSpecialWinChars(String urlStr) {
        int urlStrLen = urlStr.length();
        StringBuffer buff = null;
        for (int p = 0; p < urlStrLen; ++p) {
            char ch = urlStr.charAt(p);
            if (NEED_ESC_CHARS.indexOf(ch) >= 0) {
                if (buff == null) {
                    buff = new StringBuffer(urlStr.substring(0, p));
                }
                buff.append('^');
                buff.append(ch);
                continue;
            }
            if (buff == null) continue;
            buff.append(ch);
        }
        return buff != null ? buff.toString() : urlStr;
    }
}

