/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.FileUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipFileUtils {
    public static String[] FILE_EXTENSIONS = new String[]{"zip", "jar"};

    private ZipFileUtils() {
    }

    public static boolean hasZipExtension(String name) {
        name = name.toLowerCase().trim();
        for (int i = 0; i < FILE_EXTENSIONS.length; ++i) {
            if (!name.endsWith(FILE_EXTENSIONS[i])) continue;
            return true;
        }
        return false;
    }

    public static ZipFile openZipFile(String name) throws IOException {
        return new ZipFile(name);
    }

    public static ZipFile openZipFile(File file, int mode) throws IOException {
        return new ZipFile(file, mode);
    }

    public static ZipFile openZipFile(File file) throws ZipException, IOException {
        return new ZipFile(file);
    }

    public static int unzipZipFile(ZipFile zipFileObj, File outputDir) throws ZipException {
        return ZipFileUtils.unzipZipFile(zipFileObj, outputDir, "");
    }

    public static int unzipZipFile(ZipFile zipFileObj, File outputDir, boolean keepDateFlag) throws ZipException {
        return ZipFileUtils.unzipZipFile(zipFileObj, outputDir, keepDateFlag, "");
    }

    public static int unzipZipFile(ZipFile zipFileObj, File outputDir, String outputFilePrefix) throws ZipException {
        return ZipFileUtils.unzipZipFile(zipFileObj, outputDir, false, outputFilePrefix, null, false);
    }

    public static int unzipZipFile(ZipFile zipFileObj, File outputDir, boolean keepDateFlag, String outputFilePrefix) throws ZipException {
        return ZipFileUtils.unzipZipFile(zipFileObj, outputDir, keepDateFlag, outputFilePrefix, null, false);
    }

    public static int unzipZipFile(ZipFile zipFileObj, File outputDir, String outputFilePrefix, FileFilter filter, boolean junkPathsFlag) throws ZipException {
        return ZipFileUtils.unzipZipFile(zipFileObj, outputDir, false, outputFilePrefix, filter, junkPathsFlag);
    }

    public static int unzipZipFile(ZipFile zipFileObj, File outputDir, boolean keepDateFlag, String outputFilePrefix, FileFilter filter, boolean junkPathsFlag) throws ZipException {
        if (!outputDir.exists() ? !outputDir.mkdirs() : !outputDir.isDirectory()) {
            throw new ZipException("ZipFileUtils.unzipZipFile:  Unable to create output directory \"" + outputDir.getName() + "\"");
        }
        int fileCount = 0;
        InputStream in = null;
        FileOutputStream out = null;
        Enumeration<? extends ZipEntry> entries = zipFileObj.entries();
        while (entries.hasMoreElements()) {
            File ouputFile;
            long entryTimeVal;
            block22: {
                ZipEntry ze;
                block20: {
                    block21: {
                        entryTimeVal = 0L;
                        ouputFile = null;
                        ze = entries.nextElement();
                        String outputFileName = ze.getName();
                        if (keepDateFlag) {
                            entryTimeVal = ze.getTime();
                        }
                        ouputFile = new File(outputDir, outputFilePrefix + outputFileName);
                        if (filter == null || filter.accept(ouputFile)) break block20;
                        if (in == null) break block21;
                        FileUtils.closeStream(in);
                        in = null;
                    }
                    if (out == null) continue;
                    FileUtils.closeStream(out);
                    out = null;
                    continue;
                }
                try {
                    File parentFile = ouputFile.getParentFile();
                    if (parentFile != null) {
                        if (junkPathsFlag) {
                            ouputFile = new File(outputDir, outputFilePrefix + ouputFile.getName());
                        } else if (!parentFile.isDirectory() && !parentFile.mkdirs()) {
                            if (parentFile.exists()) {
                                throw new ZipException("ZipFileUtils.unzipZipFile: file exists with the same name as the directory \"" + parentFile.getName() + "\"");
                            }
                            throw new ZipException("ZipFileUtils.unzipZipFile: could not create directory \"" + parentFile.getName() + "\"");
                        }
                    }
                    if (ze.isDirectory()) {
                        if (!ouputFile.isDirectory() && !ouputFile.mkdirs()) {
                            if (ouputFile.exists()) {
                                throw new ZipException("ZipFileUtils.unzipZipFile: file exists with the same name as the directory \"" + ouputFile.getName() + "\"");
                            }
                            throw new ZipException("ZipFileUtils.unzipZipFile: could not create directory \"" + ouputFile.getName() + "\"");
                        }
                    } else {
                        in = zipFileObj.getInputStream(ze);
                        out = new FileOutputStream(ouputFile);
                        FileUtils.transferStream(in, out);
                        ++fileCount;
                    }
                    if (in == null) break block22;
                }
                catch (Throwable throwableObj) {
                    try {
                        throw new ZipException("ZipFileUtils.unzipZipFile:  " + throwableObj);
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            FileUtils.closeStream(in);
                            in = null;
                        }
                        if (out != null) {
                            FileUtils.closeStream(out);
                            out = null;
                        }
                        throw throwable;
                    }
                }
                FileUtils.closeStream(in);
                in = null;
            }
            if (out != null) {
                FileUtils.closeStream(out);
                out = null;
            }
            if (entryTimeVal <= 0L || ouputFile == null) continue;
            ouputFile.setLastModified(entryTimeVal);
        }
        return fileCount;
    }

    public static String getSingleDirInZip(ZipFile zipFileObj) {
        String retDirStr;
        Enumeration<? extends ZipEntry> enumObj;
        if (zipFileObj != null && (enumObj = zipFileObj.entries()) != null && enumObj.hasMoreElements()) {
            retDirStr = null;
            do {
                String str;
                ZipEntry entryObj;
                ZipEntry obj;
                if (!((obj = enumObj.nextElement()) instanceof ZipEntry) || (entryObj = obj).isDirectory()) continue;
                File dirFileObj = new File(entryObj.getName()).getParentFile();
                if (dirFileObj != null) {
                    do {
                        str = dirFileObj.getPath();
                    } while ((dirFileObj = dirFileObj.getParentFile()) != null);
                } else {
                    str = "";
                }
                if (retDirStr == null) {
                    retDirStr = str;
                    continue;
                }
                if (str.equals(retDirStr)) continue;
                retDirStr = null;
                break;
            } while (enumObj.hasMoreElements());
        } else {
            retDirStr = "";
        }
        return retDirStr;
    }

    public static String zipAndDeleteDir(String dirname, String zipFile) throws FileNotFoundException, IOException {
        File zFile;
        if (!ZipFileUtils.hasZipExtension(zipFile)) {
            zipFile = zipFile.concat(".zip");
        }
        if ((zFile = new File(zipFile)).exists() && !zFile.delete()) {
            return null;
        }
        File d = new File(dirname);
        if (!d.isDirectory()) {
            throw new IllegalArgumentException("Not a directory:  " + dirname);
        }
        String[] entries = d.list();
        byte[] buffer = new byte[4096];
        FileOutputStream zipOut = new FileOutputStream(zipFile);
        ZipOutputStream out = new ZipOutputStream(zipOut);
        for (int i = 0; i < entries.length; ++i) {
            int bytesRead;
            File f = new File(d, entries[i]);
            if (f.isDirectory()) continue;
            FileInputStream in = new FileInputStream(f);
            ZipEntry entry = new ZipEntry(f.getPath());
            out.putNextEntry(entry);
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            in.close();
        }
        out.close();
        if (!ZipFileUtils.deleteDirectory(d)) {
            return null;
        }
        return zipOut.toString();
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    ZipFileUtils.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }
}

